﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<script id="assign_melt_order_grade" type="text/x-handlebars-template">
    <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full flex justify-center items-start pt-20" id="my-modal">
        <div class="relative p-5 border w-1/3 shadow-lg rounded-md bg-white">
            <div class="flex flex-col h-full">
                <div class="pb-3 border-b">
                    <div class="flex justify-between items-center">
                        <h3 class="text-xl font-semibold text-gray-900">ASSIGN MELT ORDER AND GRADE</h3>
                        <button class="text-gray-400 hover:text-gray-500 close">
                            <svg class="h-6 w-6 " fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>
                </div>
                <div class="py-4 border-b flex justify-between">
                    <div id="meltOrdersDiv" class="w-2/5">
                        <div class="flex items-center mb-2 ml-5">
                            <div class="flex items-center mr-4">
                                <label class="text-base font-medium text-gray-700 mt-2">
                                    Melt Order Selection
                                </label>
                            </div>
                        </div>
                        <div class="ml-5">
                            <div id="melt-order-multi-select" style="width:200px;"></div>
                        </div>
                    </div>

                    <div id="gradesDiv" class="w-2/5">
                        <div class="flex items-center mb-2">
                            <div class="flex items-center mr-4">
                                <label class="text-base font-medium text-gray-700 mt-2">
                                    Grade Selection
                                </label>
                            </div>
                        </div>
                        <div>
                            <div id="grade-multi-select" style="width:200px;"></div>
                        </div>
                    </div>
                </div>

                <div class="pt-4">
                    <div class="flex justify-end">
                        <button id="cancelBtn" class="px-4 py-2 bg-gray-300 text-gray-800 text-base font-medium rounded-md shadow-sm hover:bg-gray-400 focus:outline-none focus:ring-2 focus:ring-gray-500">
                            CANCEL
                        </button>
                        <button id="acceptBtn" class="ml-3 px-4 py-2 bg-green-600 text-white text-base font-medium rounded-md shadow-sm hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-green-500" 

                        data-bind="classes: { hide:disableAssignBtn }"
                        >
                            ASSIGN
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</script>



    