﻿define([
  // Application.
  "app",
],

function (app) {

    var DatablocksConflicts = { Models: {}, Collections: {}, };

    DatablocksConflicts.init = function (ctx, module, app) {
        app.models.datablocksConflicts = new module.Model();
        app.models.datablocksConflicts.start();

        ctx.listenTo(app.models.datablocksConflicts, "change:hasConflicts", ctx.updateDisplayDbConflictsIcon);
    }; 

    DatablocksConflicts.Models.AgentConflict = Backbone.Model.extend({
        defaults: {
            agentId: null,
        },
    });

    DatablocksConflicts.Collections.AgentConflicts = Backbone.Collection.extend({
        model: DatablocksConflicts.Models.AgentConflict,
        fetch: function () {
            var that = this,
                QP = new Core.Database.QueryParameters();

            Core.Json.CallProcedure(app.DatabaseNames.IH + ".WEB.GetAgentsWithDatablocksConflicts", QP, {
                onSuccess: function (response) {
                    if (response && response.Table) {
                        records = response.Table;

                        var mdls = [];
                        for (var i = 0, len = records.length; i < len; i++) {
                            var data = records[i];

                            var mdl = new DatablocksConflicts.Models.AgentConflict({
                                agentId: data.AgentId,
                            });

                            mdls.push(mdl);
                        }

                        that.reset(mdls);
                    }
                },
                Cache: true, 
            }, app.ConnectionStrings.app);

            return this;
        }
    });

    DatablocksConflicts.Model = Backbone.Model.extend({
        defaults: {
            hasConflicts: false,
            conflicts: new DatablocksConflicts.Collections.AgentConflicts(),
        },

        toid: null,
        delay: 5000,
        refreshing: false,

        initialize: function ()
        {
            _.bindAll(this);

            this.listenTo(this.get('conflicts'), 'reset', this.conflicts_reset);
        },

        fetch: function (resetAutoRefresh)
        {
            try
            {
                if (resetAutoRefresh !== false)
                    clearTimeout(this.toid);

                
                this.get('conflicts')
                    .fetch();
            }
            catch (Error) { console.error(Error); }
            finally
            {
                if (this.refreshing)
                    this.toid = setTimeout(this.fetch, this.delay);
            }
        },

        start: function ()
        {
            if (!this.refreshing)
            {
                this.refreshing = true;

                this.fetch();
            }

            return this;
        },

        stop: function ()
        {
            clearTimeout(this.toid);

            this.refreshing = false;

            return this;
        },

        conflicts_reset: function(e)
        {
            try
            {
                var conflictsMdl = this.get("conflicts");

                this.set("hasConflicts", conflictsMdl.length > 0);
            }
            catch(Error) { console.error(Error); }
        },
        

        //@@overrides
        //overriding get and set method to allow custom getters/setters
        get: function (attr) {
            // Call the getter if available
            if (_.isFunction(this.getters[attr])) {
                return this.getters[attr].call(this);
            }

            return Backbone.Model.prototype.get.call(this, attr);
        },

        set: function (key, value, options) {
            var attrs, attr;

            // Normalize the key-value into an object
            if (_.isObject(key) || key == null) {
                attrs = key;
                options = value;
            } else {
                attrs = {};
                attrs[key] = value;
            }

            // always pass an options hash around. This allows modifying
            // the options inside the setter
            options = options || {};

            // Go over all the set attributes and call the setter if available
            for (attr in attrs) {
                if (_.isFunction(this.setters[attr])) {
                    attrs[attr] = this.setters[attr].call(this, attrs[attr], options);
                }
            }

            return Backbone.Model.prototype.set.call(this, attrs, options);
        },

        getters: {
        },

        setters: {
        },
    });

    // Required, return the module for AMD compliance.
    return DatablocksConflicts;

});
