﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture =
            CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new
            CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<% 
    if (Session["SecurityData"] == null)
    {
        Session["SecurityData"] = WebApp.GetSecurityData();
    }
    
    WebApp.SecurityData securityData = (WebApp.SecurityData) Session["SecurityData"];
    bool writePermission = securityData.GetModuleActionValue("ihconfiguration_users", "write"); 
%>

<script id="main_template" type="text/x-handlebars-template">
    <link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/app/custom-screens/IHConfiguration/users/users.css") %>" rel="stylesheet" />

    <div id="users_screen_container">
    </div>
</script>

<script id="users_list" type="text/x-handlebars-template">
    <link href="<%= ResolveUrl("~/app/custom-screens/IHConfiguration/account-information/circle-progress.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/app/custom-screens/IHConfiguration/users/users.css") %>" rel="stylesheet" />


    <div>
        <div class="row-fluid scrollable span12" style="height:80vh;">
             <div class="searchUsersInput">
                    <input type="text" id="searchUsersInput" placeholder="Search for Name or Username...">
              </div>
            <div class="row-fluid usersTableContainer">
            </div>
        </div>
    </div>
</script>

<script>

</script>

<script id="user_panel" type="text/x-handlebars-template">
    <link href="<%= ResolveUrl("~/app/custom-screens/IHConfiguration/users/users.css") %>" rel="stylesheet" />

    <style type="text/css">
        .panel {
            margin-bottom: 20px;
            background-color: #fff;
            border: 1px solid transparent;
            border-radius: 4px;
            -webkit-box-shadow: 0 1px 1px rgba(0, 0, 0, .05);
            box-shadow: 0 1px 1px rgba(0, 0, 0, .05);
        }

        .panel-body {
            padding: 15px;
        }

        .panel-heading {
            padding: 10px 15px;
            border-bottom: 1px solid transparent;
            border-top-left-radius: 3px;
            border-top-right-radius: 3px;
        }

            .panel-heading > .dropdown .dropdown-toggle {
                color: inherit;
            }

        .panel-title {
            margin-top: 0;
            margin-bottom: 0;
            font-size: 16px;
            color: inherit;
        }

            .panel-title > a {
                color: inherit;
            }

        .panel-footer {
            padding: 10px 15px;
            background-color: #f5f5f5;
            border-top: 1px solid #ddd;
            border-bottom-right-radius: 3px;
            border-bottom-left-radius: 3px;
        }

        .panel-info {
            border-color: #bce8f1;
            margin-bottom:0;
        }

            .panel-info > .panel-heading {
                color: #31708f;
                background-color: #d9edf7;
                border-color: #bce8f1;
            }

                .panel-info > .panel-heading + .panel-collapse > .panel-body {
                    border-top-color: #bce8f1;
                }

                .panel-info > .panel-heading .badge {
                    color: #d9edf7;
                    background-color: #31708f;
                }

            .panel-info > .panel-footer + .panel-collapse > .panel-body {
                border-bottom-color: #bce8f1;
            }

        .table-user-information > tbody > tr {
            border-top: 1px solid rgb(221, 221, 221);
        }

            .table-user-information > tbody > tr:first-child {
                border-top: 0;
            }


            .table-user-information > tbody > tr > td {
                border-top: 0;
            }

        .clickeable-row{
            cursor:pointer; 
        }

        .mini-control-label {
            width:80px !important;
        }

        .mini-controls {
            margin-left: 100px !important; 
            margin-top:4px !important;
        }

        .align-center-cell {
            text-align:center !important;
        }

        .backgrid .name{
            min-width:150px !important; 
        }

        .backgrid .member {
            max-width:40px;
        }

        .user-profiles-grid-container {
            max-height:350px;
            overflow-y:auto;
        }
    </style>

    <div class="row-fluid">
        <div class="span12">
            <div style="margin-left:auto !important;margin-right:auto !important;" class="panel panel-info span12">
                <div style="height: auto;" class="row-fluid span12 panel-heading">
                    <div class="span4 offset4 text-center">
                        <img style="width: 15%;" alt="User" src="<%= ResolveUrl("~/assets/img/user-placeholder-image.png") %>" class="img-circle">
                        {{#ifEquals screenmode "EDIT" }}
                            <h3 class="panel-title">{{name}} {{lastname}}</h3>
                        {{/ifEquals}}
                        {{#ifEquals screenmode "CREATE" }}
                            <h3 class="panel-title">New User</h3>
                        {{/ifEquals}}
                    </div>
                </div>
                <div class="panel-body">
                    <div class="row-fluid">
                        <form class="form-user-data form-horizontal" novalidate>
                            <fieldset>
                               <div class="legendContainer"><legend class="span10">Information</legend>
                                    <button type="button" class="btn btn-danger delete-user-btn"><i style="margin-right:5px" class="fw-icon-trash"></i>Delete User</button></div>
                                <div class="row-fluid">
                                    <div class="span6 userInfoContainer">
                                        <div class="span12 generalTitleContainer">
                                            <h5>General</h5>
                                        </div>
                                        
                                        <div class="userInfoControls">
                                        <!-- Name -->
                                        <div class="control-group">
                                            <label class="control-label" for="name"><asp:localize runat="server" meta:resourcekey="name_form_label" /></label>
                                            <div class="controls">
                                                <input <% if (!writePermission){ %> disabled="disabled" <% } %>
                                                data-validation-required-message="<asp:localize runat="server" meta:resourcekey="required_validation_message" />" data-bindingtype="two-way" data-bindingprop="name" type="text" name="name" placeholder="" value="{{name}}" class="input name-input" required>
                                            </div>
                                        </div>
                                        <!-- Last Name -->
                                        <div class="control-group">
                                            <label class="control-label" for="lastname"><asp:localize runat="server" meta:resourcekey="lastname_form_label" /></label>
                                            <div class="controls">
                                                <input <% if (!writePermission){ %> disabled="disabled" <% } %>
                                                    data-validation-required-message="<asp:localize runat="server" meta:resourcekey="required_validation_message" />" data-bindingtype="two-way" data-bindingprop="lastname" type="text" name="lastname" placeholder="" value="{{lastname}}" class="input lastname-input" required>
                                            </div>
                                        </div>
                                    
                                        <div class="control-group">
                                            <label class="control-label" for="active_directory">Active Directory</label>
                                            <div class="controls">
                                                {{#ifEquals screenmode "EDIT" }}
                                                    <input <% if (!writePermission){ %> disabled="disabled" <% } %>
                                                        {{checked autologin}} disabled="disabled" data-bindingtype="two-way" data-bindingprop="autologin" style="top:3px;position:relative;" class="input active-directory-input" type="checkbox" id="active_directory" />
                                                {{/ifEquals}}
                                                {{#ifEquals screenmode "CREATE" }}
                                                    <input <% if (!writePermission){ %> disabled="disabled" <% } %>
                                                        {{checked selected}} style="top:3px;position:relative;" data-bindingtype="two-way" data-bindingprop="autologin" class="input active-directory-input" type="checkbox" id="active_directory" />
                                                {{/ifEquals}}
                                            </div>
                                            <%--<label>
                                                <input type="checkbox" />
                                                Active Directory
                                            </label>--%>
                                        </div>

                                        <!-- Username -->
                                        <div class="control-group">
                                            <label class="control-label" for="username"><asp:localize runat="server" meta:resourcekey="username_form_label" /></label>
                                            <div class="controls">
                                                {{#ifEquals screenmode "EDIT" }}
                                                    <input <% if (!writePermission){ %> disabled="disabled" <% } %>
                                                        disabled="disabled" data-validation-required-message="<asp:localize runat="server" meta:resourcekey="required_validation_message" />" data-bindingtype="two-way" data-bindingprop="username" type="text" name="username" placeholder="<asp:localize runat="server" meta:resourcekey="username_placeholder" />" value="{{username}}" class="input username-input" required>
                                                {{/ifEquals}}
                                                {{#ifEquals screenmode "CREATE" }}
                                                    <input <% if (!writePermission){ %> disabled="disabled" <% } %>
                                                        data-validation-required-message="<asp:localize runat="server" meta:resourcekey="required_validation_message" />" data-bindingtype="two-way" data-bindingprop="username" type="text" name="username" placeholder="<asp:localize runat="server" meta:resourcekey="username_placeholder" />" value="{{username}}" class="input username-input" required>
                                                {{/ifEquals}}
                                                <%--<span class="domain-user-spans hide" style="font-size:11px;clear:both;float:left;margin-top:4px;display:inline-block;">
                                                    <asp:localize runat="server" meta:resourcekey="domain_label" /><span style="float:left;" class="domain-span"></span><br />
                                                    <asp:localize runat="server" meta:resourcekey="domain_user_label" /><span style="float:left;" class="domain-user-span"></span>
                                                </span>--%>
                                            </div>
                                        </div>

                                        <div class="control-group">
                                            <label class="control-label" for="department"><asp:localize runat="server" meta:resourcekey="department_form_label" /></label>
                                            <div class="controls">
                                                <select <% if (!writePermission){ %> disabled="disabled" <% } %> class="departmentSelect" data-bind=" value: departmentId">
                                               {{#each departments}}
                                                 <option value="{{id}}" {{selected id ../departmentId}}>{{name}}</option>
                                                {{/each}}
                                            </select>
                                            </div>
                                        </div>

                                      

                                        <div class="control-group">
                                            <label class="control-label" for="role"><asp:localize runat="server" meta:resourcekey="timezone_form_label" /></label>
                                            <div class="controls">
                                                <select <% if (!writePermission){ %> disabled="disabled" <% } %>>
                                                    data-validation-required-message="<asp:localize runat="server" meta:resourcekey="required_validation_message" />" data-bindingtype="two-way" data-bindingprop="timezone" name="timezone" required>
                                                    {{#each timezones}}
                                                    <option {{selected Id ../timezone}} value="{{Id}}">{{Name}}</option>
                                                    {{/each}}
                                                </select>
                                            </div>
                                        </div>
                                            
                                        {{#ifEquals screenmode "EDIT" }}
                                            {{#ifEquals autologin false}}
                                            <div class="control-group">
                                                <a <% if (!writePermission){ %> disabled="disabled" <% } %> class="btn-change-password btn btn-block btn-default offset3 span9"><i style="margin-right: 2px;" class="fw-icon-lock"></i>
                                                    <asp:localize runat="server" meta:resourcekey="btn_change_password" />
                                                </a>
                                            </div>
                                            
                                            {{/ifEquals}}
                                        {{/ifEquals}}
                                        <div class="password-section {{#ifEquals screenmode "EDIT" }} hide {{/ifEquals}}">
                                            <!-- Password -->
                                            <div class="control-group">
                                                <label class="control-label" for="password"><asp:localize runat="server" meta:resourcekey="password_form_label" /></label>
                                                <div class="controls">
                                                    <input <% if (!writePermission){ %> disabled="disabled" <% } %>
                                                        id="password-field" data-validation-required-message="<asp:localize runat="server" meta:resourcekey="required_validation_message" />" data-bindingtype="two-way" data-bindingprop="password" type="password" name="password" placeholder="<asp:localize runat="server" meta:resourcekey="password_placeholder" />" class="input" required>
                                                </div>
                                            </div>
                                            <!-- Confirm Password -->
                                            <div class="control-group">
                                                <label class="control-label" for="confirm-password"><asp:localize runat="server" meta:resourcekey="confirmpassword_form_label" /></label>
                                                <div class="controls">
                                                    <input <% if (!writePermission){ %> disabled="disabled" <% } %>
                                                        id="confirm-password-field" data-validation-required-message="<asp:localize runat="server" meta:resourcekey="required_validation_message" />" data-validation-matches-match="password" data-validation-matches-message="<asp:localize runat="server" meta:resourcekey="mustmatch_validation_message" />"  type="password" name="confirm-password" placeholder="<asp:localize runat="server" meta:resourcekey="repeat_password_placeholder" />" class="input" required>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    </div>
                                    <div class="span6 profileUserContainer">
                                        <div class="span12 profileTitleContainer"><h5><asp:localize runat="server" meta:resourcekey="profiles_title" /></h5></div>
                                        
                                        <div class="user-profiles-grid-container span12"></div>
                                    </div>
                                </div>
                            </fieldset>
                        </form>
                    </div>
                </div>
                <div class="panel-footer">
                    <div class="row-fluid">
                        <div class="span4">
                            {{#ifEquals screenmode "EDIT" }}
                            <div class="pull-left">
                                <%--<button class="btn btn-default"><i class="fw-icon-arrow-left"></i></button>--%>
                            </div>
                            {{/ifEquals}}
                        </div>
                        <div class="span4 text-center">
                            {{#ifEquals screenmode "EDIT" }}
                                <% if (writePermission){ %>
                                    <button <% if (!writePermission){ %> disabled="disabled" <% } %> type="submit" class="btn btn-success btn-save-changes"><asp:localize runat="server" meta:resourcekey="save_changes_btn_label" /></button>
                                    <button <% if (!writePermission){ %> disabled="disabled" <% } %> class="btn btn-danger btn-cancel-changes"><asp:localize runat="server" meta:resourcekey="cancel_changes_btn_label" /></button>
                                <% } %>
                                <% if (!writePermission){ %>
                                    <button class="btn btn-default btn-back"><asp:localize runat="server" meta:resourcekey="back_btn_label" /></button>
                                <% } %>
                            {{/ifEquals}}
                            {{#ifEquals screenmode "CREATE" }}
                                <% if (writePermission){ %>
                                <button <% if (!writePermission){ %> disabled="disabled" <% } %> type="submit" class="btn btn-success btn-create-user"><asp:localize runat="server" meta:resourcekey="create_btn_label" /></button>
                                <button <% if (!writePermission){ %> disabled="disabled" <% } %> class="btn btn-danger btn-cancel-create-user"><asp:localize runat="server" meta:resourcekey="cancel_btn_label" /></button>
                                <% } %>
                                <% if (!writePermission){ %>
                                    <button class="btn btn-default btn-back"><asp:localize runat="server" meta:resourcekey="back_btn_label" /></button>
                                <% } %>
                            {{/ifEquals}}
                        </div>
                        <div class="span4">
                            {{#ifEquals screenmode "EDIT" }}
                            <div class="pull-right">
                                <%--<button class="btn btn-default"><i class="fw-icon-arrow-right"></i></button>--%>
                            </div>
                            {{/ifEquals}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</script>

<script id="subnavbar_controls" type="text/x-handlebars-template">
    <div class="pull-right">
        <div class="btn-group">
                <%--<a class="btn btn-toolbar-remove-user hide"><i style="margin-right: 2px;" class="fw-icon-remove"></i><i style="margin-right: 4px;" class="fw-icon-user"></i><asp:localize runat="server" meta:resourcekey="btn_toolbar_remove_user" /></a>--%>
            <% if (writePermission){ %>
            <a href="{{currentRoute}}/new" class="btn add-user-btn"><i style="margin-right: 2px;" class="fw-icon-plus"></i><i style="margin-right: 4px;" class="fw-icon-user"></i><asp:localize runat="server" meta:resourcekey="btn_toolbar_add_user" /></a>
            <% } %>
        </div>
    </div>
</script>
