﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar" id="subnavbar_controls" style="margin-bottom: 0px;height:18px !important;">
    <div class="row-fluid form-inline">
        <div class="row-fluid">
            <div class="span2 pull-right">                
                <button id="TWIBtn" class="btn btn-primary" style="width:50%;height:50%">TWI</button>
            </div>
        </div>
    </div>
</div>
<div class="row-fluid screen-content">
    <div class="pull-left" style="width:100%;margin-left:0;">  
        <div class="row-fluid" style="margin-bottom:2%">   
            <svg id="chart" width="1880" height="820">
            </svg>
        </div>
    </div>
</div>


