﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar">
    <div class="row-fluid form-inline">
        <label class="control-label" for="dateStartTbx">
            <asp:localize runat="server" meta:resourcekey="date_start_tbx_label" />
        </label>
        <label class="input-prepend">
            <span class="add-on"><i class="icon-calendar"></i></span>
            <input type="text" id="dateStartTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(start$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
        </label>
        <label class="control-label" for="dateEndTbx">
            <asp:localize runat="server" meta:resourcekey="date_end_tbx_label" />
        </label>
        <label class="input-prepend">
            <span class="add-on"><i class="icon-calendar"></i></span>
            <input type="text" id="dateEndTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(end$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
        </label>
        <div style="display:inline-block;">
            <div class="row-fluid form-inline">
                <label class="control-label" for="searchTbx">
                    <asp:localize runat="server" meta:resourcekey="process_picker_label" />
                </label> 
            </div>
        </div>
        <label class="control-label" for="crewsLabel">
            <asp:localize runat="server" meta:resourcekey="crew_label" />
        </label>
        <label id="changeCrews" class="checkbox inline">
            <select class="input-medium" data-bind="value: crewId, options: crews, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=combo_crews_all />', value: 0 }, enabled: hasCrews" style="width:70px;"></select>
        </label>
        <label class="control-label" for="reasonLabel">
            <asp:localize runat="server" meta:resourcekey="reason_label" />
        </label>
        <label id="changeReasonCode" class="checkbox inline">
            <select class="input-medium" data-bind="value: electrodeChangeReasonId, options: reasons, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=combo_all_opt />', value: 0 }, enabled: hasReasons" style="width:90px;"></select>
        </label>
        <label class="control-label" for="areaCodeLabel">
            <asp:localize runat="server" meta:resourcekey="area_code_label" />
        </label>
        <label id="changeAreaCode" class="checkbox inline">
            <select class="input-medium" data-bind="value: areaCode," style="width:90px;">
                <option value="0">All</option>
                <option value="EAF">EAF</option>
                <option value="LF">LF</option>
            </select>
        </label>
        <label class="control-label" for="equipmentLabel">
            <asp:localize runat="server" meta:resourcekey="equipment_label" />
        </label>
        <label id="changeEquipment" class="checkbox inline">
            <select class="input-medium" data-bind="value: equipmentCode, options: equipments, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=combo_all_opt />', value: 0 }, enabled: all(hasEquipments, not(equals(areaCode,'0')))" style="width:90px;"></select>
        </label>
        <button id="refreshBtn" class="btn btn-primary" style="margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
            <i class="fa fa-refresh"></i>
        </button>

       
        <button class="btn btn-change-electrode pull-right" style="margin-right: 20px;" title="Change electrode">Manual changes</button>
    </div>

</div>
<div class="row-fluid screen-content">
    <div class="items-grid-container infinite-container" style="margin-top:20px"></div>
</div>






<script id="electrode_change_modal_template" type="text/x-handlebars-template">
    <!-- View's container will container the class "electrode-change-modal" -->
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="electrode_change_modal_title" /></h3>
    </div>
    <div style="max-height:500px;" class="modal-body">
        <div class="row-fluid">
            <div class="row-fluid form-inline" style="text-align:center;">               
                    <label class="control-label">
                        <asp:localize runat="server" meta:resourcekey="electrode_change_modal_equipment_label" />:
                    </label>
                    <label class="controls">
                        <select class="input-medium" style="width:100px;margin-right: 20px;" data-bind="value: equipmentCode$, options: equipments, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=combo_choose_opt />', value: null }, enabled: not(processing),">                          
                        </select>
                    </label>    
                    <label class="control-label">
                        <asp:localize runat="server" meta:resourcekey="electrode_change_modal_heat_label" />:
                    </label>
                    <label class="controls">
                        <select style="margin-right: 20px;" data-bind="value: heatName, options: heats, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=combo_choose_opt />', value: null }, enabled: not(processing),">
                        </select>
                    </label>
                    <label class="control-label">
                        <asp:localize runat="server" meta:resourcekey="electrode_change_modal_phase_label" />:
                    </label>
                    <label id="changePhase" class="controls">
                        <select data-bind="value: phaseCode, enabled: not(processing)," class="input-medium" style="width:100px;">
                            <option value= '' selected="selected">Choose...</option>
                            <option value="A">A</option>
                            <option value="B">B</option>
                            <option value="C">C</option>
                        </select>
                    </label>
            </div>

                

                <!--  
                <div id="datepicker-box" style="display:flex;margin-top:59px;margin-left:280px;">
                <div class="process-info-row">
                <div class="process-info-group;" style="display:inline-flex;margin-left:-80px;">
                    
                    <%--
                    <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_timestamp_label" />:
                    </label>
                   
                    <div id="inputs-container" style="margin-top:-9px;margin-left:20px;">
                    <input type="text" data-bind="value: coalesce(momentFormat(startDate, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />'), '')" class="process-info-field-value input-date" placeholder="<asp:Localize runat=server meta:resourcekey=mmddyyyy_display />" data-select-on-focus/>   
                    <input type="text" data-bind="value: coalesce(startTime, '')" class="process-info-field-value input-time" placeholder="<asp:Localize runat=server meta:resourcekey=hhmmss_display />" data-select-on-focus maxlength="8"/>
                    </div>--%>

                   <%-- <span class="process-info-field-value" ></span>--%>

                </div>
                </div>
                </div>
                -->
           
            <%--<h4><asp:localize runat="server" meta:resourcekey="electrode_change_modal_current_electrode_title_label" /></h4>
            <div class="row-fluid">
                <div class="form-horizontal read-only span3">
                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_phase_label" />:
                        </label>
                        <div class="controls">
                            <span class="static-control" data-bind="text: coalesce(phaseCode, '-'),"></span>
                        </div>
                    </div>
                </div>
                <div class="form-horizontal read-only span3">
                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_current_electrode_heats_count_label" />:
                        </label>
                        <div class="controls">
                            <span class="static-control" data-bind="text: coalesce(currentElectrodeHeatsCount, '-'),"></span>
                        </div>
                    </div>
                </div>
                <div class="form-horizontal read-only span3">
                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_current_electrode_supplier_label" />:
                        </label>
                        <div class="controls">
                            <span class="static-control" data-bind="text: coalesce(currentElectrodeSupplier, '-'),"></span>
                        </div>
                    </div>
                </div>
                <div class="form-horizontal read-only span3">
                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_current_electrode_weight_label" />:
                        </label>
                        <div class="controls">
                            <span class="static-control" data-bind="text: coalesce(currentElectrodeWeight, '-'),"></span>
                        </div>
                    </div>
                </div>
            </div>--%>
            <h4><asp:localize runat="server" meta:resourcekey="electrode_change_modal_new_electrode_title_label" /></h4>
            <div class="row-fluid">
                <div class="form-horizontal">
                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_new_electrode_supplier_label" />
                        </label>
                        <div class="controls">
                            <select class="input-large autofocus" data-bind="value: newElectrodeSupplierId, options: suppliers,  optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=combo_choose_opt />', value: 0 }," data-select-on-focus /></select>
                        </div>
                    </div> 
<%--                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_new_electrode_size_label" />
                        </label>
                        <div class="controls">
                            <input type="text" class="input-medium" data-bind="value: newElectrodeSize, enabled: not(processing)," placeholder="<asp:localize runat=server meta:resourcekey=electrode_change_modal_new_electrode_size_placeholder />" data-select-on-focus />
                        </div>
                    </div>--%>
                    <%--<div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_new_electrode_weight_label" />
                        </label>
                        <div class="controls">
                            <input type="text" class="input-medium" data-bind="value: newElectrodeWeight, enabled: not(processing)," placeholder="<asp:localize runat=server meta:resourcekey=electrode_change_modal_new_electrode_weight_placeholder />" data-select-on-focus />
                        </div>
                    </div>--%>
                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_new_electrode_change_reason_label" />
                        </label>
                        <div class="controls">
                            <select class="input-large" data-bind="value: newElectrodeChangeReasonId, options: electrodeChangeReasons, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=combo_choose_opt />', value: 0 },"></select>
                        </div>
                    </div> 
                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_new_electrode_comments_label" />
                        </label>
                        <div class="controls">
                            <textarea data-bind="value: trim(newElectrodeComments), enabled: not(processing)," maxlength="400" style="width:197px;height:70px;" placeholder="<asp:localize runat=server meta:resourcekey=electrode_change_modal_new_electrode_comments_placeholder />" data-select-on-focus></textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <div class="modal-status-msg-container pull-left">
            <div class="modal-status-msg hide" data-bind="toggle: processing,">
                <asp:Localize runat='server' meta:resourcekey='electrode_change_modal_processing_msg' />
                <i class="fa fa-cog fa-spin"></i>
            </div>
        </div>
        
        <button id="acceptBtn" data-bind="enabled: all(not(processing), length(coalesce(heatName, '')), equipmentCode$, length(coalesce(phaseCode, '')) )" class="btn btn-primary">
            <asp:Localize runat='server' meta:resourcekey='electrode_change_modal_accept_btn_label' />
        </button>
        
        <%--<button id="acceptBtn" data-bind="enabled: all(not(processing), newElectrodeChangeReasonId, equipmentCode$, length(coalesce(heatName, '')), length(coalesce(phaseCode, '')))" class="btn btn-primary">
            <asp:Localize runat='server' meta:resourcekey='electrode_change_modal_accept_btn_label' />
        </button>--%>
        <%--<button id="acceptBtn" data-bind="enabled: all(not(processing), newElectrodeChangeReasonId)" class="btn btn-primary">
            <asp:Localize runat='server' meta:resourcekey='electrode_change_modal_accept_btn_label' />
        </button>--%>
        <button data-bind="enabled: notEquals(processing, true)" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='electrode_change_modal_cancel_btn_label' />
        </button>
    </div>
</script>