﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<script id="main_template" type="text/x-handlebars-template">

<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />

<style>
    .blocker {
        position:absolute;
        top:0; 
        left:0; 
        width:100%;
        height:100%;
        background-color:#ccc; 
        opacity:0.4;
        z-index:99999999; 
    }

    li.node-disabled {
        background-color:#e2e2e2 !important; 
        /*opacity:0.7;*/
        color:#a1a1a1;
    }

    .node-disabled.jstree-default.jstree-wholerow-hovered {
        background: red !important;
    }

    .jstree-themeicon-custom {
        background-color: transparent;
        background-size: 24px !important;
    }
    
    .form-horizontal .control-label {
        float: left;
        width: 80px;
        padding-top: 5px;
        text-align: right;
    }

    .form-horizontal .controls {
        margin-left: 100px;
    }

    .backgrid .align-center-cell {
        text-align: center !important;
    }

    .backgrid .align-left-cell {
        text-align: left !important;
    }

    .backgrid .align-right-cell {
        text-align: right !important;
    }

    .backgrid th.tagId,
    .backgrid td.tagId,
    .backgrid th.counterId,
    .backgrid td.counterId {
        width:150px !important;
        min-width:150px !important;
        max-width:150px !important;
    }

    .backgrid td.tagId,
    .backgrid td.counterId,
    .backgrid td.tagResetValue {
        padding-left: 0px !important;
        padding-right: 0px !important;
        margin: 0px !important;
    }

    .backgrid th.tagResetValue,
    .backgrid td.tagResetValue,
    .backgrid th.tagRealAsDigital,
    .backgrid td.tagRealAsDigital,
    .backgrid th.active,
    .backgrid td.active {
        width: 60px !important;
        min-width: 60px !important;
        max-width: 60px !important;
    }
    
    .backgrid td.tagId select,
    .backgrid td.counterId select {
        width:150px !important;
        margin: 0px !important;
    }
    
    .backgrid td.tagResetValue input {
        margin: 0px !important;
        width: 50px !important;
        min-width: 50px !important;
        max-width: 50px !important;
    }

</style>

<div class="container-fluid">
    <div style="margin-top:7%;" class="row-fluid loading-poster text-center">
        <div style="width:40%; margin: 0 auto;" class="progress progress-striped active">
            <div class="bar" style="width: 100%;"></div>
        </div>
    </div>
    <div class="row-fluid">
        <div class="span4 hide equipment-tree">
            <h5><asp:Localize runat="server" meta:resourcekey="lines_and_machines_title" /></h5>
            <div style="margin-bottom:5px;">
                <%--
                <select data-bind="value: typeId, options: types, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_option_label />', value: '' }" id="selectTypeFilter" name="selectTypeFilter">
                </select>
                <button class="btn btn-mini btn-add-item"><asp:Localize runat="server" meta:resourcekey="add_item_label" /></button>
                --%>

                <%--
                <button class="btn btn-mini btn-add-area"><asp:Localize runat="server" meta:resourcekey="add_area_label" /></button>
                <button class="btn btn-mini btn-add-line"><asp:Localize runat="server" meta:resourcekey="add_line_label" /></button>
                <button class="btn btn-mini btn-add-machine" disabled="disabled"><asp:Localize runat="server" meta:resourcekey="add_machine_label" /></button>
                --%>
            </div>
            <div style="height:500px;overflow-y:auto;" class="tree">
            </div>
        </div>
        <div class="span8">
            <%--<div class="machine-configuration-messages row-fluid hide">
                <span style="font-size:14px;">Seleccione una máquina para configurar.</span>
            </div>--%>
            <div class="log-form-container row-fluid hide">
                <div class="container-fluid">
                    <div class="row-fluid">
                        <h5><asp:Localize runat="server" meta:resourcekey="new_entry_title" /></h5>
                    </div>
                    <%--<div data-bind="toggle: hasBatchOpened" class="row-fluid batch-opened-message">
                        <div class="alert alert-info">
                            <span>
                                <asp:Localize runat="server" meta:resourcekey="batch_opened_on_machine_msg" />
                            </span>
                        </div>
                    </div>--%>
                    <div style="position:relative;" class="row-fluid">
                        <%--<div data-bind="toggle: hasBatchOpened" class="blocker"></div>--%>
                        <div class="row-fluid">
                            <form id="detailsForm" class="form-horizontal">
                                <div class="span6">
                                    <div class="control-group">
                                        <label class="control-label" for="selectStatusCode"><asp:Localize runat="server" meta:resourcekey="name_label" /></label>
                                        <div class="controls">
                                            <label style="padding-top:5px; text-align:left;" data-bind="text: name, " id="label1"></label>
                                        </div>
                                    </div>
                                    <div class="control-group">
                                        <label class="control-label" for="selectStatus"><asp:Localize runat="server" meta:resourcekey="status_label" /> </label>
                                        <div class="controls">
                                            <select style="width:150px" data-bind="value: trim(statusCode), options: statusCodes, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_status />', value: null }" id="selectStatus" name="selectStatus">
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="span6">
                                    <div class="control-group">
                                        <label class="control-label" for="inputComments"><asp:Localize runat="server" meta:resourcekey="comments_label" /></label>
                                        <div class="controls">
                                            <textarea class="row-fluid" maxlength="200" style="height:70px;" data-bind="value: trim(comments)" id="inputComments"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div style="margin-top:8px;" class="row-fluid">
                        <div class="span6 offset3">
                            <div class="span6">
                                <button  class="btn btn-primary btn-block btn-save"><asp:Localize runat="server" meta:resourcekey="save_label" /></button>
                            </div>
                            <div class="span6">
                                <button  class="btn btn-block btn-cancel"><asp:Localize runat="server" meta:resourcekey="cancel_label" /></button>
                            </div>
                        </div>
                    </div>
                </div>
                        </div>
                    </div>
                </div>
            </div>
</script>

<script id="subnavbar_controls" type="text/x-handlebars-template">
    <div class="span12">
        <div class="subnavbar-toolbar form-inline">
            <div style="margin-left:10px; margin-top: 5px; float:right;" class="control-group form-inline">
                <select style="width:200px;" data-bind="value: integer(typeId), options: types, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=type_combo_all_option_label />', value: '' }, enabled: hasTypes,"></select>
            </div>
            <div id="cg_search" style="margin-top: 5px; float:right;" class="control-group form-inline">
                <label class="control-label" style="margin-right:2px;" for="searchTerm_input">
                    <asp:Localize runat="server" meta:resourcekey="search_input_label"  />
                </label>
                <input type="text" id="searchTbx" data-bind="value: trim(search), events: ['change', 'keyup']," class="input-medium" placeholder="<asp:Localize runat=server meta:resourcekey=equipment_search_place_holder />">
            </div>
        </div>
    </div>
</script>
