﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-min-max-cell/backgrid-valid-min-max-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "2/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar">
    <div class="row-fluid form-inline">   
        <label class="control-label">
            <asp:localize runat="server" meta:resourcekey="product_type_combo_label" />
            <select style="width:110px;" data-bind="value: integer(productTypeId), options: productTypes, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=product_type_combo_all_opt />', value: 0 },"> enabled: hasProductTypes,"></select>
        </label>
        <label class="control-label" for="yearTbx">
            <asp:localize runat="server" meta:resourcekey="year_week_label" />
        </label>     
        <div class="input-prepend input-append">
            <button id="previousBtn" class="btn btn-default" title="<asp:localize runat=server meta:resourcekey=previous_btn_title />">
                <i class="fa fa-play fa-rotate-180"></i>
            </button>
            <input type="number" id="yearTbx" style="width:50px;text-align:right;" data-bind="value: year,">
            <input type="number" style="width:35px;text-align:right;" data-bind="value: week,">
            <button id="nextBtn" class="btn btn-default" title="<asp:localize runat=server meta:resourcekey=next_btn_title />">
                <i class="fa fa-play"></i>
            </button>
            <button id="currentBtn" class="btn btn-default" title="<asp:localize runat=server meta:resourcekey=current_btn_title />">
                <i class="fa fa-step-forward"></i>
            </button>
        </div>
        <%--<label class="control-label" for="dateStartTbx">
            <asp:localize runat="server" meta:resourcekey="date_start_tbx_label" />
        </label>
        <label class="input-prepend">
            <span class="add-on"><i class="icon-calendar"></i></span>
            <input type="text" id="dateStartTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(start$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
        </label>
        <label class="control-label" for="dateEndTbx">
            <asp:localize runat="server" meta:resourcekey="date_end_tbx_label" />
        </label>
        <label class="input-prepend">
            <span class="add-on"><i class="icon-calendar"></i></span>
            <input type="text" id="dateEndTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(end$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
        </label>--%>
        <button id="refreshBtn" class="btn btn-primary" style="margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
            <i class="fa fa-refresh"></i>
        </button>
    </div>
</div>
<div class="row-fluid screen-content">
    <div class="row-fluid" style="margin-bottom:10px;margin-top:10px;">
        <h4><asp:Localize runat=server meta:resourcekey=eaf_title /></h4>
        <div class="row-fluid">
            <div class="pull-left" style="width:50%;">
                <h5 class="grid-title"><asp:Localize runat=server meta:resourcekey=eaf_usage_title /></h5>
                <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
                    <div class="row-fluid" style="position:relative;top:100px;">
                        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                    </div>
                    <div class="row-fluid" style="position:relative;top:115px;">
                        <h3 style="font-size:50px;">
                            <asp:localize runat="server" meta:resourcekey="loading_data" />
                        </h3>
                    </div>
                </div>
                <div class="eaf-usage-grid-container" data-bind="classes: { hide: not(all(hasData, not(isLoading))), }"></div>
            </div>
            <div class="pull-left" style="margin-left:2%;width:48%;">
                <h5 class="grid-title"><asp:Localize runat=server meta:resourcekey=eaf_cost_title /></h5>
                <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
                    <div class="row-fluid" style="position:relative;top:100px;">
                        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                    </div>
                    <div class="row-fluid" style="position:relative;top:115px;">
                        <h3 style="font-size:50px;">
                            <asp:localize runat="server" meta:resourcekey="loading_data" />
                        </h3>
                    </div>
                </div>
                <div class="eaf-cost-grid-container" data-bind="classes: { hide: not(all(hasData, not(isLoading))), }"></div>
            </div>
        </div>
        <div class="row-fluid">
            <div class="pull-left" style="width:50%;">
                <h5 class="grid-title"><asp:Localize runat=server meta:resourcekey=eaf_slag_title /></h5>
                <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
                    <div class="row-fluid" style="position:relative;top:100px;">
                        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                    </div>
                    <div class="row-fluid" style="position:relative;top:115px;">
                        <h3 style="font-size:50px;">
                            <asp:localize runat="server" meta:resourcekey="loading_data" />
                        </h3>
                    </div>
                </div>
                <div class="eaf-slag-grid-container" data-bind="classes: { hide: not(all(hasData, not(isLoading))), }"></div>
            </div>
            <div class="pull-left" style="margin-left:2%;width:25%;">
                <h5 class="grid-title"><asp:Localize runat=server meta:resourcekey=eaf_tap_temp_title /></h5>
                <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
                    <div class="row-fluid" style="position:relative;top:100px;">
                        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                    </div>
                    <div class="row-fluid" style="position:relative;top:115px;">
                        <h3 style="font-size:50px;">
                            <asp:localize runat="server" meta:resourcekey="loading_data" />
                        </h3>
                    </div>
                </div>
                <div class="eaf-tap-temp-grid-container" data-bind="classes: { hide: not(all(hasData, not(isLoading))), }"></div>
            </div>
        </div>
    </div>
    <div class="row-fluid" style="margin-bottom:10px;margin-top:10px;">
        <h4><asp:Localize runat=server meta:resourcekey=lf_title /></h4>
        <div class="row-fluid">
            <div class="pull-left" style="width:40%;">
                <h5 class="grid-title"><asp:Localize runat=server meta:resourcekey=lf_usage_title /></h5>
                <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
                    <div class="row-fluid" style="position:relative;top:100px;">
                        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                    </div>
                    <div class="row-fluid" style="position:relative;top:115px;">
                        <h3 style="font-size:50px;">
                            <asp:localize runat="server" meta:resourcekey="loading_data" />
                        </h3>
                    </div>
                </div>
                <div class="lf-usage-grid-container" data-bind="classes: { hide: not(all(hasData, not(isLoading))), }"></div>
            </div>
            <div class="pull-left" style="margin-left:2%;width:33%;">
                <h5 class="grid-title"><asp:Localize runat=server meta:resourcekey=lf_cost_title /></h5>
                <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
                    <div class="row-fluid" style="position:relative;top:100px;">
                        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                    </div>
                    <div class="row-fluid" style="position:relative;top:115px;">
                        <h3 style="font-size:50px;">
                            <asp:localize runat="server" meta:resourcekey="loading_data" />
                        </h3>
                    </div>
                </div>
                <div class="lf-cost-grid-container" data-bind="classes: { hide: not(all(hasData, not(isLoading))), }"></div>
            </div>
            <div class="pull-left" style="margin-left:2%;width:23%;">
                <h5 class="grid-title"><asp:Localize runat=server meta:resourcekey=lf_super_heats_title /></h5>
                <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
                    <div class="row-fluid" style="position:relative;top:100px;">
                        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                    </div>
                    <div class="row-fluid" style="position:relative;top:115px;">
                        <h3 style="font-size:50px;">
                            <asp:localize runat="server" meta:resourcekey="loading_data" />
                        </h3>
                    </div>
                </div>
                <div class="lf-super-heats-grid-container" data-bind="classes: { hide: not(all(hasData, not(isLoading))), }"></div>
            </div>
        </div>
    </div>
</div>