﻿define([
    'app',
    'js/templates-loader'
],

    function (app, T) {

    var Screen = {
        Models: {}, Views: {}, Collections: {},
    };

    Screen.Views.Main = Backbone.Epoxy.View.extend({
        template: 'navigation-buttons',
        isCacheable: false,
        events: function () {
            return {
            };
        },
        bindings: 'data-bind',
        coll: null,
        subviews : null,

        initialize: function (options) {
            this.options.state = app.view_states.loading;
            this.options.onappend = (_.isFunction(this.options.onappend)) ? this.options.onappend : function () { };

            var that = this;
            this.coll = new Screen.Collections.NavigationButton();
            this.bindEvents();

        },
        bindEvents: function () {
        },
        render: function (container, urlParams) {
            var that = this;
            var thatContainer = (this.options.container) ? this.options.container : container;
            this.options.container = thatContainer;

            var customPath = '/app/modules/' + this.template + '/';

            T.render.call(
                this,
                this.template,
                function (tmp) {
                    if (!that.options.i18n) that.options.i18n = {};

                    app.getI18NJed(
                        that,
                        that.template,
                        function (i18nJED) {
                            that.options.i18n[that.template] = i18nJED;
                            that.$el.html(tmp());

                            that.applyBindings();

                            //appending view to the main container
                            that.append(thatContainer, that.$el);

                            that.refresh();

                        },
                        true,
                        customPath
                    );
                },
                customPath
            );
        },
        refresh: function() {
            var that = this,
                container = this.$el.find('.navigation-buttons'),
                btn = null,
                navBtns = this.coll.toJSON();
            container.empty();
            _.each(navBtns, function (obj) {
                btn = new Screen.Views.NavigationButton({
                    model: new Backbone.Epoxy.Model(_.extend(
                        obj,
                        {
                            buttonName: obj.treatment ? (obj.text + ' T' + obj.treatment) : obj.text,
                        }
                    )),
                });

                // if has treatment i highlight the current Treatment and set false attribute currentPage in others treatments. Only way i find to compare it is with URL.

                if (obj.treatment != null && obj.treatment != ($(location).attr('href').charAt($(location).attr('href').length - 1)) ) {
                    obj.currentPage = 'false';
                  }
                if (obj.currentPage == 'true') {
                    
                    // highlight the button
                    btn.$el.addClass('highlightBtn');
                }
                container.append(btn.$el);
            });

        },
        setDataColl: function (resp) {
            if (this.coll)
                this.coll.reset();

            this.coll.setDataColl(resp);

            this.refresh();
        },
        append: function (container, el) {
            el = (el != null && el != undefined) ? el : this.$el;

            if (this.options.state == app.view_states.loading
                || this.options.state == app.view_states.shown) {
                //appending view to the main container and set state to shown

                this.options.state = app.view_states.shown;
                container.append(el);

                this.options.onappend(this);
            }

            if (this.options.state == app.view_states.hidden) {
                //append and remain hidden
                container.append(el);
            }

            if (this.options.state == app.view_states.closed) {
                //return without appending.
                return;
            }
        },
        bindViewScopedEvents: function () {
            var that = this;
        },
        unbindViewScopedEvents: function () {

        },
        close: function () {
            this.options.state = app.view_states.closed;

            this.closeSubviews();
            this.remove();
            this.unbindViewScopedEvents();
            this.unbind();
        },
        closeSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.close();
            });
        },
        show: function () {
            this.options.state = app.view_states.shown;

            this.showSubviews();
            this.bindEvents();
            this.$el.show();
        },
        showSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.show();
            });
        },
        hide: function () {
            this.options.state = app.view_states.hidden;

            this.hideSubviews();

            this.$el.hide();
            this.unbind();
            this.stopListening();
        },
        hideSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.hide();
            });
        },
        preRender: function () {
            app.models.subnavbar.set("subnavbar", false);
        },
        reRender: function (urlParams) {
            try {
                this.refresh(viewParams);
            } catch (Error) { }
        },

    });

    Screen.Models.NavigationButton = Backbone.Epoxy.Model.extend({
        defaults: {
            text: null,
            treatment: null,
            heatName: null,
            heatId: null,
        },

        parse: function (obj) {
            var result = {
                text: obj.Text ? obj.Text : null,
                treatment: obj.Treatment ? obj.Treatment : null,
                heatName: obj.HeatName ? obj.HeatName : null,
                heatId: obj.HeatId ? obj.HeatId : null,
                currentPage: obj.CurrentPage ? obj.CurrentPage : null,
            };
            return result;
        }

    });
    Screen.Collections.NavigationButton = Backbone.Collection.extend({
        model: Screen.Models.NavigationButton,
        setDataColl: function (data) {
            var newColl,
                that = this;
            newColl = _.map(data, that.model.prototype.parse);
            that.set(newColl).trigger('fetch', that, data);
        },
    });

    Screen.Views.NavigationButton = Backbone.Epoxy.View.extend({
        tagName: 'a',
        className: 'btn btn-default navigation-button',
        attributes: {
            'data-bind': "text: buttonName,",
        },
        events: function () {
            return {
                'click': this.click,
            };
        },

        parentModel: null,

        initialize: function (opt) {
            this.model = opt.model;
        },

        click: function (e) {
            var that = this;
            try {
                switch (this.model.get('text')) {
                    case 'LMF':
                        var treat = that.model.get('treatment') ? that.model.get('treatment') : 1;
                        Backbone.history.navigate('!/lmf-heat-report/' + this.model.get('heatName') + '/' + treat, { trigger: true });
                        break;
                    case 'VTD':
                        Backbone.history.navigate('!/vtd-heat-report/' + this.model.get('heatName') + '/' + this.model.get('treatment'), { trigger: true });
                        break;
                    case 'EAF':
                        Backbone.history.navigate('!/eaf-heat-report/' + this.model.get('heatName'), { trigger: true });
                        break;
                    case 'LAB':
                        Backbone.history.navigate('!/lab-heat-report/' + this.model.get('heatName'), { trigger: true });
                        break;
                    case 'SLAG EAF':
                        Backbone.history.navigate('!/slag-chemistry-samples-report-eaf/' + this.model.get('heatName'), { trigger: true });
                        break;
                    case 'THERMAL':
                        Backbone.history.navigate('!/thermal-profile/' + this.model.get('heatName'), { trigger: true });
                        break;
                    case 'CASTER':
                        Backbone.history.navigate('!/caster-heat-report/' + this.model.get('heatName'), { trigger: true });
                        break;
                    case 'LOG BOOK':
                        Backbone.history.navigate('!/casting-log-book/', { trigger: true });
                        break;
                } 
            }
            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
        },
    });





        // Required, return the module for AMD compliance.
        return Screen;

    });