﻿define([
  'app',
  'modules/base/base',
],
function (app, Base) {

    var Main = {
        Models: {},
        Collections: {},
    };

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Models.Base;
        superProto = superRef.prototype;

        Main.Models.ProcessConsumption = classRef = superRef.extend({
            defaults: _.extend(
                {},
                superProto.defaults,
                {
                    id: null,

                    processId: null,

                    code: null,
                    counter: null,
                    flowRate: null,
                    name: null,
                    status: null,
                }
            ),
            procedures: _.extend(superProto.procedures, {
                removeManualVariable: null,
            }),

            parse: function (obj) {
                return {
                    id: obj.Id,

                    processId: obj.ProcessId,

                    code: obj.Code,
                    counter: obj.Counter,
                    flowRate: obj.FlowRate,
                    name: obj.Name,
                    status: obj.Status,
                };
            },
            removeManualVariable: function (options) {
                var that = this,
                    qp = new QueryParameters(),
                    opt = _.extend(
                        {
                            params: {},
                            async: true,
                        },
                        options
                    );

                qp.Add('processId', 'INT', this.get('processId'));
                qp.Add('variableId', 'INT', opt.params.variableId);

                Core.Json.CallProcedure(
                    that.procedures.removeManualVariable,
                    qp,
                    {
                        onSuccess: function (resp) {
                            if ((resp) && (resp.Table) && (resp.Table.length > 0)) {
                                var obj = that.parse(resp.Table[0]);

                                that.set(obj, { from: 'fetch', })
                                    .trigger('fetch', that, resp, opt);

                                opt.success(that, resp, opt);
                            }
                            else {
                                var msg = (resp.Message) ? resp.Message : 'SERVER_RESPONSE_NOT_VALID';

                                opt.error(that, msg);
                                console.error(new Error(msg).stack);
                            }
                        },
                        onError: function (msg) {
                            try {
                                opt.error(msg);
                                console.error(new Error(msg).stack);
                            }
                            catch (Error) { console.error(Error.stack); }
                        },
                        Async: opt.async,
                        Secured: true,
                    },
                    app.ConnectionStrings.app
                );
            },
        });
    })();

    (function () {
        var superRef, superProto, classRef;

        superRef = Base.Collections.Base;
        superProto = superRef.prototype;

        Main.Collections.ProcessConsumptions = classRef = superRef.extend({
            model: Main.Models.ProcessConsumption,
            comparator: 'name',
        });
    })();

    // Required, return the module for AMD compliance.
    return Main;

});