define([
    'app',
    'js/templates-loader',
    'backgrid',
    'moment',
    'js/multiselect/virtual-select.min',
    'js/bootstrap-input-spinner/bootstrap-input-spinner',
    "select2",
    "select2totree",
],

    function (app, T, Backgrid, moment) {

        var Screen = {
            Models: {}, Views: {}, Collections: {},
        };

        Screen.Views.Main = Backbone.Epoxy.View.extend({
            el: null,
            data: null,
            maximumSelectionLength: null,
            selectType: 'default', // default, tree
            disabledByDefault: true,
            tagging: false,

            initialize: function (opt) {
                this.el = opt.el;
                this.data = opt.data;
                this.maximumSelectionLength = opt.maximumSelectionLength ? opt.maximumSelectionLength : null;
                this.selectType = opt.selectType ? opt.selectType : 'default';
                this.disabledByDefault = opt.disabledByDefault !== null ? opt.disabledByDefault : true,
                this.tagging = opt.tagging !== null ? opt.tagging : false,
                this.render();
            },
            render: function () {
                var that = this;
                if (that.maximumSelectionLength) this.$el.attr("multiple", true);

                if (this.selectType === 'tree') {
                    this.$el.select2ToTree({
                        treeData: {
                            dataArr: that.data,
                        },
                        expandSelectedItemParents: true,
                        maximumSelectionLength: that.maximumSelectionLength,

                    });
                    this.$el.select2ToTree({ expandSelectedItemParents: true });
                    //this.$el.prop('disabled', true).trigger('change');
                    if (that.disabledByDefault) this.$el.prop('disabled', true).trigger('change');
                } else {
                    this.$el.select2({
                        data: that.data,
                        tags: true,

                    });
                    //this.$el.prop('disabled', true).trigger('change');
                    if (that.disabledByDefault) this.$el.prop('disabled', true).trigger('change');
                }
            },
        })
        // Required, return the module for AMD compliance.
        return Screen;

    });