﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<script id="delays_report" type="text/x-handlebars-template">

    <link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/app/pages/caster/caster-delays-by-date/caster-delays-by-date.css")%>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/libs/js/jquery.contextMenu/jquery.contextMenu.css") %>" rel="stylesheet" />
    
    <link href="<%= ResolveUrl("~/assets/ag-grid/ag-grid.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/ag-grid/ag-theme-alpine.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/fonts/reboto-font.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/tailwind/tailwind.min.css") %>" rel="stylesheet" />

<style>

     /* Reduced grid container height */
     .processes-grid-container.ag-theme-alpine {
        height: 70vh; /* Reduced height */
        border: 1px solid #ccc;
    }
    .ag-root-wrapper.ag-layout-normal.ag-ltr {
        height: 70vh;
    }
    
 .processes-grid-container .ag-pinned-right-cols-container,
    .processes-grid-container .ag-pinned-left-cols-container {
      border-right: none !important;
    } 
    
    .ag-cell.ag-cell-last-left-pinned:not(.ag-cell-range-right):not(.ag-cell-range-single-cell) {
        border-right: none !important;
    }

    .ag-pinned-left-header {
    border-right: none !important;
}
    
 /* Page content */
 .content-container{
            padding-top: 0px !important;
        }
        #subnavbar-inner{
            display:none !important;
        }
        /*Page Title */
       .professional-title {
            font-size: 22px;
            font-weight: 400;
            color: #202124;
            padding-bottom: 1px;
            border-bottom: 1px solid #dadce0;
            margin-bottom: 2px;
            font-family: 'Roboto', Arial, sans-serif;
            margin-left: 10px;
        }
        /*date picker*/
        .date-picker{
            border:none !important;
            margin-bottom: 0px !important;
            -webkit-box-shadow:none !important;
            box-shadow: none !important;
            width: 100px;
            text-align: center;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .spinner {
            animation: spin 1s linear infinite;
            transform-origin: center;
        }

        @keyframes downloadAnimation {
            0% { transform: translateY(-1px); }
            50% { transform: translateY(1px); }
            100% { transform: translateY(-1px); }
        }
        .document {
            animation: downloadAnimation 1s ease-in-out infinite;
        }

</style>

<h2 class="professional-title">Caster Delays By Date</h2>

<div class="bg-white shadow-md rounded-lg p-2 mb-4">  
    <div data-bind="classes: { hide: isPageLoading }">
        <div class="bg-white shadow-md rounded-lg mb-2">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-2 mb-2">         
                    <div class="flex flex-wrap items-center space-x-1">
                        <div class="flex flex-col">
                            <div class="flex items-center">
                                <label for="dateTbx" class="ml-2 mr-2 text-sm font-medium text-gray-700">Start</label>
                                <div class="flex items-center border border-gray-300 rounded-md z-100">
                                    <input type="text" id="dateStartTbx" class="input-date date-picker pl-10 pr-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500 z-100" style="z-index:1000;width:100px" data-bind="value: momentFormat(start$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
                                    <button id="calendarStartBtn" class="px-2 py-2 border-l border-gray-300 hover:bg-gray-100">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-600" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd" />
                                        </svg>
                                    </button>
                                </div>
                            </div>
                        </div>


                        <div class="flex flex-col"></div>
                            <div class="flex items-center">
                                <label for="dateTbx" class="ml-2 mr-2 text-sm font-medium text-gray-700 z-100">End</label>
                                <div class="flex items-center border border-gray-300 rounded-md">
                                    <input type="text" id="dateEndTbx" class="input-date date-picker pl-10 pr-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500 z-100" style="z-index:1000;width:100px" data-bind="value: momentFormat(end$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
                                    <button id="calendarEndBtn" class="px-2 py-2 border-l border-gray-300 hover:bg-gray-100">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-600" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd" />
                                        </svg>
                                    </button>
                                </div>
                            </div>

                            <button id="redirectToDelayMg"
                            class="bg-blue-600 hover:bg-blue-700 text-white py-2 px-4 rounded flex items-center justify-center"
                            style="width: 250px; height: 36.5px; font-size: 14px;  margin-left:50px;">
                            <span>Delay Manager</span>
                            </button>
                            </div> 
                </div>
                <div class="flex items-center space-x-2 mb-2">
                   

                    <!-- Toggle Area / Cause -->
                    <div class="inline-flex border border-blue-600 rounded-full overflow-hidden mr-6">
                        <!-- Area -->
                        <div id="viewToggle" class="inline-flex rounded-full border border-blue-600 overflow-hidden">
                            <button type="button" data-value="area"
                                    class="toggle-btn px-4 py-2 bg-blue-600 text-white">
                              Area
                            </button>
                            <button type="button" data-value="cause"
                                    class="toggle-btn px-4 py-2 bg-white text-blue-600">
                              Cause
                            </button>
                          </div>
                      </div>
                  
                    <!-- Refresh button -->
                    <button id="refreshBtn"
                            class="bg-blue-600 hover:bg-blue-700 text-white py-2 px-4 rounded flex items-center justify-center"
                            style="width: 250px; height: 36.5px; font-size: 14px;">
                      <div data-bind="classes: { hide: isLoading }"><span>Refresh</span></div>
                      <div data-bind="classes: { hide: not(isLoading) }">
                        <div class="flex items-center">
                          <svg class="h-5 w-5 mr-3" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <g class="spinner">…</g>
                          </svg>
                          <span>Loading...</span>
                        </div>
                      </div>
                    </button>
                  </div>
            </div>   
                    
        </div>   
        <div class="relative w-full h-[70vh] mt-6">  

            <!-- AREA SECTION -->
            <div id="areaSection"
                 class="absolute inset-0 transition-opacity duration-500 ease-in-out opacity-100">
              <div class="flex space-x-4 h-full">
                <div class="w-1/2">
                    <h2 class="text-xl mt-6 mb-4">Area Codes Breakdown</h2>
                  
                  <div id="categoryGrid" class="processes-grid-container ag-theme-alpine h-full"></div>
                </div>
                <div class="w-1/2">
                  <h2 class="text-xl mt-6">Total Delays By Area</h2> 
                  <div id="metricToggle" class="inline-flex rounded-full border border-blue-600 overflow-hidden ml-4 mt-4">
                    <button type="button" data-metric="count"
                            class="toggle-btn metric-btn bg-blue-600 text-white px-4 py-2">
                    Count
                    </button>
                    <button type="button" data-metric="minutes"
                            class="toggle-btn metric-btn bg-white text-blue-600 px-4 py-2">
                    Minutes
                    </button>
                </div>
                  <canvas id="categoryChart" class="w-full h-[calc(70vh-2rem)] mt-10"></canvas>
                </div>
              </div>
            </div>
          
            <!-- CAUSE SECTION (start invisible) -->
            <div id="causeSection"
     class="absolute inset-0 transition-opacity duration-500 ease-in-out
            opacity-0 z-0 pointer-events-none">
              <div class="flex space-x-4 h-full">
                <div class="w-1/2">
                  <h2 class="text-xl mt-6 mb-4">Causes Codes Breakdown</h2> 
                  <div id="detailsGrid" class="processes-grid-container ag-theme-alpine h-full"></div>
                </div>
                <div class="w-1/2">
                    
                  <h2 class="text-xl mt-6">Total Delays By Cause</h2>
                     <!-- Metric Toggle -->
                <div id="metricToggle" class="inline-flex rounded-full border border-blue-600 overflow-hidden ml-4 mt-4">
                    <button type="button" data-metric="count"
                            class="toggle-btn metric-btn bg-blue-600 text-white px-4 py-2">
                    Count
                    </button>
                    <button type="button" data-metric="minutes"
                            class="toggle-btn metric-btn bg-white text-blue-600 px-4 py-2">
                    Minutes
                    </button>
                </div>
                  <canvas id="delayCodesChart" class="w-full h-[calc(70vh-2rem)] mt-10"></canvas>
                </div>
              </div>
            </div>
          
          </div>
    </div>   
    
    <div data-bind="classes: { hide: not(isPageLoading) }">
        <div class="bg-white shadow-md rounded-lg mb-2">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-2 mb-2">
                    <div class="flex flex-wrap items-center space-x-1">
                        <div class="skeleton-input w-40 h-10 bg-gray-200 rounded-md"></div>
                        <div class="skeleton-input w-40 h-10 bg-gray-200 rounded-md"></div>
                    </div>
                    <div class="skeleton-select w-32 h-10 bg-gray-200 rounded-md"></div>
                </div>
                <div class="flex space-x-2 mb-2">
                    <div class="skeleton-button w-64 h-9 bg-gray-200 rounded"></div>
                </div>
            </div>
        </div>
        <div class="mx-auto">
            <div class="bg-white shadow-md rounded-lg p-2 mb-4" style="border: 4px solid #ccc;">
                <div class="skeleton-grid w-full h-64vh bg-gray-200"></div>
            </div>
        </div>
    </div>
</div>
</script>

