﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>


<div class="modal-header">
    {{#if allowCancel}}
    <button type="button" id="btn-close" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
    {{/if}}
    <h3 id="modalLabel">{{header_title}}</h3>
</div>
<div class="modal-body">
    {{#if message}}
        <p>{{message}}</p>    
    {{/if}}
</div>
<div class="modal-footer">
    {{#ifEquals buttons_type "CONTINUE-CANCEL"}}
    <button type="submit" class="btn btn-primary" id="btn-continue"><asp:Localize runat="server" meta:resourcekey="modal_continue" /></button>
    <button class="btn" id="btn-cancel" data-dismiss="modal" aria-hidden="true"><asp:Localize runat="server" meta:resourcekey="modal_cancel" /></button>
    {{/ifEquals}}
    {{#ifEquals buttons_type "OK-CANCEL"}}
    <button type="submit" class="btn btn-primary" id="btn-continue"><asp:Localize runat="server" meta:resourcekey="modal_ok" /></button>
    <button class="btn" id="btn-cancel" data-dismiss="modal" aria-hidden="true"><asp:Localize runat="server" meta:resourcekey="modal_cancel" /></button>
    {{/ifEquals}}
    {{#ifEquals buttons_type "OK"}}
    <button type="submit" class="btn btn-primary" id="btn-continue"><asp:Localize runat="server" meta:resourcekey="modal_ok" /></button>
    {{/ifEquals}}
    {{#ifEquals buttons_type "YES-NO"}}
    <button type="submit" class="btn btn-primary" id="btn-continue"><asp:Localize runat="server" meta:resourcekey="modal_yes_action" /></button>
    <button class="btn" id="btn-cancel" data-dismiss="modal" aria-hidden="true"><asp:Localize runat="server" meta:resourcekey="modal_no_action" /></button>
    {{/ifEquals}}
    {{#ifEquals buttons_type "CUSTOM-YES-NO"}}
    <button type="submit" class="btn btn-primary" id="btn-continue">{{custom_yes_lbl}}</button>
    <button class="btn" id="btn-cancel" data-dismiss="modal" aria-hidden="true">{{custom_no_lbl}}</button>
    {{/ifEquals}}
    {{#ifEquals buttons_type "CUSTOM-BUTTONS"}}
        {{#each buttons}}
        <button data-buttonid="{{id}}" class="modal-custom-btn btn {{classNames}}" aria-hidden="true">{{btn_lbl}}</button>
        {{/each}}
    {{/ifEquals}}
</div>
