﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<div class="row-fluid">
<div class="span12">    
    <div class="text-center tooltip-this" style="cursor:pointer;padding-top:14px;" data-toggle="tooltip" data-placement="bottom" data-original-title="<asp:Localize runat="server" meta:resourcekey="time_sinchronized_tooltip" />">
        <%--this should be fixed, time should be centered inside the span--%>
        <span style="font-size:24px; " class="text-center">
            {{string_hours}}:{{string_minutes}}
            <%--<div id="clock-hours" class="pull-left">
                <h5>{{string_hours}}</h5>
            </div>
            <div id="clock-colons" class="pull-left">
                <h6>:</h6>
            </div>
            <div id="clock-minutes" class="pull-left">
                <h5>{{string_minutes}}</h5>
            </div>--%>
        </span>
    </div>
</div>
</div>