﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<div class="span10 offset1">
    <div class="page-header">
        <h2>User Settings</h2>
    </div>
    <div class="row-fluid">
        <div class="control-group">
            <div class="span2"><h4><asp:Localize runat="server" meta:resourcekey="username_label" /></h4></div>
            <div class="controls">
                <input type="text" disabled="disabled" value="{{userModel_username}}" />
            </div>
        </div>
        <div class="control-group">
            <div class="span2"><h4><asp:Localize runat="server" meta:resourcekey="prefLanguage_label" /></h4></div>
            <div class="controls">
                <select id="userLanguage_select">
                    <option value="no_language"><asp:Localize runat="server" meta:resourcekey="noLanguage_option_label" /></option>
                    <option value="ES"><asp:Localize runat="server" meta:resourcekey="spanish_option_label" /></option>
                    <option value="EN"><asp:Localize runat="server" meta:resourcekey="english_option_label" /></option>
                    <option value="FR"><asp:Localize runat="server" meta:resourcekey="french_option_label" /></option>
                </select>
                <select id="picker2"></select>
                <select id="picker3"></select>
            </div>
        </div>
        <br />
        <div class="control-group">
            <button id="save_btn" class="btn btn-success"><asp:Localize runat="server" meta:resourcekey="savebtn_label" /></button>
            <button id="cancel_btn" class="btn btn-danger"><asp:Localize runat="server" meta:resourcekey="cancelbtn_label" /></button>
        </div>
    </div>
</div>