﻿/*
  backgrid-time-cell 1.0.0
*/
(function (root, factory) {

    if (typeof define === 'function' && define.amd) {
        // AMD
        define(['underscore', 'backgrid'], factory);
    } else if (typeof exports === 'object') {
        // CommonJS
        module.exports = factory(require('underscore'), require('backgrid'));
    } else {
        // Browser globals
        factory(root._, root.Backgrid);
    }

}(this, function (_, Backgrid) {

    //Fix require config issue with Underscore.
    if (!_)
        _ = this._;

    Backgrid.Extension.I18Cell = Backgrid.StringCell.extend({
        className: 'string-cell i18n-cell',
        formatter: Backgrid.Extension.I18CellFormatter,
    });

    Backgrid.Extension.I18CellFormatter = I18CellFormatter = function (options) { };
    I18CellFormatter.prototype = new Backgrid.Extension.I18CellFormatter;
    _.extend(I18CellFormatter.prototype, {
        i18n: null,
        i18nSources: null,

        fromRaw: function (rawData) {
            if (rawData == null) return '';

            return this.i18n.translate(this.i18nSources, rawData);
        },
    });
    I18CellFormatter.extend = Backbone.Model.extend;
}));
