﻿using Helpers.Log;
using log4net;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Reflection;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class landing_api_confirm_email : Page
{
    private ILog logger = Logger.GetLogger(MethodBase.GetCurrentMethod().DeclaringType.Name);

    protected void Page_Load(object sender, EventArgs e)
    {
        TransactionLogger tranLog = new TransactionLogger(logger, MethodBase.GetCurrentMethod().Name);
        tranLog.LogDebug("Start: confirm-email api method...");

        System.Web.Script.Serialization.JavaScriptSerializer jss = new System.Web.Script.Serialization.JavaScriptSerializer();
        try
        {
            string key = Request.Form["key"]; 
            if (key != null){
                string status = DAL.confirmKey(key);
                Response.Write(jss.Serialize(new { status = status }));
            }else{
                Response.Write(jss.Serialize(new { status = "FAILED" }));
            }
        }
        catch (Exception ex) 
        {
            tranLog.LogDebug(ex, "Confirm-Email API failed. "); 
        }
    }
}