﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>


<script id="confirmation_modal" type="text/x-handlebars-template">
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 class="text-lg font-semibold text-gray-800 mb-4" data-bind="text: title"></h3>       
    </div>
    <div style="max-height:450px;" class="modal-body noselect">
        <div class="space-y-4">

            <!-- Message -->
            <div class="flex space-x-4 items-center">
               <h1 data-bind="text: message"></h1>  
            </div>

        </div>
    </div>

    <div class="modal-footer noselect">
        <div class="flex justify-between">
            <button id="acceptBtn" data-bind="text: acceptBtnLabel" class="bg-blue-600 text-white py-2 px-4 rounded hover:bg-blue-700" style="width: 250px; height: 36.5px;"></button>
            <button id="cancelBtn" data-bind="text: cancelBtnLabel" class="btn-close bg-gray-100 hover:bg-gray-200 rounded" style="width: 250px; height: 36.5px; border: 1px solid;"></button>
        </div>
    </div>
</script>
