﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<% if (!Request.IsLocal){ %>
<div class="container-fluid">
    <div class="hero-unit">
        <h4><asp:Localize runat="server" meta:resourcekey="agentOPC_title" /></h4>
        <p>
            <asp:Localize runat="server" meta:resourcekey="agentOPC_description" />
        </p>
        <p class="text-center download-agent-section-OPC">
            <button id="download_agent_opc" class="btn btn-primary btn-large">
                <asp:Localize runat="server" meta:resourcekey="downloadOPCAgent_downloadButtonText" />
            </button>
        </p>
        <div class="generate-download-progress-section-OPC hide">
            <div class="row-fluid text-center">
                <span class="text-info"><asp:Localize runat="server" meta:resourcekey="preparing_download_label" /></span>
            </div>
            <div class="row-fluid">
                <div class="progress progress-info progress-striped active offset3 span6">
                    <div class="bar generate-download-progress-bar" style="width: 100%"></div>
                </div>
            </div>
        </div>
        <div class="download-failed-section-OPC hide">
            <span class="text-error"><asp:Localize runat="server" meta:resourcekey="download_failed_label" /></span>
            <button data-type="OPC" class="reset-download-btn btn btn-info"><asp:Localize runat="server" meta:resourcekey="go_back_label" /></button>
        </div>
        <div class="starting-download-section-OPC hide">
            <span class="text-success"><asp:Localize runat="server" meta:resourcekey="download_success_label" /></span>
            <a href="#" class="download-direct-link-OPC"><span><asp:Localize runat="server" meta:resourcekey="if_download_does_not_start" /></span></a>
        </div>
        <h4><asp:Localize runat="server" meta:resourcekey="agentPLC_title" /></h4>
        <p>
            <asp:Localize runat="server" meta:resourcekey="agentPLC_description" />
        </p>
        <p class="text-center download-agent-section-PLC">
            <button id="download_agent_plc" class="btn btn-primary btn-large">
                <asp:Localize runat="server" meta:resourcekey="downloadPLCAgent_downloadButtonText" />
            </button>
        </p>
        <div class="generate-download-progress-section-PLC hide">
            <div class="row-fluid text-center">
                <span class="text-info"><asp:Localize runat="server" meta:resourcekey="preparing_download_label" /></span>
            </div>
            <div class="row-fluid">
                <div class="progress progress-info progress-striped active offset3 span6">
                    <div class="bar generate-download-progress-bar" style="width: 100%"></div>
                </div>
            </div>
        </div>
        <div class="download-failed-section-PLC hide">
            <span class="text-error"><asp:Localize runat="server" meta:resourcekey="download_failed_label" /></span>
            <button data-type="PLC" class="reset-download-btn btn btn-info"><asp:Localize runat="server" meta:resourcekey="go_back_label" /></button>
        </div>
        <div class="starting-download-section-PLC hide">
            <span class="text-success"><asp:Localize runat="server" meta:resourcekey="download_success_label" /></span>
            <a href="#" class="download-direct-link-PLC"><span><asp:Localize runat="server" meta:resourcekey="if_download_does_not_start" /></span></a>
        </div>
    </div>
</div>
<% } %>