﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
   
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture =
            CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new
            CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
 
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar not-print" style="min-width:1305px;margin-top: -1px;""> 
    <div class="form-inline pull-left span11" style="min-width:1260px;"> 
      
        
        <label class="control-label" id="shift">
            <button id="backNavBtn" class="btn btn-primary " style="margin-bottom:5px;margin-right:5px;" data-bind="disabled:  isLoading">
                        <asp:Localize runat="server" meta:resourcekey="back_item_btn_label" />
            </button> 
  
            <label class="input-prepend" id="date" style="margin-bottom:5px;">
                <span class="add-on"><i class="icon-calendar"></i></span>
                <input type="text" id="productionDateTbx" class="input-date" style="width:75px;z-index:1000;" data-bind="value: productionDate, disabled: isLoading ">
            </label>
            
            <input type="text" style="width:20px; text-align:center; margin-top: -5px;" data-bind="value:shiftId"  readonly />
            <button id="forwardNavBtn" class="btn btn-primary" style="margin-bottom:5px;margin-left:10px;" data-bind="disabled:  isLoading">
                        <asp:Localize runat="server" meta:resourcekey="forward_item_btn_label" />
            </button>
        </label>
        
        <button id="refreshBtn" class="btn btn-primary" style="margin-bottom:5px;margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />"  data-bind=" disabled: isLoading">
            <i class="fa fa-refresh"></i>
        </button>

        <div class="pull-right" style="margin-right:10px;">
            <button id="printBtn" class="btn btn-primary"  style="margin-bottom:5px;margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=print_btn_title />"  data-bind="disabled:  any(not(hasData), isLoading)" >
                <i class="fa fa-print"></i>
            </button>
            <button style="margin-top:0; margin-left:10px; margin-right:10px;" class="btn btn-export-to-excel pull-right hide" type="button">
                <span class="excel-export-state fa fa-file-excel-o"></span>
                <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
            </button>
        </div>
        
    </div>
</div>
<div class="row-fluid screen-content" style="min-width:1260px;">
   <div id="pageborder" style="margin-bottom:5px !important"></div>
    <div class="no-data-poster row-fluid text-center animated fadeIn not-print" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="no_data_available" />
            </h3>
        </div>
    </div> 
 
    <div class="no-data-poster row-fluid text-center animated fadeIn not-print" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
    <div class="row entry-row body-print" style="margin-left:30px;">
        <div class="entry-div-label" data-bind="classes: { hide: any(not(hasData), isLoading), }" >

            <!--STEEL DYNAMICS LOGO HTML-->
            <div class="row fluid">           
                <div id ="img-logo-main" class="span6 not-print" style="max-width:350px; margin-top: 0px; margin-left: 30px;" >
                    <img src='<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + 
                    Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".jpg") %>' />
                </div>
                <div class="span6 page-title not-print " style="font-size:40px; margin-top:20px; margin-left:24%;color:black;  "
                    data-bind="classes: { hide: any(not(hasData), isLoading), }">
                    <h2>
                        <asp:localize runat="server" meta:resourcekey="title_tbx_label" />
                    </h2>
                </div>
            </div>

             <!--STEEL DYNAMICS LOGO PRINT OPTION-->
            <div class="container-logo-title">
                <div class="badge-logo-title">
                    <div id ="img-logo" style="margin-left:-40px; /*margin-top:-100px;*/">
                        <img src='<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + 
                        Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".jpg") %>' />
                    </div>
                </div>
                <div class="badge-logo-title" style="margin-left: 80px; margin-top:100px;">
                    <h2 id="pdf-title">
                        <asp:localize runat="server" meta:resourcekey="title_tbx_label" />
                    </h2>
                </div>
            </div>

             <!--PRODUCTION DATE-->
            <div class="container-label" style="margin-left:-30px; margin-top:10px;">
                <div class="badge-label">
                    <label style="font-size:18px; margin-left: 10px;"  class="text-font-general">
                        <asp:localize runat="server" meta:resourcekey="date_tbx_label" />
                    </label>
                </div>
                <div class="badge-label" style="font-size:22px; font-weight:bold; margin-top:5px; margin-left:30px;">
                    <span data-bind="text: productionDate"></span>
                </div>
                <hr class="underline-date"/>
            </div>
            
             <!--SHIFT-->
            <div class="container-label" style="margin-left:-30px; margin-top:10px; margin-bottom:5px;float:left !important;">
                <div class="badge-label">
                    <label style="font-size:18px; margin-left: 10px;">
                        <asp:localize runat="server" meta:resourcekey="shift_combo_label" />
                    </label>
                </div>
                <div class="badge-label" style="font-size:22px; font-weight:bold; margin-left: 20px;"> 
                    <span class= "date_label" data-bind="text: shiftId"></span>
                </div>
                
                <hr class="underline-shift"/>
            </div>
            

            <!--CREW-->
            <div class="container-label" style="margin-left:-300px; margin-top:10px; margin-bottom:5px;float:left !important;">
                <div class="badge-label">
                    <label style="font-size:18px; margin-left: 10px;">
                        <asp:localize runat="server" meta:resourcekey="crew_combo_label" />
                    </label>
                </div>
                <div class="badge-label" style="font-size:22px; font-weight:bold; margin-left: 20px;"> 
                    <span class= "date_label" data-bind="text: crewId"></span>
                </div>
                
                <hr class="underline-shift"/>
            </div>
            <div class="row-fluid" style="margin-top:5px">
                <hr />
            </div>
            <%-- Print --%>
            <div class="row-fluid print" style="margin-left:-10px !important">
                <div class="span4">
                    <div data-bind="classes: { hide: any(not(hasData_warehouseCosts), isLoading_warehouseCosts), }">
                        <h4>Warehouse Costs</h4>
                        <div class="items-grid-container-warehouseCosts-print" style="max-width:50%; font-size:13px;"></div>
                    </div>
                </div>
                 
            </div>
            <div class="row-fluid print" style="margin-left:-10px !important">
                <div class="span6">
                    <div>
                        <h4>Tons per Heat (TPH)</h4>
                        <div class="items-grid-container-tph-print" style="max-width:60%; font-size:13px;"></div>
                    </div>
                </div>
            </div>
            

            <!--HEAT GANT CHARTS-->
            <div class="row-fluid not-print" style="margin-top:50px;">
                <div class="span10 avoid">
                    <div class="EAF-chart-print" style="margin-left: 13%;" data-bind="classes: { hide: any(not(hasData), isLoading), }" >
                        <h4 class="gantt-label">
                            <asp:localize runat="server" meta:resourcekey="caster1_label"  />
                        </h4>
                        <svg style="margin-top:20px"class="chart-CASTER-1 center-chart"></svg>
                    </div>
                    <div class="EAF-chart-print" style="margin-left: 13%;" data-bind="classes: { hide: any(not(hasData), isLoading), }" >
                        <h4 class="gantt-label">
                            <asp:localize runat="server" meta:resourcekey="caster2_label"  />
                        </h4>
                        <svg style="margin-top:20px"class="chart-CASTER-2 center-chart"></svg>
                    </div>
                </div>
            </div>

             <div class="row-fluid print" style="margin-top:50px">
                <div class="span12 avoid">
                    <div class="EAF-chart-print" style="margin-left: -50px !important;" data-bind="classes: { hide: any(not(hasData), isLoading), }" >
                        <h4 class="gantt-label">
                            <asp:localize runat="server" meta:resourcekey="caster1_label"  />
                        </h4>
                        <svg style="margin-top:20px;"class="chart-CASTER-1-print" ></svg>
                    </div>
                    <div class="EAF-chart-print" style="margin-left:-50px !important;" data-bind="classes: { hide: any(not(hasData), isLoading), }" >
                        <h4 class="gantt-label">
                            <asp:localize runat="server" meta:resourcekey="caster2_label"  />
                        </h4>
                        <svg style="margin-top:20px;"class="chart-CASTER-2-print"></svg>
                    </div>
                </div>
            </div>

            
            <div class="row-fluid not-print" style="margin-left:-15px; margin-top:10px;">
                <div class="span6">
                    <div data-bind="classes: { hide: any(not(hasData_warehouseCosts), isLoading_warehouseCosts), }">
                        <h4>Warehouse Costs</h4>
                        <div class="items-grid-container-warehouseCosts" style="font-size:13px;"></div>
                    </div>
                    <div data-bind="classes: { hide: any(not(hasData_caster1), isLoading_caster1), }">
                        <h4>Production</h4>
                        <div class="items-grid-container-production"></div>
                    </div>
                </div>
                <div class="span6">
                    <div data-bind="classes: { hide: any(not(hasData_caster1), isLoading_caster1), }">
                        <h4>Log Book</h4>
                        <div class="items-grid-container-caster-1"></div>
                    </div>
                </div>
            </div>
            
            
            <%-- Print --%>
            <div class="row-fluid print" style="margin-left:-15px; margin-top:10px;">
                <div class="span6">
                    <div data-bind="classes: { hide: any(not(hasData_caster1), isLoading_caster1), }">
                        <h4>Production</h4>
                        <div class="items-grid-container-production-print" style="width:90% !important; font-size:13px;"></div>
                    </div>
                </div>
                <div class="span6">
                    <div data-bind="classes: { hide: any(not(hasData_caster1), isLoading_caster1), }">
                        <h4>Log Book</h4>
                        <div class="items-grid-container-caster-1-print" style="width:90% !important; font-size:13px;"></div>
                    </div>
                </div>
            </div>
        

        </div>
    </div>   
   

</div>