USE [IHBoxSystem]
GO

USE [IHBoxSystem]
GO
CREATE ROLE castersShiftReportPDF_read AUTHORIZATION dbo 
GO  


USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'castersShiftReportPDF_read', 'SDI/australtek'
GO


INSERT INTO [FrontEnd].[Routes]
           ([Route]
           ,[ModuleName]
           ,[ModulePath]
           ,[RequiredRole]
       )
     VALUES
           (
		   '!/casters-shift-report(/:productionDate)(/:shiftId)'
           , 'casters-shift-report'
		   , 'custom-screens/casters-shift-report/'
           , 'castersShiftReportPDF_read'
           
		   )



INSERT INTO [FrontEnd].[Menu]
           ([Parent]
           ,[Name]
           ,[RouteID]
           ,[SortOrder]
           ,[Enabled]
           ,[Visible]
           ,[RequiredRole]
           ,[Group]
          )
     VALUES
           (
		   (select top 1 Id from FrontEnd.menu where Name = 'Caster' and Parent is null)
		   ,'Shift Report'
           ,@@IDENTITY
           ,(select Max(SortOrder)+1 from FrontEnd.Menu where Parent = (select Id from frontend.Menu where [Name] = 'Caster'))
           ,1
           ,1
           ,'castersShiftReportPDF_read'
           ,NULL
         )
GO

/*------------------------------------------------------Profiles------------------------------------------------------*/


EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [castersShiftReportPDF_read] -- The role
,@name = N'securedsp-CAS.GetShiftReport' -- the procedure
,@value = N'' 
GO
