﻿//SCREEN-BOILERPLATE
//this boilerplate builds screens that are gonna be shown in the <div class='content'> tag of our main HTML.
//do not build app components with this boilerplate, only screens (reports)

define([
  // Application variable, always include it to have access to app methods.
  'app',

  //templates-loader: this loads templates async.
  'js/templates-loader',
  'backgrid',
  'moment',
  'modules/navigation-buttons/navigation-buttons',
  'backgrid/moment-cell',
  'js/autocomplete/backbone.autocomplete'

],
    function (app, T, Backgrid, moment, NavigationButton) {

    var Screen = { Models: {}, Views: {}, Collections: {} }

    
    Screen.Models.Main = Backbone.Epoxy.Model.extend({
        defaults: {
            furnaceCodes: [{ label: 'A', value: 1 }, { label: 'B', value: 2 }],
            furnaceCode: 1,

            //URL parameters

            heatName: '-',

            hasData_process: false,
            isLoading_process: false,

            heatId: null,
            direction: null,
            navigation: null,
            heatNames: [],
            enterPress: false,
        },
        computeds: {
            hasData: {
                deps: ['hasData_process'],
                get: function (process) {
                    return process;
                },
            },
            isLoading: {
                deps: ['isLoading_process'],
                get: function (process) {
                    return process;
                },
            },
        },
        initialize: function () {
            this.process = new Screen.Collections.Process();

            this.limits = new Screen.Collections.Process();
        },
        fetchPickers: function (params) {
            var that = this,
                qp = new Core.Database.QueryParameters()
                async = null;

            if (params.async == null) async = true;
            else async = params.async


            qp.Add('@heatName', 'VARCHAR', params.heatName);

            Core.Json.CallProcedure(
                app.DatabaseNames.MES + '.LAB.GetChemistrySamplesCatalogs',
                qp,
                {
                    onSuccess: function (resp) {
                        try {
                            if ((resp) && (resp.Table)) {
                                that.set('heatNames', _.map(resp.Table, function (obj) {
                                    return {
                                        name: obj.Name,
                                        heatId: obj.HeatId,
                                        gradeName: obj.GradeName,
                                    };
                                }));


                                if (params.firstRefresh) {
                                    if (that.get('heatNames').length > 0) {
                                        var fromDb = that.get('heatNames')[0];
                                        if (fromDb) {
                                            that.set({
                                                heatId: fromDb.heatId,
                                                heatName: fromDb.name,
                                                gradeName: fromDb.gradeName,
                                            })
                                        }
                                    }
                                }

                            }
                            else {
                                if ((resp) && (resp.Message))
                                    console.error(new Error(resp.Message).stack);
                                else
                                    console.error(new Error('SERVER_RESPONSE_NOT_VALID').stack);
                            }
                        }
                        catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
                    },
                    onFailure: function (resp) {
                        console.error(resp);
                    },
                    Secured: true,
                    Async: async,
                },
                app.ConnectionStrings.app
            );

            return this;
        },

        fetch: function (params) {
            var that = this;
            var qp = new Core.Database.QueryParameters();

            qp.Add('@heatId', 'INT', params.heatId);
            qp.Add('@direction', 'BIT', params.direction);
            qp.Add('@ladleFurnaceCode', 'INT', params.furnaceCode );
            qp.Add('@timeZoneCode', 'CHAR(10)', app.models.user.get('timezoneCode'));

            Core.Json.CallProcedure(
                app.DatabaseNames.MES + '.LAB.GetChemistrySamplesReport',
                qp,
                {
                    onSuccess: function (resp) {
                        try {

                            if (resp && resp.Table) {
                                if (resp.Table) that.process.setDataColl(resp.Table);
                                if (resp.Table1) that.limits.setDataColl(resp.Table1);
                                if (resp.Table2) that.trigger('fetch-nav-buttons', resp.Table2);
                            }
                            else {
                                if ((resp) && (resp.Message)) {
                                    app.views.topMessages.showMessage(resp.Message, { stay: 5000, });
                                    console.error(resp.Message);
                                    that.set({
                                        hasData_process: false,
                                        isLoading_process: false,


                                    });
                                }
                                else {
                                    app.views.topMessages.showMessage("Server response not valid.", { stay: 5000, });
                                    console.error("Server response not valid.");
                                    that.set({
                                        hasData_process: false,
                                        isLoading_process: false,
                                    });
                                }

                            }


                        }
                        catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                    },
                    Secured: true,
                },
                app.ConnectionStrings.app
            );

            return this;

        },
    });

    Screen.generateID = function (viewParams) {
        try {
            //if the viewparams change the view id, then evaluate the viewparams here
            //and return the appropiate id.refreshbtn
            return 'chemistry-samples-report';
        } catch (Error) { }
    }

    Screen.Views.Main = Backbone.Epoxy.View.extend({
        template: 'chemistry-samples-report',
        id: 'chemistry-samples-report',
        title: 'Chemistry Samples',
        isCacheable: false,
        events: function () {
            return {
                'click #refreshBtn': this.refreshBtn_click,
                'click #backNavBtn': this.backNavBtn_click,
                'click #forwardNavBtn': this.forwardNavBtn_click,
                'keyup #search': this.keyPressEventHandler,

            };
        },
        bindings: 'data-bind',
        subviews: null,
        viewParams: null,

        process: null,

        autoCompleteCollection: null,
        autocompleteView : null,

        NavigationButtonView: null,

        initialize: function () {
            this.options.state = app.view_states.loading;
            this.options.onappend = (_.isFunction(this.options.onappend)) ? this.options.onappend : function () { };

            var that = this;
            this.model = new Screen.Models.Main();
            this.autoCompleteCollection = new Screen.Collections.HeatNames();

            this.NavigationButtonView = new NavigationButton.Views.Main();

            this.bindingSources = {
                process: that.model.process,
            };

            this.bindEvents();

        },
        bindEvents: function () {
            this.listenTo(this.model.process, 'fetch', this.process_fetched);
            this.listenTo(this.model, 'fetch-nav-buttons', this.fetchnavbuttons);
            this.listenTo(this.model, 'change:heatName', this.updateHeatNameInURL);
            this.listenTo(this.model, 'change:heatNames', this.updateAutocomplete);

        },
        
        render: function (container, urlParams) {
            var that = this;
            var thatContainer = (this.options.container) ? this.options.container : container;
            this.options.container = thatContainer;

            that.model.fetchPickers({
                heatName: urlParams.heatName,
                firstRefresh: true,
                async: false,
            })

            var customPath = '/app/custom-screens/' + this.template + '/';

            T.render.call(
                this,
                this.template,
                function (tmp) {
                    if (!that.options.i18n) that.options.i18n = {};

                    app.getI18NJed(
                        that,
                        that.template,
                        function (i18nJED) {
                            that.options.i18n[that.template] = i18nJED;
                            that.$el.html(tmp());



                            var grid = new Backgrid.Grid({
                                className: 'backgrid table table-hover table-condensed',
                                columns: [
                                    { name: 'localTimestamp', editable: false, label: app.translate([that, app], 'process_localTimestamp_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'location', editable: false, label: app.translate([that, app], 'process_typeCode_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell', }), },
                                    { name: 'C', editable: false, label: app.translate([that, app], 'process_c_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('C'), this.model.get('MaxC'), this.model.get('MinC'), this.model.get('AimC'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Mn', editable: false, label: app.translate([that, app], 'process_mn_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Mn'), this.model.get('MaxMn'), this.model.get('MinMn'), this.model.get('AimMn'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'S', editable: false, label: app.translate([that, app], 'process_s_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('S'), this.model.get('MaxS'), this.model.get('MinS'), this.model.get('AimS'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'P', editable: false, label: app.translate([that, app], 'process_p_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('P'), this.model.get('MaxP'), this.model.get('MinP'), this.model.get('AimP'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Si', editable: false, label: app.translate([that, app], 'process_si_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Si'), this.model.get('MaxSi'), this.model.get('MinSi'), this.model.get('AimSi'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Cu', editable: false, label: app.translate([that, app], 'process_cu_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Cu'), this.model.get('MaxCu'), this.model.get('MinCu'), this.model.get('AimCu'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Ni', editable: false, label: app.translate([that, app], 'process_ni_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Ni'), this.model.get('MaxNi'), this.model.get('MinNi'), this.model.get('AimNi'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Cr', editable: false, label: app.translate([that, app], 'process_cr_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Cr'), this.model.get('MaxCr'), this.model.get('MinCr'), this.model.get('AimCr'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Mo', editable: false, label: app.translate([that, app], 'process_mo_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Mo'), this.model.get('MaxMo'), this.model.get('MinMo'), this.model.get('AimMo'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Sn', editable: false, label: app.translate([that, app], 'process_sn_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Sn'), this.model.get('MaxSn'), this.model.get('MinSn'), this.model.get('AimSn'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Nb', editable: false, label: app.translate([that, app], 'process_nb_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Nb'), this.model.get('MaxNb'), this.model.get('MinNb'), this.model.get('AimNb'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'V', editable: false, label: app.translate([that, app], 'process_v_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('V'), this.model.get('MaxV'), this.model.get('MinV'), this.model.get('AimV'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'N', editable: false, label: app.translate([that, app], 'process_n_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('N'), this.model.get('MaxN'), this.model.get('MinN'), this.model.get('AimN'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Al', editable: false, label: app.translate([that, app], 'process_al_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Al'), this.model.get('MaxAl'), this.model.get('MinAl'), this.model.get('AimAl'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'B', editable: false, label: app.translate([that, app], 'process_b_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('B'), this.model.get('MaxB'), this.model.get('MinB'), this.model.get('AimB'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Ca', editable: false, label: app.translate([that, app], 'process_ca_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Ca'), this.model.get('MaxCa'), this.model.get('MinCa'), this.model.get('AimCa'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Pb', editable: false, label: app.translate([that, app], 'process_pb_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Pb'), this.model.get('MaxPb'), this.model.get('MinPb'), this.model.get('AimPb'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Ti', editable: false, label: app.translate([that, app], 'process_ti_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Ti'), this.model.get('MaxTi'), this.model.get('MinTi'), this.model.get('AimTi'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Mn2S', editable: false, label: app.translate([that, app], 'process_mn2S_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Mn2S'), this.model.get('MaxMn2S'), this.model.get('MinMn2S'), this.model.get('AimMn2S'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Liq', editable: false, label: app.translate([that, app], 'process_liq_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Liq'), this.model.get('MaxLiq'), this.model.get('MinLiq'), this.model.get('AimLiq'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'CorrIdx', editable: false, label: app.translate([that, app], 'process_corrIdx_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('CorrIdx'), this.model.get('MaxCorrIdx'), this.model.get('MinCorrIdx'), this.model.get('AimCorrIdx'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'CE', editable: false, label: app.translate([that, app], 'process_cE_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('CE'), this.model.get('MaxCE'), this.model.get('MinCE'), this.model.get('AimCE'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'FP', editable: false, label: app.translate([that, app], 'process_fP_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('FP'), this.model.get('MaxFP'), this.model.get('MinFP'), this.model.get('AimFP'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Fe', editable: false, label: app.translate([that, app], 'process_fe_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Fe'), this.model.get('MaxFe'), this.model.get('MinFe'), this.model.get('AimFe'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Zn', editable: false, label: app.translate([that, app], 'process_zn_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Zn'), this.model.get('MaxZn'), this.model.get('MinZn'), this.model.get('AimZn'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Sb', editable: false, label: app.translate([that, app], 'process_sb_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Sb'), this.model.get('MaxSb'), this.model.get('MinSb'), this.model.get('AimSb'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'As', editable: false, label: app.translate([that, app], 'process_as_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('As'), this.model.get('MaxAs'), this.model.get('MinAs'), this.model.get('AimAs'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Co', editable: false, label: app.translate([that, app], 'process_co_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Co'), this.model.get('MaxCo'), this.model.get('MinCo'), this.model.get('AimCo'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Zr', editable: false, label: app.translate([that, app], 'process_zr_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Zr'), this.model.get('MaxZr'), this.model.get('MinZr'), this.model.get('AimZr'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'W', editable: false, label: app.translate([that, app], 'process_w_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('W'), this.model.get('MaxW'), this.model.get('MinW'), this.model.get('AimW'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Ta', editable: false, label: app.translate([that, app], 'process_ta_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Ta'), this.model.get('MaxTa'), this.model.get('MinTa'), this.model.get('AimTa'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Bi', editable: false, label: app.translate([that, app], 'process_bi_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Bi'), this.model.get('MaxBi'), this.model.get('MinBi'), this.model.get('AimBi'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Se', editable: false, label: app.translate([that, app], 'process_se_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Se'), this.model.get('MaxSe'), this.model.get('MinSe'), this.model.get('AimSe'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Te', editable: false, label: app.translate([that, app], 'process_te_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Te'), this.model.get('MaxTe'), this.model.get('MinTe'), this.model.get('AimTe'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Mg', editable: false, label: app.translate([that, app], 'process_mg_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Mg'), this.model.get('MaxMg'), this.model.get('MinMg'), this.model.get('AimMg'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'Cb', editable: false, label: app.translate([that, app], 'process_cb_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('Cb'), this.model.get('MaxCb'), this.model.get('MinCb'), this.model.get('AimCb'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },

                                    { name: 'E1', editable: false, label: app.translate([that, app], 'process_e1_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('E1'), this.model.get('MaxE1'), this.model.get('MinE1'), this.model.get('AimE1'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'CE2', editable: false, label: app.translate([that, app], 'process_cE2_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('CE2'), this.model.get('MaxCE2'), this.model.get('MinCE2'), this.model.get('AimCE2'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'CE3', editable: false, label: app.translate([that, app], 'process_cE3_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('CE3'), this.model.get('MaxCE3'), this.model.get('MinCE3'), this.model.get('AimCE3'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'CE1', editable: false, label: app.translate([that, app], 'process_cE1_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('CE1'), this.model.get('MaxCE1'), this.model.get('MinCE1'), this.model.get('AimCE1'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'E8', editable: false, label: app.translate([that, app], 'process_e8_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('E8'), this.model.get('MaxE8'), this.model.get('MinE8'), this.model.get('AimE8'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'PC', editable: false, label: app.translate([that, app], 'process_pC_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('PC'), this.model.get('MaxPC'), this.model.get('MinPC'), this.model.get('AimPC'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'I', editable: false, label: app.translate([that, app], 'process_i_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('I'), this.model.get('MaxI'), this.model.get('MinI'), this.model.get('AimI'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'S1', editable: false, label: app.translate([that, app], 'process_s1_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('S1'), this.model.get('MaxS1'), this.model.get('MinS1'), this.model.get('AimS1'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'S2', editable: false, label: app.translate([that, app], 'process_s2_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('S2'), this.model.get('MaxS2'), this.model.get('MinS2'), this.model.get('AimS2'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'S3', editable: false, label: app.translate([that, app], 'process_s3_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('S3'), this.model.get('MaxS3'), this.model.get('MinS3'), this.model.get('AimS3'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'S4', editable: false, label: app.translate([that, app], 'process_s4_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('S4'), this.model.get('MaxS4'), this.model.get('MinS4'), this.model.get('AimS4'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'S5', editable: false, label: app.translate([that, app], 'process_s5_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('S5'), this.model.get('MaxS5'), this.model.get('MinS5'), this.model.get('AimS5'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'M2', editable: false, label: app.translate([that, app], 'process_m2_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('M2'), this.model.get('MaxM2'), this.model.get('MinM2'), this.model.get('AimM2'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'C8', editable: false, label: app.translate([that, app], 'process_c8_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('C8'), this.model.get('MaxC8'), this.model.get('MinC8'), this.model.get('AimC8'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'D1', editable: false, label: app.translate([that, app], 'process_d1_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('D1'), this.model.get('MaxD1'), this.model.get('MinD1'), this.model.get('AimD1'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },
                                    { name: 'DI', editable: false, label: app.translate([that, app], 'process_dI_col'), cell: Backgrid.StringCell.extend({ className: function () { if (that.warningElementCodeValue(this.model.get('DI'), this.model.get('MaxDI'), this.model.get('MinDI'), this.model.get('AimDI'))) return 'string-cell align-center-cell warning'; else return 'string-cell align-center-cell'; }, }), },

                                ],
                                collection: that.model.process,
                                row: Backgrid.Row.extend({
                                    events: function () {
                                        return {
                                            'click': this.click,
                                        };
                                    },
                                    click: function (e) {
                                        try {

                                            if ($(e.target).hasClass("timestamp")) {
                                                var modal = new Screen.Views.Modal({
                                                    model: this.model,
                                                    bus: that.bus,
                                                });
                                                modal.show();
                                            }
                                        }
                                        catch (Error) { console.error(Error.stack); }
                                    }
                                })
                            });
                            that.$el.find('.process-process-grid-container').append(grid.render().el);



                            var grid = new Backgrid.Grid({
                                className: 'backgrid table table-hover table-condensed',
                                columns: [
                                    { name: 'localTimestamp', editable: false, label: '', cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'location', editable: false, label: '', cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'C', editable: false, label: app.translate([that, app], 'process_c_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Mn', editable: false, label: app.translate([that, app], 'process_mn_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'S', editable: false, label: app.translate([that, app], 'process_s_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'P', editable: false, label: app.translate([that, app], 'process_p_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Si', editable: false, label: app.translate([that, app], 'process_si_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Cu', editable: false, label: app.translate([that, app], 'process_cu_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Ni', editable: false, label: app.translate([that, app], 'process_ni_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Cr', editable: false, label: app.translate([that, app], 'process_cr_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Mo', editable: false, label: app.translate([that, app], 'process_mo_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Sn', editable: false, label: app.translate([that, app], 'process_sn_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Nb', editable: false, label: app.translate([that, app], 'process_nb_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'V', editable: false, label: app.translate([that, app], 'process_v_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'N', editable: false, label: app.translate([that, app], 'process_n_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Al', editable: false, label: app.translate([that, app], 'process_al_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'B', editable: false, label: app.translate([that, app], 'process_b_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Ca', editable: false, label: app.translate([that, app], 'process_ca_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Pb', editable: false, label: app.translate([that, app], 'process_pb_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Ti', editable: false, label: app.translate([that, app], 'process_ti_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Mn2S', editable: false, label: app.translate([that, app], 'process_mn2S_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Liq', editable: false, label: app.translate([that, app], 'process_liq_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'CorrIdx', editable: false, label: app.translate([that, app], 'process_corrIdx_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'CE', editable: false, label: app.translate([that, app], 'process_cE_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'FP', editable: false, label: app.translate([that, app], 'process_fP_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Fe', editable: false, label: app.translate([that, app], 'process_fe_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Zn', editable: false, label: app.translate([that, app], 'process_zn_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Sb', editable: false, label: app.translate([that, app], 'process_sb_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'As', editable: false, label: app.translate([that, app], 'process_as_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Co', editable: false, label: app.translate([that, app], 'process_co_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Zr', editable: false, label: app.translate([that, app], 'process_zr_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'W', editable: false, label: app.translate([that, app], 'process_w_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Ta', editable: false, label: app.translate([that, app], 'process_ta_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Bi', editable: false, label: app.translate([that, app], 'process_bi_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Se', editable: false, label: app.translate([that, app], 'process_se_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Te', editable: false, label: app.translate([that, app], 'process_te_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Mg', editable: false, label: app.translate([that, app], 'process_mg_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'Cb', editable: false, label: app.translate([that, app], 'process_cb_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },

                                    { name: 'E1', editable: false, label: app.translate([that, app], 'process_e1_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'CE2', editable: false, label: app.translate([that, app], 'process_cE2_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'CE3', editable: false, label: app.translate([that, app], 'process_cE3_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'CE1', editable: false, label: app.translate([that, app], 'process_cE1_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'E8', editable: false, label: app.translate([that, app], 'process_e8_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'PC', editable: false, label: app.translate([that, app], 'process_pC_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'I', editable: false, label: app.translate([that, app], 'process_i_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'S1', editable: false, label: app.translate([that, app], 'process_s1_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'S2', editable: false, label: app.translate([that, app], 'process_s2_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'S3', editable: false, label: app.translate([that, app], 'process_s3_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'S4', editable: false, label: app.translate([that, app], 'process_s4_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'S5', editable: false, label: app.translate([that, app], 'process_s5_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'M2', editable: false, label: app.translate([that, app], 'process_m2_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'C8', editable: false, label: app.translate([that, app], 'process_c8_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'D1', editable: false, label: app.translate([that, app], 'process_d1_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },
                                    { name: 'DI', editable: false, label: app.translate([that, app], 'process_dI_col'), cell: Backgrid.StringCell.extend({ className: 'string-cell align-center-cell timestamp', }), },

                                ],
                                collection: that.model.limits,
                            });
                            that.$el.find('.process-limits-grid-container').append(grid.render().el);

                            that.applyBindings();

                            //rendering Navigation Buttons
                            that.NavigationButtonView.render(that.$el.find(".navigation-buttons"), null);

                            //appending view to the main container
                            that.append(thatContainer, that.$el);

                            //Autocomplete Heat Names
                            that.autoCompleteCollection.setDataColl(that.model.get('heatNames'));

                            that.autocompleteView = new AutoCompleteView({
                                input: $("#search"),
                                minKeywordLength: 4,
                                model: that.autoCompleteCollection,
                            }).render();

                            that.refresh();
                                                       
                        },
                        true,
                        customPath
                    );
                },
                customPath
            );
        },

        warningElementCodeValue: function (value, max, min, aim) {
            if (value == '-') value = null;
            if (max == '-') max = null;
            if (min == '-') min = null;
            if (aim == '-') aim = null;

            if (!min && !max && !aim) return false;
            else if (value && min && max) {
                if (value < min || value > max) return true
            }
            else if (value && min && value < min) return true;
            else if (value && max && value > max) return true;
            else
                return false;
        },

        refresh: function () {
            var currentAutcompleteText = this.autocompleteView.getClickedValue();
            if (currentAutcompleteText) {
                if (currentAutcompleteText) this.setHeatId(currentAutcompleteText);
                this.model.set({
                    heatName: currentAutcompleteText,
                })
            }


            var params = this.model.toJSON();
            this.model.set({
                isLoading_process: true,
                hasData_process: false,
            });

            this.model.fetch({
                heatId: params.heatId ? params.heatId : null,
                direction: params.direction,
                furnaceCode: params.furnaceCode == '-' ? null : params.furnaceCode,
            });

            this.model.set({
                direction: null,
            });

        },
                
        keyPressEventHandler: function (e) {
            var keyword = $("#search").val();
            if (keyword.length == 3 && e.keyCode != 38 && e.keyCode != 40 && e.keyCode != 13 && e.keyCode != 27 && e.keyCode != 8) {
                this.model.fetchPickers({
                    heatName: keyword,
                })
            } else if (keyword.length >= 9 && e.keyCode == 13)
                this.setHeatId(keyword);
            

        },

        setHeatId: function (keyword) {
            var that = this,
                obj = null;

            obj = _.where(that.model.get('heatNames'), { name: keyword });
            that.model.set('heatId', obj[0].heatId);
            that.model.set('heatName', obj[0].name);
            
        },

        updateAutocomplete: function () {
            var that = this;
            this.autoCompleteCollection.setDataColl(that.model.get('heatNames'));
        },

        updateHeatNameInURL: function () {
            var params = this.model.toJSON();

            if (params.navigation) {
                this.UpdateURL();
            }

            this.model.set({
                navigation: false,
            });

        },


        backNavBtn_click: function () {
            this.model.set({
                direction: false,
                navigation: true,
            });
            this.refresh();
        },

        forwardNavBtn_click: function () {
            this.model.set({
                direction: true,
                navigation: true,
            });
            this.refresh();

        },
        fetchnavbuttons: function (resp) {
            this.NavigationButtonView.setDataColl(resp);
        },
        process_fetched: function () {
            try {
                var that = this
                    model = null;
                if (that.model.process.length > 0) {
                    model = that.model.process.at(0).toJSON();
                }
                setTimeout(
                    function () {
                        that.model.set({
                            hasData_process: (that.model.process.length > 0),
                            isLoading_process: false,
                            heatId: that.model.process.length > 0 ? model.heatId : null,
                            heatName: that.model.process.length > 0 ? model.heatName : null,
                        });

                    },
                    100
                );

            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },
        UpdateURL: function () {
            try {
                var params = this.model.toJSON();
                app.router.navigate(
                    app.router.resolveURL(
                        app.router.currentModule,
                        _.extend(
                            {},
                            params,
                            {
                                heatName: params.heatName,
                            }
                        ),
                        false
                    ),
                    { trigger: false, }
                );
            }
            catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
        },

        refreshBtn_click: function (e) {
            this.refresh();
            this.UpdateURL();
        },
        append: function (container, el) {
            el = (el != null && el != undefined) ? el : this.$el;

            if (this.options.state == app.view_states.loading
                || this.options.state == app.view_states.shown) {
                //appending view to the main container and set state to shown

                this.options.state = app.view_states.shown;
                container.append(el);

                this.options.onappend(this);
            }

            if (this.options.state == app.view_states.hidden) {
                //append and remain hidden
                container.append(el);
            }

            if (this.options.state == app.view_states.closed) {
                //return without appending.
                return;
            }
        },
        bindViewScopedEvents: function () {
            var that = this;
        },
        unbindViewScopedEvents: function () {

        },
        close: function () {
            this.options.state = app.view_states.closed;
            
            this.closeSubviews();
            this.remove();
            this.unbindViewScopedEvents();
            this.unbind();
        },
        closeSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.close();
            });
        },
        show: function () {
            this.options.state = app.view_states.shown;

            this.showSubviews();
            this.bindEvents();
            this.$el.show();
        },
        showSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.show();
            });
        },
        hide: function () {
            this.options.state = app.view_states.hidden;

            this.hideSubviews();

            this.$el.hide();
            this.unbind();
            this.stopListening();
        },
        hideSubviews: function () {
            _.each(this.subviews, function (sview) {
                sview.hide();
            });
        },
        preRender: function () {
            app.models.subnavbar.set("subnavbar", false);
        },
        reRender: function (urlParams) {
            try {
                this.refresh(viewParams);
            } catch (Error) { }
        },

    });

        Screen.Models.Process = Backbone.Epoxy.Model.extend({
            defaults: {
                Al: null,
                As: null,
                B: null,
                Bi: null,
                C: null,
                C8: null,
                CE: null,
                CE1: null,
                CE2: null,
                CE3: null,
                Ca: null,
                Cb: null,
                Co: null,
                comments: null,
                CorrIdx: null,
                Cr: null,
                Cu: null,
                D1: null,
                DI: null,
                E1: null,
                E8: null,
                FP: null,
                Fe: null,
                gradeId: null,
                gradeName: null,
                gradeVersionId: null,
                heatId: null,
                heatName: null,
                heatNameSent: null,
                I: null,
                Id: null,
                Liq: null,
                localTimestamp: null,
                M2: null,
                Mg: null,
                Mn: null,
                Mn2S: null,
                Mo: null,
                N: null,
                Nb: null,
                Ni: null,
                P: null,
                PC: null,
                Pb: null,
                processTimestamp: null,
                S: null,
                S1: null,
                S2: null,
                S3: null,
                S4: null,
                S5: null,
                sampleIdCode: null,
                Sb: null,
                Se: null,
                Si: null,
                Sn: null,
                Ta: null,
                Te: null,
                Ti: null,
                timestamp: null,
                typeCode: null,
                V: null,
                W: null,
                Zn: null,
                Zr: null,
                location: null,
                MinAl: null,
                MinAs: null,
                MinB: null,
                MinBi: null,
                MinC: null,
                MinC8: null,
                MinCE: null,
                MinCE1: null,
                MinCE2: null,
                MinCE3: null,
                MinCa: null,
                MinCb: null,
                MinCo: null,
                MinCorrIdx: null,
                MinCr: null,
                MinCu: null,
                MinD1: null,
                MinDI: null,
                MinE1: null,
                MinE8: null,
                MinFP: null,
                MinFe: null,
                MinI: null,
                MinId: null,
                MinLiq: null,
                MinM2: null,
                MinMg: null,
                MinMn: null,
                MinMn2S: null,
                MinMo: null,
                MinN: null,
                MinNb: null,
                MinNi: null,
                MinP: null,
                MinPC: null,
                MinPb: null,
                MinS: null,
                MinS1: null,
                MinS2: null,
                MinS3: null,
                MinS4: null,
                MinS5: null,
                MinSb: null,
                MinSe: null,
                MinSi: null,
                MinSn: null,
                MinTa: null,
                MinTe: null,
                MinTi: null,
                MinV: null,
                MinW: null,
                MinZn: null,
                MinZr: null,

                MaxAl: null,
                MaxAs: null,
                MaxB: null,
                MaxBi: null,
                MaxC: null,
                MaxC8: null,
                MaxCE: null,
                MaxCE1: null,
                MaxCE2: null,
                MaxCE3: null,
                MaxCa: null,
                MaxCb: null,
                MaxCo: null,
                MaxCorrIdx: null,
                MaxCr: null,
                MaxCu: null,
                MaxD1: null,
                MaxDI: null,
                MaxE1: null,
                MaxE8: null,
                MaxFP: null,
                MaxFe: null,
                MaxI: null,
                MaxId: null,
                MaxLiq: null,
                MaxM2: null,
                MaxMg: null,
                MaxMn: null,
                MaxMn2S: null,
                MaxMo: null,
                MaxN: null,
                MaxNb: null,
                MaxNi: null,
                MaxP: null,
                MaxPC: null,
                MaxPb: null,
                MaxS: null,
                MaxS1: null,
                MaxS2: null,
                MaxS3: null,
                MaxS4: null,
                MaxS5: null,
                MaxSb: null,
                MaxSe: null,
                MaxSi: null,
                MaxSn: null,
                MaxTa: null,
                MaxTe: null,
                MaxTi: null,
                MaxV: null,
                MaxW: null,
                MaxZn: null,
                MaxZr: null,

                AimAl: null,
                AimAs: null,
                AimB: null,
                AimBi: null,
                AimC: null,
                AimC8: null,
                AimCE: null,
                AimCE1: null,
                AimCE2: null,
                AimCE3: null,
                AimCa: null,
                AimCb: null,
                AimCo: null,
                AimCorrIdx: null,
                AimCr: null,
                AimCu: null,
                AimD1: null,
                AimDI: null,
                AimE1: null,
                AimE8: null,
                AimFP: null,
                AimFe: null,
                AimI: null,
                AimId: null,
                AimLiq: null,
                AimM2: null,
                AimMg: null,
                AimMn: null,
                AimMn2S: null,
                AimMo: null,
                AimN: null,
                AimNb: null,
                AimNi: null,
                AimP: null,
                AimPC: null,
                AimPb: null,
                AimS: null,
                AimS1: null,
                AimS2: null,
                AimS3: null,
                AimS4: null,
                AimS5: null,
                AimSb: null,
                AimSe: null,
                AimSi: null,
                AimSn: null,
                AimTa: null,
                AimTe: null,
                AimTi: null,
                AimV: null,
                AimW: null,
                AimZn: null,
                AimZr: null,
            },

            parse: function (obj) {
                var result = {
                    Al: obj.Al ? obj.Al.toFixed(4) : '-',
                    As: obj.As ? obj.As.toFixed(4) : '-',
                    B: obj.B ? obj.B.toFixed(4) : '-',
                    Bi: obj.Bi ? obj.Bi.toFixed(4) : '-',
                    C: obj.C ? obj.C.toFixed(4) : '-',
                    C8: obj.C8 ? obj.C8.toFixed(4) : '-',
                    CE: obj.CE ? obj.CE.toFixed(4) : '-',
                    CE1: obj.CE1 ? obj.CE1.toFixed(4) : '-',
                    CE2: obj.CE2 ? obj.CE2.toFixed(4) : '-',
                    CE3: obj.CE3 ? obj.CE3.toFixed(4) : '-',
                    Ca: obj.Ca ? obj.Ca.toFixed(4) : '-',
                    Cb: obj.Cb ? obj.Cb.toFixed(4) : '-',
                    Co: obj.Co ? obj.Co.toFixed(4) : '-',
                    comments: obj.Comments ? obj.Comments : '-',
                    CorrIdx: obj.CorrIdx ? obj.CorrIdx.toFixed(4) : '-',
                    Cr: obj.Cr ? obj.Cr.toFixed(4) : '-',
                    Cu: obj.Cu ? obj.Cu.toFixed(4) : '-',
                    D1: obj.D1 ? obj.D1.toFixed(4) : '-',
                    DI: obj.DI ? obj.DI.toFixed(4) : '-',
                    E1: obj.E1 ? obj.E1.toFixed(4) : '-',
                    E8: obj.E8 ? obj.E8.toFixed(4) : '-',
                    FP: obj.FP ? obj.FP.toFixed(4) : '-',
                    Fe: obj.Fe ? obj.Fe.toFixed(4) : '-',
                    gradeId: obj.GradeId ? obj.GradeId : '-',
                    gradeName: obj.GradeName ? obj.GradeName : '-',
                    gradeVersionId: obj.GradeVersionId ? obj.GradeVersionId : '-',
                    heatId: obj.HeatId ? obj.HeatId : '-',
                    heatName: obj.HeatName ? obj.HeatName : '-',
                    heatNameSent: obj.HeatNameSent ? obj.HeatNameSent : '-',
                    I: obj.I ? obj.I.toFixed(4) : '-',
                    Id: obj.Id ? obj.Id.toFixed(4) : '-',
                    Liq: obj.Liq ? obj.Liq.toFixed(4) : '-',
                    localTimestamp: obj.LocalTimestamp ? new moment(obj.LocalTimestamp).format('MM/DD/YY HH:mm') : '-',
                    M2: obj.M2 ? obj.M2.toFixed(4) : '-',
                    Mg: obj.Mg ? obj.Mg.toFixed(4) : '-',
                    Mn: obj.Mn ? obj.Mn.toFixed(4) : '-',
                    Mn2S: obj.Mn2S ? obj.Mn2S.toFixed(4) : '-',
                    Mo: obj.Mo ? obj.Mo.toFixed(4) : '-',
                    N: obj.N ? obj.N.toFixed(4) : '-',
                    Nb: obj.Nb ? obj.Nb.toFixed(4) : '-',
                    Ni: obj.Ni ? obj.Ni.toFixed(4) : '-',
                    P: obj.P ? obj.P.toFixed(4) : '-',
                    PC: obj.PC ? obj.PC.toFixed(4) : '-',
                    Pb: obj.Pb ? obj.Pb.toFixed(4) : '-',
                    processTimestamp: obj.ProcessTimestamp ? obj.ProcessTimestamp : '-',
                    S: obj.S ? obj.S.toFixed(4) : '-',
                    S1: obj.S1 ? obj.S1.toFixed(4) : '-',
                    S2: obj.S2 ? obj.S2.toFixed(4) : '-',
                    S3: obj.S3 ? obj.S3.toFixed(4) : '-',
                    S4: obj.S4 ? obj.S4.toFixed(4) : '-',
                    S5: obj.S5 ? obj.S5.toFixed(4) : '-',
                    sampleIdCode: obj.SampleIdCode ? obj.SampleIdCode : '-',
                    Sb: obj.Sb ? obj.Sb.toFixed(4) : '-',
                    Se: obj.Se ? obj.Se.toFixed(4) : '-',
                    Si: obj.Si ? obj.Si.toFixed(4) : '-',
                    Sn: obj.Sn ? obj.Sn.toFixed(4) : '-',
                    Ta: obj.Ta ? obj.Ta.toFixed(4) : '-',
                    Te: obj.Te ? obj.Te.toFixed(4) : '-',
                    Ti: obj.Ti ? obj.Ti.toFixed(4) : '-',
                    timestamp: obj.Timestamp ? obj.Timestamp : '-',
                    typeCode: obj.TypeCode ? obj.TypeCode : '-',
                    location: (obj.TypeCode ? obj.TypeCode : '') + (obj.SampleIdCode ? (' - ' + obj.SampleIdCode) : ''),
                    V: obj.V ? obj.V.toFixed(4) : '-',
                    W: obj.W ? obj.W.toFixed(4) : '-',
                    Zn: obj.Zn ? obj.Zn.toFixed(4) : '-',
                    Zr: obj.Zr ? obj.Zr.toFixed(4) : '-',


                    MinAl: obj.MinAl ? obj.MinAl : '-',
                    MinAs: obj.MinAs ? obj.MinAs : '-',
                    MinB: obj.MinB ? obj.MinB : '-',
                    MinBi: obj.MinBi ? obj.MinBi : '-',
                    MinC: obj.MinC ? obj.MinC : '-',
                    MinC8: obj.MinC8 ? obj.MinC8 : '-',
                    MinCE: obj.MinCE ? obj.MinCE : '-',
                    MinCE1: obj.MinCE1 ? obj.MinCE1 : '-',
                    MinCE2: obj.MinCE2 ? obj.MinCE2 : '-',
                    MinCE3: obj.MinCE3 ? obj.MinCE3 : '-',
                    MinCa: obj.MinCa ? obj.MinCa : '-',
                    MinCb: obj.MinCb ? obj.MinCb : '-',
                    MinCo: obj.MinCo ? obj.MinCo : '-',
                    MinCorrIdx: obj.MinCorrIdx ? obj.MinCorrIdx : '-',
                    MinCr: obj.MinCr ? obj.MinCr : '-',
                    MinCu: obj.MinCu ? obj.MinCu : '-',
                    MinD1: obj.MinD1 ? obj.MinD1 : '-',
                    MinDI: obj.MinDI ? obj.MinDI : '-',
                    MinE1: obj.MinE1 ? obj.MinE1 : '-',
                    MinE8: obj.MinE8 ? obj.MinE8 : '-',
                    MinFP: obj.MinFP ? obj.MinFP : '-',
                    MinFe: obj.MinFe ? obj.MinFe : '-',
                    MinI: obj.MinI ? obj.MinI : '-',
                    MinId: obj.MinId ? obj.MinId : '-',
                    MinLiq: obj.MinLiq ? obj.MinLiq : '-',
                    MinM2: obj.MinM2 ? obj.MinM2 : '-',
                    MinMg: obj.MinMg ? obj.MinMg : '-',
                    MinMn: obj.MinMn ? obj.MinMn : '-',
                    MinMn2S: obj.MinMn2S ? obj.MinMn2S : '-',
                    MinMo: obj.MinMo ? obj.MinMo : '-',
                    MinN: obj.MinN ? obj.MinN : '-',
                    MinNb: obj.MinNb ? obj.MinNb : '-',
                    MinNi: obj.MinNi ? obj.MinNi : '-',
                    MinP: obj.MinP ? obj.MinP : '-',
                    MinPC: obj.MinPC ? obj.MinPC : '-',
                    MinPb: obj.MinPb ? obj.MinPb : '-',
                    MinS: obj.MinS ? obj.MinS : '-',
                    MinS1: obj.MinS1 ? obj.MinS1 : '-',
                    MinS2: obj.MinS2 ? obj.MinS2 : '-',
                    MinS3: obj.MinS3 ? obj.MinS3 : '-',
                    MinS4: obj.MinS4 ? obj.MinS4 : '-',
                    MinS5: obj.MinS5 ? obj.MinS5 : '-',
                    MinSb: obj.MinSb ? obj.MinSb : '-',
                    MinSe: obj.MinSe ? obj.MinSe : '-',
                    MinSi: obj.MinSi ? obj.MinSi : '-',
                    MinSn: obj.MinSn ? obj.MinSn : '-',
                    MinTa: obj.MinTa ? obj.MinTa : '-',
                    MinTe: obj.MinTe ? obj.MinTe : '-',
                    MinTi: obj.MinTi ? obj.MinTi : '-',
                    MinV: obj.MinV ? obj.MinV : '-',
                    MinW: obj.MinW ? obj.MinW : '-',
                    MinZn: obj.MinZn ? obj.MinZn : '-',
                    MinZr: obj.MinZr ? obj.MinZr : '-',

                    MaxAl: obj.MaxAl ? obj.MaxAl : '-',
                    MaxAs: obj.MaxAs ? obj.MaxAs : '-',
                    MaxB: obj.MaxB ? obj.MaxB : '-',
                    MaxBi: obj.MaxBi ? obj.MaxBi : '-',
                    MaxC: obj.MaxC ? obj.MaxC : '-',
                    MaxC8: obj.MaxC8 ? obj.MaxC8 : '-',
                    MaxCE: obj.MaxCE ? obj.MaxCE : '-',
                    MaxCE1: obj.MaxCE1 ? obj.MaxCE1 : '-',
                    MaxCE2: obj.MaxCE2 ? obj.MaxCE2 : '-',
                    MaxCE3: obj.MaxCE3 ? obj.MaxCE3 : '-',
                    MaxCa: obj.MaxCa ? obj.MaxCa : '-',
                    MaxCb: obj.MaxCb ? obj.MaxCb : '-',
                    MaxCo: obj.MaxCo ? obj.MaxCo : '-',
                    MaxCorrIdx: obj.MaxCorrIdx ? obj.MaxCorrIdx : '-',
                    MaxCr: obj.MaxCr ? obj.MaxCr : '-',
                    MaxCu: obj.MaxCu ? obj.MaxCu : '-',
                    MaxD1: obj.MaxD1 ? obj.MaxD1 : '-',
                    MaxDI: obj.MaxDI ? obj.MaxDI : '-',
                    MaxE1: obj.MaxE1 ? obj.MaxE1 : '-',
                    MaxE8: obj.MaxE8 ? obj.MaxE8 : '-',
                    MaxFP: obj.MaxFP ? obj.MaxFP : '-',
                    MaxFe: obj.MaxFe ? obj.MaxFe : '-',
                    MaxI: obj.MaxI ? obj.MaxI : '-',
                    MaxId: obj.MaxId ? obj.MaxId : '-',
                    MaxLiq: obj.MaxLiq ? obj.MaxLiq : '-',
                    MaxM2: obj.MaxM2 ? obj.MaxM2 : '-',
                    MaxMg: obj.MaxMg ? obj.MaxMg : '-',
                    MaxMn: obj.MaxMn ? obj.MaxMn : '-',
                    MaxMn2S: obj.MaxMn2S ? obj.MaxMn2S : '-',
                    MaxMo: obj.MaxMo ? obj.MaxMo : '-',
                    MaxN: obj.MaxN ? obj.MaxN : '-',
                    MaxNb: obj.MaxNb ? obj.MaxNb : '-',
                    MaxNi: obj.MaxNi ? obj.MaxNi : '-',
                    MaxP: obj.MaxP ? obj.MaxP : '-',
                    MaxPC: obj.MaxPC ? obj.MaxPC : '-',
                    MaxPb: obj.MaxPb ? obj.MaxPb : '-',
                    MaxS: obj.MaxS ? obj.MaxS : '-',
                    MaxS1: obj.MaxS1 ? obj.MaxS1 : '-',
                    MaxS2: obj.MaxS2 ? obj.MaxS2 : '-',
                    MaxS3: obj.MaxS3 ? obj.MaxS3 : '-',
                    MaxS4: obj.MaxS4 ? obj.MaxS4 : '-',
                    MaxS5: obj.MaxS5 ? obj.MaxS5 : '-',
                    MaxSb: obj.MaxSb ? obj.MaxSb : '-',
                    MaxSe: obj.MaxSe ? obj.MaxSe : '-',
                    MaxSi: obj.MaxSi ? obj.MaxSi : '-',
                    MaxSn: obj.MaxSn ? obj.MaxSn : '-',
                    MaxTa: obj.MaxTa ? obj.MaxTa : '-',
                    MaxTe: obj.MaxTe ? obj.MaxTe : '-',
                    MaxTi: obj.MaxTi ? obj.MaxTi : '-',
                    MaxV: obj.MaxV ? obj.MaxV : '-',
                    MaxW: obj.MaxW ? obj.MaxW : '-',
                    MaxZn: obj.MaxZn ? obj.MaxZn : '-',
                    MaxZr: obj.MaxZr ? obj.MaxZr : '-',

                    AimAl: obj.AimAl ? obj.AimAl : '-',
                    AimAs: obj.AimAs ? obj.AimAs : '-',
                    AimB: obj.AimB ? obj.AimB : '-',
                    AimBi: obj.AimBi ? obj.AimBi : '-',
                    AimC: obj.AimC ? obj.AimC : '-',
                    AimC8: obj.AimC8 ? obj.AimC8 : '-',
                    AimCE: obj.AimCE ? obj.AimCE : '-',
                    AimCE1: obj.AimCE1 ? obj.AimCE1 : '-',
                    AimCE2: obj.AimCE2 ? obj.AimCE2 : '-',
                    AimCE3: obj.AimCE3 ? obj.AimCE3 : '-',
                    AimCa: obj.AimCa ? obj.AimCa : '-',
                    AimCb: obj.AimCb ? obj.AimCb : '-',
                    AimCo: obj.AimCo ? obj.AimCo : '-',
                    AimCorrIdx: obj.AimCorrIdx ? obj.AimCorrIdx : '-',
                    AimCr: obj.AimCr ? obj.AimCr : '-',
                    AimCu: obj.AimCu ? obj.AimCu : '-',
                    AimD1: obj.AimD1 ? obj.AimD1 : '-',
                    AimDI: obj.AimDI ? obj.AimDI : '-',
                    AimE1: obj.AimE1 ? obj.AimE1 : '-',
                    AimE8: obj.AimE8 ? obj.AimE8 : '-',
                    AimFP: obj.AimFP ? obj.AimFP : '-',
                    AimFe: obj.AimFe ? obj.AimFe : '-',
                    AimI: obj.AimI ? obj.AimI : '-',
                    AimId: obj.AimId ? obj.AimId : '-',
                    AimLiq: obj.AimLiq ? obj.AimLiq : '-',
                    AimM2: obj.AimM2 ? obj.AimM2 : '-',
                    AimMg: obj.AimMg ? obj.AimMg : '-',
                    AimMn: obj.AimMn ? obj.AimMn : '-',
                    AimMn2S: obj.AimMn2S ? obj.AimMn2S : '-',
                    AimMo: obj.AimMo ? obj.AimMo : '-',
                    AimN: obj.AimN ? obj.AimN : '-',
                    AimNb: obj.AimNb ? obj.AimNb : '-',
                    AimNi: obj.AimNi ? obj.AimNi : '-',
                    AimP: obj.AimP ? obj.AimP : '-',
                    AimPC: obj.AimPC ? obj.AimPC : '-',
                    AimPb: obj.AimPb ? obj.AimPb : '-',
                    AimS: obj.AimS ? obj.AimS : '-',
                    AimS1: obj.AimS1 ? obj.AimS1 : '-',
                    AimS2: obj.AimS2 ? obj.AimS2 : '-',
                    AimS3: obj.AimS3 ? obj.AimS3 : '-',
                    AimS4: obj.AimS4 ? obj.AimS4 : '-',
                    AimS5: obj.AimS5 ? obj.AimS5 : '-',
                    AimSb: obj.AimSb ? obj.AimSb : '-',
                    AimSe: obj.AimSe ? obj.AimSe : '-',
                    AimSi: obj.AimSi ? obj.AimSi : '-',
                    AimSn: obj.AimSn ? obj.AimSn : '-',
                    AimTa: obj.AimTa ? obj.AimTa : '-',
                    AimTe: obj.AimTe ? obj.AimTe : '-',
                    AimTi: obj.AimTi ? obj.AimTi : '-',
                    AimV: obj.AimV ? obj.AimV : '-',
                    AimW: obj.AimW ? obj.AimW : '-',
                    AimZn: obj.AimZn ? obj.AimZn : '-',
                    AimZr: obj.AimZr ? obj.AimZr : '-',


                };
                return result;
            }

        });
    Screen.Collections.Process = Backbone.Collection.extend({
        model: Screen.Models.Process,
        setDataColl: function (data) {
            var newColl,
                that = this;
            newColl = _.map(data, that.model.prototype.parse);
            that.set(newColl).trigger('fetch', that, data);
        },
    });


    Screen.Models.HeatName = Backbone.Model.extend({
        label: function () {
            return this.get("name");
        }
    });
    Screen.Collections.HeatNames = Backbone.Collection.extend({
        model: Screen.Models.HeatName,

        setDataColl: function (data) {
            var newColl,
                that = this;
            newColl = _.map(data, that.model.prototype.parse);
            that.set(newColl);
        },
    });

    // Required, return the module for AMD compliance.
    return Screen;
});

