﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/add-row-cell/backgrid-add-row-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/button-cell/backgrid-button-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/jquery.timepicker/jquery.timepicker.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

{{#if mainView}}
<div class="row-fluid subnavbar fixed-subnavbar" data-bind="classes: { 'current-process': process_isCurrentProcess }">
    <div class="row-fluid form-inline">
        <label class="control-label" for="searchTbx">
            <asp:localize runat="server" meta:resourcekey="process_picker_label" />
        </label>
        <div class="input-prepend input-append">
            <button type="button" id="getPreviousItemBtn" class="btn btn-search-prev" data-bind="disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=previous_process_btn_title />"><i class="fa fa-play fa-rotate-180"></i></button>
            <input type="text" id="searchTbx" style="width:100px;" data-bind="value: trim(search), events: ['change', 'keydown',]" placeholder="<asp:Localize runat=server meta:resourcekey=process_picker_place_holder />" data-select-on-focus/>
            <label class="btn btn-search-show" id="showSearchItemsBtn" for="searchTbx"><i class="fa fa-caret-down"></i></label>
            <button type="button" id="getNextItemBtn" class="btn btn-search-next" data-bind="disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=next_process_btn_title />"><i class="fa fa-play"></i></button>
            <button type="button" class="btn" data-bind="clickSet: 'processId', clickSetValue: -1, disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=current_process_btn_title />"><i class="fa fa-step-forward"></i></button>
        </div>
        <label class="control-label" style="font-weight:bold;">
            <asp:localize runat="server" meta:resourcekey="process_info_furnace_label" />
            <span class="input-static" data-bind="text: coalesce(trim(furnaceName), '<asp:localize runat=server meta:resourcekey=no_value_legend />'),"></span>
            <%--<span class="input-static" data-bind="text: select(process_id, trim(process_furnaceName), '<asp:localize runat=server meta:resourcekey=loading_process_info_legend />'),"></span>--%>
        </label>
<%--        <label class="control-label" style="font-weight:bold;">
            <asp:localize runat="server" meta:resourcekey="process_info_furnace_heats_count_label" />
            <span class="input-static" data-bind="text: select(process_id, trim(process_furnaceHeatsCount), '<asp:localize runat=server meta:resourcekey=loading_process_info_legend />'),"></span>
        </label>--%>
        <button type="button" class="btn btn-primary btn-ship pull-right" data-bind="disabled: notEquals(process_heatStatusCode, 'INEAF')," style="margin-right:10px;" title="<asp:Localize runat=server meta:resourcekey=ship_btn_title />"><i class="fa fa-sign-out"></i></button>
        <a class="delays-anchor-link" data-bind="text: format('<asp:localize runat=server meta:resourcekey=delay_not_declared_label />', delaysNotDeclaredCount), classes: { hide: not(delaysNotDeclaredCount) },"></a>
        <%--<button class="btn btn-primary pull-right" type="button" style="margin-right:10px;">
            <i class="fa fa-plus"></i>
            <asp:Localize runat=server meta:resourcekey=create_heat_btn_title />
        </button>--%>
    </div>
</div>
{{/if}}

<div class="row-fluid screen-content" data-bind="classes: { 'edition-disabled': not(editingProcess), },">
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(all(userHasAccess, any(isLoadingProcess, all(mainView, notEquals(process_furnaceCode, furnaceCode))))), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(all(mainView, not(userHasAccess))), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-times" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;" data-bind="text: format('<asp:localize runat=server meta:resourcekey=no_user_access_furnace />', coalesce(trim(furnaceName), '<asp:localize runat=server meta:resourcekey=no_value_legend />'))">
            
            </h3>
        </div>
    </div>
    
    
    
    <div class="row-fluid process-info-container" style="min-width:1600px;" data-bind="classes: { hide: not(all(userHasAccess, not(isLoadingProcess), any(not(mainView), equals(process_furnaceCode, furnaceCode)))), },">
        <div class="form-horizontal process-info-form process-info-form-1 pull-left">
            <div class="row-fluid">
                <h4 class="heat-number-container pull-left" data-bind="text: format('<asp:Localize runat=server meta:resourcekey=process_info_title /> $1', coalesce(trim(process_heatName), '<asp:localize runat=server meta:resourcekey=no_value_legend />')),"></h4>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_initial_grade_label /></span>
                    <select class="process-info-field-value" style="width:140px;" data-bind="value: integer(process_initialGradeId), options: select(process_id, grades, []), optionsEmpty: { label: '<asp:localize runat=server meta:resourcekey=grades_combo_empty_opt />', value: 0 }, enabled: all(process_id, hasGrades), classes: { hide: not(editingProcess), },"></select>
                    <span class="process-info-field-value" data-bind="text: coalesce(trim(process_initialGradeName), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_grade_label /></span>
                    <select class="process-info-field-value" style="width:140px;" data-bind="value: integer(process_gradeId), options: select(process_id, grades, []), optionsEmpty: { label: '<asp:localize runat=server meta:resourcekey=grades_combo_empty_opt />', value: 0 }, enabled: all(process_id, hasGrades), classes: { hide: not(editingProcess), },"></select>
                    <span class="process-info-field-value" data-bind="text: coalesce(trim(process_gradeName), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_ladle_label /></span>
                    <select class="process-info-field-value" style="width:140px;" data-bind="value: integer(process_ladleId), options: select(process_id, select(notEquals(process_ladleId, -1), ladles, concatArrays([{ label: '<asp:localize runat=server meta:resourcekey=ladles_combo_unknown_opt />', value: -1 }], ladles)), []), optionsEmpty: { label: '<asp:localize runat=server meta:resourcekey=ladles_combo_empty_opt />', value: 0 }, enabled: all(process_id, hasLadles), classes: { hide: not(editingProcess), },"></select>
                    <span class="process-info-field-value" data-bind="text: coalesce(trim(process_ladleName), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                    <i class="fa fa-lock manual-lock-btn" data-variable-name="LADLE" data-bind="classes: { hide: not(contains({ name: 'LADLE', }, process_manualVariables)), }," title="<asp:Localize runat=server meta:resourcekey=manual_lock_btn_title />"></i>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_operator_label /></span>
                    <input type="text" class="process-info-field-value input-mini" style="width:140px;" data-bind="value: process_melter, classes: { hide: not(editingProcess), },"/>
                    <span class="process-info-field-value" data-bind="text: coalesce((process_melter), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                </div>
            </div>
        </div>
        <div class="form-horizontal process-info-form process-info-form-2 pull-left">
             <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_start_label /></span>
                    <input type="text" class="process-info-field-value input-date" data-bind="value: coalesce(momentFormat(process_startDate, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />'), ''), classes: { hide: not(editingProcess), }," placeholder="<asp:Localize runat=server meta:resourcekey=mmddyyyy_display />" data-select-on-focus/>
                    <input type="text" class="process-info-field-value input-time" data-bind="value: coalesce(process_startTime, ''), classes: { hide: not(editingProcess), }, events: ['changeTime',]," placeholder="<asp:Localize runat=server meta:resourcekey=hhmmss_display />" data-select-on-focus maxlength="8"/>
                    <span class="process-info-field-value" data-bind="text: coalesce(momentFormat(process_start, 'YYYY-MM-DD HH:mm:ss.SSS', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format /> HH:mm:ss'), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                    <i class="fa fa-lock manual-lock-btn" data-variable-name="START" data-bind="classes: { hide: not(contains({ name: 'START', }, process_manualVariables)), }," title="<asp:Localize runat=server meta:resourcekey=manual_lock_btn_title />"></i>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_bore_in_time_label /></span>
                    <span class="process-info-field-value" data-bind="text: coalesce(duration(process_boreInTime, 's', 'm:s'), '<asp:localize runat=server meta:resourcekey=no_value_legend />'),"></span>
                    <span class="process-info-field-unit"><asp:Localize runat=server meta:resourcekey=process_info_tapping_time_unit_legend /></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_melt_time_label /></span>
                    <span class="process-info-field-value" data-bind="text: coalesce(duration(process_meltTime, 's', 'm:s'), '<asp:localize runat=server meta:resourcekey=no_value_legend />'),"></span>
                    <span class="process-info-field-unit"><asp:Localize runat=server meta:resourcekey=process_info_tapping_time_unit_legend /></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_refine_time_label /></span>
                    <span class="process-info-field-value" data-bind="text: coalesce(duration(process_refineTime, 's', 'm:s'), '<asp:localize runat=server meta:resourcekey=no_value_legend />'),"></span>
                    <span class="process-info-field-unit"><asp:Localize runat=server meta:resourcekey=process_info_tapping_time_unit_legend /></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_tapping_time_label /></span>
                    <span class="process-info-field-value" data-bind="text: coalesce(duration(process_tappingTime, 's', 'm:s'), '<asp:localize runat=server meta:resourcekey=no_value_legend />'),"></span>
                    <span class="process-info-field-unit"><asp:Localize runat=server meta:resourcekey=process_info_tapping_time_unit_legend /></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_tap_to_tap_label /></span>
                    <span class="process-info-field-value" data-bind="text: coalesce(duration(process_tapToTap, 's', 'm:s'), '<asp:localize runat=server meta:resourcekey=no_value_legend />'),"></span>
                    <span class="process-info-field-unit"><asp:Localize runat=server meta:resourcekey=process_info_tap_to_tap_unit_legend /></span>
                </div>
            </div>
        </div>
        <div class="form-horizontal process-info-form process-info-form-3 pull-left">
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_charge_weight_label /></span>
                    <span class="process-info-field-value" data-bind="text: coalesce(process_chargeWeight, '<asp:localize runat=server meta:resourcekey=no_value_legend />'),"></span>
                    <span class="process-info-field-unit"><asp:Localize runat=server meta:resourcekey=process_info_steel_weight_unit_legend /></span>
               </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_steel_weight_label /></span>
                    <input type="text" class="process-info-field-value input-mini" data-bind="value: decimalFixed(process_steelWeight, 2), classes: { hide: not(editingProcess), }," data-select-on-focus/>
                    <span class="process-info-field-value" data-bind="text: coalesce(decimalFixed(process_steelWeight, 2), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                    <i class="fa fa-lock manual-lock-btn" data-variable-name="STEELWEIGHT" data-bind="classes: { hide: not(contains({ name: 'STEELWEIGHT', }, process_manualVariables)), }," title="<asp:Localize runat=server meta:resourcekey=manual_lock_btn_title />"></i>
                    <span class="process-info-field-unit"><asp:Localize runat=server meta:resourcekey=process_info_steel_weight_unit_legend /></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_pourback_heat_label /></span>
                    <input type="text" class="process-info-field-value input-mini" data-bind="value: trim(process_pourbackHeatName), classes: { hide: not(editingProcess), }," data-select-on-focus/>
                    <span class="process-info-field-value" data-bind="text: coalesce(trim(process_pourbackHeatName), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_pourback_weight_label /></span>
                    <input type="text" class="process-info-field-value input-mini" data-bind="value: decimalFixed(process_pourbackWeight, 2), classes: { hide: not(editingProcess), }," data-select-on-focus/>
                    <span class="process-info-field-value" data-bind="text: coalesce(decimalFixed(process_pourbackWeight, 2), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                    <span class="process-info-field-unit"><asp:Localize runat=server meta:resourcekey=process_info_pourback_weight_unit_legend /></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_heel_label /></span>
                    <input type="text" class="process-info-field-value input-mini" data-bind="value: decimalFixed(process_heel, 2), classes: { hide: not(editingProcess), }," data-select-on-focus/>
                    <span class="process-info-field-value" data-bind="text: coalesce(decimalFixed(process_heel, 2), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                    <i class="fa fa-lock manual-lock-btn" data-variable-name="HEEL" data-bind="classes: { hide: not(contains({ name: 'HEEL', }, process_manualVariables)), }," title="<asp:Localize runat=server meta:resourcekey=manual_lock_btn_title />"></i>
                    <span class="process-info-field-unit" title="Click to revert to automatic"><asp:Localize runat=server meta:resourcekey=process_info_heel_unit_legend /></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_yield_label /></span>
                    <span class="process-info-field-value" data-bind="text: coalesce(decimalFixed(process_yield, 1), '<asp:localize runat=server meta:resourcekey=no_value_legend />'),"></span>
                    <span class="process-info-field-unit"><asp:Localize runat=server meta:resourcekey=process_info_yield_unit_legend /></span>
                </div>
            </div>
        </div>
        <div class="form-horizontal process-info-form process-info-form-4 pull-left">
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_regulation_mode_label /></span>
                    <select class="process-info-field-value" style="width:105px;" data-bind="value: integer(process_regulationModeId), options: select(process_id, regulationModes, []), optionsEmpty: { label: '<asp:localize runat=server meta:resourcekey=regulation_modes_combo_empty_opt />', value: 0 }, enabled: all(process_id, hasRegulationModes), classes: { hide: not(editingProcess), },"></select>
                    <span class="process-info-field-value" data-bind="text: coalesce(trim(process_regulationModeName), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                    <i class="fa fa-lock manual-lock-btn" data-variable-name="REGULATIONMODE" data-bind="classes: { hide: not(contains({ name: 'REGULATIONMODE', }, process_manualVariables)), }," title="<asp:Localize runat=server meta:resourcekey=manual_lock_btn_title />"></i>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_power_program_label /></span>
                    <input type="text" class="process-info-field-value input-mini" style="width:140px;" data-bind="value: process_powerProgram, classes: { hide: not(editingProcess), },"/>                    
                    <span class="process-info-field-value" data-bind="text: coalesce(process_powerProgram, '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>               
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_burner_program_label /></span>
                    <input type="text" class="process-info-field-value input-mini" style="width:140px;" data-bind="value: process_burnerProgram, classes: { hide: not(editingProcess), },"/>
                    <span class="process-info-field-value" data-bind="text: coalesce(process_burnerProgram, '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_power_on_label /></span>
                    <input type="text" class="process-info-field-value input-duration-small" data-mask="#0:00" data-mask-reverse="true" data-bind="value: duration(process_powerOn$, 's', 'm:s'), classes: { hide: not(editingProcess), }," data-select-on-focus/>
                    <span class="process-info-field-value" data-bind="text: coalesce(duration(process_powerOn$, 's', 'm:s'), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                    <i class="fa fa-lock manual-lock-btn" data-variable-name="POWERON" data-bind="classes: { hide: not(contains({ name: 'POWERON', }, process_manualVariables)), }," title="<asp:Localize runat=server meta:resourcekey=manual_lock_btn_title />"></i>
                    <span class="process-info-field-unit"><asp:Localize runat=server meta:resourcekey=process_info_power_on_unit_legend /></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_power_off_label /></span>
                    <span class="process-info-field-value" data-bind="text: coalesce(duration(process_powerOff, 's', 'm:s'), '<asp:localize runat=server meta:resourcekey=no_value_legend />'),"></span>
                    <span class="process-info-field-unit"><asp:Localize runat=server meta:resourcekey=process_info_power_off_unit_legend /></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_energy_label /></span>
                    <input type="text" class="process-info-field-value input-mini" data-bind="valueLockFocus: decimalFixed(process_energy, 2), classes: { hide: not(editingProcess), }," data-select-on-focus/>
                    <span class="process-info-field-value" data-bind="text: coalesce(decimalFixed(process_energy, 2), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                    <i class="fa fa-lock manual-lock-btn" data-variable-name="ENERGY" data-bind="classes: { hide: not(contains({ name: 'ENERGY', }, process_manualVariables)), }," title="<asp:Localize runat=server meta:resourcekey=manual_lock_btn_title />"></i>
                    <span class="process-info-field-unit"><asp:Localize runat=server meta:resourcekey=process_info_energy_unit_legend /></span>
                </div>
            </div>
        </div>
        <div class="form-horizontal process-info-form process-info-form-6 pull-left">
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text info-label-form-6"><asp:Localize runat=server meta:resourcekey=process_info_ncc_1_label /></span>
                    <span class="process-info-field-value" data-bind="text: coalesce(trim(process_ncc1), '<asp:localize runat=server meta:resourcekey=no_value_legend />'),"></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                     <span class="process-info-field-label-long-text info-label-form-6"><asp:Localize runat=server meta:resourcekey=process_info_ncc_2_label /></span>
                     <span class="process-info-field-value" data-bind="text: coalesce(trim(process_ncc2), '<asp:localize runat=server meta:resourcekey=no_value_legend />'),"></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                     <span class="process-info-field-label-long-text info-label-form-6"><asp:Localize runat=server meta:resourcekey=process_info_ncc_3_label /></span>
                     <span class="process-info-field-value" data-bind="text: coalesce(trim(process_ncc2), '<asp:localize runat=server meta:resourcekey=no_value_legend />'),"></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text info-label-form-6"><asp:Localize runat=server meta:resourcekey=process_info_cave_in_1_label /></span>
                    <span class="process-info-field-value" data-bind="text: coalesce(trim(process_caveIn1), '<asp:localize runat=server meta:resourcekey=no_value_legend />'),"></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text info-label-form-6"><asp:Localize runat=server meta:resourcekey=process_info_cave_in_2_label /></span>
                    <span class="process-info-field-value" data-bind="text: coalesce(trim(process_caveIn2), '<asp:localize runat=server meta:resourcekey=no_value_legend />'),"></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text info-label-form-6"><asp:Localize runat=server meta:resourcekey=process_info_cave_in_3_label /></span>
                    <span class="process-info-field-value" data-bind="text: coalesce(trim(process_caveIn3), '<asp:localize runat=server meta:resourcekey=no_value_legend />'),"></span>
                </div>
            </div>
        </div>
        
        <div class="form-horizontal process-info-form process-info-form-5 pull-left">
            <div class="process-info-row">
                <div class="process-info-group">
                    <label class="process-info-field-value">
                        <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_electrode_changed_label /></span>
                    </label>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <label class="process-info-field-value" data-bind="classes: { hide: not(editingProcess), },">
                        <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_electrode_1_changed_label /></span>
                        <input type="checkbox" class="process-info-field-value" data-bind="checked: process_electrode1Changed," />
                    </label>
                    <label class="process-info-field-value readonly" data-bind="classes: { hide: not(not(editingProcess)), },">
                        <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_electrode_1_changed_label /></span>
                        <i class="fa process-info-field-value" data-bind="classes: { 'fa-check-square-o': process_electrode1Changed, 'fa-square-o': not(process_electrode1Changed), }," />
                    </label>
                    <i class="fa fa-lock manual-lock-btn" data-variable-name="ELECTRODE1CHANGED" data-bind="classes: { hide: not(contains({ name: 'ELECTRODE1CHANGED', }, process_manualVariables)), }," title="<asp:Localize runat=server meta:resourcekey=manual_lock_btn_title />"></i>
                    <button class="btn btn-change-electrode" data-phase-code="A" data-bind="classes: { hide: not(all(editingProcess, process_electrode1ChangeId)), }," style="margin-left: 10px;margin-top: 6px;padding: 0;" title="Change electrode">
                        <i class="fa fa-edit" style="padding: 3px;"></i>
                    </button>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <label class="process-info-field-value" data-bind="classes: { hide: not(editingProcess), },">
                        <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_electrode_2_changed_label /></span>
                        <input type="checkbox" class="process-info-field-value" data-bind="checked: process_electrode2Changed," />
                    </label>
                    <label class="process-info-field-value readonly" data-bind="classes: { hide: not(not(editingProcess)), },">
                        <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_electrode_2_changed_label /></span>
                        <i class="fa process-info-field-value" data-bind="classes: { 'fa-check-square-o': process_electrode2Changed, 'fa-square-o': not(process_electrode2Changed), }," />
                    </label>
                    <i class="fa fa-lock manual-lock-btn" data-variable-name="ELECTRODE2CHANGED" data-bind="classes: { hide: not(contains({ name: 'ELECTRODE2CHANGED', }, process_manualVariables)), }," title="<asp:Localize runat=server meta:resourcekey=manual_lock_btn_title />"></i>
                    <button class="btn btn-change-electrode" data-phase-code="B" data-bind="classes: { hide: not(all(editingProcess, process_electrode2ChangeId)), }," style="margin-left: 10px;margin-top: 6px;padding: 0;" title="Change electrode">
                        <i class="fa fa-edit" style="padding: 3px;"></i>
                    </button>
<%--                    <input type="text" class="process-info-field-value electrode-name-field" data-bind="value: process_electrode2Name, classes: { hide: not(all(editingProcess, process_electrode2Changed)), }," placeholder="<asp:Localize runat=server meta:resourcekey=process_info_electrode_name_placeholder />" />
                    <span class="process-info-field-label electrode-name-field" data-bind="text: coalesce(process_electrode2Name, '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(all(not(editingProcess), process_electrode2Changed)), },"></span>--%>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <label class="process-info-field-value" data-bind="classes: { hide: not(editingProcess), },">
                        <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_electrode_3_changed_label /></span>
                        <input type="checkbox" class="process-info-field-value" data-bind="checked: process_electrode3Changed," />
                    </label>
                    <label class="process-info-field-value readonly" data-bind="classes: { hide: not(not(editingProcess)), },">
                        <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_electrode_3_changed_label /></span>
                        <i class="fa process-info-field-value" data-bind="classes: { 'fa-check-square-o': process_electrode3Changed, 'fa-square-o': not(process_electrode3Changed), }," />
                    </label>
                    <i class="fa fa-lock manual-lock-btn" data-variable-name="ELECTRODE3CHANGED" data-bind="classes: { hide: not(contains({ name: 'ELECTRODE3CHANGED', }, process_manualVariables)), }," title="<asp:Localize runat=server meta:resourcekey=manual_lock_btn_title />"></i>
                    <button class="btn btn-change-electrode" data-phase-code="C" data-bind="classes: { hide: not(all(editingProcess, process_electrode3ChangeId)), }," style="margin-left: 10px;margin-top: 6px;padding: 0;" title="Change electrode">
                        <i class="fa fa-edit" style="padding: 3px;"></i>
                    </button>
<%--                    <input type="text" class="process-info-field-value electrode-name-field" data-bind="value: process_electrode3Name, classes: { hide: not(all(editingProcess, process_electrode3Changed)), }," placeholder="<asp:Localize runat=server meta:resourcekey=process_info_electrode_name_placeholder />" />
                    <span class="process-info-field-label electrode-name-field" data-bind="text: coalesce(process_electrode3Name, '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(all(not(editingProcess), process_electrode3Changed)), },"></span>--%>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group"></div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group"></div>
            </div>
        </div>
    </div>

    <div class="grids-containers row-fluid" data-bind="classes: { hide: not(all(userHasAccess, not(isLoadingProcess), any(not(mainView), equals(process_furnaceCode, furnaceCode)))), },">
        <div class="row-fluid">
            <div class="span6 pull-left">
                <h5><asp:Localize runat=server meta:resourcekey=process_phases_title /></h5>
                <div class="process-phases-grid-container"></div>
                <div class="process-phases-chart-container row-fluid" data-bind="collection: $phases, itemView: 'phaseChartView'">
                </div>
            </div>
            <div class="span6 pull-left">
                <div class="form-horizontal row-fluid process-info-form" style="margin-left:0;width:100%;">
                    <div class="row-fluid process-info-row">
                        <div class="row-fluid process-info-group" style="height:auto;">
                            <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_comments_label /></span>
                            <textarea class="row-fluid" maxlength="200" style="height:45px;" data-bind="value: trim(process_comments), classes: { hide: not(editingProcess), },"></textarea>
                            <span class="row-fluid process-info-field-value-text-area" style="height:45px;" data-bind="text: select(trim(process_comments), trim(process_comments), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                        </div>
                    </div>
                </div>
                <div class="row-fluid">
                    <h5 class="row-fluid"><asp:Localize runat=server meta:resourcekey=process_consumptions_title /></h5>
                    <div class="row-fluid">
                        <div class="span4 pull-left">
                            <div class="process-consumptions-grid-container"></div>
                        </div>
                        <div class="span8 table-pivot pull-left">
                            <div class="col" style="width:35%;display:inline-block;">
                                <div class="header-cell"><asp:Localize runat=server meta:resourcekey=consumable_sidewall_row_header_name_label /></div>
                                <%--<div class="header-cell"><asp:Localize runat=server meta:resourcekey=consumable_sidewall_row_header_status_label /></div>--%>
                                <div class="header-cell"><asp:Localize runat=server meta:resourcekey=consumable_sidewall_row_header_flow_rate_oxygen_label /></div>
                                <div class="header-cell"><asp:Localize runat=server meta:resourcekey=consumable_sidewall_row_header_flow_rate_fuel_label /></div>
                            </div>
                            <div class="process-consumptions-sidewalls-grid-container" style="width:65%;display:inline-block;"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row-fluid" style="margin-top:10px;">
            <div class="span6 pull-left">
                    <h5 class="grid-title"><asp:Localize runat=server meta:resourcekey=process_buckets_title /></h5>
                    <i class="fa fa-lock manual-lock-btn" data-bind="classes: { hide: not(contains({ name: 'BUCKETS', }, process_manualVariables)), },"></i>
                    <div class="process-buckets-grid-container"></div>
            </div>
            <div class="span3 pull-left">
                <h5 class="grid-title"><asp:Localize runat=server meta:resourcekey=process_temperatures_title /></h5>
                <i class="fa fa-lock manual-lock-btn" data-bind="classes: { hide: not(contains({ name: 'TEMPERATURES', }, process_manualVariables)), },"></i>
                <div class="process-temperatures-grid-container"></div>
            </div>
            <div class="span3 pull-left">
                <h5 class="grid-title"><asp:Localize runat=server meta:resourcekey=process_additions_title /></h5>
                <i class="fa fa-lock manual-lock-btn" data-bind="classes: { hide: not(contains({ name: 'ADDITIONS', }, process_manualVariables)), },"></i>
                <div class="process-additions-grid-container"></div>
            </div>
        </div>
    </div>
    <div class="delays-container row-fluid delays-anchor-target" data-bind="classes: { hide: not(all(userHasAccess, not(isLoadingProcess), any(not(mainView), equals(process_furnaceCode, furnaceCode)))), },">
        <h5><asp:Localize runat=server meta:resourcekey=process_delays_title /></h5>
        <div class="delays-grid-container row-fluid">
    </div>
    {{#if displayChemistry}}
    <div class="row-fluid" data-bind="classes: { hide: not(all(userHasAccess, not(isLoadingProcess), any(not(mainView), equals(process_furnaceCode, furnaceCode)))), }," style="margin-top:30px;">
        <div class="chemistry-samples-info-container row-fluid" style="overflow-x:auto;"></div>
    </div>
    {{/if}}
    <div class="row-fluid" data-bind="classes: { hide: not(all(userHasAccess, not(isLoadingProcess), any(not(mainView), equals(process_furnaceCode, furnaceCode)))), }," style="margin-top:30px;">
        <div class="slag-chemistry-samples-info-container row-fluid" style="overflow-x:auto;"></div>
    </div>
</div>


</div>
<script id="actions_header_cell_template" type="text/x-handlebars-template">
    <button data-toggle="tooltip" data-placement="bottom" data-cell-action="NEW" title="<asp:Localize runat=server meta:resourcekey=grid_new_btn_title />" class="btn btn-cell-action btn-small btn-new"><i class="fa fa-plus"></i></button>
</script>

<script id="actions_cell_template" type="text/x-handlebars-template">
    <button data-toggle="tooltip" data-placement="bottom" data-cell-action="SAVE" title="<asp:Localize runat=server meta:resourcekey=grid_save_btn_title />" class="btn btn-small btn-cell-action btn-save hide" style="margin-right:2px;"><i class="fa fa-floppy-o"></i></button>
    <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DISCARD" title="<asp:Localize runat=server meta:resourcekey=grid_discard_btn_title />" class="btn btn-small btn-cell-action btn-discard hide"><i class="fa fa-times"></i></button>
    <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DELETE" title="<asp:Localize runat=server meta:resourcekey=grid_remove_btn_title />" class="btn btn-small btn-cell-action btn-remove"><i class="fa fa-trash-o"></i></button>
</script>

<script id="actions_cell_template_buckets" type="text/x-handlebars-template">
    <button data-toggle="tooltip" data-placement="bottom" data-cell-action="SAVE" title="<asp:Localize runat=server meta:resourcekey=grid_save_btn_title />" class="btn btn-small btn-cell-action btn-save hide" style="margin-right:2px;"><i class="fa fa-floppy-o"></i></button>
    <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DISCARD" title="<asp:Localize runat=server meta:resourcekey=grid_discard_btn_title />" class="btn btn-small btn-cell-action btn-discard hide"><i class="fa fa-times"></i></button>
    <%--{{HBExp "#if editingProcess"}}--%>
    <button data-toggle="tooltip" data-placement="bottom" data-cell-action="GOTO" title="<asp:Localize runat=server meta:resourcekey=grid_goto_btn_title />" class="btn btn-small btn-cell-action btn-remove"><i class="fa fa-arrow-circle-right"></i></button>
    <%--{{HBExp "/if"}}--%>
    <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DELETE" title="<asp:Localize runat=server meta:resourcekey=grid_remove_btn_title />" class="btn btn-small btn-cell-action btn-remove"><i class="fa fa-trash-o"></i></button>
</script>

<script id="consumable_sidewall_col_template" type="text/x-handlebars-template">

<div class="header-cell" data-bind="text: coalesce(oxygen_name, ''),"></div>
<%--<div class="body-cell">
    <input type="checkbox" data-bind="checked: oxygen_status,"/>
</div>--%>
<div class="body-cell">
    <input type="text" class="row-fluid pull-left" data-bind="value: coalesce(oxygen_counter, ''), classes: { hide: not(editingProcess), manual: contains({ name: format('OXYGEN_BURNER_$1.COUNTER', oxygen_name), }, process_manualVariables), },"/>
    <span class="row-fluid pull-left" data-bind="text: coalesce(oxygen_counter, ''), classes: { hide: not(not(editingProcess)), manual: contains({ name: format('OXYGEN_BURNER_$1.COUNTER', oxygen_name), }, process_manualVariables), },"></span>
    <i class="fa fa-lock manual-lock-btn" data-bind="attr: { 'data-code': oxygen_code, 'data-variable-name': format('OXYGEN_BURNER_$1.COUNTER', oxygen_name), }, classes: { hide: not(contains({ name: format('OXYGEN_BURNER_$1.COUNTER', oxygen_name), }, process_manualVariables)), }," title="<asp:Localize runat=server meta:resourcekey=manual_lock_btn_title />"></i>
</div>
<div class="body-cell">
    <input type="text" class="row-fluid pull-left" data-bind="value: coalesce(naturalGas_counter, ''), classes: { hide: not(editingProcess), manual: contains({ name: format('NATURAL_GAS_BURNER_$1.COUNTER', naturalGas_name), }, process_manualVariables), },"/>
    <span class="row-fluid pull-left" data-bind="text: coalesce(naturalGas_counter, ''), classes: { hide: not(not(editingProcess)), manual: contains({ name: format('NATURAL_GAS_BURNER_$1.COUNTER', naturalGas_name), }, process_manualVariables), },"></span>
    <i class="fa fa-lock manual-lock-btn" data-bind="attr: { 'data-code': naturalGas_code, 'data-variable-name': format('NATURAL_GAS_BURNER_$1.COUNTER', naturalGas_name), }, classes: { hide: not(contains({ name: format('NATURAL_GAS_BURNER_$1.COUNTER', naturalGas_name), }, process_manualVariables)), }," title="<asp:Localize runat=server meta:resourcekey=manual_lock_btn_title />"></i>
</div>

</script>

<script id="phase_chart_view" type="text/x-handlebars-template">

    <div data-bind="text: coalesce(formattedDuration, ''), css: { width: format('$1%', mathDiv(mathMul(duration, 100), processDuration)), }, attr: { 'class': format('phases-chart-item phase-$1-color', order), },"></div>
    
</script>

<script id="electrode_change_modal_template" type="text/x-handlebars-template">
    <!-- View's container will container the class "electrode-change-modal" -->
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="electrode_change_modal_title" /></h3>
    </div>
    <div style="max-height:500px;" class="modal-body">
        <div class="row-fluid">
            <div class="row-fluid">
                <div class="form-horizontal read-only span3">
                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_heat_label" />:
                        </label>
                        <div class="controls">
                            <span class="static-control" data-bind="text: coalesce(heatName, '-'),"></span>
                        </div>
                    </div>
                </div>
                <div class="form-horizontal read-only span3">
                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_phase_label" />:
                        </label>
                        <div class="controls">
                            <span class="static-control" data-bind="text: coalesce(phaseCode, '-'),"></span>
                        </div>
                    </div>
                </div>
            </div>
            <%--<h4><asp:localize runat="server" meta:resourcekey="electrode_change_modal_current_electrode_title_label" /></h4>
            <div class="row-fluid">
                <div class="form-horizontal read-only span3">
                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_phase_label" />:
                        </label>
                        <div class="controls">
                            <span class="static-control" data-bind="text: coalesce(phaseCode, '-'),"></span>
                        </div>
                    </div>
                </div>
                <div class="form-horizontal read-only span3">
                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_current_electrode_heats_count_label" />:
                        </label>
                        <div class="controls">
                            <span class="static-control" data-bind="text: coalesce(currentElectrodeHeatsCount, '-'),"></span>
                        </div>
                    </div>
                </div>
                <div class="form-horizontal read-only span3">
                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_current_electrode_supplier_label" />:
                        </label>
                        <div class="controls">
                            <span class="static-control" data-bind="text: coalesce(currentElectrodeSupplier, '-'),"></span>
                        </div>
                    </div>
                </div>
                <div class="form-horizontal read-only span3">
                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_current_electrode_weight_label" />:
                        </label>
                        <div class="controls">
                            <span class="static-control" data-bind="text: coalesce(currentElectrodeWeight, '-'),"></span>
                        </div>
                    </div>
                </div>
            </div>--%>
            <h4><asp:localize runat="server" meta:resourcekey="electrode_change_modal_new_electrode_title_label" /></h4>
            <div class="row-fluid">
                <div class="form-horizontal">
                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_new_electrode_supplier_label" />
                        </label>
                        <div class="controls">
                            <input type="text" class="input-large autofocus" data-bind="value: newElectrodeSupplier, enabled: not(processing)," placeholder="<asp:localize runat=server meta:resourcekey=electrode_change_modal_new_electrode_supplier_placeholder />" data-select-on-focus />
                        </div>
                    </div> 
                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_new_electrode_size_label" />
                        </label>
                        <div class="controls">
                            <input type="text" class="input-medium" data-bind="value: newElectrodeSize, enabled: not(processing)," placeholder="<asp:localize runat=server meta:resourcekey=electrode_change_modal_new_electrode_size_placeholder />" data-select-on-focus />
                        </div>
                    </div>
                    <%--<div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_new_electrode_weight_label" />
                        </label>
                        <div class="controls">
                            <input type="text" class="input-medium" data-bind="value: newElectrodeWeight, enabled: not(processing)," placeholder="<asp:localize runat=server meta:resourcekey=electrode_change_modal_new_electrode_weight_placeholder />" data-select-on-focus />
                        </div>
                    </div>--%>
                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_new_electrode_change_reason_label" />
                        </label>
                        <div class="controls">
                            <select class="input-large" data-bind="value: integer(newElectrodeChangeReasonId), options: electrodeChangeReasons, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=combo_choose_opt />', value: 0 }, enabled: not(processing),"></select>
                        </div>
                    </div> 
                    <div class="control-group">
                        <label class="control-label">
                            <asp:localize runat="server" meta:resourcekey="electrode_change_modal_new_electrode_comments_label" />
                        </label>
                        <div class="controls">
                            <textarea data-bind="value: trim(newElectrodeComments), enabled: not(processing)," maxlength="400" style="width:197px;height:70px;" placeholder="<asp:localize runat=server meta:resourcekey=electrode_change_modal_new_electrode_comments_placeholder />" data-select-on-focus></textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <div class="modal-status-msg-container pull-left">
            <div class="modal-status-msg hide" data-bind="toggle: processing,">
                <asp:Localize runat='server' meta:resourcekey='electrode_change_modal_processing_msg' />
                <i class="fa fa-cog fa-spin"></i>
            </div>
        </div>
        <button id="acceptBtn" data-bind="enabled: all(notEquals(processing, newElectrodeChangeReasonId))," class="btn btn-primary">
            <asp:Localize runat='server' meta:resourcekey='electrode_change_modal_accept_btn_label' />
        </button>
        <button data-bind="enabled: notEquals(processing, true)" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='electrode_change_modal_cancel_btn_label' />
        </button>
    </div>
</script>