﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar">
    <div class="row-fluid form-inline">
        <div class="span11">
            <div class="span12 ">
                <label class="control-label" for="dateStartTbx">
                    <asp:localize runat="server" meta:resourcekey="date_from_tbx_label" />
                </label>
                <label class="input-prepend" >
                    <span class="add-on"><i class="icon-calendar"></i></span>
                    <input type="text" id="dateStartTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(start$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
                </label>
                <label class="control-label" for="dateEndTbx">
                    <asp:localize runat="server" meta:resourcekey="date_to_tbx_label" />
                </label>
                <label class="input-prepend">
                    <span class="add-on"><i class="icon-calendar"></i></span>
                    <input type="text" id="dateEndTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(end$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
                </label>
            

                <label class="control-label" for="selectShift"><asp:Localize runat="server" meta:resourcekey="shifts_label" /></label>
                <select style="width:100px" data-bind="value: integer(shiftId), options: shifts, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=combo_all_option />', value: 0 }" id="selectShift" name="selectShift">
                </select>
                <label class="control-label" for="selectCrew"><asp:Localize runat="server" meta:resourcekey="crews_label" /></label>
                <select style="width:100px" data-bind="value: trim(crewId), options: crews, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=combo_all_option />', value: null }" id="selectCrew" name="selectCrew">
                </select>
                <label class="control-label" for="selectStatus"><asp:Localize runat="server" meta:resourcekey="status_label" /></label>
                <select style="width:100px" data-bind="value: trim(statusCode), options: status, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=combo_all_option />', value: null }" id="selectStatus" name="selectCrew">
                </select>
            </div>

            <div class="span12" style="margin-left:0px">
                <label class="control-label" for="searchEquipmentsTbx">
                    <asp:localize runat="server" meta:resourcekey="equipment_picker_label" />
                </label>
                <div class="input-prepend input-append " style="margin-top:4px">
                    <input type="text" id="searchEquipmentsTbx" style="width:150px;" data-bind="value: trim(equipmentName), events: ['change', 'keydown',]" placeholder="<asp:Localize runat=server meta:resourcekey=equipment_picker_place_holder />" data-select-on-focus/>
                    <label class="btn btn-search-show" id="showSearchEquipmentsBtn" for="searchEquipmentsTbx"><i class="fa fa-caret-down"></i></label>
                </div>

                <label class="control-label" for="searchUsersTbx">
                    <asp:localize runat="server" meta:resourcekey="user_picker_label" />
                </label>
                <div class="input-prepend input-append " style="margin-top:4px">
                    <input type="text" id="searchUsersTbx" style="width:150px;" data-bind="value: trim(userName), events: ['change', 'keydown',]" placeholder="<asp:Localize runat=server meta:resourcekey=user_picker_place_holder />" data-select-on-focus/>
                    <label class="btn btn-search-show" id="showSearchUsersBtn" for="searchUsersTbx"><i class="fa fa-caret-down"></i></label>
                </div>

                <label class="control-label" for="commentSearch">
                    <asp:localize runat="server" meta:resourcekey="comment_tbx_label" />
                </label>
                <div class="input-prepend input-append " style="margin-top:4px">
                    <input type="text" id="commentSearch" style="width:150px;" data-bind="value: trim(commentSearch)" placeholder="<asp:Localize runat=server meta:resourcekey=comment_tbx_place_holder />" />
                </div>
            </div>
            
        </div>
        
        <div class="span1 text-right">
            <div class="span12">
                <button id="refreshBtn" class="btn btn-primary" style="margin-right:4px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                    <i class="fa fa-refresh"></i>
                </button>
            </div>
            <div class="span12"  style="margin-left:0px;">
                <button style="margin-top:4px; margin-right:4px;" class="btn btn-export-to-excel " type="button">
                    <span class="excel-export-state fa fa-file-excel-o"></span>
                    <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
                </button>
            </div>
        </div>
        
    </div>
</div>
<div class="row-fluid screen-content">
    <div style="margin-top:7%;" class="row-fluid loading-poster text-center">
        <div style="width:40%; margin: 0 auto;" class="progress progress-striped active">
            <div class="bar" style="width: 100%;"></div>
        </div>
    </div>
    <div class="row-fluid">
        <div class="equipment-logs-grid-container infinite-container hide" style="margin-top:20px"></div>
    </div>
    
</div>

<script id="actions_cell_template" type="text/x-handlebars-template">
    <div class="text-center">
        <button data-toggle="tooltip" data-placement="bottom" data-cell-action="EDIT_DETAILS" title="<asp:Localize runat=server meta:resourcekey=edit_details_title />" class="btn btn-cell-action btn-small btn-edit-details"><i class="fa fa-pencil-square-o"></i></button>
    </div>
</script>