-------------
-- ROLES
-------------
	USE [IHBoxSystem]
	GO
	CREATE ROLE forecast_melt_orders_read AUTHORIZATION dbo 
	GO  

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'forecast_melt_orders_read', 'admin'
	GO

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'forecast_melt_orders_read', 'SDI/australtek'
	GO


	CREATE ROLE forecast_melt_orders_readWrite AUTHORIZATION dbo 
	GO  

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'forecast_melt_orders_readWrite', 'admin'
	GO

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'forecast_melt_orders_readWrite', 'SDI/australtek'
	GO


-------------------
-- Menu and Route
-------------------
	declare @parent int, @result_routeId INT
	select @parent=id from [FrontEnd].[Menu] where [Name] = 'MES' and Parent is null

	INSERT INTO [FrontEnd].[Routes]
			   ([Route]
			   ,[ModuleName]
			   ,[ModulePath]
			   ,[RequiredRole]
		   )
		 VALUES 
			   (
			   '!/forecast-melt-orders(/)'
			   , 'forecast-melt-orders'
			   , 'custom-screens/forecast-melt-orders/'
			   , 'forecast_melt_orders_read'           
			   )
			   SET @result_routeId = @@IDENTITY
	INSERT INTO [FrontEnd].[Menu]
			   ([Parent]
			   ,[Name]
			   ,[RouteID]
			   ,[SortOrder]
			   ,[Enabled]
			   ,[Visible]
			   ,[RequiredRole]
			   ,[Group]
			  )
		 VALUES
			   (
			   @parent
			   ,'Forecast Melt Orders'
			   ,@result_routeId 
			   ,1
			   ,1
			   ,1
			   ,'forecast_melt_orders_read'
			   ,NULL
			 )
	GO


-------------------
-- SP Permissions
-------------------
--EXECUTE sys.sp_addextendedproperty 
--@level0type = N'USER' -- The object type
--,@level0name = [forecast_melt_orders_readWrite] -- The role
--,@name = N'securedsp-CAS.GetProducts' -- the procedure
--,@value = N'' 
--GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [forecast_melt_orders_read] -- The role
,@name = N'securedsp-MES.GetForecastMeltOrders' -- the procedure
,@value = N'' 
GO


-------------------
--	Profiles
-------------------
	USE [IHBoxSystem]
	GO

	DECLARE @ModuleId INT

	INSERT INTO [SECURITY].[Modules]([Code],[Name])
	VALUES('forecast_melt_orders','Forecast Melt Orders')

	SET @ModuleId = @@IDENTITY

	INSERT INTO [SECURITY].[ModuleActions]([ModuleId],[Code],[Name],[Role])
	VALUES(@ModuleId,'readWrite','Read/Write','forecast_melt_orders_readWrite')


	INSERT INTO [SECURITY].ModuleActions(ModuleId,Code,[Name],[Role])
	VALUES (@ModuleId,'read','Read','forecast_melt_orders_read')

