﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(all(not(hasData), not(isLoading))), }," style="height:500px;">
    <div class="row-fluid" style="position:relative;top:100px;">
        <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
    </div>
    <div class="row-fluid" style="position:relative;top:115px;">
        <h3 style="font-size:50px;">
            <asp:localize runat="server" meta:resourcekey="no_data_available" />
        </h3>
    </div>
</div>
<div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }," style="height:500px;">
    <div class="row-fluid" style="position:relative;top:100px;">
        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
    </div>
    <div class="row-fluid" style="position:relative;top:115px;">
        <h3 style="font-size:50px;">
            <asp:localize runat="server" meta:resourcekey="loading_data" />
        </h3>
    </div>
</div>



<div class="screen-content" data-bind="classes: { hide: any(isLoading,not(hasData)), },"> 
       <div class="box-button-container">
           <div class="box-button box-button-x">
            <button id="refreshBtn" class="button-4 pull-right">
                <i class="fa fa-refresh"></i>
            </button>
          <%--  <button id="redirect" class="button-4 pull-right">
                <i class="fa fa-cog fa-1x"></i>
            </button>--%>
        </div>
    </div>
     <div class="center-box-small">
        <div class="row-fluid box-container-small"  data-bind="classes: { hide: any(not(hasData), isLoading), },">  
            <div class="data-container-small">
                <h5 class="grid-title-small" data-bind="text: tonsCastedCurrentMonth"></h5>
            </div>  
            
        </div>
    </div>

    <div class="box-container">
     

        <div class="box box-x">

            <div class="row-fluid box-container"  data-bind="classes: { hide: any(not(hasData), isLoading), },">  
                <div class="data-container">
                    <h5 class="grid-title top-table grid-title-bottom" data-bind="text: tonsCastedPreviousWeek"></h5>
                    <div class="row-fluid items-grid-contaner-previous"></div>
                </div>
            </div>
        </div>

        <div class="box box-x">

            <div class="row-fluid box-container"  data-bind="classes: { hide: any(not(hasData), isLoading), },">  
                <div class="data-container">
                    <h5 class="grid-title top-table grid-title-bottom" data-bind="text: tonsCastedCurrentWeek"></h5>
                    <div class="row-fluid items-grid-contaner-current"></div>
                </div>
            </div>
        </div>

        <div class="box box-x">

            <div class="row-fluid box-container"  data-bind="classes: { hide: any(not(hasData), isLoading), },">  
                <div class="data-container">
                    <h5 class="grid-title top-table grid-title-bottom">Following Week</h5>
                    <div class="row-fluid items-grid-contaner-next"></div>
                </div>
            </div>
        </div>
    </div>   
</div>






