﻿//SCREEN-BOILERPLATE
//this boilerplate builds screens that are gonna be shown in the <div class='content'> tag of our main HTML.
//do not build app components with this boilerplate, only screens (reports)

define([
    // Application variable, always include it to have access to app methods.
    'app',

    //templates-loader: this loads templates async.
    'js/templates-loader',
    'backgrid',
    'moment',
    'modules/navigation-buttons/navigation-buttons',
    'modules/modal-lab-heat-report-edit/modal-lab-heat-report-edit',

    'modules/modal2',
    'backgrid/moment-cell',
    'js/autocomplete/backbone.autocomplete',
    'backgrid/grouped-columns',
    "js/jquery.floatThead/jquery.floatThead",
    'js/multiselect/virtual-select.min',
    'js/jquery.contextMenu/jquery.contextMenu'

],
    function (app, T, Backgrid, moment, NavigationButton, LabHeatReportModal, Modal) {

        var Screen = { Models: {}, Views: {}, Collections: {} }


        Screen.Models.Main = Backbone.Epoxy.Model.extend({
            defaults: {
                furnaceCodes: [{ label: 'A', value: 1 }, { label: 'B', value: 2 }],
                furnaceCode: 1,

                //URL parameters

                heatName: null,
                gradeName: '-',
                time: '-',
                hasData_process: false,
                isLoading_process: true,

                heatId: null,
                direction: null,
                navigation: null,
                heatNames: [],
                enterPress: false,

                appendGrid: true,

                hideExcelBtn: false,
                hideNavitaionBtns: false,
                sampleTimesTable: [],


                hasPermission: false,
            },
            computeds: {
                hasData: {
                    deps: ['hasData_process'],
                    get: function (process) {
                        return process;
                    },
                },
                isLoading: {
                    deps: ['isLoading_process'],
                    get: function (process) {
                        return process;
                    },
                },
                hasHeatName: {
                    deps: ['heatName'],
                    get: function (heatName) {
                        if (heatName === '' || !heatName) return false;
                        else return true;
                    }
                }
            },
            initialize: function () {
                this.labGridCollection = new Screen.Collections.LabGrid();
                this.limitsCompare = null;
            },

            resendToL3: function (params) {
                var qp = new Core.Database.QueryParameters();
                var that = this;
                
                qp.Add('@Id', 'INT', params.Id);
                Core.Json.CallProcedure(
                    app.DatabaseNames.MES + '.LAB.ResendChemistrySampleToL3',
                    qp,
                    {
                        onSuccess: function (resp) {
                            try {
                                if (resp && resp.Table && resp.Table[0]) {
                                    app.views.topMessages.showMessage('The sample ' + resp.Table[0].Sample + ' was resent to L3', { stay: 5000, });
                                }
                                else {
                                    if ((resp) && (resp.Message)) {
                                        app.views.topMessages.showMessage(resp.Message, { stay: 5000, });
                                        console.error(resp.Message);                                      
                                    }
                                    else {
                                        app.views.topMessages.showMessage("Server response not valid.", { stay: 5000, });
                                        console.error("Server response not valid.");
                                       
                                    }

                                }


                            }
                            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                        },
                        Secured: true,
                        Async: false,
                    },
                    app.ConnectionStrings.app
                );
            },
            fetchNavigateHeat: function (params) {
                var qp = new Core.Database.QueryParameters();
                var that = this;
                qp.Add('@heatName', 'VARCHAR(10)', params.heatName);
                qp.Add('@direction', 'SMALLINT', params.direction);

                Core.Json.CallProcedure(
                    app.DatabaseNames.MES + '.LAB.GetNavigatedHeat',
                    qp,
                    {
                        onSuccess: function (resp) {
                            try {
                                if (resp && resp.Table && resp.Table[0] && resp.Table[0].HeatName && resp.Table[0].HeatName !== '') {
                                    that.set({
                                        heatName: resp.Table[0].HeatName,
                                        heatNames: [{
                                            value: resp.Table[0].HeatName,
                                            label: resp.Table[0].HeatName
                                        }],
                                    });
                                    that.trigger('heat-name-changed');
                                }
                                else {
                                    if ((resp) && (resp.Message)) {
                                        app.views.topMessages.showMessage(resp.Message, { stay: 5000, });
                                        console.error(resp.Message);
                                        that.set({
                                            hasData_process: false,
                                            isLoading_process: false,
                                        });
                                    }
                                    else {
                                        app.views.topMessages.showMessage("Server response not valid.", { stay: 5000, });
                                        console.error("Server response not valid.");
                                        that.set({
                                            hasData_process: false,
                                            isLoading_process: false,
                                        });
                                    }

                                }


                            }
                            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                        },
                        Secured: true,
                        Async: false,
                    },
                    app.ConnectionStrings.app
                );
            },
            fetchCatalogs: function () {
                var that = this;
                var qp = new Core.Database.QueryParameters();
                qp.Add('@HeatName', 'VARCHAR(10)', that.get('heatName'));
                qp.Add('@ReturnNewestHeat', 'BIT', that.get('heatName') ? false : true);
                Core.Json.CallProcedure(
                    app.DatabaseNames.MES + '.LAB.GetAutocompleteHeats',
                    qp,
                    {
                        onSuccess: function (resp) {
                            try {
                                if (resp && resp.Table) {
                                    that.set({
                                        heatNames: resp.Table,
                                        heatName: resp.Table[0] && resp.Table[0].value ? resp.Table[0].value : '',
                                    });
                                    that.trigger('catalogs-fetched');
                                }
                                else {
                                    if ((resp) && (resp.Message)) {
                                        app.views.topMessages.showMessage(resp.Message, { stay: 5000, });
                                        console.error(resp.Message);
                                        that.set({
                                            hasData_process: false,
                                            isLoading_process: false,


                                        });
                                    }
                                    else {
                                        app.views.topMessages.showMessage("Server response not valid.", { stay: 5000, });
                                        console.error("Server response not valid.");
                                        that.set({
                                            hasData_process: false,
                                            isLoading_process: false,
                                        });
                                    }

                                }


                            }
                            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                        },
                        Secured: true,
                        Async: false,
                    },
                    app.ConnectionStrings.app
                );
            },
            fetch: function (params) {
                var that = this;
                var qp = new Core.Database.QueryParameters();
                var grade = '-';
                qp.Add('@timeZoneCode', 'CHAR(10)', app.models.user.get('timezoneCode'));
                qp.Add('@HeatName', 'VARCHAR(10)', that.get('heatName'));
                Core.Json.CallProcedure(
                    app.DatabaseNames.MES + '.LAB.GetChemistrySamplesWithCalculatedByHeat',
                    qp,
                    {
                        onSuccess: function (resp) {
                            try {
                                if (resp && resp.Table) {
                                    grade = resp.Table3 && resp.Table3[0] && resp.Table3[0].GradeName ? resp.Table3[0].GradeName : '-';

                                    that.set({
                                        gradeName: 'Grade: ' + grade,
                                    })
                                    that.trigger('buildGrid', resp.Table, resp.Table1, resp.Table2);
                                    if (resp.Table2) {
                                        that.set({
                                            sampleTimesTable: resp.Table2
                                        })
                                    }
                                    if (resp.Table4) that.trigger('fetch-nav-buttons', resp.Table4);
                                }
                                else {
                                    if ((resp) && (resp.Message)) {
                                        app.views.topMessages.showMessage(resp.Message, { stay: 5000, });
                                        console.error(resp.Message);
                                        that.set({
                                            hasData_process: false,
                                            isLoading_process: false,
                                        });
                                    }
                                    else {
                                        app.views.topMessages.showMessage("Server response not valid.", { stay: 5000, });
                                        console.error("Server response not valid.");
                                        that.set({
                                            hasData_process: false,
                                            isLoading_process: false,
                                        });
                                    }

                                }


                            }
                            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                        },
                        Secured: true,
                        Async: true,
                    },
                    app.ConnectionStrings.app
                );

                return this;

            },

        });

        Screen.Collections.LabGrid = Backbone.Collection.extend({
            setDataColl: function (data) {
                this.set(data).trigger('fetch', data);
            }
        });
        Screen.generateID = function (viewParams) {
            try {
                //if the viewparams change the view id, then evaluate the viewparams here
                //and return the appropiate id.refreshbtn
                return 'lab-heat-report';
            } catch (Error) { }
        }

        Screen.Views.Main = Backbone.Epoxy.View.extend({
            template: 'lab-heat-report',
            id: 'lab-heat-report',
            title: 'Lab Heat Report',
            isCacheable: false,
            events: function () {
                return {
                    'click #refreshBtn': this.refreshBtn_click,
                    'click #backNavBtn': this.heatNavigationBtn_click,
                    'click #forwardNavBtn': this.heatNavigationBtn_click,
                    'click #exportExcel': this.exportToExcel,
                };
            },
            bindings: 'data-bind',
            subviews: null,
            viewParams: null,
            labGrid: [],

            NavigationButtonView: null,
            initialize: function () {
                this.options.state = app.view_states.loading;
                this.options.onappend = (_.isFunction(this.options.onappend)) ? this.options.onappend : function () { };

                var that = this;
                this.model = new Screen.Models.Main();
                this.autoRefresh = {
                    enabled: null
                    , toid: null
                    , every: 15 * 1000
                };

                this.NavigationButtonView = new NavigationButton.Views.Main();
                this.bindEvents();
                this.bus = _.extend({}, Backbone.Events);
                this.bus.on("modalAcceptBtn", this.onModalAcceptBtn, this);

            },
            getPermissions: function () {
                var read = $.inArray('lab_heat_report_read', app.models.user.get('roles'));
                var write = $.inArray('lab_heat_report_readWrite', app.models.user.get('roles'));
                var ctx = {
                    readWrite: (read != -1 && write != -1) ? true : false,
                };
                this.model.set('hasPermission', ctx.readWrite);
            },
            onModalAcceptBtn: function () {
                this.refreshBtn_click();
            },
            heatNavigationBtn_click: function (e) {
                let { id } = e.target;
                const heatName = this.model.get('heatName');
                const direction = id === 'backNavBtn' ? -1 : 1;
                this.model.fetchNavigateHeat({
                    heatName,
                    direction
                });

            },
            bindEvents: function () {
                this.listenTo(this.model.labGridCollection, 'fetch', this.process_fetched);
                this.listenTo(this.model, 'buildGrid', this.buildGrid);
                this.listenTo(this.model, 'heat-name-changed', this.heatNameChanged);
                this.listenTo(this.model, 'catalogs-fetched', this.catalogsFetched);
                this.listenTo(this.model, 'fetch-nav-buttons', this.fetchnavbuttons);
                this.listenTo(this.model, 'edit-button-click', this.editbtn_click);
                this.listenTo(this.model, 'send-to-l3-button-click', this.sendToL3btn_click);
            },
            editbtn_click: function (name) {
                var that = this;
                const sampleTimesTable = that.model.get('sampleTimesTable');
                const columnModel = {
                    HeatNumber: name.split('-')[0],
                    SelectedSample: sampleTimesTable.filter(x => x.HeatTypeSample == name)[0],
                };


                var modal = new LabHeatReportModal.Views.EditLabReport({
                    parent: this,
                    data: columnModel,
                    bus: that.bus,
                });
                modal.show();
            },
            sendToL3btn_click: function (name) {
                var that = this;

                const sampleTimesTable = this.model.get('sampleTimesTable');
                const columnModel = {
                    HeatNumber: name.split('-')[0],
                    SelectedSample: sampleTimesTable.filter(x => x.HeatTypeSample == name)[0],
                  
                };
                var message = 'This sample will be resend to L3. Do you want to continue?'


                modal = new Modal.Views.Main({
                    focusOk: false,
                    focusSelector: '#btn-cancel',
                    title: 'Resend Sample To L3 - [ ' + name + ' ]',
                    message: message,
                    buttons_type: "CONTINUE-CANCEL",
                });
                this.listenToOnce(modal, "continue", function (modal) {
                    try {
                        that.model.resendToL3({
                            Id: columnModel.SelectedSample.Id,
                        });
                    }
                    catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                });
                modal.show();
            },
            catalogsFetched: function () {
                this.UpdateURL();
            },

            fetchnavbuttons: function (resp) {
                this.NavigationButtonView.setDataColl(resp);
            },
            heatNameChanged: function () {
                const value = this.model.get('heatName');
                const options = this.model.get('heatNames');
                document.querySelector('#heat-picker-multi-select').setOptions(options);
                document.querySelector('#heat-picker-multi-select').setValue(value);
                this.UpdateURL();
                this.refresh();
            },


            buildGrid: function (chemistriesTable, elementOrderTable, sampleTimesTable) {

                this.getPermissions();
                if (chemistriesTable.length === 0) {
                    this.model.set({
                        hasData_process: false,
                        isLoading_process: false,
                    });
                    this.UpdateURL();
                    return;
                }

                var that = this;
                this.$el.find('.lab-real-time-grid-container').html('');
                var keys = null,
                    columnsName = [];
                this.model.set({
                    appendGrid: false,
                });

                var newTable = [];
                var completeTable = [];
                var limits = [];
                var model = null;

                var chemistries = [];
                //First we push into "newTable" the chemistries with an order number
                _.each(elementOrderTable, function (obj) {
                    chemistries = _.findWhere(chemistriesTable, { Code: obj.Code });
                    if (chemistries) {
                        newTable.push($.extend(obj, chemistries));
                    }
                });

                //Then we push into "newTable" the chemistries with out an order number
                _.each(chemistriesTable, function (obj) {
                    elementOrder = _.findWhere(elementOrderTable, { Code: obj.Code });
                    if (!elementOrder) {
                        elementOrder = { Code: obj.Code, Min: null, Aim: null, Max: null };
                        newTable.push($.extend(obj, elementOrder));
                    }

                });

                if (newTable && newTable[0]) {
                    columnsName = [];
                    keys = Object.keys(newTable[0]);
                    var timeRow = {};
                    var commentsRow = {};
                    var sample = [];
                    var order = [];
                    order.push("Code");

                    var element = [];
                    _.each(keys, function (obj, i) {
                        sample = _.findWhere(sampleTimesTable, { HeatTypeSample: obj });
                        if (obj === 'Code') {
                            timeRow[obj] = 'Datetime';
                            commentsRow[obj] = 'Comments';
                        } else if (sample) {
                            timeRow[obj] = new moment(sample.Timestamp).format('MM/DD/YYYY HH:mm:ss');;
                            commentsRow[obj] = sample.Comments;
                        } else {
                            timeRow[obj] = '-';
                            commentsRow[obj] = '-';
                        }
                        element = _.findWhere(sampleTimesTable, { rn: i });
                        if (element) {
                            order.push(element.HeatTypeSample);
                        }
                    });

                   
                    order.push("Min");
                    order.push("Aim");
                    order.push("Max");
                    completeTable.push(timeRow);
                    completeTable.push(commentsRow);
                    _.each(newTable, function (obj) {
                        completeTable.push(obj);
                    });

                    //var completeTableOrdered = JSON.parse(JSON.stringify(completeTable, order, 4));
                    var completeTableOrdered = JSON.parse(JSON.stringify(completeTable));
                    this.model.labGridCollection.reset();
                    this.model.labGridCollection.setDataColl(completeTableOrdered);
                    var matchKeys = [];
                    var currentKey = null;

                    //-------------------------------------------
                    //------- Get Column names for excel export
                    //-------------------------------------------
                    var colNames = [];

                    _.each(keys, function (obj, i) {
                        if (obj !== 'Code' && obj !== 'Min' && obj !== 'Aim' && obj !== 'Max' && obj !== 'Order') {
                            colNames.push(obj);
                        }
                    });
                    this.model.set({ colNames: colNames });
                    //-------------------------------------------
                    //------- Get Column names for excel export
                    //-------------------------------------------

                    var hasPermission = that.model.get('hasPermission');
                    var CustomHeaderCell = Backgrid.HeaderCell.extend({                      
                        events: {
                            'click .btn-save': 'handleButtonClick',
                            'click .btn-send-l3':'handleButtonSendToL3'
                        },
                        handleButtonClick: function (event) {
                            event.preventDefault();
                            var model = this.column.toJSON();
                            that.model.trigger('edit-button-click', model.name);
                        },
                        handleButtonSendToL3: function (event) {
                            event.preventDefault();
                            var model = this.column.toJSON();
                            that.model.trigger('send-to-l3-button-click', model.name);
                        },
                        render: function () {
                            this.$el.empty();
                            var column = this.column;
                            var columnName = column.get('label');
                            // Check if the column name is not "Code", "Min", or contains these words
                            var shouldAddButton = !/(?:^|\W)(?:Code|Min|Max|Aim|Grade)(?:$|\W)/i.test(columnName);

                            // Create a container for the column name and button
                            var headerContainer = $('<div class="header-container"></div>');

                            // Append the column name to the header container
                            headerContainer.append('<span class="column-name">' + columnName + '</span>');

                            // Append the button only if the condition is met
                            if (shouldAddButton && hasPermission) {
                                //headerContainer.append('<button class="custom-button">Button</button>');
                                headerContainer.append('<button data-toggle="tooltip" class="btn btn-cell-action btn-small btn-save" title="Edit Sample"><i class="fa fa-edit"></i></button>');
                                headerContainer.append('<button data-toggle="tooltip" class="btn btn-cell-action btn-small btn-send-l3" title="Send To L3"><i class="fa fa-arrow-up"></i></button>');

                            }

                            // Append the header container to the cell
                            this.$el.append(headerContainer);

                            this.delegateEvents(); // Ensure events are correctly bound
                            return this;
                        }
                    });
                    var keyOrder = null;

                    _.each(keys, function (obj, i) {
                        keyOrder = order[i];
                        matchKeys.push({ obj: obj, keyOrder: keyOrder });
                        if (keyOrder) {
                            columnsName.push({
                                "name": keyOrder,
                                "editable": false,
                                "label": keyOrder === 'Code' ? 'Code' : keyOrder,
                                "cell": Backgrid.StringCell.extend({
                                    className: function () {
                                        currentKey = _.findWhere(matchKeys, { obj: obj });
                                        if (currentKey.keyOrder != 'Min' && currentKey.keyOrder != 'Max' && currentKey.keyOrder != 'Aim' && currentKey.keyOrder != 'Code') {
                                            model = this.model.toJSON();
                                            if (model.Code === 'Datetime' || model.Code === 'Comments') {
                                                return 'string-cell align-center-cell no-editable';
                                            } else {
                                                return that.getElementClass(model[currentKey.keyOrder], model.Min, model.Max);
                                            }
                                        }
                                        else return 'string-cell align-center-cell no-editable';
                                    }
                                }),
                                "headerCell": CustomHeaderCell,
                            });
                        }
                    });
                    var columnLayout = [];
                    _.each(keys, function (obj) {
                        if (obj != 'Code') {
                            columnLayout.push({ 'name': obj });
                        }
                    });
                    columnLayout.push({
                        name: that.model.get('gradeName'), children:
                            [
                                { name: 'Min' }
                                , { name: 'Aim' }
                                , { name: 'Max' }
                            ]
                    })
                    that.labGrid = new Backgrid.Grid({
                        className: 'backgrid table table-hover table-condensed samples-table',
                        header: Backgrid.Extension.GroupedHeader.extend({
                            columnLayout: columnLayout,
                            initialize: function (options) {
                                Backgrid.Extension.GroupedHeader.prototype.initialize.apply(this, arguments);
                            },
                            render: function () {
                                var that = this;
                                Backgrid.Extension.GroupedHeader.prototype.render.apply(this, arguments);
                                return this;
                            },
                            events: {
                                contextmenu: 'onRightClick',
                            },
                            onRightClick: function (e) {
                                e.preventDefault();

                                var columnModel = [];

                                columnModel = {
                                    HeatNumber: that.model.get('heatName'),
                                    SelectedSample: sampleTimesTable.filter(x => x.HeatTypeSample == e.target.innerText)[0],
                                };
                                that.model.set({
                                    columnModel: columnModel,
                                });
                            },
                        }),
                        columns: columnsName,
                        row: Backgrid.Row.extend({
                            initialize: function (options) {
                                Backgrid.Row.prototype.initialize.apply(this, arguments);
                            },
                        }),
                        collection: that.model.labGridCollection,
                    });
                    that.$el.find('.lab-real-time-grid-container').append(that.labGrid.render().el);
                    that.model.set({ labGrid: that.labGrid });
                    this.model.set({
                        hasData_process: true,
                        isLoading_process: false,
                    })
                }

                that.setFixedHeader();

            },

            setFixedHeader: function () {
                var container = this.$el.find(".lab-real-time-grid-container");
                var table = container.find(".samples-table")
                table.floatThead({
                    scrollingTop: function () {
                        try {
                            return $(".fixed-subnavbar").height() + ($("header").height() / 2);
                        } catch (error) { return 111; }
                    },
                    zIndex: 500,
                    useAbsolutePositioning: false,
                });

            },

            render: function (container, urlParams) {
                var that = this;
                var thatContainer = (this.options.container) ? this.options.container : container;
                this.options.container = thatContainer;

                this.viewParams = urlParams;

                var customPath = '/app/custom-screens/' + this.template + '/';

                T.render.call(
                    this,
                    this.template,
                    function (tmp) {
                        if (!that.options.i18n) that.options.i18n = {};

                        app.getI18NJed(
                            that,
                            that.template,
                            function (i18nJED) {
                                that.options.i18n[that.template] = i18nJED;
                                that.$el.html(tmp());

                                that.applyBindings();


                                //rendering Navigation Buttons
                                that.NavigationButtonView.render(that.$el.find(".navigation-buttons"), null);

                                $.contextMenu('destroy');

                                //const write = true;
                                //if (write) {
                                //    $(function (obj) {
                                //        $.contextMenu({
                                //            selector: '.lab-real-time-grid-container',
                                //            callback: function (key, options) {
                                //                that.model.set({ contextMenuOption: key });
                                //                that.contextMenuOptionPressed();
                                //            },
                                //            items: {
                                //                "edit-row": {
                                //                    name: "Edit",
                                //                    icon: "fa-pencil",
                                //                },


                                //            },
                                //            events: {
                                //                hide: function (options) {
                                //                    that.pauseRealTime = false;
                                //                },
                                //                show: function () {
                                //                    that.pauseRealTime = true;
                                //                }
                                //            }
                                //        });
                                //    });

                                //}

                                //appending view to the main container
                                that.append(thatContainer, that.$el);


                                var fixedParams = _.extend({}, urlParams);
                                if (fixedParams && fixedParams.heatName && fixedParams.heatName.length === 7) {
                                    that.model.set(fixedParams);
                                } else {
                                    that.UpdateURL();
                                }
                                that.model.fetchCatalogs();

                                that.renderMultipicker();

                                that.refresh();
                            },
                            true,
                            customPath
                        );
                    },
                    customPath
                );
            },
            renderMultipicker: function () {
                var that = this;
                var heatNamesPicker = new VirtualSelect.init({
                    ele: '#heat-picker-multi-select',
                    options: that.model.get('heatNames'),
                    multiple: false,
                    search: true,
                    placeholder: 'Select Heat',
                    hasOptionDescription: false,
                    showSelectedOptionsFirst: true,
                    hideClearButton: true,
                    onServerSearch: that.onSampleSelectServerSearch,
                });
                var heat = that.model.get('heatName');
                document.querySelector('#heat-picker-multi-select').setOptions(that.model.get('heatNames'));
                document.querySelector('#heat-picker-multi-select').setValue(heat);
                document.querySelector('#heat-picker-multi-select').addEventListener('change', function () {
                    $('.vscomp-search-clear').click();
                    if (this.value === that.model.get('heatName')) {
                        return 0;
                    }
                    else {
                        var newHeatName = this.value;
                        if (newHeatName && newHeatName != '') {
                            that.model.set({
                                heatName: newHeatName
                            });
                            that.refresh();
                            that.UpdateURL();
                        }
                    }
                });

            },

            onSampleSelectServerSearch: function (searchValue, virtualSelect) {
                var qp = new Core.Database.QueryParameters();
                qp.Add('@HeatName', 'VARCHAR(10)', searchValue);
                qp.Add('@SelectedHeatName', 'VARCHAR(10)', this.selectedValues[0]);
                Core.Json.CallProcedure(
                    app.DatabaseNames.MES + '.LAB.GetAutocompleteHeats',
                    qp,
                    {
                        onSuccess: function (resp) {
                            try {
                                virtualSelect.setServerOptions(resp.Table);

                            }
                            catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
                        },
                        Secured: true,
                        Async: false,
                    },
                    app.ConnectionStrings.app
                );
            },

            UpdateURL: function () {
                try {
                    var params = this.model.toJSON();
                    app.router.navigate('!/lab-heat-report/' + (params.heatName ? params.heatName : ''), { trigger: false });
                }
                catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
            },

            getElementClass: function (value, min, max) {
                if (min === '-') min = null;
                if (max === '-') max = null;
                if (value === '-')
                    return 'string-cell align-center-cell no-editable';
                if (value === null)
                    return 'string-cell align-center-cell';
                if (!min && !max)
                    return 'string-cell align-center-cell ok';
                if (value != null && min && value < min)
                    return 'string-cell align-center-cell warning';
                if (value != null && max && value > max)
                    return 'string-cell align-center-cell danger';
                if (value != null && max && !min && value <= max)
                    return 'string-cell align-center-cell ok';
                if (value != null && min && !max && value >= min)
                    return 'string-cell align-center-cell ok';
                if (value != null && min && max && value >= min && value <= max)
                    return 'string-cell align-center-cell ok';


            },

            warningElementCodeValue: function (element, value) {
                var that = this,
                    min = null,
                    max = null;
                var limits = _.findWhere(that.model.limitsCompare, { Code: element });

                if (limits) {
                    min = limits.Min;
                    max = limits.Max;
                }
                if (value == '-') value = null;

                if (!value)
                    return 'string-cell align-center-cell';
                if (!min && !max)
                    return 'string-cell align-center-cell ok';
                if (value && min && value < min)
                    return 'string-cell align-center-cell warning';
                if (value && max && value > max)
                    return 'string-cell align-center-cell danger';
                if (value && max && !min && value <= max)
                    return 'string-cell align-center-cell ok';
                if (value && min && !max && value >= min)
                    return 'string-cell align-center-cell ok';
                if (value && min && max && value >= min && value <= max)
                    return 'string-cell align-center-cell ok';


            },

            refresh: function () {
                this.model.set({
                    hasData_process: false,
                    isLoading_process: true,
                })
                this.$el.find('.lab-real-time-grid-container').html('');
                this.model.fetch();

            },
            process_fetched: function () {
                try {
                    var that = this;
                    this.pauseTimer = false;
                    setTimeout(
                        function () {
                            that.model.set({
                                hasData_process: (that.model.labGridCollection.length > 0),
                                isLoading_process: false,
                            });

                        },
                        100
                    );

                }
                catch (e) { console.error((e.stack) ? e.stack : new Error(e).stack); }
            },

            refreshBtn_click: function (e) {
                this.refresh();
            },

            exportToExcel: function () {
                var that = this,
                    attrs = this.model.toJSON();

                that.setExportButtonExporting(true);
                var QP = new QueryParameters();
                const currentHeatName = attrs.heatName;
                const currentGrade = attrs.gradeName;
                const sheetName = currentGrade ? currentHeatName + ' - ' + currentGrade : currentHeatName;

                QP.Add('@HeatName', 'VARCHAR(10)', currentHeatName);
                QP.Add('@ExcelExport', 'BIT', true);



                var data = {
                    Data: [],
                    ConnectionStringName: 'APP',
                    ExportMethod: 3,
                    FileName: 'LAB-chemistries',
                    TemplateFileFullPath: 'generic.xls',
                    SQLDataSources: [
                        {
                            Name: 'data',
                            DatabaseParameters: {
                                DBEngine: 'SQLSERVER',
                                Procedure: app.DatabaseNames.MES + '.LAB.GetChemistrySamplesWithCalculatedByHeat',
                                QueryParameters: QP,
                            },
                        },
                    ]
                };


                /* -------------------------------------------------------- Table ------------------------------------------------------------ */
                letterArray = ['B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N'];
                var index = 0;
                var cellsData = [];
                var sqlCellsData = [];

                // Cells Data
                cellsData.push({ Column: 'A', Value: 'Code' });
                _.each(attrs.colNames, function (obj, i) {
                    cellsData.push({ Column: letterArray[i], Value: obj });
                    index = i;
                });
                cellsData.push({ Column: letterArray[index + 1], Value: 'Min' });
                cellsData.push({ Column: letterArray[index + 2], Value: 'Aim' });
                cellsData.push({ Column: letterArray[index + 3], Value: 'Max' });


                // SQL Cells Data
                sqlCellsData.push({ ExcelColumnName: 'A', SQLDataColumnName: 'Code', DataType: 'String' });
                _.each(attrs.colNames, function (obj, i) {
                    sqlCellsData.push({ ExcelColumnName: letterArray[i], SQLDataColumnName: obj, DataType: 'String' });
                    index = i;
                });
                sqlCellsData.push({ ExcelColumnName: letterArray[index + 1], SQLDataColumnName: 'Min', DataType: 'String' });
                sqlCellsData.push({ ExcelColumnName: letterArray[index + 2], SQLDataColumnName: 'Aim', DataType: 'String' });
                sqlCellsData.push({ ExcelColumnName: letterArray[index + 3], SQLDataColumnName: 'Max', DataType: 'String' });




                // set cellsData
                data.Data.push({
                    SheetName: sheetName,
                    RowsData: [{
                        CellsData: cellsData,

                    }],
                    StartRowIndex: 1,
                });


                // set SQLCellsData
                data.Data.push({
                    SheetName: sheetName,
                    RowsData: [],
                    StartRowIndex: 1,
                    DataSourceName: 'data',
                    DataSourceTableIndex: 0,
                    SQLCellsData: sqlCellsData,
                });

                Core.Export.Excel(
                    data,
                    function (resp) {
                        try {
                            if ((resp) && (resp.Success == true) && (resp.Data)) {
                                location.href = app.foldersRoot + '/excel/' + resp.Data;

                            }
                            else {
                                if ((resp) && (resp.Message))
                                    console.error(resp.Message);
                                else
                                    console.error('Server response not valid.');
                            }
                        }
                        catch (Error) { console.error(Error); }
                        that.setExportButtonExporting(false);
                    },
                    function (resp) {
                        that.model.refreshProcesses();
                        that.setExportButtonExporting(false);
                        console.error(resp);
                    }
                );
            },
            setExportButtonExporting: function (val) {
                var btn_export = this.$el.find('.btn-export-to-excel');
                var export_state = btn_export.find('.excel-export-state');
                var loading_state = btn_export.find('.loading-state');

                if (val) {
                    export_state.css('display', 'none', 'important');
                    loading_state.removeClass('hide');

                    btn_export.attr('disabled', true);
                } else {
                    loading_state.addClass('hide');
                    export_state.css('display', 'inline-block', 'important');

                    btn_export.attr('disabled', false);
                }
            },

            //Auto refresh
            _refresh: function (opt) {
                if (this.autoRefresh.toid != null) {
                    clearTimeout(this.autoRefresh.toid);
                    this.autoRefresh.toid = null;
                }
                if (!this.pauseTimer) this.refresh();

                if (this.autoRefresh.enabled == true) {
                    var that = this;

                    this.autoRefresh.toid = setTimeout(
                        function () { that._refresh(); },
                        this.autoRefresh.every
                    );
                }
            },
            startAutoRefresh: function () {
                try {
                    if (this.autoRefresh.enabled !== true) {
                        var that = this;

                        if (this.autoRefresh.toid != null) {
                            clearTimeout(this.autoRefresh.toid);
                            this.autoRefresh.toid = null;
                        }

                        this.autoRefresh.enabled = true;

                        //use a timeout to execute the first refresh to return the handle to the start function caller.
                        //So when the caller finish it will do the first refresh.
                        this.autoRefresh.toid = setTimeout(
                            function () { that._refresh(); },
                            1
                        );
                    }
                } catch (error) { console.error((error.stack) ? error.stack : new Error(error).stack); }
            },
            stopAutoRefresh: function () {
                if (this.autoRefresh.toid != null) {
                    clearTimeout(this.autoRefresh.toid);
                    this.autoRefresh.toid = null;
                }
                this.autoRefresh.enabled = false;
            },

            append: function (container, el) {
                el = (el != null && el != undefined) ? el : this.$el;

                if (this.options.state == app.view_states.loading
                    || this.options.state == app.view_states.shown) {
                    //appending view to the main container and set state to shown

                    this.options.state = app.view_states.shown;
                    container.append(el);

                    this.options.onappend(this);
                }

                if (this.options.state == app.view_states.hidden) {
                    //append and remain hidden
                    container.append(el);
                }

                if (this.options.state == app.view_states.closed) {
                    //return without appending.
                    return;
                }
            },
            bindViewScopedEvents: function () {
                var that = this;
            },
            unbindViewScopedEvents: function () {

            },
            close: function () {
                this.options.state = app.view_states.closed;

                this.stopAutoRefresh();
                this.closeSubviews();
                this.remove();
                this.unbindViewScopedEvents();
                this.unbind();
            },
            closeSubviews: function () {
                _.each(this.subviews, function (sview) {
                    sview.close();
                });
            },
            show: function () {
                this.options.state = app.view_states.shown;

                this.showSubviews();
                this.bindEvents();
                this.$el.show();
            },
            showSubviews: function () {
                _.each(this.subviews, function (sview) {
                    sview.show();
                });
            },
            hide: function () {
                this.options.state = app.view_states.hidden;

                this.hideSubviews();

                this.$el.hide();
                this.unbind();
                this.stopListening();
            },
            hideSubviews: function () {
                _.each(this.subviews, function (sview) {
                    sview.hide();
                });
            },
            preRender: function () {
                app.models.subnavbar.set("subnavbar", false);
            },
            reRender: function (urlParams) {
                try {
                    this.refresh(viewParams);
                } catch (Error) { }
            },

        });


        // Required, return the module for AMD compliance.
        return Screen;
    });

