<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/autocomplete/backbone.autocomplete.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/multiselect/virtual-select.min.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/select2/select2.min.css") %>" rel="stylesheet" />

<div class="row-fluid screen-content">
   
   
    <div class="span2 ">
        <div class="ladle-container">

        </div>
    </div>
     <div class="row-fluid"  data-bind="classes: { hide: any(not(hasData), isLoading), }" style="margin-bottom:20px;">
    <div class="span10">
    <table>
        <tr class="buttonRow">
            <td></td>
            <td class="sendtoEAF-label-column">
                <div>
                    <button id="sendtoFABtn" class="span2 btn btn-primary">EAF A</button>
                </div>
                <div>
                    <button id="sendtoFBBtn" class="span2 btn btn-primary">EAF B</button>
                </div>
                 <div>
                     <button id="sendToMaintenanceBtn" class="span4 btn btn-primary">Maintenance Box</button>
                 </div>

            </td>
            <td class="drain-label-column">
                <div>
                    <button id="drainBtn" class="span4 btn btn-primary">Drain</button>
                </div>
               
            </td>

              <td style="border:none;">
        <div class="ladle-campaign-container">
            <div class="ladle-campaign-title">Ladle Campaign</div>
            <div class="ladle-campaign-value" id="ladleCampaignValue"  data-bind="text: ladleCampaignValue">
            </div>
        </div>
    </td>
        </tr>
        <tr>
            <th class="label-column">Heat Number</th>
            <td>
                <div>
                    <input type="text" id="prevHeatName" name="HeatName" data-bind="value: prevHeatName, disabled:  true">
                </div>
            </td>
        </tr>
        <tr>
            <th class="label-column">Tap Time</th>
            <td>
                <div>
                    <input type="text" id="prevTapTime" name="TapTime" data-bind="value: prevTapTime, disabled:  true">
                </div>
            </td>
            <td>

            </td>
            <th class="label-column">Last Modified</th>
        </tr>
         <tr>
            <th class="label-column">Plate Assembly</th>
            <td>
                <div>
                    <button class="decrementBtn"><i class="fa fa-minus fa-2x"></i></button>
                    <input type="number" id="prevPlateAssembly" name="PlateAssembly" data-bind="value: prevPlateAssembly, disabled:  true">
                    <button class="incrementBtn"><i class="fa fa-plus fa-2x"></i></button>
                </div>
            </td>
             <td class="select-column">
                <div>
                    <button class="resetBtn">Reset</button>
                </div>
            </td>
             <td class="lastmod-column">
                 <div >
                    <input type="text" id="lmPlateAssembly"  name="PlateAssembly"  data-bind="value: lmPlateAssembly, disabled: true">
                 </div>
             </td>
        </tr>
        <tr>
            <th class="label-column">Upper Nozzle</th>
            <td>
                <div >
                    <button class="decrementBtn"><i class="fa fa-minus fa-2x"></i></button>
                    <input type="number" id="prevUpperNozzle" name="UpperNozzle" data-bind="value: prevUpperNozzle, disabled:  true">
                    <button class="incrementBtn"><i class="fa fa-plus fa-2x"></i></button>
                </div>
            </td>
            <td class="select-column">
                <div>
                    <button class="resetBtn">Reset</button>
                </div>
            </td>
            <td class="lastmod-column">
                 <div >
                    <input type="text" id="lmUpperNozzle"  name="UpperNozzle"  data-bind="value: lmUpperNozzle, disabled: true">
                 </div>
             </td>
        </tr>
        <tr>
            <th class="label-column">Working Lining</th>
            <td>
                <div >
                      <button class="decrementBtn"><i class="fa fa-minus fa-2x"></i></button>
                    <input type="number" id="prevWorkingLining" name="WorkingLining" data-bind="value: prevWorkingLining, disabled:  true">
                     <button class="incrementBtn"  data-bind="disabled: disableButtons"><i class="fa fa-plus fa-2x"></i></button>
                </div>
            </td>
            <td class="select-column">
                <div >
                    <button class="resetBtn">Reset</button>
                </div>
            </td>
            <td class="lastmod-column">
                 <div >
                    <input type="text" id="lmWorkingLining"  name="WorkingLining"  data-bind="value: lmWorkingLining, disabled: true">
                 </div>
             </td>
        </tr>
        <tr>
            <th class="label-column">PorousPlugNorth</th>
            <td>
                <div >
                    <button class="decrementBtn"><i class="fa fa-minus fa-2x"></i></button>
                    <input type="number" id="prevPorousPlugNorth" name="PorousPlugNorth" data-bind="value: prevPorousPlugNorth, disabled:  true">
                    <button class="incrementBtn"><i class="fa fa-plus fa-2x"></i></button>
                </div>
            </td>
            <td class="select-column">
                <div>
                    <button class="resetBtn">Reset</button>
                </div>
            </td>
            <td class="lastmod-column">
                 <div >
                     <input type="text" id="lmPorousPlugNorth"  name="PorousPlugNorth" data-bind="value: lmPorousPlugNorth, disabled: true">
                 </div>
             </td>
        </tr>
        <tr>
            <th class="label-column">PorousPlugSouth</th>
            <td>
                <div >
                    <button class="decrementBtn"><i class="fa fa-minus fa-2x"></i></button>
                    <input type="number" id="prevPorousPlugSouth" name="PorousPlugSouth" data-bind="value: prevPorousPlugSouth, disabled:  true">
                    <button class="incrementBtn"><i class="fa fa-plus fa-2x"></i></button>
                </div>
            </td>
            <td class="select-column">
                <div >
                    <button class="resetBtn">Reset</button>
                </div>
            </td>
            <td class="lastmod-column">
                 <div >
                    <input type="text" id="lmPorousPlugSouth"  name="PorousPlugSouth"  data-bind="value: lmPorousPlugSouth, disabled: true">
                     
                 </div>
             </td>
        </tr>
    </table>
    </div>

    </div>
 
     <div class="span10 no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
     <div class="row-fluid" style="position:relative;top:100px;">
         <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
     </div>
     <div class="row-fluid" style="position:relative;top:115px;">
         <h3 style="font-size:50px;">
             <asp:localize runat="server" meta:resourcekey="no_data_available" />
         </h3>
     </div>
 </div>
 <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
     <div class="row-fluid" style="position:relative;top:100px;">
         <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
     </div>
     <div class="row-fluid" style="position:relative;top:115px;">
         <h3 style="font-size:50px;">
             <asp:localize runat="server" meta:resourcekey="loading_data" />
         </h3>
     </div>
 </div>

    

</div>