﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(all(not(hasData), not(isLoading))), }," style="height:500px;">
    <div class="row-fluid" style="position:relative;top:100px;">
        <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
    </div>
    <div class="row-fluid" style="position:relative;top:115px;">
        <h3 style="font-size:50px;">
            <asp:localize runat="server" meta:resourcekey="no_data_available" />
        </h3>
    </div>
</div>

<div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }," style="height:500px;">
    <div class="row-fluid" style="position:relative;top:100px;">
        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
    </div>
    <div class="row-fluid" style="position:relative;top:115px;">
        <h3 style="font-size:50px;">
            <asp:localize runat="server" meta:resourcekey="loading_data" />
        </h3>
    </div>
</div>

<div class="row-fluid items-grid-container infinite-container" data-bind="classes: { hide: any(not(hasData), isLoading), },"></div>

<script id="actions_cell_template" type="text/x-handlebars-template">
    <div class="row-fluid">
        <div style="width:100%; text-align:center;">
            {{HBExp '#ifEquals isLoading true'}}
            <div class="popover-on-icon" style="float:left;margin-left:15px;height:31px;cursor:default;"><img style="width:30px;height:30px;" src="<%= ResolveUrl("~/assets/img/spinner22.gif")%>" /></div>
            {{HBExp 'else'}}
            <div class="btn-group">
                <!--<button type="button" class="configure-source-btn btn"></button>-->
                {{HBExp '#ifEquals optChangePosition true'}}
                <button class="configure-source-btn btn btn-dropdown-config-option" data-option="opt-change-position" style="font-size: 12px;">
                    <asp:Localize runat="server" meta:resourcekey="change_position_button_label" />
                </button>
                {{HBExp 'else'}}
                <button class="configure-source-btn btn btn-dropdown-config-option" data-option="opt-change-position-warning" style="font-size: 12px;">
                    <asp:Localize runat="server" meta:resourcekey="change_position_button_label" />
                </button>
                {{HBExp '/ifEquals'}}
                <button id="editDropdownMenu" class="configure-source-btn btn dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" data-open="false" style="font-size: 12px;">
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu" style="font-size: 12px;">
                    {{HBExp '#ifEquals optChangeWeights true'}}
                    <li style="cursor: pointer;">
                        <a class="btn-dropdown-config-option" data-option="opt-change-heat-weights">
                            <asp:Localize runat="server" meta:resourcekey="change_weights_button_label" />
                        </a>
                    </li>
                    {{HBExp 'else'}}
                    <li style="cursor: pointer;">
                        <a class="btn-dropdown-config-option" data-option="opt-change-heat-weights-warning">
                            <asp:Localize runat="server" meta:resourcekey="change_weights_button_label" />
                        </a>
                    </li>    
                    {{HBExp '/ifEquals'}}
                    {{HBExp '#ifEquals optAssignMeltOrder true'}}
                    <li style="cursor: pointer;">
                        <a class="btn-dropdown-config-option" data-option="opt-change-melt-order">
                            <asp:Localize runat="server" meta:resourcekey="change_melt_order_button_label" />
                        </a>
                    </li>
                    {{HBExp 'else'}}
                    <li style="cursor: pointer; pointer-events:none;opacity:0.6;">
                        <a class="btn-dropdown-config-option" data-option="opt-change-melt-order-warning">
                            <asp:Localize runat="server" meta:resourcekey="change_melt_order_button_label" />
                        </a>
                    </li>
                    {{HBExp '/ifEquals'}}
                    {{HBExp '#ifEquals optAssignHeat true'}}         
                    <li style="cursor: pointer; border-bottom: solid 1px #ddd;">
                        <a class="btn-dropdown-config-option" data-option="opt-assign-heat">
                            <asp:Localize runat="server" meta:resourcekey="assign_heat_button_label" />
                        </a>
                    </li>
                    {{HBExp 'else'}}
                    <li style="cursor: pointer; border-bottom: solid 1px #ddd;" >
                        <a class="btn-dropdown-config-option" data-option="opt-assign-heat-warning">
                            <asp:Localize runat="server" meta:resourcekey="assign_heat_button_label" />
                        </a>
                    </li>
                    {{HBExp '/ifEquals'}}
                    {{HBExp '#ifEquals optReturnLadle true'}}
                    <li style="cursor: pointer;">
                        <a class="btn-dropdown-config-option" data-option="opt-return-ladle">
                            <asp:Localize runat="server" meta:resourcekey="return_ladle_button_label" />
                        </a>
                    </li>
                    {{HBExp 'else'}}
                    <li style="cursor: pointer;">
                        <a class="btn-dropdown-config-option" data-option="opt-return-ladle-warning">
                            <asp:Localize runat="server" meta:resourcekey="return_ladle_button_label" />
                        </a>
                    </li>
                    {{HBExp '/ifEquals'}}
                    {{HBExp '#ifEquals optReladle true'}}
                    <li style="cursor: pointer;">
                        <a class="btn-dropdown-config-option" data-option="opt-reladle">
                            <asp:Localize runat="server" meta:resourcekey="reladle_button_label" />
                        </a>
                    </li>
                    {{HBExp 'else'}}
                    <li style="cursor: pointer;">
                        <a class="btn-dropdown-config-option" data-option="opt-reladle-warning">
                            <asp:Localize runat="server" meta:resourcekey="reladle_button_label" />
                        </a>
                    </li>
                    {{HBExp '/ifEquals'}}
                    {{HBExp '#ifEquals optSplitHeat true'}}
                    <li style="cursor: pointer; border-bottom: solid 1px #ddd;">
                        <a class="btn-dropdown-config-option" data-option="opt-split-heat">
                            <asp:Localize runat="server" meta:resourcekey="split_heat_button_label" />
                        </a>
                    </li>
                    {{HBExp '/ifEquals'}}
                    {{HBExp '#ifEquals optRemoveHeat true'}}
                    <li style="cursor: pointer;">
                        <a class="btn-dropdown-config-option" data-option="opt-remove-heat">
                            <asp:Localize runat="server" meta:resourcekey="remove_heat_button_label" />
                        </a>
                    </li>
                    {{HBExp '/ifEquals'}}
                    {{HBExp '#ifEquals optClearLadle true'}}
                    <li style="cursor: pointer;">
                        <a class="btn-dropdown-config-option" data-option="opt-clear-ladle">
                            <asp:Localize runat="server" meta:resourcekey="clear_ladle_button_label" />
                        </a>
                    </li>
                    {{HBExp '/ifEquals'}}
                    {{HBExp '#ifEquals optCreateHeat true'}}
                    <li style="cursor: pointer;">
                        <a class="btn-dropdown-config-option" data-option="opt-create-heat">
                            <asp:Localize runat="server" meta:resourcekey="create_heat_button_label" />
                        </a>
                    </li>
                    {{HBExp '/ifEquals'}}
                    {{HBExp '#ifEquals optFixLadle true'}}
                    <li style="cursor: pointer;">
                        <a class="btn-dropdown-config-option" data-option="opt-fix-ladle">
                            <asp:Localize runat="server" meta:resourcekey="fix_ladle_button_label" />
                        </a>
                    </li>
                    {{HBExp '/ifEquals'}}
                </ul>
            </div>
            {{HBExp '/ifEquals'}}
        </div>
    </div>
</script>




<script id="create_heat_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 data-bind="text: format('<asp:Localize runat=server meta:resourcekey=create_heat_modal_title />')"></h3>
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:300px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=heat_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline" data-bind="classes: { notValid: not(isValid), },">
                    <input type="text" style="width:186px;" data-bind="value: heat"/>
                </div>
                
            </div>
            <div data-bind="classes: { hide: isValid, },">
                <hr />
                <label style="color:red">
                    Warning: The Heat is not valid
                </label>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button id="acceptBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>



<script id="split_heat_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3>
            <asp:Localize runat=server meta:resourcekey=split_heat_modal_title />
        </h3>
    </div>
    <div style="max-height:400px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:350px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=heat_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: trim(heat), enabled: false,"/>
                </div>
            </div>
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=from_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: trim(position), enabled: false,"/>
                </div>
            </div>
            <div class="row-fluid" style="text-align:center; text-align:right;">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=from_ladle_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: trim(ladle), enabled: false,"/>
                </div>
            </div>
            <div class="row-fluid" style="text-align:center; text-align:right;">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=to_ladle_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <select style="width:80px;" data-bind="value: integer(toLadle), options: ladles, enabled: hasLadles,"></select>
                </div>
                <div style="margin-top:5px; padding-top:5px;" class="span1 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=weight_label />
                </div>
                <div style="margin-left:15px; margin-top: 5px; float:left;" class="control-group form-inline">
                     <input type="text" style="width:50px;" data-bind="value: trim(weight), enabled: true,"/>
                </div>
            </div>
             <div class="row-fluid" style="text-align:center; text-align:right;">
               
            </div>
            <div class="row-fluid" style="text-align:center; text-align:right;">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=comments_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                      <textarea style="resize: none; width:185px; height:90px;" data-bind="value: comments,"></textarea>
                </div>
            </div>
           
        </div>
    </div>
    <div class="modal-footer">
        <button id="acceptBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>

<script id="change_position_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 data-bind="text: format('<asp:Localize runat=server meta:resourcekey=change_position_modal_title />', ladle)"></h3>
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:300px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=heat_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: trim(heat), enabled: false,"/>
                </div>
            </div>
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=from_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: trim(position), enabled: false,"/>
                </div>
            </div>
            <div class="row-fluid" style="text-align:center; text-align:right;">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=to_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <select style="width:200px;" data-bind="value: integer(newPositionId), options: positions, enabled: hasPositions,"></select>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button id="acceptBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>

<script id="change_melt_order_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 data-bind="text: format('<asp:Localize runat=server meta:resourcekey=change_melt_order_modal_title />', heat)"></h3>
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <table>
                        <tr>
                            <td></td>
                            <td><b><asp:Localize runat=server meta:resourcekey=melt_order_label /></b></td>
                            <td><b><asp:Localize runat=server meta:resourcekey=grade_label /></b></td>
                            <td><b><asp:Localize runat=server meta:resourcekey=dim_label /></b></td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center;">
                                <b><asp:Localize runat=server meta:resourcekey=from_label /></b>
                            </td>
                            <td>
                                <input type="text" data-bind="value: curMeltOrder, enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                            <td>
                                <input type="text" data-bind="value: trim(curGrade), enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                            <td>
                                <input type="text" data-bind="value: trim(curDim), enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center;">
                                <b><asp:Localize runat=server meta:resourcekey=to_label /></b>
                            </td>
                            <td>
                                <select style="width:100px; text-align:center; text-align-last:center;" data-bind="value: newMeltOrder, options: meltOrders, enabled: hasMeltOrders,"></select>
                            </td>
                            <td>
                                <input type="text" data-bind="value: trim(newGrade), enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                            <td>
                                <input type="text" data-bind="value: trim(newDim), enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center; vertical-align:top; padding-top:6px;">
                                <b><asp:Localize runat=server meta:resourcekey=melt_order_sequence_label /></b>
                            </td>
                            <td colspan="3" style="text-align:left; padding:6px;">
                                <input id="inputMeltOrderSequence" type="text" data-bind="value: meltOrderSequence," style="width:100px; text-align:center;" />
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center; vertical-align:top; padding-top:6px;">
                                <b><asp:Localize runat=server meta:resourcekey=comments_label /></b>
                            </td>
                            <td colspan="3" style="text-align:left; padding:6px;">
                                <textarea style="resize: none; width:90%; height:100px;" data-bind="value: comments,"></textarea>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button id="changeMeltOrderSaveBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>

<script id="change_heat_weights_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 data-bind="text: format('<asp:Localize runat=server meta:resourcekey=change_heat_weights_modal_title />', heat)"></h3>
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <table class="span12">
                    <tr>
                        
                        <td><b><asp:Localize runat=server meta:resourcekey=net_label /></b></td>
                        <td><b><asp:Localize runat=server meta:resourcekey=tare_label /></b></td>
                        <td><b><asp:Localize runat=server meta:resourcekey=alloy_label /></b></td>
                    </tr>
                    <tr>
                        <td style="width:20%;">
                            <input type="text" data-bind="value: net," style="width:85%; text-align:center;" />
                        </td>
                        <td style="width:20%;">
                            <input type="text" data-bind="value: tare," style="width:85%; text-align:center;" />
                        </td>
                        <td style="width:20%;">
                            <input type="text" data-bind="value: alloy," style="width:85%; text-align:center;" disabled/>
                        </td>
                      
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button id="changeHeatWeightsSaveBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>

<script id="assign_heat_to_ladle_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 data-bind="text: format('<asp:Localize runat=server meta:resourcekey=assign_heat_to_ladle_modal_title />', ladle)"></h3>
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:300px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right; font-weight:bold;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=from_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" data-bind="value: heat, enabled: false," style="width:186px;" />
                </div>
            </div>
            <div class="row-fluid" style="text-align:center; text-align:right; font-weight:bold;">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=to_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <select style="width:200px;" data-bind="value: newHeat, options: heats, enabled: hasHeats,"></select>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button id="assignHeatToLadleSaveBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>

<script id="return_ladle_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 data-bind="text: format('<asp:Localize runat=server meta:resourcekey=return_ladle_modal_title />', ladle)"></h3>
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="span12 control-group form-inline">
                    <table style="width:100%;">
                        <tr>
                            <td style="width:20%;"></td>
                            <td><b><asp:Localize runat=server meta:resourcekey=heat_label /></b></td>
                            <td><b><asp:Localize runat=server meta:resourcekey=position_label /></b></td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center;">
                                <b><asp:Localize runat=server meta:resourcekey=from_label /></b>
                            </td>
                            <td>
                                <input type="text" data-bind="value: trim(heat), enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                            <td>
                                <input type="text" data-bind="value: trim(position), enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center;">
                                <b><asp:Localize runat=server meta:resourcekey=to_label /></b>
                            </td>
                            <td></td>
                            <td>
                                <select style="width:100px; text-align:center; text-align-last:center;" data-bind="value: newPosition, options: positions, enabled: hasPositions,"></select>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center; vertical-align:top; padding-top:6px;">
                                <b><asp:Localize runat=server meta:resourcekey=comments_label /></b>
                            </td>
                            <td colspan="2" style="text-align:left; padding:6px;">
                                <textarea style="resize: none; width:90%; height:100px;" data-bind="value: comments,"></textarea>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button id="returnLadleSaveBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>

<script id="reladle_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 data-bind="text: format('<asp:Localize runat=server meta:resourcekey=reladle_modal_title />', heat)"></h3>
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="span12 control-group form-inline">
                    <table style="width:100%;">
                        <tr>
                            <td style="width:20%;"></td>
                            <td><b><asp:Localize runat=server meta:resourcekey=position_label /></b></td>
                            <td><b><asp:Localize runat=server meta:resourcekey=ladle_label /></b></td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center;">
                                <b><asp:Localize runat=server meta:resourcekey=from_label /></b>
                            </td>
                            <td>
                                <input type="text" data-bind="value: position, enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                            <td>
                                <input type="text" data-bind="value: ladle, enabled: false," style="width:100px; text-align:center; border:none; box-shadow:none; -moz-box-shadow:none; -webkit-box-shadow:none; background:#fff;" />
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center;">
                                <b><asp:Localize runat=server meta:resourcekey=to_label /></b>
                            </td>
                            <td></td>
                            <td>
                                <select style="width:100px; text-align:center; text-align-last:center;" data-bind="value: newLadle, options: ladles, enabled: hasLadles,"></select>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-right:20px; text-align:center; vertical-align:top; padding-top:6px;">
                                <b><asp:Localize runat=server meta:resourcekey=comments_label /></b>
                            </td>
                            <td colspan="2" style="text-align:left; padding:6px;">
                                <textarea style="resize: none; width:90%; height:100px;" data-bind="value: comments,"></textarea>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button id="reladleSaveBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>




<script id="fix_ladle_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 data-bind="text: format('<asp:Localize runat=server meta:resourcekey=fix_ladle_modal_title />')"></h3>
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:300px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right; font-weight:bold;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=heat_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" data-bind="value: heat, enabled: false," style="width:186px;" />
                </div>
            </div>
            <div class="row-fluid" style="text-align:center;">
                <div style="margin-top:5px; padding-top:5px; text-align:right; font-weight:bold;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=ladle_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" data-bind="value: currentLadle, enabled: false," style="width:186px;" />
                </div>
            </div>
            <div class="row-fluid" style="text-align:center; text-align:right; font-weight:bold;">
                <div style="margin-top:5px; padding-top:5px;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=new_ladle_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <select style="width:200px;" data-bind="value: newLadle, options: ladles, enabled: hasLadles,"></select>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button id="fixLadleSaveBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_btn_label /></button>
    </div>
</script>