USE [IHBoxSystem]
GO
CREATE ROLE lmfheatreport_readWrite AUTHORIZATION dbo 
GO  

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'lmfheatreport_readWrite', 'admin'
GO

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'lmfheatreport_readWrite', 'SDI/australtek'
GO

USE [IHBoxSystem]
GO
CREATE ROLE lmfheatreport_read AUTHORIZATION dbo 
GO  

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'lmfheatreport_read', 'SDI/australtek'
GO

USE [IHBoxSystem]
GO
EXEC sp_addrolemember 'lmfheatreport_read', 'admin'
GO



EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [lmfheatreport_readWrite] -- The role
,@name = N'securedsp-LF.GetProcess' -- the procedure
,@value = N'' 

Go

--EXECUTE sys.sp_addextendedproperty 
--@level0type = N'USER' -- The object type
--,@level0name = [lmfheatreport_readWrite] -- The role
--,@name = N'securedsp-LF.GetProcessCatalogs' -- the procedure  -- DELETE THIS SP from DB
--,@value = N'' 

--Go

declare @parent int, @result_routeId INT
select @parent=id from [FrontEnd].[Menu] where name='LMF'

INSERT INTO [FrontEnd].[Routes]
		   ([Route]
		   ,[ModuleName]
		   ,[ModulePath]
		   ,[RequiredRole]
	   )
	 VALUES
		   (
		   '!/lmf-heat-report(/:heatName)(/:treatmentNumber)(/)'
		   , 'lmf-heat-report'
		   , 'custom-screens/lmf-heat-report/'
		   , 'lmfheatreport_read'           
		   )
		   SET @result_routeId = @@IDENTITY
INSERT INTO [FrontEnd].[Menu]
		   ([Parent]
		   ,[Name]
		   ,[RouteID]
		   ,[SortOrder]
		   ,[Enabled]
		   ,[Visible]
		   ,[RequiredRole]
		   ,[Group]
		  )
	 VALUES
		   (
		   @parent
		   ,'LMF Heat Report'
		   ,@result_routeId 
		   ,3
		   ,1
		   ,1
		   ,'lmfheatreport_read'
		   ,NULL
		 )
GO


UPDATE FrontEnd.[Routes]
	SET [Route] = '!/lmf-heat-report(/:heatName)(/:treatmentNumber)(/)'
 WHERE Id = (  SELECT TOP 1 Id FROM FrontEnd.[Routes] WHERE ModuleName = 'lmf-heat-report')

/*------------------------------------------------------Profiles------------------------------------------------------*/
USE [IHBoxSystem]
GO

DECLARE @ModuleId INT

INSERT INTO [SECURITY].[Modules]
		   ([Code]
		   ,[Name])
	 VALUES
		   ('lmf_heat_report'
		   ,'LMF Heat Report')

		  SET @ModuleId = @@IDENTITY

INSERT INTO [SECURITY].[ModuleActions]
		   ([ModuleId]
		   ,[Code]
		   ,[Name]
		   ,[Role])
	 VALUES
		   (@ModuleId
		   ,'readWrite'
		   ,'Read/Write'
		   ,'lmfheatreport_readWrite')


		   
	INSERT INTO [SECURITY].ModuleActions(ModuleId,Code,[Name],[Role])
	VALUES (@ModuleId,'read','Read','lmfheatreport_read')
GO

/*-----------------------------------------------------26-09-2022---------------------------------------------------------------------------*/
/*-----------------------------------------------------26-09-2022---------------------------------------------------------------------------*/
/*-----------------------------------------------------26-09-2022---------------------------------------------------------------------------*/
/*-----------------------------------------------------26-09-2022---------------------------------------------------------------------------*/
/*-----------------------------------------------------26-09-2022---------------------------------------------------------------------------*/
EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [lmfheatreport_readWrite] -- The role
,@name = N'securedsp-MES.GetAutocompleteHeats' -- the procedure
,@value = N'' 


EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [lmfheatreport_readWrite] -- The role
,@name = N'securedsp-MES.GetNavigatedHeat' -- the procedure
,@value = N'' 


EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [lmfheatreport_readWrite] -- The role
,@name = N'securedsp-LF.GetHeatReport' -- the procedure
,@value = N'' 









EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [lmfheatreport_read] -- The role
,@name = N'securedsp-MES.GetNavigatedHeat' -- the procedure
,@value = N'' 



EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [lmfheatreport_read] -- The role
,@name = N'securedsp-MES.GetAutocompleteHeats' -- the procedure
,@value = N'' 


EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [lmfheatreport_read] -- The role
,@name = N'securedsp-LF.GetHeatReport' -- the procedure
,@value = N'' 




















USE [MES]
GO
/****** Object:  StoredProcedure [MES].[GetAutocompleteHeats]    Script Date: 27/9/2022 07:42:18 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

ALTER PROCEDURE [MES].[GetAutocompleteHeats]
 	@heatName VARCHAR(10) = NULL
	,@treatment INT = NULL
	,@SelectedHeatName VARCHAR(7) = NULL
	,@SelectedTreatment INT = NULL
	,@Asset CHAR(3) = 'LMF'
AS
BEGIN
	-----------------------
	-- Common procedures variables
	-----------------------
	DECLARE 
		--Start of the message to be printed at the end of the procedure.
		@finishEndMSG VARCHAR(300),
		--The name of the procedure with its schema.
		@procName VARCHAR(300)

	SET @procName = OBJECT_SCHEMA_NAME(@@PROCID) + '.' + OBJECT_NAME(@@PROCID)
	
	SET @finishEndMSG =  @procName + ' finished.'

	PRINT @procName + ' Parameters:'
		+ ', @heatName: ' + ISNULL(CAST(@heatName AS VARCHAR), '')

		
	DECLARE @SearchTextString VARCHAR(100)

	SET @searchTextString = '%' + @heatName + '%'

	declare @heatNames table ([value] varchar(9), [label] varchar(9),[Datetime] datetime, [processId] int,[treatment] int)
	
	declare @filterHeats table ([value] varchar(9), [label] varchar(9),[processId] int)
	-----------------------
	-- Begin Query
	-----------------------
	if (@Asset = 'LMF')
	begin		
		insert into @heatNames
		select top 20 
			cast(h.[Name] as varchar(7)) + '-' +  cast(l.Treatment as varchar(1)),
			cast(h.[Name] as varchar(7)) + '-' +  cast(l.Treatment as varchar(1)),
			l.[Start],
			l.Id,
			l.Treatment
		from mes.heats h
		left join lf.Processes l on l.HeatId = h.Id
		where 
		@heatName is null 
		or (
			h.[Name] like @searchTextString 
		)
		and l.HeatId is not null	
		order by l.[Start] desc		
		
	end


	if (@heatName is not null and @treatment is not null)	
		insert into @filterHeats
		select [value],[label],[processId] from @heatNames where treatment = @treatment order by [Datetime] desc
	else if (@heatName is null)  	-- When the page is first opened, we need to get the last process
		insert into @filterHeats
		select top 1 [value],[label],[processId] from @heatNames order by [Datetime] desc	
	else -- When the user searches by heat, we need to show the last 20 heats 
		insert into @filterHeats
		select [value],[label],[processId] from @heatNames order by [Datetime] desc


	-- If the pikcer has a selected heat is needed to add this to the list
	if (@SelectedHeatName is not null)
	begin
		declare @selectedHeatId int = (select top 1 Id from mes.heats where [Name] = @SelectedHeatName)
		insert into @filterHeats
		values(
			 @SelectedHeatName  + '-' + cast(@SelectedTreatment as varchar(1))
			, @SelectedHeatName + '-' + cast(@SelectedTreatment as varchar(1))
			,(select top 1 Id from lf.Processes where Treatment = @SelectedTreatment and HeatId = @selectedHeatId)
		)
	end
	
	select distinct([value]),[label],[processId] from @filterHeats
	-----------------------
	-- Finish procedure
	-----------------------
	PRINT @finishEndMSG

	RETURN 0
END


GO



USE [MES]
GO
/****** Object:  StoredProcedure [LF].[GetProcess]    Script Date: 26/9/2022 15:17:44 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [LF].[GetHeatReport]
	@heatName varchar(7) = 'A217802',
	@treatment int = 1,
	@timeZoneCode CHAR(10) = NULL
AS
BEGIN
	-----------------------
	-- Common procedures variables
	-----------------------
	DECLARE 
		--Start of the message to be printed at the end of the procedure.
		@finishEndMSG VARCHAR(300),
		--The name of the procedure with its schema.
		@procName VARCHAR(300)

	SET @procName = OBJECT_SCHEMA_NAME(@@PROCID) + '.' + OBJECT_NAME(@@PROCID)
	
	SET @finishEndMSG =  @procName + ' finished.'

	PRINT @procName + ' Parameters:'
		+ ', @timeZoneCode: ' + ISNULL(CAST(@timeZoneCode AS VARCHAR), '')	
		+ ', @treatment: ' + ISNULL(CAST(@treatment AS VARCHAR), '')	
		+ ', @heatName: ' + ISNULL(CAST(@heatName AS VARCHAR), '')	

	-----------------------
	-- Variables
	-----------------------
	DECLARE @heatId INT,
			@processId INT,
			@start DATETIME,
			@startProcess DATETIME,
			
			@endProcess DATETIME,
			@startFirstHeating DATETIME,
			@endLastHeating DATETIME

	-----------------------
	-- Validation
	-----------------------
	IF (@timeZoneCode IS NULL)
		SET @timeZoneCode = 'EDTIND'

	-----------------------
	-- Begin Query
	-----------------------
	select @heatId = Id from mes.Heats where [Name] = @heatName
	select @processId = Id from lf.Processes where Treatment = @treatment and HeatId = @heatId

	
		SELECT
			@startProcess = p.[Start],
			@endProcess = p.[End],
			@startFirstHeating = (SELECT TOP 1 h.[Start] FROM lf.Heatings h where ProcessId = @processId  and h.[Start] between p.[Start] and p.[End] ORDER BY h.[Start] ASC),
			 @endLastHeating = (SELECT TOP 1 h.[End] FROM lf.Heatings h where ProcessId = @processId and h.[End] between p.[Start] and p.[End]	  ORDER BY h.[Start] DESC)
		FROM MES.Heats hs
		LEFT JOIN LF.Processes p on p.HeatId = hs.Id
		WHERE p.Id = @processId 
			

		-----------------------
		-- Process
		-----------------------
		SELECT 
			process.*,
			StartLocal = IH.ToLocal(process.[Start], @timeZoneCode),
			ArriveTimestampLocal = IH.ToLocal(process.[ArriveTimestamp], @timeZoneCode),
			EndLocal = IH.ToLocal(process.[End], @timeZoneCode),
			HeatName = heat.[Name],
			SteelWeight = cast (heat.SteelWeight as decimal(18,2)),
			GradeName = grade.[Name],
			InitGradeName = NULL,
			LadleFurnaceName = ladleFurnace.[Name],
			LadleName = ladle.[Name],
			OperatorName = operator.[Name]
			, TreatmentCurrentAndTotal = cast(Treatment as varchar) + '/'  + cast((select max(z.Treatment) from lf.Processes z where z.HeatId = heat.Id) as varchar)
			
			,MeltOrder = mo.MeltOrderNumber
			,PreparationTime =	DATEDIFF(SS,@startProcess,@startFirstHeating) 
			,HeatingTime =		DATEDIFF(SS,@startFirstHeating,@endLastHeating) 
			,LastStage =		DATEDIFF(SS,@endLastHeating,@endProcess)  -- maybe endheat is null
			,TotalTreatmentTime =	DATEDIFF(SS,@startProcess,@endProcess)  -- maybe endheat is null
			,PowerOff = ABS(DATEDIFF(SS,@startProcess,@endProcess) - process.PowerOn)
		FROM LF.Processes process
		LEFT JOIN MES.Heats heat ON heat.Id = process.HeatId
		LEFT JOIN CAT.Grades grade ON grade.Id = heat.GradeId
		LEFT JOIN CAT.LadleFurnaces ladleFurnace ON ladleFurnace.Code = process.LadleFurnaceCode
		LEFT JOIN CAT.Ladles ladle ON ladle.Id = heat.LadleId
		LEFT JOIN CAT.Operators operator ON operator.Id = process.OperatorId
		left join MES.MeltOrders mo on heat.MeltOrderId = mo.id
		WHERE process.Id = @processId 
	
		-----------------------
		-- Probes
		-----------------------
		SELECT * FROM (
				SELECT
				[Datetime] = IH.ToLocal([Datetime],@timeZoneCode),
				[Value]= cast([Value] as decimal(8,2)),
				[ProbeType]
				FROM LF.Probes t
				left join lf.Processes p on t.ProcessId = p.Id 
				WHERE ProcessId = @processId and t.[Datetime] between p.[Start] and p.[End]
		) ProbesResult
		PIVOT (
			MAX([Value])
			FOR [ProbeType]
			IN (
			[O],
			[T],
			[C]
			)
		) AS PivotTable
		-----------------------
		-- Heatings
		-----------------------
		SELECT
			h.Id,
			h.ProcessId,
			[Start] = IH.ToLocal(h.[Start],@timeZoneCode),
			[End] = IH.ToLocal(h.[End],@timeZoneCode),
			[Duration] = DATEDIFF(SECOND, h.[Start],h.[End]),
			h.[Tap],
			h.[Energy]	
		FROM LF.Heatings h
		LEFT JOIN LF.Processes p on p.Id = h.ProcessId
		WHERE ProcessId = @processId
		and h.[Start] between p.[Start] and p.[End]
		-----------------------
		-- Alloys
		-----------------------
		SELECT
			a.ID,
			a.ProcessID,
			a.SourceCode,
			BatchStart = IH.ToLocal(BatchStart,@timeZoneCode),
			BatchEnd =   IH.ToLocal(BatchEnd,@timeZoneCode),
			DumpStart = IH.ToLocal(DumpStart,@timeZoneCode),
			DumpEnd =   IH.ToLocal(DumpEnd,@timeZoneCode)

		FROM LF.AdditionBatches a
		left join lf.Processes p on p.Id = a.ProcessID
		WHERE ProcessId = @processId 
		and a.DumpStart between p.[Start] and p.[End]
		ORDER BY BatchStart ASC

		SELECT 
			ID = ab.ID,
			AdditionBatchID = ab.AdditionBatchID,
			WeightSP = cast(ab.WeightSP as int),
			WeightPV = cast(ab.WeightPV as int),
			MaterialName = mat.[Name],
			Parameter1 = ab.Parameter1
		FROM LF.AdditionBatchDetails ab
		LEFT JOIN CAT.Materials mat on mat.Id = ab.MaterialId
		WHERE AdditionBatchID IN(
								SELECT a.ID 
								FROM LF.AdditionBatches a
								left join lf.Processes p on p.Id = a.ProcessID
								WHERE ProcessID = @processId 
								
								and a.DumpStart between p.[Start] and p.[End]
							 )
		AND mat.[Name] is not null
		ORDER BY ab.AdditionBatchID ASC


		----------------------
		-- Phases
		----------------------
		select
			ProcessDuration =DATEDIFF(SS,@startProcess,@endProcess)   -- TotalTreatmentTime
			,Duration = DATEDIFF(SS,@startProcess,@startFirstHeating) -- PreparationTime
			,FormattedDuration = CONVERT(varchar, DATEADD(ms, DATEDIFF(SS,@startProcess,@startFirstHeating)* 1000, 0), 108)				
			,[Order] = 1
			,[Code]= 'Preparation Time'
			,[Percentage] = (DATEDIFF(SS,@startProcess,@startFirstHeating) * 100.0 / DATEDIFF(SS,@startProcess,@endProcess))-2

			union all

		select
			ProcessDuration =DATEDIFF(SS,@startProcess,@endProcess)   -- TotalTreatmentTime
			,Duration = DATEDIFF(SS,@startFirstHeating,@endLastHeating)  -- HeatingTime
			,FormattedDuration = CONVERT(varchar, DATEADD(ms, DATEDIFF(SS,@startFirstHeating,@endLastHeating)* 1000, 0), 108)					
			,[Order] = 2			
			,[Code]= 'Heating Time'
			,[Percentage] = (DATEDIFF(SS,@startFirstHeating,@endLastHeating) * 100.0 / DATEDIFF(SS,@startProcess,@endProcess)) - 2 

			union all

		select
			ProcessDuration =DATEDIFF(SS,@startProcess,@endProcess) -- TotalTreatmentTime
			,Duration = DATEDIFF(SS,@endLastHeating,@endProcess)	-- LastStage
			,FormattedDuration =  CONVERT(varchar, DATEADD(ms, DATEDIFF(SS,@endLastHeating,@endProcess)* 1000, 0), 108)	
			,[Order] = 3			
			,[Code]= 'Last Stage'
			,[Percentage] = (DATEDIFF(SS,@endLastHeating,@endProcess) * 100.0 / DATEDIFF(SS,@startProcess,@endProcess)) + 4

		-----------------------
		-- Navigate Buttons
		-----------------------
		select top 5 [Text]= 'EAF', Treatment = null, HeatName = h.[Name], HeatId = h.Id 
		from EAF.Processes p 
		left join mes.Heats h on h.Id = p.HeatId
		where p.HeatId = @heatId

		union all
		
		select top 5 [Text]= 'VTD', Treatment = p.Treatment, HeatName = h.[Name], HeatId = h.Id
		from VTD.Processes p 
		left join mes.Heats h on h.Id = p.HeatId
		where p.HeatId = @heatId

		union all
		
		select top 1 [Text]= 'LAB', Treatment = null, HeatName = h.[Name], HeatId = h.Id
		from LAB.ChemistrySamplesWithCalculated l 
		left join mes.Heats h on h.Id = l.HeatId
		where l.HeatId = @heatId

		union all
		
		select top 5 [Text]= 'SLAG EAF', Treatment = null, HeatName = h.[Name], HeatId = h.Id
		from LAB.SlagChemistrySamples l
		left join mes.Heats h on h.Id = l.HeatId
		where l.HeatId = @heatId



	-----------------------
	-- Chart 
	-----------------------

		EXEC [LF].[GetChartData] @id  = @processId
	-----------------------
	-- Finish procedure
	-----------------------
	PRINT @finishEndMSG

	RETURN 0
END


GO



USE [MES]
GO
/****** Object:  StoredProcedure [MES].[GetNavigatedHeat]    Script Date: 27/9/2022 07:24:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

ALTER PROCEDURE [MES].[GetNavigatedHeat]
	@heatName VARCHAR(10),
	@treatment INT,
	@direction SMALLINT,
	@Asset CHAR(3) = 'LMF'
AS
BEGIN
	-----------------------
	-- Common procedures variables
	-----------------------
	DECLARE 
		--Start of the message to be printed at the end of the procedure.
		@finishEndMSG VARCHAR(300),
		--The name of the procedure with its schema.
		@procName VARCHAR(300)

	SET @procName = OBJECT_SCHEMA_NAME(@@PROCID) + '.' + OBJECT_NAME(@@PROCID)
	
	SET @finishEndMSG =  @procName + ' finished.'

	PRINT @procName + ' Parameters:'
		+ ', @heatName: ' + ISNULL(CAST(@heatName AS VARCHAR), '')
		+ ', @direction: ' + ISNULL(CAST(@direction AS VARCHAR), '')


	-----------------------
	-- Navigation Variables
	-----------------------
	declare @heatId int = (select Id from MES.Heats where [Name] = @heatName)
	declare @EAFProcessStart datetime = (select [Start] from EAF.Processes where HeatId = @heatId)
	declare @LMFProcessStart datetime = (select [Start] from LF.Processes where HeatId = @heatId and Treatment = @treatment)
	
	declare @newHeatName VARCHAR(10) = @heatName
	declare @newTreatment INT = 1
	---------------------------------------------------
	------------------- BEGIN QUERY -------------------
	---------------------------------------------------	
	IF (@Asset = 'EAF' or @Asset = 'LAB')
	BEGIN
		if (@direction = 1 and @EAFProcessStart is not null)
			select top 1 
				@newHeatName = isNULL(h.[Name],@heatName) 
			from eaf.Processes p
			left join mes.heats h on h.Id = p.HeatId
			where p.[Start] > @EAFProcessStart order by p.[Start] asc

		if (@direction = -1 and @EAFProcessStart is not null)
			select top 1 
				@newHeatName = isNULL(h.[Name],@heatName) 
			from eaf.Processes p
			left join mes.heats h on h.Id = p.HeatId
			where p.[Start] < @EAFProcessStart order by p.[Start] desc

		-- Result:
		select [HeatName] = cast(@newHeatName as varchar(7))

		return
	END		


	IF (@Asset = 'LMF')
	BEGIN
		if (@direction = 1 and @LMFProcessStart is not null)
			select top 1 
				@newHeatName = isNULL(h.[Name],@heatName) 
				,@newTreatment = p.Treatment
			from lf.Processes p
			left join mes.heats h on h.Id = p.HeatId
			where p.[Start] > @LMFProcessStart order by p.[Start] asc

		if (@direction = -1 and @LMFProcessStart is not null)
			select top 1 
				@newHeatName = isNULL(h.[Name],@heatName) 
				,@newTreatment = p.Treatment
			from lf.Processes p
			left join mes.heats h on h.Id = p.HeatId
			where p.[Start] < @LMFProcessStart order by p.[Start] desc

		-- Result:
		select 
			[HeatName] = cast(@newHeatName as varchar(7))
			,[Treatment] = @newTreatment

		return
	END		





	----------------------
	-- Finish procedure
	-----------------------
	PRINT @finishEndMSG

	RETURN 0
END

GO
















create table MES.Audit(
	Id int identity(1,1) primary key
	, HeatId int
	, HeatName varchar(10)
	, Station varchar(10)
	, [Type] char(2)
	, [Timestamp] datetime
	, [User] varchar(100)
	, [Description] varchar(max))


	use ihboxsystem
	go

	EXECUTE sys.sp_addextendedproperty 
		@level0type = N'USER' -- The object type
		,@level0name = [lmfheatreport_readWrite] -- The role
		,@name = N'securedsp-LF.MoveAddition' -- the procedure
		,@value = N'SendCurrentUser=TRUE' 
		GO


		
	EXECUTE sys.sp_addextendedproperty 
		@level0type = N'USER' -- The object type
		,@level0name = [lmfheatreport_readWrite] -- The role
		,@name = N'securedsp-LF.UpdateAdditionManually' -- the procedure
		,@value = N'SendCurrentUser=TRUE' 
		GO




		
		
	EXECUTE sys.sp_addextendedproperty 
		@level0type = N'USER' -- The object type
		,@level0name = [lmfheatreport_readWrite] -- The role
		,@name = N'securedsp-LF.InsertAdditionManually' -- the procedure
		,@value = N'SendCurrentUser=TRUE' 
		GO


		

		
		
	EXECUTE sys.sp_addextendedproperty 
		@level0type = N'USER' -- The object type
		,@level0name = [lmfheatreport_readWrite] -- The role
		,@name = N'securedsp-LF.RemoveAdditionManually' -- the procedure
		,@value = N'SendCurrentUser=TRUE' 
		GO


-------------------------------------------------------
----------------- 25/02/2023 --------------------------
-------------------------------------------------------

	--- replace this code in [LF].[GetHeatReport]
		-----------------------
		-- Probes
		-----------------------
		declare @eafProcessId int = (select top 1 Id from EAF.Processes where HeatId = @heatId)

		select 
			[Source] = 'EAF',
			[Datetime] = IH.ToLocal([Timestamp],null),
			[O] = Oxygen,
			[T] = Temperature,
			[C] = Carbon
		from EAF.Temperatures  where ProcessId = @eafProcessId
		union all
		SELECT * FROM (
				SELECT
				[Source] = 'LMF',
				[Datetime] = IH.ToLocal([Datetime],@timeZoneCode),
				[Value]= cast([Value] as decimal(8,2)),
				[ProbeType]
				FROM LF.Probes t
				left join lf.Processes p on t.ProcessId = p.Id 
				WHERE ProcessId = @processId --and t.[Datetime] between p.[Start] and p.[End]
		) ProbesResult
		PIVOT (
			MAX([Value])
			FOR [ProbeType]
			IN (
			[O],
			[T],
			[C]
			)
		) AS PivotTable
		order by [Source], [Datetime]