﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>



<script id="main_template" type="text/x-handlebars-template"> 

    <link href="<%= ResolveUrl("~/assets/libs/js/modules/OEE/jquery-timepicker/jquery.timepicker.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />    

    <style>
        .clickeable-row{
            cursor:pointer; 
        }

        .backgrid th{
            font-size:12px !important;
        }

        .backgrid tr{
            font-size:12px !important;
        }

        .backgrid tr td{
            overflow:visible !important; 
        }

        .backgrid tr td button{
            font-size:12px !important;
        }

        .backgrid td {
            width:150px !important; 
        }

        .toolbar-filter {
            display:inline-block;
        }
    </style>

    <div class="container-fluid">
        <div class="span12">
            <div class="row-fluid">
                <div style="margin-top:7%;" class="row-fluid loading-poster text-center">
                    <div style="width:40%; margin: 0 auto;" class="progress progress-striped active">
                        <div class="bar" style="width: 100%;"></div>
                    </div>
                </div>
                <div class="batch-schedule-grid-container infinite-container hide">
                </div>
            </div>
        </div>    
    </div>

    <script id="actions_cell_template" type="text/x-handlebars-template">
        <div>
            {{HBExp '#ifEquals mode "EDIT"'}}
                <button data-toggle="tooltip" data-placement="bottom" data-cell-action="SAVECHANGES" title="<asp:Localize runat=server meta:resourcekey=save_changes_title />" class="btn btn-cell-action btn-small btn-save-changes"><i class="fa fa-floppy-o"></i></button>
                <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DISCARDCHANGES" title="<asp:Localize runat=server meta:resourcekey=discard_changes_title />" class="btn btn-cell-action btn-small btn-discard-changes"><i class="fa fa-times"></i></button>
            {{HBExp '/ifEquals'}}
            
            {{HBExp '#ifEquals mode "NEW"'}}
                <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DELETE" title="<asp:Localize runat=server meta:resourcekey=remove_batch_title />" class="btn btn-cell-action btn-small btn-remove"><i class="fa fa-trash-o"></i></button>
            {{HBExp '/ifEquals'}}

            {{HBExp '#ifEquals mode "CLOSED"'}}
                <a href="{{HBExp 'batch_oee_href'}}" data-toggle="tooltip" data-placement="bottom" data-cell-action="GOTOBATCHOVERVIEW" title="<asp:Localize runat=server meta:resourcekey=go_to_batch_overview_title />" class="btn btn-cell-action btn-small btn-go-to-batch-overview"><i class="fa fa-area-chart"></i></a>
            {{HBExp '/ifEquals'}}
        </div>
    </script>

</script>

<script id="subnavbar_controls" type="text/x-handlebars-template">
    <div class="span6">
        <div class="batch-schedule-subnavbar-toolbar">
            <div style="display:inline-block;" class="batch-schedule-subnavbar-button">
                <button class="btn add-batch"><asp:Localize runat="server" meta:resourcekey="add_batch_btn_label" /></button>
            </div>
        </div>
    </div>
    <div class="span6">
        <div class="batch-schedule-subnavbar-right-toolbar">
            <div style="display:inline-block;height:40px;" class="pull-right">
                <div class="toolbar-filter">
                    <label style="display:inline-block;margin-left:10px;line-height:40px;"><asp:Localize runat="server" meta:resourcekey="line_label" /></label>
                    <select style="margin-left:10px;top:3px;position:relative;" data-bind="value: integer(lineProductionItemId), options: lines, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_lines_label />', value: -1 }" id="selectbasic" name="selectbasic" class="input-medium">
                    </select>
                </div>
                <div style="margin-left:20px;display:inline-block;">
                    <div class="toolbar-filter">
                        <label class="checkbox inline" style="display:inline-block;margin-left:10px;margin-right:10px;position:relative;top:-2px;">
                            <input data-bind="checked: newBatches" type="checkbox" name="checkboxes" id="checkboxes-0">
                            <span><asp:Localize runat="server" meta:resourcekey="new_status_label" /></span>
                        </label>
                    </div>
                    <div class="toolbar-filter">
                        <label class="checkbox inline" style="display:inline-block;margin-left:10px;margin-right:10px;position:relative;top:-2px;">
                            <input data-bind="checked: openBatches" type="checkbox" name="checkboxes" id="checkbox1">
                            <span><asp:Localize runat="server" meta:resourcekey="open_status_label" /></span>
                        </label>
                    </div>
                    <div class="toolbar-filter">
                        <label class="checkbox inline" style="display:inline-block;margin-left:10px;margin-right:10px;position:relative;top:-2px;">
                            <input data-bind="checked: closedBatches" type="checkbox" name="checkboxes" id="checkbox2">
                            <span><asp:Localize runat="server" meta:resourcekey="closed_status_label" /></span>
                        </label>
                    </div>
                </div>
            </div>
        </div>        
    </div>
</script>

<script id="batch_schedule_modal_loading" type="text/x-handlebars-template">
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="delay_information_title" /></h3>
    </div>
    <div style="max-height:450px;min-height:350px;" class="modal-body noselect">
        <div class="row-fluid">
            <div class="span12">
                <div style="text-align:center;margin-top:10px;">
                    <i class="fa fa-5x fa-cog fa-spin"></i><br />
                    <span style="font-size: 20px;top:3px;position:relative;"><asp:Localize runat="server" meta:resourcekey="loading_label" /></span>
                </div>
            </div>
        </div>
    </div>
</script>