﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/modules/elt/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

<div class="row-fluid subnavbar fixed-subnavbar">
    <div class="row-fluid form-inline">
        <%--<label class="control-label" for="dateEndTbx">
            <asp:localize runat="server" meta:resourcekey="date_label" />
        </label>
        <label class="input-prepend">
            <span class="add-on"><i class="icon-calendar"></i></span>
            <input type="text" id="dateEndTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(date$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
        </label>--%>
        <label class="control-label" for="selectType"><asp:Localize runat="server" meta:resourcekey="types" /></label>
        <select style="width:200px" data-bind="value: integer(equipmentTypeId), options: equipmentTypes, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=combo_all_option />', value: 0 }" id="selectType" class="subnavbar-select" name="selectType">
        </select>
        <label class="control-label" for="searchTbx">
            <asp:localize runat="server" meta:resourcekey="equipment_picker_label" />
        </label>
        <div class="input-prepend input-append ">
            <input type="text" id="searchTbx" style="width:300px;" data-bind="value: trim(equipmentName), events: ['change', 'keydown',]" placeholder="<asp:Localize runat=server meta:resourcekey=equipment_picker_place_holder />" data-select-on-focus/>
            <label class="btn btn-search-show" id="showSearchItemsBtn" for="searchTbx"><i class="fa fa-caret-down"></i></label>
        </div>
        <label class="control-label" for="selectAlarm"><asp:Localize runat="server" meta:resourcekey="alarms_label" /></label>
        <select style="width:100px" data-bind="value: integer(alarmTypeId), options: alarms, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=combo_all_option />', value: 0 }" id="selectAlarm" class="subnavbar-select" name="selectAlarm">
        </select>
        <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;margin-left: 10px;">
            <input type="checkbox" data-bind="checked: includeChildrens" />
            <span>
                <asp:Localize runat="server" meta:resourcekey="include_childrens_label" />
            </span>
        </label>
        <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;margin-left: 10px;">
            <input type="checkbox" data-bind="checked: showAbsolutes" />
            <span>
                <asp:Localize runat="server" meta:resourcekey="show_absolutes_label" />
            </span>
        </label>
        <button id="refreshBtn" class="btn btn-primary" style="margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
            <i class="fa fa-refresh"></i>
        </button>
        
        
    </div>
    
</div>
<div class="row-fluid screen-content">
    <div class="equipment-counters-report-grid-container infinite-container" style="margin-top:20px"></div>
</div>
