﻿define([
  // Application.
  "app",

  //templates-loader
  "js/templates-loader"

],

function (app, T) {

    var Settings = { Model: {}, Views: {} }

    Settings.Model = Backbone.Model.extend({
        defaults: {}
    });

    Settings.Views.Main = Backbone.View.extend({
        template: "settings/settings"
        , id: "user-settings"
        , title: "Settings"
        //default not cacheable, change this if you want the view to be cacheable
        // if the view is set as cacheable should also have a refresh method to reset the view without erasing the DOM.
        //refreshing only the data, maybe?
        , isCacheable: false
        , initialize: function () {
        },
        events: {
            "click #save_btn": "saveChanges",
            "click #cancel_btn": "cancelChanges"
        }, 
        // global view variable (seen in this scope, public to the view, and SHARED BETWEEN OTHER INSTANCES OF THE SAME VIEW)
        // containing all the variables for this view

        //properties that you wanna scope as private variables for each instance of a view should not be placed here
        //the only way i found to maintain the variables between instances of the same view, is either using models,
        // (each view will have its own model so data is not shared between them), or in case you don't want to use a model
        // you can use the Backbone.View.options object, and doing something like
        // this.options.attributes = {}
        // and storing every single variable inside attributes.

        render: function (container) {

            var that = this;
            var thatContainer = container;
            T.render.call(this, this.template, function (tmp) {

                //start: before the view is visible, but the template was already loaded (not instanced nor appended)

                //end:

                //loading the view and appeding it to the views's $el.
                that.$el.html(tmp({userModel_username: app.models.user.get("username")}));

                //start: the view was already loaded an is on a div element, but not appended to the main container
                //here you can perform anything you want DOM related, by getting the dom element via that.$el.find("#id")

                Core.Include({
                    Widgets: []
                    , Events: {
                        onLoad: function () {

                            var b = new DropDownSelect({
                                "Picker1": {
                                    Elem: that.$el.find("#userLanguage_select").get(0)
                                    , DatabaseType: "VARCHAR"
                                    , Events: {
                                        onChange: function () {
                                            console.log("changed the one on the left");
                                        }
                                    }
                                }       
                                , 
                                "Picker2": {
                                    Elem: that.$el.find("#picker2").get(0)
                                    , DatabaseType: "INT"
                                    , Events: {
                                        onChange: [function () {
                                            console.log("changed the one on the center");
                                        }]
                                    }
                                }
                                ,
                                "Picker3": {
                                    Elem: that.$el.find("#picker3").get(0)
                                    , Events: {
                                        onChange: [function () {
                                            console.log("changed the one on the right"); 
                                        }]
                                    }
                                }
                                //,
                                //"Picker4": {
                                //    Elem: that.$el.find("#picker2").get(0)
                                //}
                            }, {
                                DatabaseParameters: {
                                    Procedure: "dbo.GetLanguageSelectOptions"
                                    , ConnectionStringName: app.ConnectionStrings.app
                                }
                                , Events: {
                                    onComplete: _pepeCompleted
                                    , onChange: [_valueChanged]
                                }
                            });

                            b.RefreshData();

                            function _pepeCompleted() {
                                //console.log("Complete!"); 
                            }

                            function _valueChanged() {
                                //console.log(JSON.stringify(b.GetValues())); 
                            }

                        }
                    }
                    , ExternalWidgets: [
                        { Name: 'DropDownSelect', URL: '/IndustrialDashboard/Widgets/DropDownSelect/', JS: ['DropDownSelect.js'], CSS: [], Order: 51 }
                    ]
                }); 

                //var lang = app.models.user.get("preferredLanguage"); 
                //that.$el.find("#userLanguage_select").val(lang); 

                //:end

                //appending view to the main container
                thatContainer.append(that.$el);

            });
        }
        , close: function () {
            this.remove();
            this.unbind();
        }
        , show: function () {
            this.$el.show();
        }
        , hide: function () {
            this.$el.hide();
        }

        , saveChanges: function () {

        }


        , cancelChanges: function () {

        }

    });

    // Required, return the module for AMD compliance.
    return Settings;

});
