﻿/// <reference path="http://localhost/IndustrialDashboard/Scripts/IndustrialDashboard-debug.js" />

//VIEW-BOILERPLATE
//This view is prepared to be used inside the "modules" folder. This view is easier to include via the define call
//using define([ "modules/viewjsnamewithoutjsextension"]); 

//This boilerplate is usually used to create app components views such as pickers, menus, and everything that's not a screen.

define([
  // Application variable, always include it to have access to app methods.
  "app",

  //templates-loader: this loads templates async.
  "js/templates-loader"

],

function (app, T) {

    //replace all ViewName for the name of your view.
    var ViewName = { Model: {}, Views: {} }

    //you can create more than one model, default model is called Model.
    ViewName.Model = Backbone.Model.extend({
        defaults: {}
    });

    //you can create more than one view, default view is called Main.
    ViewName.Views.Main = Backbone.View.extend({
        template: "viewTemplateFolder/viewTemplateName"
        , id: "view-id"
        , title: "View Title"
        //default is not cacheable, change this if you want the view to be cacheable
        //if the view is set as cacheable it should also have a reRender method to reset the view without erasing the DOM.
        //refreshing only the data, maybe?

        , isCacheable: false
        , initialize: function () {
            //you can use:
            //this.options.viewParameters; contains the URL parameters, if any.
        },
        // global view variable (seen in this scope, public to the view, and SHARED BETWEEN OTHER INSTANCES OF THE SAME VIEW)
        // containing all the variables for this view (eg. isCacheable is a global view variable and its shared between other
        // instances of the same view.

        //properties that you wanna scope as private variables for each instance of a view should not be placed here
        //the only way to maintain the variables between instances of the same view, is either using models,
        // (each view will have its own model so data is not shared between them), or in case you don't want to use a model
        // you can use the Backbone.View.options object, and doing something like
        // this.options.attributes = {}
        // and storing every single variable inside attributes.

        //render the view when it's not cached (first time or if the view is not cacheable); 
        //arguments [0] container, [1] viewParams from URL
        render: function (container, viewParams) {
            var that = this;
            var thatContainer = container;
            //calling the template-loader passing the correct "this" object.
            T.render.call(this, this.template, function (tmp) {
                //getInternationalizationData
                if (!that.options.i18n) that.options.i18n = {};
                //calling app method to get the translation for this view
                //the translation should be a resx file stored inside the template folder (inside a LocalResourcesFolder).
                app.getI18NJed(that, that.template, function (i18nJED) {
                    //storing internationalization data
                    that.options.i18n[that.template] = i18nJED;

                    //start: before the view is visible, but the template was already loaded (not instanced nor appended)

                    //end:

                    //loading the view and appeding it to the views's $el.
                    that.$el.html(tmp());

                    //start: the view was already loaded an is on a div element, but not appended to the main container
                    //here you can perform anything you want DOM related, by getting the dom element via that.$el.find("#id")

                    //:end

                    //appending view to the main container
                    thatContainer.append(that.$el);

                });
            });
        }

        //called to close a view, this removes the current $el element attached to the DOM and also unbinds
        //all the events that are attached to this view.
        , close: function () {
            this.remove();
            this.unbind();
        }

        //this shows the $el, simply sets display:block; using jquery.
        , show: function () {
            this.$el.show();
        }

        //this hides the $el, simply sets display:none; using jquery. IMPORTANT: no "unbind" is called, so methods
        //or listeners that this view has (if any) will be called if they are triggered by someone else.
        , hide: function () {
            this.$el.hide();
        }

        //reRender: usually called when navigating a page with back/forward buttons and the view is cacheable.
        , reRender: function (viewParams) {
            //reRender is called when the route changes, the view routed is not the current view (see refresh for this case)
            //and the view is cached.
            //if the view is not cached, the render method will be executed instead of reRender
            //if you want render to be the only method executed then set "isCacheable" to false; 

            //here you could also call the refresh method if you are using stuff from the URL.
        }

        , refresh: function (viewParams) {
            //refresh is called when the route changes but the view that the route instances is the same
            //one that is already being shown. 
            //here you can do some stuff like working with parameters.
            //suggestion. the render method should only contain those methods that "draw" stuff. those which refresh elements
            //based on the URL parameters should be here. Then you can call from the render method to the refresh method.
            
            //IMPORTANT: if your view is listening to models and some parts of the view are changing according to the model, then
            //do not repeat that behaviour here. (This would only happen if the model also rewrites parameters on the URL and fires
            //a routing when going back in the history or manually); 

        }
    });

    // Required, return the module for AMD compliance.
    return ViewName;

});
