﻿//SCREEN-BOILERPLATE

//this boilerplate builds screens that are gonna be shown in the <div class="content"> tag of our main HTML.
//do not build app components with this boilerplate, only screens (reports)

define([
  // Application variable, always include it to have access to app methods.
  "app",

  //templates-loader: this loads templates async.
  "js/templates-loader",

  "modules/modal"

],

function (app, T, Modal) {

    //replace all "ViewName" with your view's name.
    var ViewName = { Model: {}, Views: {} }

    ViewName.Model = Backbone.Model.extend({
        defaults: {
            procedure: ''
        }
    });

    //the generate id method is called everytime a view is going to be shown by the router and returns and id that
    //is used by the router to store in cache (if it is cacheable) and to know the current shown view.
    //this is useful in case your view is reusable, and displays different data depending on url parameters 
    //(such as a catalog view, or a report that doesnt change in terms of UI but it does change in terms of data)
    //so you can always use the same view on the router but the cache can tell which view is which by using differents ids.
    ViewName.generateID = function (viewParams) {
        try {
            //if the viewparams change the view id, then evaluate the viewparams here
            //and return the appropiate id.
            return "screen-boilerplate"; 
        } catch (Error) { }
    }

    ViewName.Views.Main = Backbone.View.extend({
        template: "screen-boilerplate"
        , id: "screen-boilerplate"
        , title: "Screen Boilerplate"
        //default not cacheable, change this if you want the view to be cacheable
        // if the view is set as cacheable should also have a refresh method to reset the view without erasing the DOM.
        , isCacheable: true
        , initialize: function () {
            if (this.options.viewParams) {
            }

            var model = new ViewName.Model({
                procedure: "dbo.procedureName"
            });

            this.model = model;

            this.bindEvents();
            _.bindAll(this);
        },

        events: {
            "click #getstarted_btn": "showGetStartedModal"
        }, 

        render: function (container) {
            var that = this;
            var thatContainer = container;
            this.options.MYREFERENCES = {};

            //the screens have a custompath, so it has to be specified in the customPath variable that is
            //then sent to the template loader.
            var customPath = "/app/screens/screen-boilerplate/";

            T.render.call(this, this.template, function (tmp) {

                //start: before the view is visible, but the template was already loaded (not instanced nor appended)

                //end:

                //loading the view and appeding it to the views's $el.
                that.$el.html(tmp());

                //start: the view was already loaded an is on a div element, but not appended to the main container
                //here you can perform anything you want DOM related, by getting the dom element via that.$el.find("#id")
                //or this.$("#id")


                //end

                //appending view to the main container
                thatContainer.append(that.$el);

            }, customPath);
        }

        , showGetStartedModal: function () {
            try {

                var html = $("#getstarted_modal_template").html();

                var modal = new Modal.Views.Main({
                    id: "getstarted-modal"
                    , content: html
                    , title: "Getting started: "
                    , allowCancel: true
                    , buttons_type: "OK"
                });

                modal.show();

            } catch (Error) {
            }
        }

        , refresh: function () {
            try {
                
            } catch (Error) { }
        }

        , bindEvents: function () {
            //this function should be in every view that uses listenTo anywhere
            //all the model bindings or view-model binding should be here, to manage
            //the show/hide view easily
        }

        , close: function () {
            this.remove();
            this.unbind();
        }

        , show: function () {
            this.bindEvents();
            this.$el.show();
        }

        , hide: function () {
            this.$el.hide();
            this.unbind();
            this.stopListening();
        }

        , preRender: function () {
            app.models.subnavbar.set("dateControl", false);
        }

        , reRender: function () {
        }
    });

    // Required, return the module for AMD compliance.
    return ViewName;

});
