﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<script id="assign_cover" type="text/x-handlebars-template">
<link href="<%= ResolveUrl("~/app/templates/modal-assign-cover/modal-assign-cover.css")%>" rel="stylesheet" />
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4>
            <span style="font-weight: bold;">Assing Cover To Heat</span>
        </h4>
    </div>
    <div class="modal-body">
        <div class="row-fluid firstMainRow">
                <div class="row-fluid">
                    <div id="heatNumberDiv" class="form-group span5">
                        <label for="heatNumber">Heat Number</label>
                        <input disabled type="text" class="form-control" data-bind="value: HeatNumber">
                    </div>
                    <div class="span2"></div>
                    <div id="coversSelectDiv" class="form-group span5">
                        <label for="covers">Available Covers</label>
                       <select data-bind="value: coverId, options: covers"></select> 

                    </div>
                </div>
            
        </div>
    </div>
    <div class="modal-footer">
        <button id="acceptBtn" class="btn btn-primary">
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>

        <button id="cancelBtn" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>
    </div>
</script>
