﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<style type="text/css">

    .sections-span-4-4-4 {
        /*This divides the span12 navbar in 4 span4*/
    }

        .sections-span-4-4-4 > .sections:not(.span4){
            display:none;            
        }

        .sections-span-4-4-4 > .sections:not(.span4) + div{
            margin-left:0; 
        }
    
    .sections-span-6-6 {
        /*This divides the span12 navbar in 2 span6*/
    }
        .sections-span-6-6 > .sections:not(.span6){
            display:none; 
        }

        .sections-span-6-6 > .sections:not(.span6) + div{
            margin-left:0; 
        }

    .sections-span-12 {
    /*This keeps the span12*/
    }
        .sections-span-12 > .sections:not(.span12){
            display:none; 
        }

        .sections-span-12 > .sections:not(.span12) + div{
            margin-left:0; 
        }

</style>

<div class="navbar">
    <div class="row-fluid" id="subnavbar-inner" style="height:59px; border:0px; border-bottom:1px solid #ccc;background:#fff;display:table;">
        <div class="container-fluid" style="display:table-cell; vertical-align:middle;">
            <div id="sections_container" class="row-fluid sections-span-4-4-4">
                <div id="section1span6" class="sections span6">
                    <div id="dateTimeScopeControlView_holder"></div>
                    <div class="custom_holder"></div>
                </div>
                <div id="section2span6" class="sections span6">
                    <div class="custom_holder"></div>
                </div>
                <div id="section1span12" class="sections span12">
                    <div class="custom_holder"></div>
                </div>
                <div id="section1span4" class="sections span4">
                    <div id="dateControlView_holder"></div>
                    <div class="custom_holder"></div>
                </div>
                <div id="section2span4" class="sections span4">
                    <div class="custom_holder"></div>
                </div>
                <div id="section3span4" class="sections span4">
                    <div id="notificationBarView_holder"></div>
                    <div class="custom_holder"></div>
                </div>
            </div>
        </div>
    </div>
</div>