define([
    'jquery',
    'assets/libs/jam/bootstrap-amd/src/typeahead',
    'js/jquery.scrollIntoView/jquery.scrollIntoView',
], function (jQuery) {
    //Extend bootstrap-typeahead.js v2.3.2
     

    !function ($) {

        "use strict"; // jshint ;_;


        /* TYPEAHEAD PUBLIC CLASS DEFINITION
         * ================================= */
        var TypeaheadExtended = function (element, options) {
            this.supperClass.constructor.apply(this, arguments);
        };
        var supperProto = $.fn.typeahead.Constructor.prototype;

        TypeaheadExtended.prototype = _.extend(
            {},
            supperProto,
            {
                supperClass: supperProto,
                constructor: TypeaheadExtended,
                keyup: function (e) {
                    switch (e.keyCode) {
                        case 16: // shift
                        case 17: // ctrl
                        case 18: // alt
                            break

                        case 9: // tab
                        case 13: // enter
                            if (!this.shown) return
                            this.select()
                            break

                        case 27: // escape
                            if (!this.shown) return
                            this.hide()
                            break

                        case 38: // up arrow
                        case 40: // down arrow
                            if (this.shown) return
                            this.lookup();
                            break;
                        default:
                            this.lookup()
                    }

                    e.stopPropagation()
                    e.preventDefault()
                },
                lookup: function (event) {
                    var items

                    this.query = this.$element.val()

                    if (this.query.length < this.options.minLength) {
                        return this.shown ? this.hide() : this
                    }

                    items = $.isFunction(this.source) ? this.source(this.query, $.proxy(this.process, this)) : this.source

                    return items ? this.process(items) : this
                },
                next: function (event) {
                    var active = this.$menu.find('.active').removeClass('active')
                      , next = active.next()

                    if (!next.length) {
                        next = $(this.$menu.find('li')[0])
                    }

                    next.addClass('active')

                    next.scrollIntoView(false);
                },
                prev: function (event) {
                    var active = this.$menu.find('.active').removeClass('active')
                      , prev = active.prev()

                    if (!prev.length) {
                        prev = this.$menu.find('li').last()
                    }

                    prev.addClass('active')

                    prev.scrollIntoView(false);
                },
                select: function () {
                    var val = this.$menu.find('.active').attr('data-value')
                    this.$element
                      .val(this.updater(val))
                      .focus()
                      .select()
                      .change()
                    return this.hide()
                }
            }
        );


        /* TYPEAHEAD PLUGIN DEFINITION
         * =========================== */

        var old = $.fn.typeaheadExtended;

        $.fn.typeaheadExtended = function (option) {
            return this.each(function () {
                var $this = $(this)
                  , data = $this.data('typeahead-extended')
                  , options = typeof option == 'object' && option;
                if (!data) $this.data('typeahead-extended', (data = new TypeaheadExtended(this, options)));
                if (typeof option == 'string') data[option]();
            });
        };

        $.fn.typeaheadExtended.Constructor = TypeaheadExtended;


        /* TYPEAHEAD NO CONFLICT
         * =================== */

        $.fn.typeaheadExtended.noConflict = function () {
            $.fn.typeaheadExtended = old;
            return this;
        };


        /* TYPEAHEAD DATA-API
         * ================== */

        $(document).on('focus.typeahead-extended.data-api', '[data-provide="typeahead-extended"]', function (e) {
            var $this = $(this);
            if ($this.data('typeahead-extended')) return;
            $this.typeaheadExtended($this.data());
        });

    }(jQuery);

});