﻿/// <reference path="../../assets/libs/jam/jquery/dist/jquery.js" />
/// <reference path="http://localhost/IHBOX/IndustrialDashboard/Scripts/IndustrialDashboard-debug.js" />
require(["app-config"], function (app_config) {
    $().ready(function () {
        $(".user-sign-up-form input, select").not("[type=submit]").jqBootstrapValidation();
        //ajax call to create a new account
        $(".user-sign-up-form").submit(function (e) {
            e.preventDefault();

            if ($(".user-sign-up-form").jqBootstrapValidation("hasErrors")) {
                return; 
            }

            $(".btn-createaccount").css("display", "none");
            $(".sign-up-spinner").css("display", "block"); 

            var data_qp = {
                "name": { Name: "Name", Type: "VARCHAR" },
                "lastname": { Name: "LastName", Type: "VARCHAR" },
                "email": { Name: "Email", Type: "VARCHAR" },
                "country": { Name: "Country", Type: "VARCHAR" },
                "password": { Name: "Password", Type: "VARCHAR" },
            }; 

            var formdata = $(".user-sign-up-form").serializeArray();
            var datadict = {}; 

            for (var i = 0; i < formdata.length; i++)
                datadict[formdata[i].name] = formdata[i].value; 

            var QP = new Core.Database.QueryParameters(); 
            for (var i = 0; i < formdata.length; i++) {
                if (data_qp[formdata[i].name]) {
                    QP.Add(data_qp[formdata[i].name].Name, data_qp[formdata[i].name].Type, formdata[i].value); 
                }
            }

            Core.Json.CallProcedure("FrontEnd.CreateAccount", QP, {
                onSuccess: function (data) {
                    if (data && data.Table && data.Table[0].Status == 1) {
                        $.ajax({
                            url: "../api/signup.aspx",
                            type: 'POST',
                            data: { name: datadict.name, lastname: datadict.lastname, email: datadict.email, country: datadict.country, userid: data.Table[0].UserID },
                            dataType: "json",
                            success: function () {
                                swal({
                                    title: "La cuenta ha sido creada, por favor verifique su dirección de email.",
                                    text: "Se ha enviado un mensaje de verificación a " + datadict.email + " con instrucciones para verificar su cuenta.",
                                    type: "success",
                                    confirmButtonText: "OK",
                                    allowOutsideClick: false,
                                }, function () {
                                    window.location.replace("../login/login.aspx");
                                });
                            },
                            error: function () {
                            }
                        }); 
                    } else {
                        swal({
                            title: "Oops! Algo ha salido mal!",
                            text: "Hubo un error al intentar crear la cuenta, por favor intente nuevamente.",
                            type: "error",
                            confirmButtonText: "OK",
                            allowOutsideClick: false,
                        });
                        $(".btn-createaccount").css("display", "block");
                        $(".sign-up-spinner").css("display", "none");
                    }
                },
                onFailure: function () {
                    swal({
                        title: "Oops! Algo ha salido mal!",
                        text: "Hubo un error al intentar crear la cuenta, por favor intente nuevamente.",
                        type: "error",
                        confirmButtonText: "OK",
                        allowOutsideClick: false,
                    });
                    $(".btn-createaccount").css("display", "block"); 
                    $(".sign-up-spinner").css("display", "none");
                },
                Secured: true, 
            }
            ,app_config.ConnectionStrings.app);
        });

    });
}); 