﻿using Helpers.Log;
using log4net;
using System;
using System.Diagnostics;
using System.Reflection;
using System.Web.Script.Serialization;
using System.Web.UI;

public partial class app_custom_screens_IHConfiguration_system_network_configuration_api_network_configuration : Page
{
    private JavaScriptSerializer jss = new JavaScriptSerializer();
    private ILog logger = Logger.GetLogger(MethodBase.GetCurrentMethod().DeclaringType.Name);

    protected void Page_Load(object sender, EventArgs e)
    {
        object response = null;

        try
        {
            string action = Request.Form["action"];

            if (action != null)
            {
                switch (action.ToString().ToUpper())
                {
                    case "GET_NETWORK_STATUS":
                        response = this.GetNetworkStatus();
                        break;
                    case "GET_NETWORK_INFO":
                        response = this.GetNetworkConfiguration();
                        break;
                    case "CONFIGURE_NETWORK":
                        response = this.ConfigureNetworkInterface();
                        break;
                    case "CONNECT_TO_ACCESSPOINT":
                        response = this.ConnectToAccessPoint();
                        break;
                    case "DISCONNECT_WIFI":
                        response = this.DisconnectWifi();
                        break;
                    default:
                        response = new Response
                        {
                            Success = false,
                            Message = string.Format("Action '{0} is not supported'.", action),
                        };
                        break;
                }
            }
            else
            {
                response = new Response
                {
                    Success = false,
                    Message = "Parameter 'Action' can not be empty or null.",
                };
            }
        }
        catch (Exception ex)
        {
            response = new Response
            {
                Success = false,
                Message = ex.Message,
            };

            this.logger.Error(ex);
        }


        Response.Clear();
        Response.ContentType = "application/json; charset=utf-8";
        Response.Write(jss.Serialize(response));
        Response.End();
    }

    private Response ConfigureNetworkInterface()
    {
        NetworkInterfaceInfo nic = jss.Deserialize<NetworkInterfaceInfo>(Request.Form["config"]);
        nic.Name = this.GetNicName(nic.Name); 

        Response response = IhBoxSystemtConfiguration.ConfigureNetworkInterface(nic);
        response.Data = IhBoxSystemtConfiguration.GetNetworkConfiguration(nic.Name);

        //restarting IHBox server to apply changes if the user is making changes on the wifi network card.
        if (nic.Name.Equals(IhBoxSystemtConfiguration.NETWORK_TYPE_WIFI, StringComparison.OrdinalIgnoreCase) == true)
        {
            ProcessStartInfo startInfo = new ProcessStartInfo(@"C:\Windows\System32\shutdown.exe", "/r /f /t 2");
            Process.Start(startInfo);
        }

        return response;
    }
    private Response ConnectToAccessPoint()
    {
        return IhBoxSystemtConfiguration.ConnectToAccessPoint(Request.Form["ap_name"], null, Request.Form["ap_password"]);
    }
    private Response DisconnectWifi()
    {
        return IhBoxSystemtConfiguration.DisconnectWifi();
    }
    private Response GetNetworkStatus()
    {
        //String nicName = this.GetNicName(Request.Form["name"]); 
        return new Response
        {
            Data = IhBoxSystemtConfiguration.GetNetworkStatus(Request.Form["name"]),
        };
    }
    private Response GetNetworkConfiguration()
    {
        String nicName = this.GetNicName(Request.Form["name"]); 
        return new Response
        {
            Data = IhBoxSystemtConfiguration.GetNetworkConfiguration(nicName),
        };
    }
    private String GetNicName(String type)
    {
        String nicName = IhBoxSystemtConfiguration.NETWORK_ETHERNET_NIC_NAME;
        switch (type.ToUpper())
        {
            case IhBoxSystemtConfiguration.NETWORK_TYPE_ETHERNET:
                nicName = IhBoxSystemtConfiguration.NETWORK_ETHERNET_NIC_NAME;
                break;
            case IhBoxSystemtConfiguration.NETWORK_TYPE_WIFI:
                nicName = IhBoxSystemtConfiguration.NETWORK_WIFI_NIC_NAME;
                break;
        }

        return nicName; 
    }
}