﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>



<script id="main_template" type="text/x-handlebars-template">
    <style>
        .loading-poster.connecting span[data-name="disconnectingLegend"] {
            display:none;
        }
        .loading-poster.disconnecting span[data-name="connectingLegend"] {
            display:none;
        }
        .connect-to-wifi .control-label {
            text-align: left;
        }

        .form-horizontal .control-group {
            margin-bottom: 10px;
        }

        .form-horizontal .control-label {
            width: 100px;
        }

        .form-horizontal .controls {
            margin-left: 0;
        }

        legend + .control-group {
            margin-top: 0px;
        }

        .network-configure-form .input-controls {
            float: right;
        }
        .network-configure-form .control-label {
            width: 160px;
            text-align: left;
        }
        .network-configure-form .second-radio-container {
            margin-top: 5px;
        }
        .network-configure-form .control-disabled {
            color: #A9A2A2;
        }
        .network-configure-form .control-disabled input {
            color: #A9A2A2;
        }
        .network-configure-form input[type="radio"] {
            margin-top: 0;
        }

        .nav-tabs > li > a:hover, .nav-tabs > li > a:focus {
            background-color: transparent;
            border: 1px solid #eeeeee;
            text-decoration: none;
        }

        .nav-tabs > .active > a, .nav-tabs > .active > a:hover, .nav-tabs > .active > a:focus {
            color: #555555;
            border-color: #ddd #ddd #ffffff #ddd;
            background-color: #ffffff;
            cursor: default;
        }

        .nav-tabs > li > a {
            background-color: transparent;
            border: transparent;
        }
    </style>

    <div class="container-fluid">
        <ul style="cursor:pointer;" class="nav nav-tabs configuration-tabs">
            <li>
                <a data-tab-id="ethernet" data-toggle="tab">
                    <asp:localize runat="server" meta:resourcekey="tab_title_ethernet" />
                </a>
            </li>
            <li>
                <a data-tab-id="wifi" data-toggle="tab">
                    <asp:localize runat="server" meta:resourcekey="tab_title_wifi" />
                </a>
            </li>
        </ul>

        <div class="tab-content">
            <div class="tab-pane" data-tab-id="wifi">
                <div class="row-fluid">
                    <div id="wifi_status_container" style="float:left;width:35%;"></div>
                    <div id="wifi_config_container" style="float:left;width:60%;margin-left:5%;"></div>
                </div>
            </div>

            <div class="tab-pane" data-tab-id="ethernet">
                <div class="row-fluid">
                    <div id="ethernet_status_container" style="float:left;width:35%;"></div>
                    <div id="ethernet_config_container" style="float:left;width:60%;margin-left:5%;"></div>
                </div>
            </div>
        </div>

    </div>
</script>

<script id="wifi_status_template" type="text/x-handlebars-template">
    <legend>
        <asp:localize runat="server" meta:resourcekey="status_view_wifi_title" />
    </legend>

    <div class="main-section control-group">
        {{#addPartial "connected"}}
        <div style="margin-bottom:10px;" class="wifi-information row-fluid">
            <div class="control-group">
                <div class="controls">
                    <span>
                        <asp:localize runat="server" meta:resourcekey="status_view_current_ssid_label" />
                    </span>
                    <strong>{{currentSSID}}</strong>
                </div>
            </div>
            <div class="control-group">
                <div class="controls">
                    <button id="disconnect_btn" name="singlebutton" class="btn btn-primary">
                        <asp:localize runat="server" meta:resourcekey="status_view_wifi_disconnect_btn" />
                    </button>
                </div>
            </div>
        </div>
        {{/addPartial}}

        {{#addPartial "notConnected"}}
        <form class="form-horizontal connect-to-wifi">
            <!-- Select Basic -->
            <div class="control-group">
                <label class="control-label" for="selectbasic">
                    <asp:localize runat="server" meta:resourcekey="status_view_wifi_combo_label" />
                </label>
                <div class="controls">
                    <select id="ap_name" name="currentSSID" class="input-medium">                        
                        <option>
                            <asp:localize runat="server" meta:resourcekey="status_view_wifi_combo_default_opt" />
                        </option>
                        {{#each detectedSSIDs}}
                        <option value="{{Name}}">{{Name}}</option>
                        {{/each}}
                    </select>
                </div>
            </div>

            <!-- Text input-->
            <div class="control-group">
                <label class="control-label" for="wifi_password">
                    <asp:localize runat="server" meta:resourcekey="status_view_wifi_password_label" />
                </label>
                <div class="controls">
                    <input type="password" id="ap_password" name="password" class="input-medium">
                    <label style="margin-top:5px;"><input id="chkbox_show_password" type="checkbox" /><asp:localize runat="server" meta:resourcekey="status_view_wifi_show_password_label" /></label>
                </div>
            </div>

            <%--{{#ifEquals mode "NORMAL" }}--%>
            <!-- Button -->
            <div class="control-group">
                <div class="controls">
                    <button id="connect_btn" class="btn btn-primary">
                        <%--{{#ifEquals mode "NORMAL" }}--%>
                            <asp:localize runat="server" meta:resourcekey="status_view_wifi_connect_btn" />
                        <%--{{/ifEquals}}
                        {{#ifEquals mode "INIT_CONFIG" }}
                            <asp:localize runat="server" meta:resourcekey="status_view_wifi_verify_btn" />
                        {{/ifEquals}}--%>
                    </button>
                </div>
            </div>
            <%--{{/ifEquals}}--%>
        </form>
        {{/addPartial}}

        {{#addPartial "configuring"}}
        <div style="margin-bottom:10px;" class="wifi-information row-fluid">
            <div class="control-group">
                <div class="controls">
                    <span>
                        <asp:localize runat="server" meta:resourcekey="status_view_connecting_ssid_label" />
                    </span>
                    <strong>{{currentSSID}}</strong>
                </div>
            </div>
        </div>
        {{/addPartial}}


        {{#ifEquals status "CONNECTED"}}
            {{#getPartial "connected"}}{{/getPartial}}
        {{else}}
            {{#ifEquals status "CONFIGURING"}}
                {{#getPartial "configuring"}}{{/getPartial}}
            {{else}}
                {{#getPartial "notConnected"}}{{/getPartial}}
            {{/ifEquals}}
        {{/ifEquals}}
        
    </div>

    <div class="loading-poster hide">
        <span data-name="connectingLegend"><asp:localize runat="server" meta:resourcekey="status_view_wifi_status_connecting_legend" /></span>
        <span data-name="disconnectingLegend"><asp:localize runat="server" meta:resourcekey="status_view_wifi_status_disconnecting_legend" /></span>
    </div>
</script>

<script id="ethernet_status_template" type="text/x-handlebars-template">
    <legend>
        <asp:localize runat="server" meta:resourcekey="status_view_ethernet_title" />
    </legend>

    <div class="main-section control-group">
        {{#ifEquals status "UP" }}
        <span>
            <asp:localize runat="server" meta:resourcekey="status_view_ethernet_status_connected" />
        </span>
        {{else}}
        <span>
            <asp:localize runat="server" meta:resourcekey="status_view_ethernet_status_disconnected" />
        </span>
        {{/ifEquals}}
    </div>
</script>

<script id="network_config_template" type="text/x-handlebars-template">
    <!-- Form Name -->
    <legend>
        <asp:localize runat="server" meta:resourcekey="config_view_title" />
    </legend>
    <form class="form-horizontal network-configure-form">
        <!-- Multiple Radios-->
        <div class="control-group">
            <label id="dhcp_auto_label" class="controls">
                <input type="radio" id="dhcp_auto" name="ipAddress" value="DHCP" checked="checked" />
                <asp:localize runat="server" meta:resourcekey="status_view_obtain_ip_mode_dhcp_label" />
            </label>
            <label id="dhcp_static_label"  class="controls second-radio-container">
                <input type="radio" id="dhcp_static" name="ipAddress" value="Static" />
                <asp:localize runat="server" meta:resourcekey="status_view_obtain_ip_mode_static_label" />
            </label>
        </div>

        <div id="dhcp_static_fields">
            <!-- Text input-->
            <div class="control-group">
                <label id="ip_address_label" class="control-label" for="ip_address">
                    <asp:localize runat="server" meta:resourcekey="status_view_ip_address_label" />
                </label>
                <div class="controls input-controls">
                    <input id="ip_address" name="ip4Address" type="text" placeholder="" class="input-medium">    
                </div>
            </div>

            <!-- Text input-->
            <div class="control-group">
                <label id="subnet_mask_label" class="control-label" for="subnet_mask">
                    <asp:localize runat="server" meta:resourcekey="status_view_subnet_mask_label" />
                </label>
                <div class="controls input-controls">
                    <input id="subnet_mask" name="subnetMask" type="text" placeholder="" class="input-medium">    
                </div>
            </div>

            <!-- Text input-->
            <div class="control-group">
                <label id="default_gateway_label" class="control-label" for="default_gateway">
                    <asp:localize runat="server" meta:resourcekey="status_view_default_gateway_label" />
                </label>
                <div class="controls input-controls">
                    <input id="default_gateway" name="defaultGateway" type="text" placeholder="" class="input-medium">    
                </div>
            </div>
        </div>
        <!-- Multiple Radios -->   
        <div class="control-group">
            <label id="dsn_server_auto_label" class="controls second-radio-container">
                <input type="radio" id="dsn_server_auto" value="Automatic" checked="checked">
                <asp:localize runat="server" meta:resourcekey="status_view_dns_server_mode_auto_label" />
            </label>
            <label id="dsn_server_static_label" class="controls">
                <input type="radio" id="dsn_server_static" value="Static">
                <asp:localize runat="server" meta:resourcekey="status_view_dns_server_mode_static_label" />
            </label>
        </div>

        <!-- Text input-->
        <div  id="preferred_dns_fields" class="control-group">
            <label id="preferred_dns_label" class="control-label" for="preferred_dns">
                <asp:localize runat="server" meta:resourcekey="status_view_preferred_dns_label" />
            </label>
            <div class="controls input-controls">
                <input id="preferred_dns" name="preferredDns" type="text" placeholder="" class="input-medium">    
            </div>
        </div>
        {{#ifEquals mode "NORMAL" }}
        <br />
        <!-- Button -->
        <div class="control-group" style="margin-bottom:0;">
            <div class="controls" style="float:right;">
                <button id="configure_network_btn" class="btn btn-primary">
                    <asp:localize runat="server" meta:resourcekey="status_view_save_btn" />
                </button>
            </div>
        </div>
        {{/ifEquals}}
    </form>
</script>