﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/jquery.contextMenu/jquery.contextMenu.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/tailwind/tailwind.min.css") %>" rel="stylesheet" />
<div class="row-fluid subnavbar fixed-subnavbar" id="subnavbar_controls" style="margin-bottom: 0px;height:38px !important;">
    <div class="row-fluid form-inline">
        <div class="span10">
            <label class="control-label" for="dateStartTbx">
                <asp:localize runat="server" meta:resourcekey="date_start_tbx_label" />
            </label>
            <label class="input-prepend">
                <span class="add-on"><i class="icon-calendar"></i></span>
                <input type="text" id="dateStartTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(start$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
            </label>
            <label class="control-label" for="dateEndTbx">
                <asp:localize runat="server" meta:resourcekey="date_end_tbx_label" />
            </label>
            <label class="input-prepend">
                <span class="add-on"><i class="icon-calendar"></i></span>
                <input type="text" id="dateEndTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(end$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
            </label>
            <label style="margin-left:10px;margin-bottom:0 !important; ">
                <asp:Localize runat="server" meta:resourcekey="caster_label" /> 
                    <select disabled data-bind=" value: casterCode, options: casters," style="width:50px;margin-top:0px;">
                    </select>
            </label>
            <label style="margin-left:10px;margin-bottom:0 !important; ">
                <asp:Localize runat="server" meta:resourcekey="crew_label" /> 
                    <select data-bind=" value: crewId, options: crews, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_crew_label />', value: null }" style="width:60px;margin-top:0px;">
                    </select>
            </label>
            <label style="margin-left:10px;margin-bottom:0 !important; ">
                <asp:Localize runat="server" meta:resourcekey="shift_label" /> 
                    <select data-bind=" value: shiftId, options: shifts, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_shift_label />', value: null }" style="width:60px;margin-top:0px;">
                    </select>
            </label>
            <label style="margin-left:10px;margin-bottom:0 !important; ">
                <asp:Localize runat="server" meta:resourcekey="strand_label" /> 
                    <select data-bind=" value: strandId, options: strands, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_strand_label />', value: null }" style="width:60px;margin-top:0px;">
                    </select>
            </label>

            
            <label class="control-label">
                <asp:localize runat="server" meta:resourcekey="search_label" />
                <input type="text" class="input-large clear-search" id="search" style="margin-top:-4px; width:150px;" data-bind="value: trim(searchText)," placeholder="<asp:Localize runat=server meta:resourcekey=search_place_holder />" />
            </label>  

        </div>
        <div class="span2">
            <button style="margin-top:0; margin-left:10px; margin-right:10px;" class="btn btn-export-to-excel pull-right" type="button">
                <span class="excel-export-state fa fa-file-excel-o"></span>
                <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
            </button>
            <button id="refreshBtn" class="btn btn-primary pull-right" style="" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                <i class="fa fa-refresh"></i>
            </button>
            
        </div>
        
    </div>
</div>
<div class="row-fluid screen-content">
    <div class="pull-left" style="width:100%;margin-left:0;">  
        <div class="processes-grid-container infinite-container" style="margin-top:20px"></div>
        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
            <div class="row-fluid" style="position:relative;top:100px;">
                <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
            </div>
            <div class="row-fluid" style="position:relative;top:115px;">
                <h3 style="font-size:50px;">
                    <asp:localize runat="server" meta:resourcekey="no_data_available" />
                </h3>
            </div>
        </div>
        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
            <div class="row-fluid" style="position:relative;top:100px;">
                <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
            </div>
            <div class="row-fluid" style="position:relative;top:115px;">
                <h3 style="font-size:50px;">
                    <asp:localize runat="server" meta:resourcekey="loading_data" />
                </h3>
            </div>
        </div>
    </div>


</div>
<script id="print_confirmation_modal" type="text/x-handlebars-template">
  <div class="modal-header">
    <h5 id="offcanvasRightLabel">Print Tag Confirmation</h5>
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
  </div>
<div class="modal-body">
  <div class="form-grid">

    <!-- Product Number -->
    <label class="form-label">
      <asp:Localize runat="server" meta:resourcekey="productNumber_label" />
    </label>
    <input class="field-input form-control" type="text"
           data-bind="value: productNumber" style="text-align:center;" disabled>

    <!-- Reason -->
    <label class="form-label">
      <asp:Localize runat="server" meta:resourcekey="reasonPhrases_combo_label" />
      <span class="required-star">*</span>
    </label>
    <select class="field-select form-control" data-bind="value: reasonPhraseId, options: reasonPhrases"></select>

    <!-- Printer / Employee (two columns on the right) -->
    <label class="form-label printerLabel">
      <asp:Localize runat="server" meta:resourcekey="printer_combo_label" />
      <span class="required-star">*</span>
    </label>
    <div class="pair-2">
      <select class="field-select form-control printer-select"
              data-bind="value: printerId, options: printers"></select>

      <div>
        <label class="form-label" style="display:block; margin-bottom:4px;">
          <asp:Localize runat="server" meta:resourcekey="employee_combo_label" />
          <span class="required-star">*</span>
        </label>
        <input class="field-input form-control" type="number" data-bind="value: employeeNumber">
        <span id="warning" style="display:none;">This field is required.</span>
      </div>
    </div>
  </div>
  <div class="length-note alert alert-info mt-4" role="alert">
    <strong> Printing COLD length.</strong></div>

    <!-- Hot & Cold Lengths -->
    <label class="form-label">Lengths</label>
    <div class="pair-2">
      <div>
        <label style="display:block; margin-bottom:4px;">Hot Length</label>
        <input id="pieceLengthInput" class="field-input form-control" type="number"
               data-bind="value: pieceLength">
      </div>
      <div>
        <label style="display:block; margin-bottom:4px;">Cold Length</label>
        <input id="coldLengthInput" class="field-input form-control" type="number"
               >
      </div>
    </div>

    <!-- Comments (full width) -->
    <label class="form-label">Comments</label>
    <textarea class="print-comments form-control full"
              data-bind="value: comments"
              placeholder="Add any additional comments…"></textarea>

  </div>
</div>

  <div class="modal-footer noselect">
    <div class="footer-btn-bar">
      <button id="acceptBtn" class="btn btn-primary w-half">
        <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
      </button>
      <button id="cancelBtn" class="btn btn-cancel w-half" data-dismiss="modal">
        <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
      </button>
    </div>
  </div>
</script>


<script id="edit_length_modal" type="text/x-handlebars-template">
  <div class="modal-header">
    <h5>Edit Length</h5>
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
  </div>

  <div class="modal-body">
    <div class="form-grid">

      <!-- Product Number -->
      <label class="form-label">Product Number</label>
      <input class="field-input form-control" type="text"
             data-bind="value: productNumber" style="text-align:center;" disabled>

      <!-- Toggle -->
      <label class="form-label">Length Type</label>
      <div>
        <div class="btn-group btn-group-sm" id="editLengthToggle">
          <label class="btn btn-default">
            <input type="radio" name="editLengthMode" value="hot"  autocomplete="off" checked> Hot
          </label>
          <label class="btn btn-default">
            <input type="radio" name="editLengthMode" value="cold" autocomplete="off"> Cold
          </label>
        </div>
      </div>

      <!-- Inputs: editable one depends on the toggle -->
      <label class="form-label">Lengths</label>
      <div class="pair-2">
        <div>
          <label style="display:block; margin-bottom:4px;">Hot Length</label>
          <input id="editHotInput"  class="field-input form-control" type="number">
        </div>
        <div>
          <label style="display:block; margin-bottom:4px;">Cold Length</label>
          <input id="editColdInput" class="field-input form-control" type="number">
        </div>
      </div>

    </div>
  </div>

  <div class="modal-footer">
    <button id="saveEditLengthBtn" class="btn btn-primary">Save</button>
    <button id="savePrintEditLengthBtn" class="btn btn-primary">Save &amp; Print</button>
    <button class="btn btn-default" data-dismiss="modal">Cancel</button>
  </div>

</script>

