﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<%--<link href="<%= ResolveUrl("~/app/custom-screens/melt-shop-overview/melt-shop-overview.css")%>" rel="stylesheet" />--%>
<link href="<%= ResolveUrl("~/assets/libs/js/jquery.contextMenu/jquery.contextMenu.css") %>" rel="stylesheet" />

<div class="row-fluid screen-content">
    <div class="pull-left parent"  style="width:100%;margin-left:0;">  
        <div class="row-fluid child" style="margin-top:-8px;">
            <div class="span9">
                <table id="coolingBed" style="width:100% !important">  
                                 
                    <tr>
                        <td><svg height="21px" id="graph37_p"  style="width:65% !important"></svg></td>
                           <td rowspan="11" id="tundish-buttons-heats">
                            <div class="row-fluid" style="margin-bottom:10px;margin-top:50px">
                                <div class="span6" style="margin-top:-10px">
                                  
                                </div>
                              <%--  <div class="span2">
                                    <button id="HydrogenBtn" class="btn btn-primary" style="width:100%;height:50%">Hydrogen</button>
                                </div>--%>
                                <div class="span1">                
                                    <button id="TWIBtn" class="btn btn-primary" style="width:100%;height:50%">TWI</button>
                                </div>
                                <div class="span3">                
                                    <button id="LadleOpenBtn" class="btn btn-primary" style="width:100%;height:50%">Manual Ladle Open</button>
                                </div>
                            </div>                            
                            <div class="processes-grid-container"></div>    
                            <div>
                                 <button id="HeatsRealTimeBtn" class="btn btn-primary pull-right" style="margin-bottom:-30px !important;margin-top:5px !important">More Heats  ❯❯</button>
                            </div>
                           </td>
                    </tr>
                    <tr><td><svg height="21px" id="graph36_p"  style="width:65% !important"></svg></td></tr>
                    <tr><td><svg height="21px" id="graph35_p"  style="width:65% !important"></svg></td></tr>
                    <tr><td><svg height="21px" id="graph34_p"  style="width:65% !important"></svg></td></tr>
                    <tr><td><svg height="21px" id="graph33_p"  style="width:65% !important"></svg></td></tr>
                    <tr>
                        <td style="width:25%"><svg height="21px" id="graph32_p"  style="width:65% !important"></svg></td>
                                                
                            
                     
                    </tr>                    
                    <tr><td><svg height="21px" id="graph31_p"  style="width:65% !important"></svg></td></tr>
                    <tr><td><svg height="21px" id="graph30_p"  style="width:65% !important"></svg></td></tr>
                    <tr><td><svg height="21px" id="graph29_p"  style="width:65% !important"></svg></td></tr>
                    <tr><td><svg height="21px" id="graph28_p"  style="width:65% !important"></svg></td></tr>
                    <tr><td><svg height="21px" id="graph27_p"  style="width:65% !important"></svg></td></tr>
                    <tr><td><svg height="21px" id="graph26_p"  style="width:65% !important"></svg></td></tr>
                    <tr><td><svg height="21px" id="graph25_p"  style="width:100% !important"></svg></td></tr>
                    <tr><td><svg height="21px" id="graph24_p"  style="width:100% !important"></svg></td></tr>
                    <tr><td><svg height="21px" id="graph23_p"  style="width:100% !important"></svg></td></tr>
                    <tr><td><svg height="21px" id="graph22_p"  style="width:100% !important"></svg></td></tr>
                    <tr><td><svg height="21px" id="graph21_p"  style="width:100% !important"></svg></td></tr>
                    <tr><td><svg height="21px" id="graph20_p"  style="width:100% !important"></svg></td></tr>
                    
                    <tr><td>
                        <div class="row-fluid">
                            <div class="span6">
                                <label style="font-weight: bold;margin-left: 30px;" class="control-label">Cooling Bed</label>                                
                            </div>
                            <div class="span6">
                                <label style="font-weight: bold;margin-left: 5px !important;" class="control-label">Hot Charge</label>            
                                
                            </div>
                        </div>

                        </td></tr>
                </table>
                <table id="runout" style="width:100% !important;margin-top:-130px">
                    <tr>
                        <td style="width:21%"></td>
                        <td rowspan="4" id="turret-tundish" style="padding-left:50px;">
                            <div class="row-fluid">
                                <div class="span4">                                     
                                    <div style="width: 281px; height: 150px">
                                        <div class="heat ">                                            
                                            <h4 data-bind="text: Title_3" class="title"></h4>
                                            <div class="row-fluid"> 
                                                <div class="span3 left-value" id="in-transit-position">
                                                    <h3 data-bind="text: LeftValue_3"></h3>
                                                </div>
                                                <div class="span9 heat-details box-height-ladle-widget" style="margin-left:4px !important">
                                                    <h4 data-bind="text: TopValue_3" class="top-value intransit-heat"></h4>
                                                    <h6 data-bind="text: MiddleValue_3"  class="middle-value"></h6>
            
                                                    <div class="row-fluid border-top-bottom">
                                                        <div class="span4 border-right" >
                                                            <h6 data-bind="text: MiddleLeftValue_3" class="middle-left-value"></h6>
            
                                                        </div>
                                                        <div class="span8">
                                                              <h6 data-bind="text: MiddleRightValue_3" class="middle-right-value" ></h6>
            
                                                        </div>
                                                    </div>

                                                    <div class="row-fluid">
                                                        <div class="span4 bottom-left-value">
                                                            <span data-bind="text: BottomLeftValue_3" class="label-heats-min-mwh"></span>
                                                            <span><label class="bottom-left-value-label">Heats</label></span>

                                                        </div>
                                                        <div class="span4 bottom-middle-value">
                                                            <span data-bind="text: BottomMiddleValue_3" class="label-heats-min-mwh"></span>
                                                            <span><label class="bottom-middle-value-label">Min</label></span>
                                                        </div>
                                                        <div class="span4 bottom-right-value">
                                                            <span data-bind="text: BottomRightValue_3" class="label-heats-min-mwh"></span>
                                                            <span><label class="bottom-right-value-lable">MWH</label></span>
                                                        </div>

                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>                                
                                <div class="span4">
                                    <div style="width: 281px; height: 150px;margin-left:30px">
                                        <div class="heat">
                                            <h4 data-bind="text: Title_2" class="title"></h4>
                                            <div class="row-fluid"> 
                                                <div class="span3 left-value" id="out-position">
                                                    <h3 data-bind="text: LeftValue_2"></h3>
                                                </div>
                                                <div class="span9 heat-details box-height-ladle-widget" style="margin-left:4px !important">
                                                    <h4 data-bind="text: TopValue_2" class="top-value outboard-heat"></h4>
                                                    <h6 data-bind="text: MiddleValue_2"  class="middle-value"></h6>
            
                                                    <div class="row-fluid border-top-bottom">
                                                        <div class="span4 border-right" >
                                                            <h6 data-bind="text: MiddleLeftValue_2" class="middle-left-value"></h6>
            
                                                        </div>
                                                        <div class="span8">
                                                              <h6 data-bind="text: MiddleRightValue_2" class="middle-right-value" ></h6>
            
                                                        </div>
                                                    </div>

                                                    <div class="row-fluid">
                                                        <div class="span4 bottom-left-value">
                                                            <span data-bind="text: BottomLeftValue_2" class="label-heats-min-mwh"></span>
                                                            <span><label class="bottom-left-value-label">Heats</label></span>

                                                        </div>
                                                        <div class="span4 bottom-middle-value">
                                                            <span data-bind="text: BottomMiddleValue_2" class="label-heats-min-mwh"></span>
                                                            <span><label class="bottom-middle-value-label">Min</label></span>
                                                        </div>
                                                        <div class="span4 bottom-right-value">
                                                            <span data-bind="text: BottomRightValue_2" class="label-heats-min-mwh"></span>
                                                            <span><label class="bottom-right-value-lable">MWH</label></span>
                                                        </div>

                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>                                
                                <div class="span4">
                                    <div style="width: 281px; height: 150px;">                                         
                                        <div class="heat">
                                            <h4 data-bind="text: Title_1" class="title"></h4>
                                            <div class="row-fluid"> 
                                                <div class="span3 left-value" id="in-position">
                                                <h3 data-bind="text: LeftValue_1"></h3>
                                            </div>
                                                <div class="span9 heat-details box-height-ladle-widget" style="margin-left:4px !important">
                                                <h4 data-bind="text: TopValue_1" class="top-value inboard-heat"></h4>
                                                <h6 data-bind="text: MiddleValue_1"  class="middle-value"></h6>
            
                                                <div class="row-fluid border-top-bottom">
                                                    <div class="span4 border-right" >
                                                        <h6 data-bind="text: MiddleLeftValue_1" class="middle-left-value"></h6>
            
                                                    </div>
                                                    <div class="span8">
                                                          <h6 data-bind="text: MiddleRightValue_1" class="middle-right-value" ></h6>
            
                                                    </div>
                                                </div>

                                                <div class="row-fluid">
                                                    <div class="span4 bottom-left-value">
                                                        <span data-bind="text: BottomLeftValue_1" class="label-heats-min-mwh"></span>
                                                        <span><label class="bottom-left-value-label">Heats</label></span>

                                                    </div>
                                                    <div class="span4 bottom-middle-value">
                                                        <span data-bind="text: BottomMiddleValue_1" class="label-heats-min-mwh"></span>
                                                        <span><label class="bottom-middle-value-label">Min</label></span>
                                                    </div>
                                                    <div class="span4 bottom-right-value">
                                                        <span data-bind="text: BottomRightValue_1" class="label-heats-min-mwh"></span>
                                                        <span><label class="bottom-right-value-lable">MWH</label></span>
                                                    </div>

                                                </div>
                                            </div>
                                            </div>
                                        </div>
                                        <div class="ladle-open" data-bind="classes:{hide: not(LadleOpen)}"></div >
                                        <div class="ladle-open-not-open" data-bind="classes:{hide: LadleOpen}"></div >                                         
                                    </div>
                                </div>
                            </div>
                            <div class="row-fluid">
                                <div class="span5">

                                </div>
                                <div class="span3">
                                     <div class="row-fuild">
                                        <div class="span10">
                                            <label style="margin-bottom:0 !important;font-weight: bold; " class="control-label">
                                                <asp:Localize runat="server" meta:resourcekey="tundish_car_1_label" /> 
                                                    <select disabled data-bind=" value: tundish1Number, options: tundishes, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=no_tundish_selected />', value: '-' }" style="width:105px;margin-top:5px;">
                                                    </select>
                                            </label>
                                        </div>
                                        <div class="span2">
                                            <div class="tunidsh1Circle"></div>
                                        </div>                                        
                                    </div>
                                    <div class="row-fluid">
                                        <div class="span10">
                                            <label style="margin-bottom:0 !important;font-weight: bold; " class="control-label">
                                                <asp:Localize runat="server" meta:resourcekey="tundish_car_2_label" /> 
                                                    <select disabled data-bind=" value: tundish2Number, options: tundishes, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=no_tundish_selected />', value: '-' }" style="width:105px;margin-top:5px;">
                                                    </select>
                                            </label>
                                        </div>
                                        <div class="span2">                                            
                                            <div class="tunidsh2Circle"></div>
                                        </div>
                                    </div>
                                </div>

                                <div class="span4">   
                                    <div style="width: 281px; height: 60px;margin-top:20px;"> 
                                         <div class="heat-no-widget row-fluid">                                            
                                            <div data-bind="classes:{hide: SingleLeftValue}">
                                                <div class="span8 heat-details box-height-no-ladle-widget" style="border-left: none">   
                                         
                                                    <div class="row-fluid" style="border-bottom: 2px solid #ccc;margin-top: -1.8px;">
                                                        <div class="span6 no-widget-ton1 tundish-heat-top" style="border-right: 2px solid #ccc" >
                                                            <h5 data-bind="text: TopLeftValue_4" class="top-left-value" style="margin-top: 3px;"></h5>
                                                        </div>
                                                        <div class="span6 no-widget-heat1">
                                                            <div class="row-fluid">
                                                                <div class="span9">                                         
                                                                    <h5 data-bind="text: TopRightValue_4" class="top-right-value" style="margin-top: 3px;"></h5>
                                                                </div>
                                                                <div class="span3" style="margin-left: -4px;">                                                            
                                                                    <span><label class="tundish-unit-labels">tons</label></span>
                                                                </div>
                                                            </div>

                                                       </div>
                                                    </div>
                                                    <div class="row-fluid">
                                                        <div class="span6 no-widget-ton2 tundish-heat-bottom-2" style="border-right: 2px solid #ccc">
                                                            <h5 data-bind="text: BottomLeftValue2_4" class="bottom-left-value2" style="margin-top: 3px;"></h5>
                                                        </div>
                                                        <div class="span6 no-widget-heat2">

                                                             <div class="row-fluid">
                                                                <div class="span9">                                         
                                                                    <h5 data-bind="text: BottomRightValue2_4" class="bottom-right-value2" style="margin-top: 3px;"></h5>
                                                                </div>
                                                                <div class="span3" style="margin-left: -4px;">                                                            
                                                                    <span><label class="tundish-unit-labels">tons</label></span>
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>
                                                 <div class="span4 single-value-middle left-value-no-ladle-widget" style="margin-left:-2px;">
                                                     <div class="row-fluid">
                                                         <div class="span9">                                                             
                                                            <h5 data-bind="text: LeftValue_4"></h5>
                                                         </div>
                                                         <div class="span3" style="margin-top: 5px;">                                                             
                                                            <span><label class="tundish-unit-labels">F</label></span>
                                                         </div>
                                                     </div>
                                                </div>
                                            </div>


                                             <div data-bind="classes:{hide: not(SingleLeftValue)}" >
                                                <div class="span4 left-value-no-ladle-widget tundish-heat-bottom" style="margin-right:-8px;">                                                 
                                                    <h5 data-bind="text: BottomLeftValue2_4"></h5>                                              
                                                </div>
                                                <div class="span4 left-value-no-ladle-widget single-value-middle">    
                                                    <div class="row-fluid">
                                                        <div class="span9">                                                            
                                                            <h5 data-bind="text: BottomRightValue2_4"></h5> 
                                                        </div>
                                                        <div class="span3" style="margin-top: 5px;">                                                            
                                                            <span><label class="tundish-unit-labels">tons</label></span>
                                                        </div>
                                                    </div>
                                                </div>
                                                 <div class="span4 single-value-middle left-value-no-ladle-widget" >
                                                     <div class="row-fluid">
                                                         <div class="span9">                                                             
                                                            <h5 data-bind="text: LeftValue_4"></h5>
                                                         </div>
                                                         <div class="span3" style="margin-top: 5px;">                                                             
                                                            <span><label class="tundish-unit-labels">F</label></span>
                                                         </div>
                                                     </div>
                                                     
                                                </div>
                                             </div>

                                          
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </td>
                    </tr>
                    <tr style="height:50px !important">
                        <td>
                        <%--<svg height="50px" id="graph11_p"  style="width:100% !important;"></svg>--%>
                             <div class="row-fluid">
                                 <div class="span4 row-fluid" style="border: 2.5px solid #ccc;background-color: #eee;"> <%--drop-positon-container-large--%>
                                    <div class="not-drop-positon-container" id="pos11"></div>
                                </div>           
                            </div>
                        </td>

                    </tr>  
                    <tr style="height:40px !important">
                        <td>
                            <%--<svg height="40px" id="graph10_p"  style="width:100% !important;"></svg>--%>
                             <div class="row-fluid">
                                 <div class="span4 row-fluid" style="border: 2.5px solid #ccc;background-color: #eee;"> <%--drop-positon-container-large--%>
                                    <div class="not-drop-positon-container" id="pos10"></div>
                                </div>           
                            </div>
                        </td>

                    </tr> 
                    <tr style="height:40px !important">
                        <td>
                       <%--     <svg height="40px" id="graph9_p"  style="width:100% !important;"></svg>--%>
                             <div class="row-fluid">
                                 <div class="span4 row-fluid" style="border: 2.5px solid #ccc;background-color: #eee;"> <%--drop-positon-container-large--%>                                    
                                    <div class="not-drop-positon-container" id="pos9"></div>
                                </div>           
                            </div>
                        </td>

                    </tr>
                    
                </table>
                <table id="positions" style="line-height:0px !important">
                     <tr> 
                        <th style="width:21% !important; height:40px !important">          
                            <%--<svg height="40px" id="graph8_p"  style="width:100% !important;font-weight:500;margin-bottom:30px"></svg>--%>

                             <div class="row-fluid">
                                 <div class="span4 row-fluid" style="border: 2.5px solid #ccc;background-color: #eee;"> <%--drop-positon-container-large--%>
                                    <div class="not-drop-positon-container" id="pos8"></div>
                                </div>           
                            </div>
                        </th>
                        <th style="width:48% !important;text-align:left;height:40px !important"><label style="margin-left:265px;font-weight: bold" class="control-label">Home</label></th>
                        <th style="width:7% !important;border: 1px solid #ccc;background-color: #eee;"><label class="control-label" style="font-weight: bold">Speed in/min</label></th>
                        <th style="width:5% !important;border: 1px solid #ccc;background-color: #eee;"><label class="control-label" style="font-weight: bold">Preset in</label></th>
                        <th style="width:7% !important;border: 1px solid #ccc;background-color: #eee;"><label class="control-label" style="font-weight: bold">Measured in</label></th>
                        <th style="width:9% !important;border: 1px solid #ccc;background-color: #eee;"><label class="control-label" style="font-weight: bold">Remaining</label></th>
                        <th style="width:4% !important"></th>
                     </tr>
                      <tr>
                        <td>
                              <%--<td><svg height="40px" id="graph1_p"  style="width:100% !important;margin-top:-10px"></svg></td>--%>
                            <div class="row-fluid">
                                 <div class="span4 row-fluid" style="border: 2.5px solid #ccc;background-color: #eee;"> <%--drop-positon-container-large--%>
                                    <div class="span4"></div>
                                    <div class="span4">                                        
                                        <div class="dropable drop-positon-container-pos6" id="strand1pos6"></div>
                                    </div>
                                     <div class="span4"></div>
                                </div>
                                <div class="span2">                        
                                    <div class="dropable drop-positon-container" id="strand1pos5"></div>
                                </div>
                                <div class="span2">                        
                                    <div class="dropable drop-positon-container" id="strand1pos4"></div>
                                </div>
                                <div class="span2">                        
                                    <div class="dropable drop-positon-container" id="strand1pos3"></div>
                                </div>                    
                                <div class="span2">                        
                                    <div class="dropable drop-positon-container" id="strand1pos2"></div>
                                </div>                
                            </div>
                        </td>
                        <td><svg height="50px" id="graph1"  style="width:100% !important"></svg></td>  
                         <td style="border: 1px solid #ccc"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:Speed_S1" ></label></td>
                         <td style="border: 1px solid #ccc"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:SP_S1" ></label></td>
                         <td style="border: 1px solid #ccc"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:Measured_S1" ></label></td>
                         <td style="border: 1px solid #ccc;height:48px !important">
                             <label class="control-label" style="font-weight: bold;text-align: center; font-size:11px;margin-bottom:0px !important;margin-top: -5px !important;" data-bind="text:MaterialRemaining_Top_S1" ></label>
                             <label class="control-label" style="font-weight: bold;text-align: center; font-size:11px;margin-top:0px !important; margin-bottom:0px !important;line-height: 10px;" data-bind="text:MaterialRemaining_Middle_S1" ></label>
                             <label class="control-label" style="font-weight: bold;text-align: center; font-size:11px;margin-top:0px !important; margin-bottom:0px !important" data-bind="text:MaterialRemaining_Bottom_S1" ></label>
              

                         </td>
                    
                         <td style="border: 2px solid #ccc;background-color: #eee;" id="Name_S1"><label class="control-label" style="font-weight: bold;text-align: center;" data-bind="text:Name_S1" ></label></td>

                      </tr>
                     <tr>
                        <td>
                            <%--<td><svg height="40px" id="graph2_p"  style="width:100% !important;margin-top:-10px"></svg></td>--%>
                            <div class="row-fluid">
                                 <div class="span4 row-fluid" style="border: 2.5px solid #ccc;background-color: #eee;"> <%--drop-positon-container-large--%>
                                    <div class="span4"></div>
                                    <div class="span4">                                        
                                        <div class="dropable drop-positon-container-pos6" id="strand2pos6"></div>
                                    </div>
                                     <div class="span4"></div>
                                </div>
                                <div class="span2">                        
                                    <div class="dropable drop-positon-container" id="strand2pos5"></div>
                                </div>
                                <div class="span2">                        
                                    <div class="dropable drop-positon-container" id="strand2pos4"></div>
                                </div>
                                <div class="span2">                        
                                    <div class="dropable drop-positon-container" id="strand2pos3"></div>
                                </div>                    
                                <div class="span2">                        
                                    <div class="dropable drop-positon-container" id="strand2pos2"></div>
                                </div>                
                            </div>
                        </td>
                        <td><svg height="50px" id="graph2"  style="width:100% !important"></svg></td>   
                         <td style="border: 1px solid #ccc"><label class="control-label"  style="font-weight: bold;text-align: center" data-bind="text:Speed_S2" ></label></td>
                         <td style="border: 1px solid #ccc"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:SP_S2" ></label></td>
                         <td style="border: 1px solid #ccc"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:Measured_S2" ></label></td>
                         <td style="border: 1px solid #ccc;height:48px !important">

                             
                             <label class="control-label" style="font-weight: bold;text-align: center; font-size:11px;margin-bottom:0px !important;margin-top: -5px !important;" data-bind="text:MaterialRemaining_Top_S2" ></label>
                             <label class="control-label" style="font-weight: bold;text-align: center; font-size:11px;margin-top:0px !important; margin-bottom:0px !important;line-height: 10px;" data-bind="text:MaterialRemaining_Middle_S2" ></label>
                             <label class="control-label" style="font-weight: bold;text-align: center; font-size:11px;margin-top:0px !important; margin-bottom:0px !important" data-bind="text:MaterialRemaining_Bottom_S2" ></label>
              
                                                

                         </td>
                         <td style="border: 2px solid #ccc;background-color: #eee;" id="Name_S2"><label class="control-label" style="font-weight: bold;text-align: center;" data-bind="text:Name_S2" ></label></td>
                     </tr>
                     <tr>
                        <td>
                            
                            <%--<td><svg height="40px" id="graph3_p"  style="width:100% !important;margin-top:-10px"></svg></td>--%>
                            <div class="row-fluid">
                                 <div class="span4 row-fluid" style="border: 2.5px solid #ccc;background-color: #eee;"> <%--drop-positon-container-large--%>
                                    <div class="span4"></div>
                                    <div class="span4">                                        
                                        <div class="dropable drop-positon-container-pos6" id="strand3pos6"></div>
                                    </div>
                                     <div class="span4"></div>
                                </div>
                                <div class="span2">                        
                                    <div class="dropable drop-positon-container" id="strand3pos5"></div>
                                </div>
                                <div class="span2">                        
                                    <div class="dropable drop-positon-container" id="strand3pos4"></div>
                                </div>
                                <div class="span2">                        
                                    <div class="dropable drop-positon-container" id="strand3pos3"></div>
                                </div>                    
                                <div class="span2">                        
                                    <div class="dropable drop-positon-container" id="strand3pos2"></div>
                                </div>                
                            </div>

                        </td>
                        <td><svg height="50px" id="graph3" style="width:100% !important"></svg></td>   
                        <td style="border: 1px solid #ccc"><label class="control-label"  style="font-weight: bold;text-align: center" data-bind="text:Speed_S3" ></label></td>
                        <td style="border: 1px solid #ccc"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:SP_S3" ></label></td>
                        <td style="border: 1px solid #ccc"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:Measured_S3" ></label></td>
                        <td style="border: 1px solid #ccc;height:48px !important">
                             <label class="control-label" style="font-weight: bold;text-align: center; font-size:11px;margin-bottom:0px !important;margin-top: -5px !important;" data-bind="text:MaterialRemaining_Top_S3" ></label>
                             <label class="control-label" style="font-weight: bold;text-align: center; font-size:11px;margin-top:0px !important; margin-bottom:0px !important;line-height: 10px;" data-bind="text:MaterialRemaining_Middle_S3" ></label>
                             <label class="control-label" style="font-weight: bold;text-align: center; font-size:11px;margin-top:0px !important; margin-bottom:0px !important" data-bind="text:MaterialRemaining_Bottom_S3" ></label>
                           </td>
                         
                         <td style="border: 2px solid #ccc;background-color: #eee;" id="Name_S3"><label class="control-label" style="font-weight: bold;text-align: center;" data-bind="text:Name_S3" ></label></td>
                      </tr>
                     <tr>
                        <td>
                            
                            <%--<td><svg height="40px" id="graph4_p"  style="width:100% !important;margin-top:-10px"></svg></td>--%>
                            <div class="row-fluid">
                                <div class="span4 row-fluid" style="border: 2.5px solid #ccc;background-color: #eee;"> <%--drop-positon-container-large--%>
                                    <div class="span4"></div>
                                    <div class="span4">                                        
                                        <div class="dropable drop-positon-container-pos6" id="strand4pos6"></div>
                                    </div>
                                     <div class="span4"></div>
                                </div>
                                <div class="span2">                        
                                    <div class="dropable drop-positon-container" id="strand4pos5"></div>
                                </div>
                                <div class="span2">                        
                                    <div class="dropable drop-positon-container" id="strand4pos4"></div>
                                </div>
                                <div class="span2">                        
                                    <div class="dropable drop-positon-container" id="strand4pos3"></div>
                                </div>                    
                                <div class="span2">                        
                                    <div class="dropable drop-positon-container" id="strand4pos2"></div>
                                </div>                
                            </div>

                        </td>
                        <td><svg height="50px" id="graph4"  style="width:100% !important"></svg></td>  
                         <td style="border: 1px solid #ccc"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:Speed_S4" ></label></td>
                         <td style="border: 1px solid #ccc"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:SP_S4" ></label></td>
                         <td style="border: 1px solid #ccc"><label class="control-label" style="font-weight: bold;text-align: center" data-bind="text:Measured_S4" ></label></td>
                         <td style="border: 1px solid #ccc;height:48px !important">
                             <label class="control-label" style="font-weight: bold;text-align: center; font-size:11px;margin-bottom:0px !important;margin-top: -5px !important;" data-bind="text:MaterialRemaining_Top_S4" ></label>
                             <label class="control-label" style="font-weight: bold;text-align: center; font-size:11px;margin-top:0px !important; margin-bottom:0px !important;line-height: 10px;" data-bind="text:MaterialRemaining_Middle_S4" ></label>
                             <label class="control-label" style="font-weight: bold;text-align: center; font-size:11px;margin-top:0px !important; margin-bottom:0px !important" data-bind="text:MaterialRemaining_Bottom_S4" ></label>

                                                

                         </td>
                         <td style="border: 2px solid #ccc;background-color: #eee;" id="Name_S4"><label class="control-label" style="font-weight: bold;text-align: center;" data-bind="text:Name_S4" ></label></td>
            
                      </tr>
                 </table>

                  <div class="hide" data-bind="collection: $productsTablePosition, itemView: 'productsPositionView'"></div>
               


            </div>

         
            <div class="span3 row-fluid" style="margin-top:30px">
                <div class="row-fluid form-inline">
                    <div class="row-fluid">
                        <div class="span5">    
                            <label class="control-label" style="font-weight: bold;">
                                <asp:localize runat="server" meta:resourcekey="search_label" />
                            </label>
                        </div>
                        <div class="span3">   
                            <label class="control-label" style="font-weight: bold;">
                                <asp:localize runat="server" meta:resourcekey="strand_combo_label" />
                            </label>
                        </div>
                         <div class="span4">
                        </div>
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="span5">
                           <input type="text" style="width:140px;" id="search" data-bind="value: search," placeholder="<asp:Localize runat=server meta:resourcekey=search_place_holder />"/>           
                    </div>
                    <div class="span3">                       
                        <select style="width:100px;" id="strands" data-bind="value: strandId, options: strands, optionsDefault: { label: '<asp:localize runat=server meta:resourcekey=strand_combo_all_opt />', value: '-' },disabled:  disabledStrandPicker "></select> 
                    </div>
                    <div class="span4">
                        <button id="backToRealTime" class="btn btn-primary pull-right" style="width:90%;height:50%" data-bind="disabled:  realTime ">Go Real Time</button>
                    </div>
                   
                </div>
               

                <div class="products-grid-container" id="main-div" data-bind="classes: { hide: isLoading_products, }" ></div>
                 <div class="no-data-poster row-fluid text-center animated fadeIn not-print" data-bind="classes: { hide: not(isLoading_products), }" style="height:500px;">
                    <div class="row-fluid" style="position:relative;top:100px;">
                        <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                    </div>
                    <div class="row-fluid" style="position:relative;top:115px;">
                        <h3 style="font-size:50px;">
                            <asp:localize runat="server" meta:resourcekey="loading_data" />
                        </h3>
                    </div>
                </div>


            </div>

        </div>       
    </div>
</div>

<script id="actions_cell_template" type="text/x-handlebars-template">
    <div class="text-center">
         <button data-toggle="tooltip" data-placement="bottom" data-cell-action="EDIT_DETAILS" title="<asp:Localize runat=server meta:resourcekey=edit_details_title />" class="btn btn-cell-action btn-small btn-edit-details"><i class="fa fa-pencil"></i></button>
    </div>
</script>
<script id="assign_heats_torch_modal" type="text/x-handlebars-template">
    <div class="modal-header" >    
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4>
            <span data-bind="text: title" style="font-weight:bold;"></span>
        </h4>    
    </div>
    <div class="modal-body">
        <div style="padding-bottom:0;" class="modal-body">
            <div class="row-fluid">                 
                
                <div class="pull-left" style="width:100%;margin-left:0;">  
                        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:350px;">
                            <div class="row-fluid" style="position:relative;top:100px;">
                                <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
                            </div>
                            <div class="row-fluid" style="position:relative;top:115px;">
                                <h3 style="font-size:50px;">
                                    <asp:localize runat="server" meta:resourcekey="no_data_available" />
                                </h3>
                            </div>
                        </div>
                        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:350px;">
                            <div class="row-fluid" style="position:relative;top:100px;">
                                <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
                            </div>
                            <div class="row-fluid" style="position:relative;top:115px;">
                                <h3 style="font-size:50px;">
                                    <asp:localize runat="server" meta:resourcekey="loading_data" />
                                </h3>
                            </div>
                        </div>
                </div>
               
                <div class="last-heats-grid-container row-fluid infinite-container" data-bind="classes: { hide: any(not(hasData), isLoading), }"></div>   

            </div>
        </div>
    </div>
    <div class="modal-footer">
        <div class="modal-status-msg-container pull-left">
            <div class="modal-status-msg hide" data-bind="toggle: notEquals(errorMsg, ''),">
                <span data-bind="text: errorMsg, attr: { title: errorMsg, }," style="color:#ff0000;font-size:16px;"></span>
            </div>
            <div class="modal-status-msg hide" data-bind="toggle: processing,">
                <asp:Localize runat='server' meta:resourcekey='processing_msg' />
                <i class="fa fa-cog fa-spin"></i>
            </div>
        </div>
        <button  id="unassignBtn" class="btn btn-primary btn-danger" data-bind="enabled: not(processing), classes: { hide: not(show_unassign_btn), }">
            <asp:Localize runat='server' meta:resourcekey='unassign_btn_label' />
        </button>
        <button id="acceptBtn" class="btn btn-primary" data-bind="enabled: all(not(processing), selectedHeatId),">
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        
        <button id="cancelBtn" class="btn" data-dismiss="modal" data-bind="enabled: not(processing),">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>


    </div>
</script>
<script id="split_product_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat='server' meta:resourcekey='split_product_modal_title' /></h3>        
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:300px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:left;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=product_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;"data-bind="value: productNumber" disabled>
                </div>
            </div>
          <%--  <div class="row-fluid" style="text-align:left;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=length_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: length" disabled/>
                </div>
            </div>--%>
            <div class="row-fluid" style="text-align:left;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=piece_length_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: pieceLength" />
                </div>
            </div>
            <div class="row-fluid" style="text-align:left;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=scrap_length_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" <%--data-bind="value: trim(heat), enabled: false,"--%> data-bind="value: scrapLength" />
                </div>
            </div>
        </div>
      
    </div>
    <div class="modal-footer">
    <%--    <button id="acceptBtn" type="button" class="btn btn-success btn-save"><asp:Localize runat=server meta:resourcekey=save_split_product_btn_label /></button>
        <button type="button" class="btn btn-default btn-cancel" data-dismiss="modal"><asp:Localize runat=server meta:resourcekey=cancel_split_product_btn_label /></button>--%>

           <button id="acceptBtn" class="btn btn-primary" >
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        
        <button id="cancelBtn" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>

    </div>
</script>
<script id="add_new_product_template" type="text/x-handlebars-template">
  <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat='server' meta:resourcekey='add_new_product_modal_title' /></h3>        
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:300px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:left;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=heat_name_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;"data-bind="value: heatNumber" disabled>
                </div>
            </div>
             <div class="row-fluid" style="text-align:left;">
                 <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=strand_combo_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">      
                    <select style="width:200px;" data-bind="value: strandId, options: strands"></select> 
                </div>

              </div>
            <div class="row-fluid" style="text-align:left;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=piece_length_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: pieceLength" />
                </div>
            </div>
           
        </div>
      
    </div>
    <div class="modal-footer">

           <button id="acceptBtn" class="btn btn-primary" >
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        
        <button id="cancelBtn" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>

    </div>
</script>
<script id="edit_product_length_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat='server' meta:resourcekey='edit_product_length_modal_title' /></h3>        
    </div>
    <div style="max-height:350px;padding-bottom:0;padding-top:0;" class="modal-body">
        <div style="max-height:300px;padding-bottom:0;" class="modal-body">
            <div class="row-fluid" style="text-align:left;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=product_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;"data-bind="value: productNumber" disabled>
                </div>
            </div>
            <div class="row-fluid" style="text-align:left;">
                <div style="margin-top:5px; padding-top:5px; text-align:right;" class="span4 control-group form-inline">
                    <asp:Localize runat=server meta:resourcekey=piece_length_label />
                </div>
                <div style="margin-left:10px; margin-top: 5px; float:left;" class="control-group form-inline">
                    <input type="text" style="width:186px;" data-bind="value: pieceLength" />
                </div>
            </div>
      
    </div>
    <div class="modal-footer">
           <button id="acceptBtn" class="btn btn-primary" >
            <asp:Localize runat='server' meta:resourcekey='accept_btn_label' />
        </button>
        
        <button id="cancelBtn" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='cancel_btn_label' />
        </button>

    </div>
</script>




<script id="ProductsViewPositionTemplate" type="text/x-handlebars-template">
    <div draggable="true" class="productBoxLarge" data-bind="classes: { hide: DraggableArea, }">
        <h5 data-bind="text:ProductNumber," style="font-size: 11px !important; font-weight:bold; text-align: center;padding-top: 4px;margin-top: 0px;margin-bottom: 0px;"></h5>   
    </div>

    <div draggable="true" class="productBox" data-bind="classes: { hide: not(DraggableArea), }">
        <h5 data-bind="text:Sequence," style="font-size: 16px !important; text-align: center;padding-top: 4px;margin-top: 0px;margin-bottom: 0px;"></h5>   
    </div>
    


</script>
    