﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />
<div class="row-fluid subnavbar fixed-subnavbar">
    <div class="row-fluid form-inline">
        <label style="display:inline-block;margin: 0 0 0 50px";>
            <input class="big-radio" data-bind="checked: filterGroup" type="radio" name="radio" id="radio1" value='DATE' style="margin-bottom: 5px;" />
        </label>
        <label class="control-label" for="dateStartTbx">
            <asp:localize runat="server" meta:resourcekey="date_start_tbx_label" />
        </label>
        <label class="input-prepend">
            <span class="add-on"><i class="icon-calendar"></i></span>
            <input type="text" id="dateStartTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(start$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />'), enabled: equals(filterGroup, 'DATE')," />
        </label>
        <label class="control-label" for="dateEndTbx">
            <asp:localize runat="server" meta:resourcekey="date_end_tbx_label" />
        </label>
        <label class="input-prepend">
            <span class="add-on"><i class="icon-calendar"></i></span>
            <input type="text" id="dateEndTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(end$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />'), enabled: equals(filterGroup, 'DATE'),">
        </label>
        <label style="display:inline-block;margin: 0 10px 0 50px";>
            <input class="big-radio" data-bind="checked: filterGroup" type="radio" name="radio" id="radio2" value='HEAT' style="margin-bottom: 5px;" />
        </label>
        <div style="display:inline-block;">
            <div class="row-fluid form-inline">
                <label class="control-label" for="searchTbx">
                    <asp:localize runat="server" meta:resourcekey="process_picker_label" />
                </label>
                <label class="control-label" for="HeatFilter">
                        <asp:localize runat="server" meta:resourcekey="heat_filter" />
                </label>
                <div class="input-prepend input-append">
                    <button type="button" id="getPreviousItemBtn" class="btn btn-search-prev" data-bind="disabled: navigating, enabled: equals(filterGroup,'HEAT')," title="<asp:Localize        runat=server meta:resourcekey=previous_process_btn_title />"><i class="fa fa-play fa-rotate-180"></i></button>
                    <input type="text" id="searchTbx" style="width:100px;" data-bind="value: trim(search), events: ['change', 'keydown',], enabled: equals(filterGroup, 'HEAT'),"      placeholder="<asp:Localize runat=server meta:resourcekey=process_picker_place_holder />" data-select-on-focus/>       
                    <label data-bind="enabled: equals(filterGroup, 'HEAT'), classes: { disabled: not(equals(filterGroup, 'HEAT')), }," class="btn btn-search-show" id="showSearchItemsBtn" for="searchTbx"><i class="fa fa-caret-down"></i></label>
                    <button type="button" id="getNextItemBtn" class="btn btn-search-next" data-bind="disabled: navigating, enabled: equals(filterGroup, 'HEAT')," title="<asp:Localize    runat=server    meta:resourcekey=next_process_btn_title />"><i class="fa fa-play"></i></button>
                    <button type="button" class="btn" data-bind="clickSet: 'heatId', clickSetValue: -1, enabled: all(equals(filterGroup, 'HEAT'), not(navigating))," title="<asp:Localize         runat=server meta:resourcekey=current_process_btn_title />"><i class="fa fa-step-forward"></i></button>
                </div>
            </div>
        </div>
       
        <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
            <input type="checkbox" class="big-checkbox" data-bind="checked: onlyMissing," style="margin-left: 55px;margin-top:-0.5%">
            <span>
                <asp:Localize runat="server" meta:resourcekey="only_missing_label" />
            </span>
        </label>


            
        <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
            <input type="checkbox"  class="big-checkbox" data-bind="checked: eafChecked," style="margin-left: 55px;margin-top:-0.5%">
            <span>
                <asp:Localize runat="server" meta:resourcekey="eaf_label" />
            </span>
        </label>
              
        <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
            <input type="checkbox" class="big-checkbox" data-bind="checked: eafSlagChecked," style="margin-left: 55px;margin-top:-0.5%">
            <span>
                <asp:Localize runat="server" meta:resourcekey="eaf_slag_label" />
            </span>
        </label>
                  
        <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
            <input type="checkbox"  class="big-checkbox" data-bind="checked: lfChecked," style="margin-left: 55px;margin-top:-0.5%">
            <span>
                <asp:Localize runat="server" meta:resourcekey="lf_label" />
            </span>
        </label>      
        
        <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
            <input type="checkbox"  class="big-checkbox" data-bind="checked: lfSlagChecked," style="margin-left: 55px;margin-top:-0.5%">
            <span>
                <asp:Localize runat="server" meta:resourcekey="lf_slag_label" />
            </span>
        </label>
        
        <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
            <input type="checkbox"  class="big-checkbox" data-bind="checked: licoChecked," style="margin-left: 55px;margin-top:-0.5%">
            <span>
                <asp:Localize runat="server" meta:resourcekey="lico_label" />
            </span>
        </label>

        
        <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
            <input type="checkbox"  class="big-checkbox"data-bind="checked: vtdChecked," style="margin-left: 55px;margin-top:-0.5%">
            <span>
                <asp:Localize runat="server" meta:resourcekey="vtd_label" />
            </span>
        </label>

        <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;">
            <input type="checkbox" class="big-checkbox" data-bind="checked: casterChecked," style="margin-left: 55px;margin-top:-0.5%">
            <span>
                <asp:Localize runat="server" meta:resourcekey="caster_label" />
            </span>
        </label>




        <button id="refreshBtn" class="btn btn-primary" style="margin-left:10px;" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
            <i class="fa fa-refresh"></i>
        </button>
    </div>
</div>
<div class="row-fluid screen-content">
   
    <div class="row-fluid" style="margin-top:0.5% !important;">
   
        <div class="span3">
             <div class="span1">
                <i class="fa fa-times no-samples-bullet"></i>
            </div>
            <div class="span2">
               <asp:Localize runat="server" meta:resourcekey="no_samples" />
            </div>
            <div class="span1">
                <i class="fa fa-check one-samples-bullet "></i>
            </div>   
            <div class="span4">
               <asp:Localize runat="server" meta:resourcekey="one_samples" />
            </div>
            <div class="span1">
                <i class="fa fa-check two-samples-bullet"></i>
            </div>
            <div class="span1">
               <asp:Localize runat="server" meta:resourcekey="two_samples" />
            </div>
        </div>
        
    </div>
    <div class="items-grid-container infinite-container"></div>
</div>