-------------
-- ROLES
-------------
	USE [IHBoxSystem]
	GO
	CREATE ROLE eafelectrodeevents_read AUTHORIZATION dbo 
	GO  

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'eafelectrodeevents_read', 'admin'
	GO

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'eafelectrodeevents_read', 'SDI/australtek'
	GO


	CREATE ROLE eafelectrodeevents_readWrite AUTHORIZATION dbo 
	GO  

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'eafelectrodeevents_readWrite', 'admin'
	GO

	USE [IHBoxSystem]
	GO
	EXEC sp_addrolemember 'eafelectrodeevents_readWrite', 'SDI/australtek'
	GO


-------------------
-- Menu and Route
-------------------
	declare @parent int, @result_routeId INT
	select @parent=id from [FrontEnd].[Menu] where [Name] = 'EAF' and Parent is null

	INSERT INTO [FrontEnd].[Routes]
			   ([Route]
			   ,[ModuleName]
			   ,[ModulePath]
			   ,[RequiredRole]
		   )
		 VALUES 
			   (
			   '!/eaf-electrode-events(/:start)(/:end)(/:furnaceCode)(/:eventCode)(/:phaseCode)(/)'
			   , 'eaf-electrode-events'
			   , 'custom-screens/eaf-electrode-events/'
			   , 'eafelectrodeevents_read'           
			   )
			   SET @result_routeId = @@IDENTITY
	INSERT INTO [FrontEnd].[Menu]
			   ([Parent]
			   ,[Name]
			   ,[RouteID]
			   ,[SortOrder]
			   ,[Enabled]
			   ,[Visible]
			   ,[RequiredRole]
			   ,[Group]
			  )
		 VALUES
			   (
			   @parent
			   ,'Electrode Events'
			   ,@result_routeId 
			   ,1
			   ,1
			   ,1
			   ,'eafelectrodeevents_read'
			   ,NULL
			 )
	GO


-------------------
-- SP Permissions
-------------------
GO

EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [eafelectrodeevents_read] -- The role
,@name = N'securedsp-EAF.GetElectrodeEventsWeb' -- the procedure
,@value = N'' 
GO


EXECUTE sys.sp_addextendedproperty 
@level0type = N'USER' -- The object type
,@level0name = [eafelectrodeevents_readWrite] -- The role
,@name = N'securedsp-EAF.GetElectrodeEventsWeb' -- the procedure
,@value = N'' 
GO

-------------------
--	Profiles
-------------------
	USE [IHBoxSystem]
	GO

	DECLARE @ModuleId INT

	INSERT INTO [SECURITY].[Modules]([Code],[Name])
	VALUES('caster_production','EAF Electrode Events')

	SET @ModuleId = @@IDENTITY

	INSERT INTO [SECURITY].[ModuleActions]([ModuleId],[Code],[Name],[Role])
	VALUES(@ModuleId,'readWrite','Read/Write','eafelectrodeevents_readWrite')


	INSERT INTO [SECURITY].ModuleActions(ModuleId,Code,[Name],[Role])
	VALUES (@ModuleId,'read','Read','eafelectrodeevents_read')


