﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();

    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css")%>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/valid-limit-cell/backgrid-valid-limit-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />




<div class="row-fluid subnavbar fixed-subnavbar" style="margin-bottom: 0px;">
    <div class="row-fluid form-inline">
        <div class="span10">
            <label class="control-label" for="dateStartTbx">
                <asp:localize runat="server" meta:resourcekey="date_start_tbx_label" />
            </label>
            <label class="input-prepend">
                <span class="add-on"><i class="icon-calendar"></i></span>
                <input type="text" id="dateStartTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(start$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
            </label>
            <label class="control-label" for="dateEndTbx">
                <asp:localize runat="server" meta:resourcekey="date_end_tbx_label" />
            </label>
            <label class="input-prepend">
                <span class="add-on"><i class="icon-calendar"></i></span>
                <input type="text" id="dateEndTbx" class="input-date" style="z-index:1000;" data-bind="value: momentFormat(end$, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />')">
            </label>
            <label style="margin-left:10px;margin-bottom:0 !important; ">
                <asp:Localize runat="server" meta:resourcekey="furnace_label" /> 
                    <select data-bind=" value: furnaceCode, options: furnaces, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_furnace_label />', value: null }" style="width:100px;margin-top:0px;">
                    </select>
            </label>
            <label style="margin-left:10px;margin-bottom:0 !important; ">
                <asp:Localize runat="server" meta:resourcekey="crew_label" /> 
                    <select data-bind=" value: crewId, options: crews, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_crew_label />', value: null }" style="width:100px;margin-top:0px;">
                    </select>
            </label>
            <label style="margin-left:10px;margin-bottom:0 !important; ">
                <asp:Localize runat="server" meta:resourcekey="grade_label" /> 
                    <select data-bind=" value: gradeId, options: grades, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_grades_label />', value: null }" style="width:150px;margin-top:0px;">
                    </select>
            </label>

           <%-- <label style="margin-left:10px;margin-bottom:0 !important; ">
                <asp:Localize runat="server" meta:resourcekey="shift_label" /> 
                    <select data-bind=" value: shiftId, options: shifts, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_shift_label />', value: null }" style="width:100px;margin-top:0px;">
                    </select>
            </label>
            <label class="checkbox inline" style="display:inline-block;position:relative;top:-2px;margin-left: 10px;">
                <input type="checkbox" data-bind="checked: showHighTemps" />
                <span>
                    <asp:Localize runat="server" meta:resourcekey="show_tap_temps_label" />
                </span>
            </label>--%>

        </div>
        <div class="span2">
            <button style="margin-top:0; margin-left:10px; margin-right:10px;" class="btn btn-export-to-excel pull-right" type="button">
                <span class="excel-export-state fa fa-file-excel-o"></span>
                <img class="loading-state hide" style="width:20px;height:20px;" src="<%= ResolveUrl("~/assets/img/spinner20.gif") %>" />
            </button>
            <button id="refreshBtn" class="btn btn-primary pull-right" style="" title="<asp:localize runat=server meta:resourcekey=refresh_btn_title />">
                <i class="fa fa-refresh"></i>
            </button>
            
        </div>
        
    </div>
</div>
<div class="row-fluid screen-content">
    <div class="pull-left" style="width:100%;margin-left:0;">  
        <div class="processes-grid-container infinite-container" style="margin-top:20px"></div>
        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: any(hasData, isLoading), }" style="height:500px;">
            <div class="row-fluid" style="position:relative;top:100px;">
                <i class="fw-icon-circle-blank fw-icon-4x" style="font-size:115px;"></i>
            </div>
            <div class="row-fluid" style="position:relative;top:115px;">
                <h3 style="font-size:50px;">
                    <asp:localize runat="server" meta:resourcekey="no_data_available" />
                </h3>
            </div>
        </div>
        <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(isLoading), }" style="height:500px;">
            <div class="row-fluid" style="position:relative;top:100px;">
                <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
            </div>
            <div class="row-fluid" style="position:relative;top:115px;">
                <h3 style="font-size:50px;">
                    <asp:localize runat="server" meta:resourcekey="loading_data" />
                </h3>
            </div>
        </div>
    </div>


</div>