﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>

<script runat="server">
    //@Override this is suggested by Microsoft, overriding the initialize culture function (that is
    //automatically called by the aspx.
    //Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
    //(English).
    protected override void InitializeCulture()
    {
        HttpCookie lang = Request.Cookies["siteLanguage"];

        String selectedLanguage = (lang != null) ? lang.Value : "en";
        UICulture = selectedLanguage;
        Culture = selectedLanguage;

        Thread.CurrentThread.CurrentCulture = CultureInfo.CreateSpecificCulture(selectedLanguage);
        Thread.CurrentThread.CurrentUICulture = new CultureInfo(selectedLanguage);
        base.InitializeCulture();
    }
</script>

<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).

    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/add-row-cell/backgrid-add-row-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/extensions/button-cell/backgrid-button-cell.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/jquery.timepicker/jquery.timepicker.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/app/custom-screens/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + "/" + Path.GetFileNameWithoutExtension(this.Request.PhysicalPath) + ".css")%>" rel="stylesheet" />

{{#if mainView}}
<div class="row-fluid subnavbar fixed-subnavbar" data-bind="classes: { 'current-process': process_isCurrentProcess }">
    <div class="row-fluid form-inline">
        <label class="control-label" for="searchTbx">
            <asp:localize runat="server" meta:resourcekey="process_picker_label" />
        </label>
        <div class="input-prepend input-append">
            <button type="button" id="getPreviousItemBtn" class="btn btn-search-prev" data-bind="disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=previous_process_btn_title />"><i class="fa fa-play fa-rotate-180"></i></button>
            <input type="text" id="searchTbx" style="width:100px;" data-bind="value: trim(search), events: ['change', 'keydown',]" placeholder="<asp:Localize runat=server meta:resourcekey=process_picker_place_holder />" data-select-on-focus/>
            <label class="btn btn-search-show" id="showSearchItemsBtn" for="searchTbx"><i class="fa fa-caret-down"></i></label>
            <button type="button" id="getNextItemBtn" class="btn btn-search-next" data-bind="disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=next_process_btn_title />"><i class="fa fa-play"></i></button>
            <button type="button" class="btn" data-bind="clickSet: 'processId', clickSetValue: -1, disabled: navigating," title="<asp:Localize runat=server meta:resourcekey=current_process_btn_title />"><i class="fa fa-step-forward"></i></button>
        </div>
        <label class="control-label" style="font-weight:bold;">
            <asp:localize runat="server" meta:resourcekey="process_info_ladle_furnace_label" />
            <span class="input-static" data-bind="text: coalesce(trim(ladleFurnaceName), '<asp:localize runat=server meta:resourcekey=no_value_legend />'),"></span>
            <%--<span class="input-static" data-bind="text: select(process_id, trim(process_ladleFurnaceName), '<asp:localize runat=server meta:resourcekey=loading_process_info_legend />'),"></span>--%>
        </label>
<%--        <label class="control-label" style="font-weight:bold;">
            <asp:localize runat="server" meta:resourcekey="process_info_lf_heats_count_label" />
            <span class="input-static" data-bind="text: select(process_id, trim(process_lfHeatsCount), '<asp:localize runat=server meta:resourcekey=loading_process_info_legend />'),"></span>
        </label>--%>
        <button type="button" class="btn btn-primary btn-ship pull-right" data-bind="disabled: notEquals(process_heatStatusCode, 'INLF')," style="margin-right:10px;" title="<asp:Localize runat=server meta:resourcekey=ship_btn_title />"><i class="fa fa-sign-out"></i></button>
        <button type="button" class="btn btn-primary btn-arrive pull-right" style="margin-right:10px;" title="<asp:Localize runat=server meta:resourcekey=arrive_btn_title />"><i class="fa fa-sign-in"></i></button>
        <a class="delays-anchor-link" data-bind="text: format('<asp:localize runat=server meta:resourcekey=delay_not_declared_label />', delaysNotDeclaredCount), classes: { hide: not(delaysNotDeclaredCount) },"></a>
    </div>
</div>
{{/if}}

<div class="row-fluid screen-content" data-bind="classes: { 'edition-disabled': not(editingProcess), },">
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(all(userHasAccess, any(isLoadingProcess, all(mainView, notEquals(process_ladleFurnaceCode, ladleFurnaceCode))))), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-cog fw-icon-4x fa-spin" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;">
                <asp:localize runat="server" meta:resourcekey="loading_data" />
            </h3>
        </div>
    </div>
    <div class="no-data-poster row-fluid text-center animated fadeIn" data-bind="classes: { hide: not(all(mainView, not(userHasAccess))), }" style="height:500px;">
        <div class="row-fluid" style="position:relative;top:100px;">
            <i class="fa fa-times" style="font-size:115px;"></i>
        </div>
        <div class="row-fluid" style="position:relative;top:115px;">
            <h3 style="font-size:50px;" data-bind="text: format('<asp:localize runat=server meta:resourcekey=no_user_access_ladle_furnace />', coalesce(trim(ladleFurnaceName), '<asp:localize runat=server meta:resourcekey=no_value_legend />'))">
            
            </h3>
        </div>
    </div>
    <div class="row-fluid process-info-container" data-bind="classes: { hide: not(all(userHasAccess, not(isLoadingProcess), any(not(mainView), equals(process_ladleFurnaceCode, ladleFurnaceCode)))), },">
        <div class="form-horizontal process-info-form process-info-form-1 pull-left">
            <div class="row-fluid">
                <h4 class="heat-number-container pull-left" data-bind="text: format('<asp:Localize runat=server meta:resourcekey=process_info_title /> $1', coalesce(trim(process_heatNameTreatment), '<asp:localize runat=server meta:resourcekey=no_value_legend />')),"></h4>
                <%--<div class="pull-left" style="margin:3px 0 0 0;width:120px;text-align:center;">
                    <button class="btn btn-default" data-bind="clickSet: 'editingProcess', clickSetValue: true, classes: { hide: not(not(editingProcess)), }">
                        <i class="fa fa-edit"></i>
                    </button>
                    <div class="row-fluid" data-bind="classes: { hide: not(editingProcess), }">
                        <button id="acceptProcessEditionBtn" class="btn btn-success" style="margin-right:5px;" >
                            <i class="fa fa-check"></i>
                        </button>
                        <button id="cancelProcessEditionBtn" data-bind="clickSet: 'editingProcess', clickSetValue: false," style="margin-left:5px;" class="btn btn-default">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                </div>--%>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_initial_grade_label /></span>
                    <select class="process-info-field-value" style="width:140px;" data-bind="value: integer(process_initialGradeId), options: select(process_id, grades, []), optionsEmpty: { label: '<asp:localize runat=server meta:resourcekey=grades_combo_empty_opt />', value: 0 }, enabled: all(process_id, hasGrades), classes: { hide: not(editingProcess), },"></select>
                    <span class="process-info-field-value" data-bind="text: coalesce(trim(process_initialGradeName), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label-long-text"><asp:Localize runat=server meta:resourcekey=process_info_grade_label /></span>
                    <select class="process-info-field-value" style="width:140px;" data-bind="value: integer(process_gradeId), options: select(process_id, grades, []), optionsEmpty: { label: '<asp:localize runat=server meta:resourcekey=grades_combo_empty_opt />', value: 0 }, enabled: all(process_id, hasGrades), classes: { hide: not(editingProcess), },"></select>
                    <span class="process-info-field-value" data-bind="text: coalesce(trim(process_gradeName), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_ladle_label /></span>
                    <select class="process-info-field-value" style="width:140px;" data-bind="value: integer(process_ladleId), options: select(process_id, select(notEquals(process_ladleId, -1), ladles, concatArrays([{ label: '<asp:localize runat=server meta:resourcekey=ladles_combo_unknown_opt />', value: -1 }], ladles)), []), optionsEmpty: { label: '<asp:localize runat=server meta:resourcekey=ladles_combo_empty_opt />', value: 0 }, enabled: all(process_id, hasLadles), classes: { hide: not(editingProcess), },"></select>
                    <span class="process-info-field-value" data-bind="text: coalesce(trim(process_ladleName), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                    <i class="fa fa-lock manual-lock-btn" data-variable-name="LADLE" data-bind="classes: { hide: not(contains({ name: 'LADLE', }, process_manualVariables)), }," title="<asp:Localize runat=server meta:resourcekey=manual_lock_btn_title />"></i>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_operator_label /></span>
                    <select class="process-info-field-value" style="width:140px;" data-bind="value: integer(process_operatorId), options: select(process_id, operators, []), optionsEmpty: { label: '<asp:localize runat=server meta:resourcekey=operators_combo_empty_opt />', value: 0 }, enabled: all(process_id, hasOperators), classes: { hide: not(editingProcess), },"></select>
                    <span class="process-info-field-value" data-bind="text: coalesce(trim(process_operatorName), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                </div>
            </div>
        </div>
        <div class="form-horizontal process-info-form process-info-form-2 pull-left">
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_start_label /></span>
                    <input type="text" class="process-info-field-value input-date" data-bind="value: coalesce(momentFormat(process_startDate, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />'), ''), classes: { hide: not(editingProcess), }," placeholder="<asp:Localize runat=server meta:resourcekey=mmddyyyy_display />" data-select-on-focus/>
                    <input type="text" class="process-info-field-value input-time" data-bind="value: coalesce(process_startTime, ''), classes: { hide: not(editingProcess), }, events: ['changeTime',]," placeholder="<asp:Localize runat=server meta:resourcekey=hhmmss_display />" data-select-on-focus maxlength="8"/>
                    <span class="process-info-field-value" data-bind="text: coalesce(momentFormat(process_start, 'YYYY-MM-DD HH:mm:ss.SSS', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format /> HH:mm:ss'), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                    <i class="fa fa-lock manual-lock-btn" data-variable-name="START" data-bind="classes: { hide: not(contains({ name: 'START', }, process_manualVariables)), }," title="<asp:Localize runat=server meta:resourcekey=manual_lock_btn_title />"></i>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_end_label /></span>
                    <input type="text" class="process-info-field-value input-date" data-bind="value: coalesce(momentFormat(process_endDate, 'YYYY-MM-DD', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format />'), ''), classes: { hide: not(editingProcess), }," placeholder="<asp:Localize runat=server meta:resourcekey=mmddyyyy_display />" data-select-on-focus/>
                    <input type="text" class="process-info-field-value input-time" data-bind="value: coalesce(process_endTime, ''), classes: { hide: not(editingProcess), }, events: ['changeTime', ]," placeholder="<asp:Localize runat=server meta:resourcekey=hhmmss_display />" data-select-on-focus maxlength="8"/>
                    <span class="process-info-field-value" data-bind="text: coalesce(momentFormat(process_end, 'YYYY-MM-DD HH:mm:ss.SSS', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format /> HH:mm:ss'), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                    <i class="fa fa-lock manual-lock-btn" data-variable-name="END" data-bind="classes: { hide: not(contains({ name: 'END', }, process_manualVariables)), }," title="<asp:Localize runat=server meta:resourcekey=manual_lock_btn_title />"></i>
                </div>
            </div>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_power_on_label /></span>
                    <input type="text" class="process-info-field-value input-duration-small" data-mask="#0:00" data-mask-reverse="true" data-bind="value: duration(process_powerOn$, 's', 'm:s'), classes: { hide: not(editingProcess), }," data-select-on-focus/>
                    <span class="process-info-field-value" data-bind="text: coalesce(duration(process_powerOn$, 's', 'm:s'), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                    <i class="fa fa-lock manual-lock-btn" data-variable-name="POWERON" data-bind="classes: { hide: not(contains({ name: 'POWERON', }, process_manualVariables)), }," title="<asp:Localize runat=server meta:resourcekey=manual_lock_btn_title />"></i>
                    <span class="process-info-field-unit"><asp:Localize runat=server meta:resourcekey=process_info_power_on_unit_legend /></span>
                </div>
            </div>
            <%--<div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_power_off_label /></span>
                    <span class="process-info-field-value" data-bind="text: coalesce(duration(process_powerOff, 's', 'm:s'), '<asp:localize runat=server meta:resourcekey=no_value_legend />'),"></span>
                    <span class="process-info-field-unit"><asp:Localize runat=server meta:resourcekey=process_info_power_off_unit_legend /></span>
                </div>
            </div>--%>
            <div class="process-info-row">
                <div class="process-info-group">
                    <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_energy_label /></span>
                    <input type="text" class="process-info-field-value input-mini" data-bind="valueLockFocus: decimalFixed(process_energy, 2), classes: { hide: not(editingProcess), }," data-select-on-focus/>
                    <span class="process-info-field-value" data-bind="text: coalesce(decimalFixed(process_energy, 2), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                    <i class="fa fa-lock manual-lock-btn" data-variable-name="ENERGY" data-bind="classes: { hide: not(contains({ name: 'ENERGY', }, process_manualVariables)), }," title="<asp:Localize runat=server meta:resourcekey=manual_lock_btn_title />"></i>
                    <span class="process-info-field-unit"><asp:Localize runat=server meta:resourcekey=process_info_energy_unit_legend /></span>
                </div>
            </div>
        </div>
        <div class="process-info-form-3 pull-left">
            <div class="form-horizontal row-fluid process-info-form" style="margin-left:0;width:90%;">
                <div class="row-fluid process-info-row">
                    <div class="row-fluid process-info-group" style="height:auto;">
                        <span class="process-info-field-label"><asp:Localize runat=server meta:resourcekey=process_info_comments_label /></span>
                        <textarea class="row-fluid" maxlength="200" style="height:45px;" data-bind="value: trim(process_comments), classes: { hide: not(editingProcess), },"></textarea>
                        <span class="row-fluid process-info-field-value-text-area" style="height:45px;" data-bind="text: select(trim(process_comments), trim(process_comments), '<asp:localize runat=server meta:resourcekey=no_value_legend />'), classes: { hide: not(not(editingProcess)), },"></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="process-info-form-4 pull-left">
            <h5 class="row-fluid"><asp:Localize runat=server meta:resourcekey=process_consumptions_title /></h5>
            <div class="process-consumptions-grid-container"></div>
        </div>
    </div>
    <div class="grids-containers row-fluid" data-bind="classes: { hide: not(all(userHasAccess, not(isLoadingProcess), any(not(mainView), equals(process_ladleFurnaceCode, ladleFurnaceCode)))), },">
        <div class="row-fluid" style="margin-top:10px;">
            <div class="pull-left" style="width:32%;">
                <h5 class="grid-title"><asp:Localize runat=server meta:resourcekey=process_temperatures_title /></h5>
                <i class="fa fa-lock manual-lock-btn" data-bind="classes: { hide: not(contains({ name: 'TEMPERATURES', }, process_manualVariables)), },"></i>
                <div class="process-temperatures-grid-container"></div>
            </div>
            <div class="pull-left" style="width:26%;margin-left:2.5%;">
                <h5 class="grid-title"><asp:Localize runat=server meta:resourcekey=process_additions_title /></h5>
                <i class="fa fa-lock manual-lock-btn" data-bind="classes: { hide: not(contains({ name: 'ADDITIONS', }, process_manualVariables)), },"></i>
                <div class="process-additions-grid-container"></div>
            </div>
            <div class="pull-left" style="width:37%;margin-left:2.5%;">
                <h5 class="grid-title"><asp:Localize runat=server meta:resourcekey=process_heatings_title /></h5>
                <i class="fa fa-lock manual-lock-btn" data-bind="classes: { hide: not(contains({ name: 'HEATINGS', }, process_manualVariables)), },"></i>
                <div class="process-heatings-grid-container"></div>
            </div>
        </div>
    </div>
    <div class="delays-container row-fluid delays-anchor-target" data-bind="classes: { hide: not(all(userHasAccess, not(isLoadingProcess), any(not(mainView), equals(process_ladleFurnaceCode, ladleFurnaceCode)))), },">
        <h5><asp:Localize runat=server meta:resourcekey=process_delays_title /></h5>
        <div class="delays-grid-container row-fluid">
    </div>
    {{#if displayChemistry}}
    <div class="row-fluid" data-bind="classes: { hide: not(all(userHasAccess, not(isLoadingProcess), any(not(mainView), equals(process_ladleFurnaceCode, ladleFurnaceCode)))), }," style="margin-top:30px;">
        <div class="chemistry-samples-info-container row-fluid" style="overflow-x:auto;"></div>
    </div>
    {{/if}}
</div>

<script id="actions_header_cell_template" type="text/x-handlebars-template">
    <button data-toggle="tooltip" data-placement="bottom" data-cell-action="NEW" title="<asp:Localize runat=server meta:resourcekey=grid_new_btn_title />" class="btn btn-cell-action btn-small btn-new"><i class="fa fa-plus"></i></button>
</script>

<script id="actions_cell_template" type="text/x-handlebars-template">
    <button data-toggle="tooltip" data-placement="bottom" data-cell-action="SAVE" title="<asp:Localize runat=server meta:resourcekey=grid_save_btn_title />" class="btn btn-small btn-cell-action btn-save hide" style="margin-right:2px;"><i class="fa fa-floppy-o"></i></button>
    <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DISCARD" title="<asp:Localize runat=server meta:resourcekey=grid_discard_btn_title />" class="btn btn-small btn-cell-action btn-discard hide"><i class="fa fa-times"></i></button>
    <button data-toggle="tooltip" data-placement="bottom" data-cell-action="DELETE" title="<asp:Localize runat=server meta:resourcekey=grid_remove_btn_title />" class="btn btn-small btn-cell-action btn-remove"><i class="fa fa-trash-o"></i></button>
</script>

<script id="arrive_heat_modal_template" type="text/x-handlebars-template">

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
    <h3><asp:Localize runat="server" meta:resourcekey="arrive_heat_modal_title" /></h3>
</div>
<div style="max-height:500px;" class="modal-body">
    <div class="row-fluid">
        <h2 data-bind="classes: { hide: not(not(hasHeats)), }" style="text-align:center;">
            <asp:localize runat="server" meta:resourcekey="arrive_heat_modal_no_heats_legend" />
        </h2>
        <form class="form-horizontal form-data" data-bind="classes: { hide: not(hasHeats), }">
            <div class="control-group">
                <label class="control-label" style="font-weight:bold;">
                    <asp:localize runat="server" meta:resourcekey="arrive_heat_modal_heat_label" />
                </label>
                <div class="controls">
                    <select class="input-large autofocus" data-bind="value: integer(heatId), options: heatsCombo, optionsEmpty: { label: '<asp:localize runat=server meta:resourcekey=heat_combo_empty_opt />', value: 0 }, enabled: hasHeats," style="width:250px;"></select>
                </div>
            </div>
            <div class="form-data-row">
                <div class="form-data-group">
                    <span class="form-data-field-label"><asp:Localize runat=server meta:resourcekey=arrive_heat_modal_prev_equipment_label />:</span>
                    <span class="form-data-field-value" data-bind="text: coalesce(prop(heat, 'previousEquipmentName'), '-'),"></span>
                </div>
                <div class="form-data-group">
                    <span class="form-data-field-label"><asp:Localize runat=server meta:resourcekey=arrive_heat_modal_status_label />:</span>
                    <span class="form-data-field-value" data-bind="text: coalesce(prop(heat, 'statusName'), '-'),"></span>
                </div>
            </div>
            <div class="form-data-row">
                <div class="form-data-group">
                    <span class="form-data-field-label"><asp:Localize runat=server meta:resourcekey=arrive_heat_modal_grade_label />:</span>
                    <span class="form-data-field-value" data-bind="text: coalesce(prop(heat, 'gradeName'), '-'),"></span>
                </div>
                <div class="form-data-group">
                    <span class="form-data-field-label"><asp:Localize runat=server meta:resourcekey=arrive_heat_modal_ship_timestamp_label />:</span>
                    <span class="form-data-field-value" data-bind="text: select(prop(heat, 'shipTimestamp'), momentFormat(prop(heat, 'shipTimestamp'), 'YYYY-MM-DD HH:mm:ss.SSS', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format /> HH:mm:ss'), '-'),"></span>
                </div>
            </div>
            <div class="form-data-row">
                <div class="form-data-group">
                    <span class="form-data-field-label"><asp:Localize runat=server meta:resourcekey=arrive_heat_modal_ladle_label />:</span>
                    <span class="form-data-field-value" data-bind="text: coalesce(prop(heat, 'ladleName'), '-'),"></span>
                </div>
                <div class="form-data-group">
                    <span class="form-data-field-label"><asp:Localize runat=server meta:resourcekey=arrive_heat_modal_start_tap_timestamp_label />:</span>
                    <span class="form-data-field-value" data-bind="text: select(prop(heat, 'startTapTimestamp'), momentFormat(prop(heat, 'startTapTimestamp'), 'YYYY-MM-DD HH:mm:ss.SSS', '<asp:Localize runat=server meta:resourcekey=mmddyyyy_format /> HH:mm:ss'), '-'),"></span>
                </div>
            </div>
        </form>
    </div>
</div>
<div class="modal-footer">
    <div class="modal-status-msg-container pull-left">
        <div class="modal-status-msg hide" data-bind="toggle: notEquals(errorMsg, ''),">
            <span data-bind="text: errorMsg, attr: { title: errorMsg, }," style="color:#ff0000;font-size:16px;"></span>
        </div>
        <div class="modal-status-msg hide" data-bind="toggle: processing,">
            <asp:Localize runat='server' meta:resourcekey='arrive_heat_modal_processing_msg' />
            <i class="fa fa-cog fa-spin"></i>
        </div>
    </div>
    <button id="acceptBtn" data-bind="enabled: all(heatId, notEquals(processing, true))," class="btn btn-primary">
        <asp:Localize runat='server' meta:resourcekey='arrive_heat_modal_accept_btn_label' />
    </button>
    <button data-bind="enabled: notEquals(processing, true)" class="btn" data-dismiss="modal">
        <asp:Localize runat='server' meta:resourcekey='arrive_heat_modal_cancel_btn_label' />
    </button>
</div>

</script>