﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<script id="main_template" type="text/x-handlebars-template">

<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />

<style>
    select.select-mini {
        height: auto;
        line-height: 14px;
        /*padding-right: 16px;*/
        width:120px;
    }
</style>

<div class="container-fluid">
    <div class="row-fluid">
        <div class="span4">
            <h5><asp:Localize runat="server" meta:resourcekey="lines_and_products_title" /></h5>
            <div style="margin-bottom:5px;">
                <select data-bind="value: integer(productId), options: products, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_option_label />', value: -1 }" class="select-mini inline"></select>
                <button style="top:-5px;position:relative;" disabled="disabled" class="btn btn-add-product-to-line btn-small"><asp:Localize runat="server" meta:resourcekey="add_product_to_line_label" /></button>
            </div>
            <div style="height:500px;overflow-y:auto;" class="tree">
            </div>
        </div>
        <div class="span8">
            <div class="product-configuration-container row-fluid">
            </div>
        </div>
    </div>
</div>

</script>

<script id="machine_configuration" type="text/x-handlebars-template">
    <link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />

    <style>
        .backgrid th{
            font-size:12px !important;
        }

        .backgrid tr{
            font-size:12px !important;
        }

        .backgrid tr td{
            overflow:visible !important; 
        }

        .backgrid tr td button{
            font-size:12px !important;
        }

        .backgrid td {
            width:150px !important; 
        }

        .blocker {
            position:absolute;
            top:0; 
            left:0; 
            width:100%;
            height:100%;
            background-color:#ccc; 
            opacity:0.4;
            z-index:99999999; 
        }
    </style>

    <div class="container-fluid">
        <h4><asp:Localize runat="server" meta:resourcekey="product_label" /> {{name}}</h4>
        <hr />
        <div data-bind="toggle: hasBatchOpened" class="row-fluid batch-opened-message">
            <div class="alert alert-info">
                <span>
                    <asp:Localize runat="server" meta:resourcekey="batch_opened_on_machine_msg" />
                </span>
            </div>
        </div>
        <div style="position:relative;" class="row-fluid">
            <div data-bind="toggle: hasBatchOpened" class="blocker"></div>
            <div class="row-fluid">
                <div class="row-fluid">
                    <h4>Configuración General</h4>
                </div>
                <div class="row-fluid">
                    <form class="form-horizontal">
                        <div class="control-group">
                            <label class="control-label" for="setpointOEE"><asp:Localize runat="server" meta:resourcekey="line_product_oee_setpoint_label" /></label>
                            <div class="controls">
                                <input data-bind="value: integer(setpointOEE)" id="setpointOEE" type="text" class="input-mini">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <hr />
            <div class="row-fluid">
                <h4>Configuración por Máquina</h4>
                <div class="product-machine-configurations-grid span12">
                </div>
            </div>
        </div>
    </div>
</script>