﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<script id="main_template" type="text/x-handlebars-template"> 

    <link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/libs/js/bootstrap-colorpicker/css/bootstrap-colorpicker.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/libs/js/perfect-scrollbar/css/perfect-scrollbar.min.css") %>" rel="stylesheet" />

    <style>
        .ui-datepicker {
            z-index:1052 !important;
        }

        .card {
            border: .0625rem solid #e5e5e5;border-radius: .25rem;padding:1.25rem;
        }

        .clickeable-row{
            cursor:pointer; 
        }

        .backgrid tr.disabled-row {
            background-color:rgba(238, 238, 238, 1);
            color:rgba(153, 153, 153, 1); 
        }

        .backgrid tbody tr.disabled-row:hover > td,
        .backgrid tbody tr.disabled-row:hover > th {
            background-color:rgba(238, 238, 238, 1);
            color:rgba(153, 153, 153, 1); 
        }

        .backgrid tr.selected {
            background-color:#b4e8ff;
        }

        .backgrid tbody tr.selected:hover > td,
        .backgrid tbody tr.selected:hover > th {
          background-color: #b4e8ff;
        }

        /*.backgrid tbody tr:hover > td,
        .backgrid tbody tr:hover > th {
          background-color: #b4e8ff;
        }*/

        .backgrid th{
            font-size:12px !important;
        }

        .backgrid tr{
            font-size:12px !important;
        }

        .backgrid td.actions-cell {
            width:30px !important;
        }

        .backgrid td {
            width:150px !important; 
        }

            .backgrid tr td button{
                font-size:12px !important;
            }

        .span-color-picker-cell > i{
            border:1px solid #000000; 
        }

        .span-color-picker-cell {
            margin-left:0px !important;
        }

        .inline {
            display:inline-block;
        }

        .shifts-grid-container {
            max-height:190px;
            min-height:190px;
            overflow-y:auto;
            position:relative;
        }
    </style>

    <div class="row-fluid">
        <div class="row-fluid">
            <div class="card">
                <div class="row-fluid" style="min-height:40px;">
                    <button class="btn btn-medium btn-add-shift"><asp:Localize runat="server" meta:resourcekey="add_shift_label" /></button>
                    <form class="add-shift-form form-horizontal hide">
                        <div class="control-group pull-left" style="margin-bottom:5px;">
                            <label style="width:auto;" class="control-label"><asp:Localize runat="server" meta:resourcekey="shift_name_label" /></label>
                            <div style="margin-left:0;float:left;" class="controls">
                                <input required="required" style="margin-left:4px;" class="input input-medium input-shift-name" type="text" placeholder="<asp:Localize runat="server" meta:resourcekey="shift_name_placeholder" />" />
                            </div>
                        </div>
                        <div style="margin-left:5px;" class="buttons-section pull-left">
                            <button data-loading-text="<asp:Localize runat="server" meta:resourcekey="add_shift_loading_state" />" type="submit" class="btn btn-primary btn-add-shift-final"><asp:Localize runat="server" meta:resourcekey="add_shift_btn_label" /></button>
                            <button type="button" class="btn btn-cancel-add-shift"><asp:Localize runat="server" meta:resourcekey="cancel_add_shift_btn_label" /></button>
                        </div>
                    </form>
                    <form class="form-inline pull-right">
                        <div class="control-group">
                            <label class="control-label"><asp:Localize runat=server meta:resourcekey=shifts_timezone_legend />:</label>
                            <span class="controls shifts-timezone-legend"></span>
                        </div>
                    </form>
                </div>
                <hr style="margin: 10px 0;" />
                <div class="row-fluid">
                    <div class="span4">
                        <div class="row-fluid">
                            <h5><asp:Localize runat="server" meta:resourcekey="shifts_title" /></h5>
                            <div class="shifts-grid-container">
                            </div>
                        </div>
                    </div>
                    <div class="span8">
                        <div class="shift-configuration-container"></div>
                    </div>
                </div>
                <div style="margin-top:20px;" class="row-fluid">
                    <div class="row-fluid">
                        <div class="progress-bar-container">
                            <div class="shifts-week-overview-bar progress" style="position:relative;">
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span12 shifts-week-overview-bar-labels" style="position:relative;">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div style="margin-top:5px;" class="row-fluid">
        <div class="card">
            <h4><asp:Localize runat="server" meta:resourcekey="no_activity_days_title" /></h4>
            <div class="inline">
                <button class="btn btn-small btn-add-day"><asp:Localize runat="server" meta:resourcekey="add_day_label" /></button>
                <button class="btn btn-small btn-add-period"><asp:Localize runat="server" meta:resourcekey="add_period_label" /></button>
            </div>
            <div class="row-fluid">
                <div class="no-activity-grid-container"></div>
            </div>
        </div>
    </div>

    <div id="noactivity_actions_cell_template" class="hide template">
        <div class="text-center">
            <button data-preventclick="true" data-toggle="tooltip" data-placement="left" data-cell-action="DELETE" title="<asp:Localize runat=server meta:resourcekey=remove_shift_title />" class="btn btn-cell-action btn-small btn-remove"><i class="fa fa-trash-o"></i></button>
        </div>
    </div>

    <script id="actions_cell_template" type="text/x-handlebars-template">
        <div class="text-center">
            {{HBExp '#if enabled'}}
            <button data-preventclick="true" data-toggle="tooltip" data-placement="left" data-cell-action="DELETE" title="<asp:Localize runat=server meta:resourcekey=remove_shift_title />" class="btn btn-cell-action btn-small btn-remove"><i class="fa fa-trash-o"></i></button>
            {{HBExp 'else'}}
            <button data-preventclick="true" data-toggle="tooltip" data-placement="left" data-cell-action="ENABLE" title="<asp:Localize runat=server meta:resourcekey=enable_shift_title />" class="btn btn-cell-action btn-small btn-enable"><i class="fa fa-undo"></i></button>
            {{HBExp '/if'}}
        </div>
    </script>

</script>

<script id="add_no_activity_period_modal" type="text/x-handlebars-template">
    <div class="modal-header noselect">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat="server" meta:resourcekey="add_no_activity_period_title" /></h3>
    </div>
    <div style="max-height:450px;" class="modal-body noselect">
        {{#if singleDay}}
        <div class="add-day-section">
            <div class="row-fluid text-center" style="margin-top:8px;">
                <div style="position:relative;margin:0 auto;display:inline-block;width:250px;">
                    <div style="width:100px;float:left;text-align:right;">
                        <span style="top:5px;position:relative;"><asp:Localize runat="server" meta:resourcekey="select_date_label" /></span>
                    </div>
                    <div style="width:150px;float:left;" class="from-date-control-container">
                    </div>
                </div>
            </div>
        </div>
        {{else}}
        <div class="add-period-section">
            <div class="row-fluid text-center" style="margin-top:8px;">
                <div style="position:relative;margin:0 auto;width:250px;">
                    <div style="width:65px;float:left;text-align:right;">
                        <span style="top:5px;position:relative;"><asp:Localize runat="server" meta:resourcekey="from_label" /></span>
                    </div>
                    <div style="width:150px;float:left;" class="from-date-control-container">
                    </div>
                </div>
                <div style="position:relative;margin:0 auto;width:250px;top:5px;">
                    <div style="width:65px;float:left;text-align:right;">
                        <span style="top:5px;position:relative;"><asp:Localize runat="server" meta:resourcekey="to_label" /></span>
                    </div>
                    <div style="width:150px;float:left;" class="to-date-control-container">
                    </div>
                </div>
            </div>
        </div>
        {{/if}}
    </div>
    <div class="modal-footer noselect">
        <div class="row-fluid">
            <div class="offset6 span6">
                <div class="span6"> 
                    <button class="btn-add btn btn-block btn-primary"><asp:Localize runat="server" meta:resourcekey="add_label" /></button>
                </div>
                <div class="span6"> 
                    <button class="btn-cancel btn-block btn"><asp:Localize runat="server" meta:resourcekey="cancel_label" /></button>
                </div>
            </div>
        </div>
    </div>
</script>

<script id="disabled_shift_configuration" type="text/x-handlebars-template">
    <div class="row-fluid text-center" style="margin-top:80px;">
        <span style="font-size:18px;"><asp:Localize runat="server" meta:resourcekey="shift_disabled_message" /></span>
    </div>
</script>

<script id="shift_configuration" type="text/x-handlebars-template"> 
    <div class="card">
        <h4></h4>
        <div>
            <label style="position:relative;top:-4px;width:60px;text-align:right;" class="inline"><asp:Localize runat="server" meta:resourcekey="name_label" /></label>
            <input data-bind="value:name" style="margin-left:5px;" class="input-medium" type="text" />
        </div>
        <div class="row-fluid">
            <div class="inline">
                <label style="position:relative;top:-4px;width:60px;text-align:right;" class="inline"><asp:Localize runat="server" meta:resourcekey="from_hour_label" /> </label>
                <div style="margin-left:5px;" class="input-prepend inline">
                    <span class="add-on"><i class="icon-time"></i></span>
                    <input class="input-small from-timepicker" type="text">
                </div>
            </div>
            <div style="margin-left:10px;" class="inline">
                <label style="position:relative;top:-4px;" class="inline"><asp:Localize runat="server" meta:resourcekey="hours_qty_label" /> </label>
                <input data-bind="value:integer(duration)" style="margin-left:5px;" class="input-mini inline" type="text" />
            </div>
        </div>
        <div class="row-fluid">
            <span class="">Días </span>
            <div class="">
                <div>
                    <label class="checkbox inline" style="display:inline-block;margin-left:10px;margin-right:10px;position:relative;width:55px;">
                        <input value="2" data-bind="checked: weekdays" type="checkbox">
                        <span><asp:Localize runat="server" meta:resourcekey="monday_label" /></span>
                    </label>
                    <label class="checkbox inline" style="display:inline-block;margin-left:10px;margin-right:10px;position:relative;width:55px;">
                        <input value="3" data-bind="checked: weekdays" type="checkbox">
                        <span><asp:Localize runat="server" meta:resourcekey="tuesday_label" /></span>
                    </label>
                    <label class="checkbox inline" style="display:inline-block;margin-left:10px;margin-right:10px;position:relative;width:55px;">
                        <input value="4" data-bind="checked: weekdays" type="checkbox">
                        <span><asp:Localize runat="server" meta:resourcekey="wednesday_label" /></span>
                    </label>
                </div>
                <div>
                    <label class="checkbox inline" style="display:inline-block;margin-left:10px;margin-right:10px;position:relative;width:55px;">
                        <input value="5" data-bind="checked: weekdays" type="checkbox">
                        <span><asp:Localize runat="server" meta:resourcekey="thursday_label" /></span>
                    </label>
                    <label class="checkbox inline" style="display:inline-block;margin-left:10px;margin-right:10px;position:relative;width:55px;">
                        <input value="6" data-bind="checked: weekdays" type="checkbox">
                        <span><asp:Localize runat="server" meta:resourcekey="friday_label" /></span>
                    </label>
                    <label class="checkbox inline" style="display:inline-block;margin-left:10px;margin-right:10px;position:relative;width:55px;">
                        <input value="7" data-bind="checked: weekdays" type="checkbox">
                        <span><asp:Localize runat="server" meta:resourcekey="saturday_label" /></span>
                    </label>
                </div>
                <div>
                    <label class="checkbox inline" style="display:inline-block;margin-left:10px;margin-right:10px;position:relative;width:55px;">
                        <input value="1" data-bind="checked: weekdays" type="checkbox">
                        <span><asp:Localize runat="server" meta:resourcekey="sunday_label" /></span>
                    </label>
                </div>
            </div>
        </div>
    </div>    
</script>