﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/app/custom-screens/oee/oee.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/perfect-scrollbar/css/perfect-scrollbar.min.css") %>" rel="stylesheet" />
<link href="<%= ResolveUrl("~/assets/libs/js/backgrid-0.3.5/lib/backgrid.css") %>" rel="stylesheet" />

<style>

    .circle{
        display: inline-block;
        position: relative;
        text-align: center;
    }

    .circle .main-text-centered-in-circle{
        position: absolute;
        top: 35%;
        left: 0;
        width: 100%;
        text-align: center;
    }

    .circle .sub-text-centered-in-circle{
        position: absolute;
        top: 53%;
        left: 0;
        width: 100%;
        text-align: center;
    }

    .backgrid tr.selected {
        background-color:#b4e8ff;
    }

    .backgrid tbody tr.selected:hover > td,
    .backgrid tbody tr.selected:hover > th {
        background-color: #b4e8ff;
    }

    .dashboard-font{
        font-family:'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; 
    }

    .font55{
        font-size:55px;
    }

    .font35 {
        font-size:35px;
    }
    
    .font20 {
        font-size:20px;
    }

    .font15 {
        font-size:15px;
    }

    .time-progressbar-container{
        height:10px; 
        width:100px;
    }

    .separator-bar{
        width:100%;height:2px;background-color:#ccc;margin-top:2px;margin-bottom:2px;
    }

    .production-item-container:hover{
        background-color:#e8e8e8;
    }

    /*.progress {background: rgba(245, 245, 245, 1); border: 0px solid rgba(245, 245, 245, 1); border-radius: 4px; height: 20px;}*/

    .progress .bar-custom-color{background-color:none;background-image:none;background-repeat:initial;filter:initial;}
    .progress .bar-red{background-color:#de2e27;background-image:-moz-linear-gradient(top, #de2e27, #c43c35);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#de2e27), to(#c43c35));background-image:-webkit-linear-gradient(top, #de2e27, #c43c35);background-image:-o-linear-gradient(top, #de2e27, #c43c35);background-image:linear-gradient(to bottom, #de2e27, #c43c35);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#de2e27', endColorstr='#ffc43c35', GradientType=0);}
    .progress .bar-green{background-color:#3aea3a;background-image:-moz-linear-gradient(top, #3aea3a, #57a957);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#3aea3a), to(#57a957));background-image:-webkit-linear-gradient(top, #3aea3a, #57a957);background-image:-o-linear-gradient(top, #3aea3a, #57a957);background-image:linear-gradient(to bottom, #3aea3a, #57a957);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#3aea3a', endColorstr='#ff57a957', GradientType=0);}
    .progress .bar-blue{background-color:#15a1cb;background-image:-moz-linear-gradient(top, #15a1cb, #339bb9);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#15a1cb), to(#339bb9));background-image:-webkit-linear-gradient(top, #15a1cb, #339bb9);background-image:-o-linear-gradient(top, #15a1cb, #339bb9);background-image:linear-gradient(to bottom, #15a1cb, #339bb9);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#15a1cb', endColorstr='#ff339bb9', GradientType=0);}
    .progress .bar-yellow{background-color:#ecee12;background-image:-moz-linear-gradient(top, #ecee12, #f89406);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#ecee12), to(#f89406));background-image:-webkit-linear-gradient(top, #ecee12, #f89406);background-image:-o-linear-gradient(top, #ecee12, #f89406);background-image:linear-gradient(to bottom, #ecee12, #f89406);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#ecee12', endColorstr='#fff89406', GradientType=0);}
    .progress .bar-orange{background-color:#ffae00;background-image:-moz-linear-gradient(top, #ffae00, #fe9b00);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#ffae00), to(#fe9b00));background-image:-webkit-linear-gradient(top, #ffae00, #fe9b00);background-image:-o-linear-gradient(top, #ffae00, #fe9b00);background-image:linear-gradient(to bottom, #ffae00, #fe9b00);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#ffae00', endColorstr='#fffe9b00', GradientType=0);}
    .progress .bar-light-blue{background-color:#0088FF;background-image:-moz-linear-gradient(top, #0088FF, #0c67b7);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#0088FF), to(#0c67b7));background-image:-webkit-linear-gradient(top, #0088FF, #0c67b7);background-image:-o-linear-gradient(top, #0088FF, #0c67b7);background-image:linear-gradient(to bottom, #0088FF, #0c67b7);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#0088FF', endColorstr='#ff0c67b7', GradientType=0);}
    .progress .bar-white{background-color:#FFFFFF;background-image:-moz-linear-gradient(top, #FFFFFF, #FFFFFF);background-image:-webkit-gradient(linear, 0 0, 0 100%, from(#FFFFFF), to(#FFFFFF));background-image:-webkit-linear-gradient(top, #FFFFFF, #FFFFFF);background-image:-o-linear-gradient(top, #FFFFFF, #FFFFFF);background-image:linear-gradient(to bottom, #FFFFFF, #FFFFFF);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#FFFFFF', endColorstr='#FFFFFF', GradientType=0);}

    .progress .bar-mixed-striped {
        background-color: #df8a14;
        background-image: -webkit-gradient(linear, 0 100%, 100% 0, color-stop(0.25, rgba(255, 255, 255, 0.15)), color-stop(0.25, transparent), color-stop(0.5, transparent), color-stop(0.5, rgba(255, 255, 255, 0.15)), color-stop(0.75, rgba(255, 255, 255, 0.15)), color-stop(0.75, transparent), to(transparent));
        background-image: -webkit-linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);
        background-image: -moz-linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);
        background-image: -o-linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);
        background-image: linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent);
        -webkit-background-size: 40px 40px;
        -moz-background-size: 40px 40px;
        -o-background-size: 40px 40px;
        background-size: 40px 40px;
    }

    .progress .no-data-bar {background: rgba(255, 255, 255, 1);} 
    .progress .no-data-bar {background-color: rgba(255, 255, 255, 1); background-image: -webkit-gradient(linear,0 100%,100% 0,color-stop(0.25,rgba(77, 77, 77, 0.31),color-stop(0.25,transparent),color-stop(0.5,transparent),color-stop(0.5,rgba(77, 77, 77, 0.31)),color-stop(0.75,rgba(77, 77, 77, 0.31)),color-stop(0.75,transparent),to(transparent))); background-image: -webkit-linear-gradient(45deg,rgba(77, 77, 77, 0.31) 25%,transparent 25%,transparent 50%,rgba(77, 77, 77, 0.31) 50%,rgba(77, 77, 77, 0.31) 75%,transparent 75%,transparent); background-image: linear-gradient(45deg,rgba(77, 77, 77, 0.31) 25%,transparent 25%,transparent 50%,rgba(77, 77, 77, 0.31) 50%,rgba(77, 77, 77, 0.31) 75%,transparent 75%,transparent); background-size: 27px 27px;}

    .progress .bar-hover {
    }
    .progress .bar-hover:hover {
        border:2px dashed #2b2b2b; 
        padding:2px; 
    }

    .box {
        /*padding:2px;*/
    }

    .green {
        background-color:#27ca27; 
    }

    .batches-grid-container {
        max-height:235px;
        min-height:235px;
        overflow-y:auto;
        overflow-x:hidden;
        position:relative;
    }

    table.batches-table {
        font-size:12px;
    }

    table.time-accounts-table {
        font-size:12px;
    }

    .clickeable-row{
        cursor:pointer; 
    }

    .title-h-condensed {
        margin:4px auto;
    }

        h1.title-h-condensed, h2.title-h-condensed, h3.title-h-condensed, h4.title-h-condensed, h5.title-h-condensed, h6.title-h-condensed{
            line-height:15px;
        }

        h1.title-h-condensed, h2.title-h-condensed, h3.title-h-condensed{
            line-height:30px;
        }

    .title-h-condensed-extra {
        margin:2px auto;
    }
        
        h1.title-h-condensed-extra, h2.title-h-condensed-extra, h3.title-h-condensed-extra, h4.title-h-condensed-extra, h5.title-h-condensed-extra, h6.title-h-condensed-extra {
            line-height:10px;
        }

        h1.title-h-condensed-extra, h2.title-h-condensed-extra, h3.title-h-condensed-extra{
            line-height:20px;
        }

    .oee-component {
        cursor:pointer;
    }

    .highlight-elem {
        background-color: #FDFF47; 
    }

    .batch-indicators-container {
        margin-bottom:2px;
        width:100%;
        height:9px;
        position:relative;
    }
    
    .batch-line {
        width:80px;
        height:9px;
        float:left;
        position:relative;
        cursor:pointer;
    }

        .batch-line.yellow {
            background-color:#ffae00;
        }

        .batch-line.green {
            background-color:#3aea3a;
        }

        .batch-line.blue {
            background-color:#15a1cb;
        }

        .batch-line.orange {
            background-color:#ff6a00; 
        }

        .batch-line.purple {
            background-color:#b200ff; 
        }

</style>

<div class="dashboard-container dashboard-font">
    <div class="row-fluid">
        <div class="span6">
            <div style="border:1px solid #ccc;padding:6px;" class="row-fluid">
                <div class="row-fluid">
                    <div class="span12">
                        <div style="width:200px;display:inline-block;top:4px;position:relative;">
                            <div style="width:50px;float:left;text-align:right;">
                                <span style="top:5px;position:relative;"><asp:Localize runat="server" meta:resourcekey="from_label" /></span>
                            </div>
                            <div style="width:150px;float:left;margin-left:-10px;" class="from-date-control-container">
                            </div>
                        </div>
                        <div style="width:200px;display:inline-block;top:4px;position:relative;">
                            <div style="width:50px;float:left;text-align:right;">
                                <span style="top:5px;position:relative;"><asp:Localize runat="server" meta:resourcekey="to_label" /></span>
                            </div>
                            <div style="width:150px;float:left;margin-left:-10px;" class="to-date-control-container">
                            </div>
                        </div>
                        <div style="display:inline-block;position:relative;top:-3px;margin-left:10px;">
                            <span style="position:relative;top:-3px;">Linea: </span>
                            <select data-bind="value: integer(lineProductionItemIdFilter), options: lines, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_lines_label />', value: -1 }" id="select1" name="selectbasic" class="input-medium">
                            </select>
                        </div>
                    </div>
                </div>
                <div style="margin-top:5px;" class="row-fluid">
                    <div class="batches-grid-container">
                    </div>
                </div>
            </div>
            
        </div>
        <div class="span6">
            <div style="margin-bottom:8px;" class="row-fluid">
                <div class="span6">
                    <h4>
                        <span data-bind="text: coalesce(line, '-')"></span>
                        /
                        <select data-bind="value: integer(machineProductionItemId), options: machines, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_machines_label />', value: -1 }" id="selectbasic" name="selectbasic" class="input-large">
                        </select>
                    </h4>
                </div>
                <div class="span6">
                    <h4 class="pull-right">
                        <span data-bind="text: coalesce(batchNumber, '-')"></span>
                        /
                        <span data-bind="text: coalesce(product, '-')"></span>
                    </h4>
                </div>
            </div>
            <div class="row-fluid">
                <div class="row-fluid hide-on-loading">
                    <div class="row-fluid">
                        <div class="span3 circle-container">
                            <div data-circle-name="oee" data-circle-thickness="15" data-circle-gradient='["#29D65A", "#5feba3"]' data-circle-value="{{oee}}" class="circle">
                                <span class="font35 main-text-centered-in-circle progress-display"></span>
                                <span class="font20 sub-text-centered-in-circle"><asp:Localize runat="server" meta:resourcekey="OEE_label" /></span>
                            </div>
                        </div>
                        <div class="span3 circle-container">
                            <div style="cursor:pointer;" data-circle-name="ava" data-circle-thickness="15" data-circle-gradient='["#0685c3", "#06c4c1"]' data-circle-value="{{availability}}" class="circle oee-component">
                                <span class="font35 main-text-centered-in-circle progress-display"></span>
                                <span class="font20 sub-text-centered-in-circle"><asp:Localize runat="server" meta:resourcekey="AVA_label" /></span>
                            </div>
                        </div>
                        <div class="span3 circle-container">
                            <div data-circle-name="per" data-circle-thickness="15" data-circle-gradient='["#0685c3", "#06c4c1"]' data-circle-value="{{performance}}" class="circle oee-component">
                                <span class="font35 main-text-centered-in-circle progress-display"></span>
                                <span class="font20 sub-text-centered-in-circle"><asp:Localize runat="server" meta:resourcekey="PER_label" /></span>
                            </div>
                        </div>
                        <div class="span3 circle-container">
                            <div data-circle-name="qua" data-circle-thickness="15" data-circle-gradient='["#0685c3", "#06c4c1"]' data-circle-value="{{quality}}" class="circle oee-component">
                                <span class="font35 main-text-centered-in-circle progress-display"></span>
                                <span class="font20 sub-text-centered-in-circle"><asp:Localize runat="server" meta:resourcekey="QUA_label" /></span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="row-fluid">
                            <div class="span12 pbar-container" style="position:relative;margin-top:10px;">
                                <div class="progressbar-trail" style="border:1px solid #ccc;height:25px;top:0px;width:100%;background-color:#fff;position:absolute;"></div>
                                <div class="progressbar-target" style="height:25px;top:1px;width:100%;position:absolute;"></div>
                                <div class="progressbar-actual" style="height:25px;top:1px;width:100%;position:absolute;"></div>
                            </div>
                        </div>
                        <div style="margin-top:3px;" class="row-fluid">
                            <div class="span2 pull-left">
                                <h4 class="QUA-oee-component good-qty-display title-h-condensed" data-bind="text: coalesce(goodQty, '-')"></h4>
                                <h6 class="QUA-oee-component title-h-condensed"><asp:Localize runat="server" meta:resourcekey="good_qty_label" /></h6>
                            </div>
			                <div class="span2 pull-left">
                                <h4 class="bad-qty-display title-h-condensed" data-bind="text: coalesce(badQty, '-')">-</h4>
                                <h6 class="title-h-condensed"><asp:Localize runat="server" meta:resourcekey="bad_qty_label" /></h6>
                            </div>
                            <div class="span2 pull-left">
                                <h4 class="QUA-oee-component PER-oee-component total-qty-display title-h-condensed" data-bind="text: coalesce(totalQty, '-')">-</h4>
                                <h6 class="QUA-oee-component PER-oee-component title-h-condensed"><asp:Localize runat="server" meta:resourcekey="total_qty_label" /></h6>
                            </div>
                            <div class="span2 pull-left">
                                <h4 class="PER-oee-component rated-qty-display title-h-condensed" data-bind="text: coalesce(ratedQty, '-')">-</h4>
                                <h6 class="PER-oee-component title-h-condensed"><asp:Localize runat="server" meta:resourcekey="rated_qty_label" /></h6>
                            </div>
                            <div class="span2 pull-right">
                                <h3 class="target-qty-display title-h-condensed" data-bind="text: coalesce(targetQty, '-')">-</h3>
                                <h5 class="title-h-condensed"><asp:Localize runat="server" meta:resourcekey="target_qty_label" /></h5>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="loading-poster hide">
                    <div style="text-align:center;margin-top:10px;font-size:24px;">
                        <i class="fa fa-5x fa-cog fa-spin"></i><br />
                        <%--Loading ...--%>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div style="margin-top:15px;" class="row-fluid">
        <div class="span6">
            <div class="hide-on-loading">
                <div class="row-fluid">
                    <div style="min-height:260px;" class="oee-line-chart-container span12"></div>
                </div>
                <div class="row-fluid">
                    <div class="span12">
                        <div class="row-fluid">
                            <div class="row-fluid">
                                <div class="row-fluid">
                                    <div style="margin-top:5px;" class="progress-bar-container">
                                        <div class="row-fluid">
                                            <div class="batch-indicators-container">
                                            </div>
                                        </div>
                                        <div class="row-fluid">
                                            <div class="progress">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row-fluid">
                                    <div class="span12 progress-bar-timeline" style="position:relative;height:0;min-height:0;max-height:0;">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="loading-poster hide">
                <div style="text-align:center;margin-top:10px;font-size:24px;">
                    <i class="fa fa-5x fa-cog fa-spin"></i><br />
                    Loading ...
                </div>
            </div>
        </div>
        <div class="span6">
            <div style="margin-top:12px;" class="row-fluid">
                <div class="span12">
                    <div class="time-accounts-grid-container hide-on-loading">
                    </div>
                    <div class="loading-poster hide">
                        <div style="text-align:center;margin-top:10px;font-size:24px;">
                            <i class="fa fa-5x fa-cog fa-spin"></i><br />
                            Loading ...
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script id="mixed_popover_content_template" type="text/x-handlebars-template">
    <div>
        <dl class="dl-horizontal">
            <dt style="width:100px;"><asp:Localize runat="server" meta:resourcekey="startTime_popover_label" /></dt><dd style="margin-left:120px;">{{HBExp 'startTime'}}</dd>
            {{HBExp '#each details'}}
            <dt style="width:100px;">{{HBExp 'reason'}}</dt><dd style="margin-left:120px;">{{HBExp 'duration'}}</dd>
            {{HBExp '/each'}}
            <dt style="width:100px;"><asp:Localize runat="server" meta:resourcekey="total_popover_label" /></dt><dd style="margin-left:120px;">{{HBExp 'duration'}}</dd>
        </dl>
    </div>
</script>

<script id="popover_content_template" type="text/x-handlebars-template">
    <div>
        <dl class="dl-horizontal">
            <dt style="width:100px;"><asp:Localize runat="server" meta:resourcekey="reason_popover_label" /></dt><dd style="margin-left:120px;">{{HBExp 'reason'}}</dd>
            <dt style="width:100px;"><asp:Localize runat="server" meta:resourcekey="startTime_popover_label" /></dt><dd style="margin-left:120px;">{{HBExp 'startTime'}}</dd>
            <dt style="width:100px;"><asp:Localize runat="server" meta:resourcekey="duration_popover_label" /></dt><dd style="margin-left:120px;">{{HBExp 'duration'}}</dd>
        </dl>
    </div>
</script>

<script id="nodata_popover_content_template" type="text/x-handlebars-template">
    <div>
        <dl class="dl-horizontal">
            <dt style="width:100px;"><asp:Localize runat="server" meta:resourcekey="startTime_popover_label" /></dt><dd style="margin-left:120px;">{{HBExp 'startTime'}}</dd>
            <dt style="width:100px;"><asp:Localize runat="server" meta:resourcekey="duration_popover_label" /></dt><dd style="margin-left:120px;">{{HBExp 'duration'}}</dd>
        </dl>
    </div>
</script>