﻿<%@ Page Language="C#" AutoEventWireup="true" UICulture="auto" Culture="auto" meta:resourcekey="PageResource1" %>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
//@Override this is suggested by Microsoft, overriding the initialize culture function (that is
//automatically called by the aspx.
//Checks if the cookie exists and sets the language correctly, otherwise will fall-back to the default language
//(English).
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    String selectedLanguage = (lang != null) ? lang.Value : "en";
    UICulture = selectedLanguage ;
    Culture = selectedLanguage ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(selectedLanguage);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(selectedLanguage);
    base.InitializeCulture();
}
</script>
<%  
    //this prevents the browser from caching templates. (on IE the templates where cached with the old language
    //too, so the change language was not working, this is a workaround for that).
    
    Response.Cache.SetCacheability(HttpCacheability.NoCache);
    Response.Cache.SetExpires(DateTime.Now.AddMinutes(-30)); %>

<%--view template starts here (will be appended inside a row-fluid)--%>

<link href="<%= ResolveUrl("~/assets/libs/js/jstree/themes/default/style.css") %>" rel="stylesheet" />

<style>
    .blocker {
        position:absolute;
        top:0; 
        left:0; 
        width:100%;
        height:100%;
        background-color:#ccc; 
        opacity:0.4;
        z-index:99999999; 
    }

    li.node-disabled {
        background-color:#e2e2e2 !important; 
        /*opacity:0.7;*/
        color:#a1a1a1;
    }

    .node-disabled.jstree-default.jstree-wholerow-hovered {
        background: red !important;
    }

    .jstree-themeicon-custom {
        background-color: transparent;
        background-size: 24px !important;
    }

    .form-horizontal .control-label {
        float: left;
        width: 80px;
        padding-top: 5px;
        text-align: right;
    }

    .form-horizontal .controls {
        margin-left: 100px;
    }
</style>

<div class="container-fluid">
    <div class="row-fluid">
        <div class="span6">
            <div style="margin-bottom:5px;">
                <%--
                <select data-bind="value: typeId, options: types, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=all_option_label />', value: '' }" id="selectTypeFilter" name="selectTypeFilter">
                </select>
                <button class="btn btn-mini btn-add-item"><asp:Localize runat="server" meta:resourcekey="add_item_label" /></button>
                --%>

                <%--
                <button class="btn btn-mini btn-add-area"><asp:Localize runat="server" meta:resourcekey="add_area_label" /></button>
                <button class="btn btn-mini btn-add-line"><asp:Localize runat="server" meta:resourcekey="add_line_label" /></button>
                <button class="btn btn-mini btn-add-machine" disabled="disabled"><asp:Localize runat="server" meta:resourcekey="add_machine_label" /></button>
                --%>
            </div>
            <div style="overflow-y:auto;" class="tree">
            </div>
        </div>
        <div class="span5">
            <%--<div class="machine-configuration-messages row-fluid hide">
                <span style="font-size:14px;">Seleccione una máquina para configurar.</span>
            </div>--%>
            <div class="new-machine-container row-fluid">
            </div>
            <div class="machine-configuration-container row-fluid">
            </div>

        </div>
    </div>
</div>

<script id="add_machine" type="text/x-handlebars-template">
    <div class="container-fluid">
        <div class="row-fluid">
            <h5><asp:Localize runat="server" meta:resourcekey="add_machine_title" /></h5>
        </div>

        <div style="position:relative;" class="row-fluid">
            <div class="row-fluid">
                <form id="addMachineForm" class="form-horizontal">
                    <div class="control-group">
                        <label class="control-label" for="machineParent"><asp:Localize runat="server" meta:resourcekey="parent_label" /></label>
                        <label class="control-label" style="text-align:left; margin-left:15px;width:auto;" data-bind="text: trim(hierarchyList)"></label>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="newMachineName"><asp:Localize runat="server" meta:resourcekey="name_label" /></label>
                        <div class="controls">
                            <input type="text" data-bind="value: newMachineName, events: ['change', 'keyup']" id="newMachineName" name="newMachineName">
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="newMachineIcon"><asp:Localize runat="server" meta:resourcekey="icon_label" /></label>
                        <div class="controls">
                            <div class="span12">
                                <select id="newMachineIcon" class="selectpicker span12">
                                </select>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div style="margin-top:8px;" class="row-fluid">
            <div class="span6 offset3">
                <div class="span6">
                    <button disabled="disabled" class="btn btn-primary btn-block btn-save"><asp:Localize runat="server" meta:resourcekey="save_label" /></button>
                </div>
                <div class="span6">
                    <button disabled="disabled" class="btn btn-block btn-cancel"><asp:Localize runat="server" meta:resourcekey="cancel_label" /></button>
                </div>
            </div>
        </div>
    </div>
</script>

<script id="machine_configuration" type="text/x-handlebars-template">
    <div class="container-fluid">
        <div class="row-fluid">
            <h5><asp:Localize runat="server" meta:resourcekey="configuration_title" /></h5>
        </div>
        <%--<div data-bind="toggle: hasBatchOpened" class="row-fluid batch-opened-message">
            <div class="alert alert-info">
                <span>
                    <asp:Localize runat="server" meta:resourcekey="batch_opened_on_machine_msg" />
                </span>
            </div>
        </div>--%>
        <div style="position:relative;" class="row-fluid">
            <%--<div data-bind="toggle: hasBatchOpened" class="blocker"></div>--%>
            <div class="row-fluid">
                <form id="detailsForm" class="form-horizontal">
                    <%--{#ifEquals parent '#'}}
                    --%>
                    <div class="control-group">
                        <label class="control-label" for="modelType"><asp:Localize runat="server" meta:resourcekey="modelType_label" /></label>
                        <label class="control-label" style="text-align:left; margin-left:15px;width:auto;" data-bind="text: trim(typeName)"></label>
                    </div>
                    <div class="control-group" >
                        <label class="control-label" for="inputName"><asp:Localize runat="server" meta:resourcekey="name_label" /></label>
                        <div class="controls">
                            <input type="text" data-bind="value: name, events: ['change', 'keyup']" id="inputName" name="inputName">
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="selectIcon"><asp:Localize runat="server" meta:resourcekey="icon_label" /></label>
                        <div class="controls">
                            <%--<div class="control-group form-inline">
                                <select data-bind="value: integer(iconId), options: icons, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_option_label />', value: '' }, enabled: hasIcons,"></select>
                            </div>--%>
                            <div class="span12">
                                <select id="iconsSelect" class="selectpicker span12">
                                </select>
                            </div>
                        </div>
                    </div>
                    <%--{else}}
                        {#ifEquals parent -1}}
                        <div class="control-group">
                            <label class="control-label" for="inputName"><asp:Localize runat="server" meta:resourcekey="name_label" /></label>
                            <div class="controls">
                                <input type="text" data-bind="value: name, events: ['change', 'keyup']" id="Text1" name="inputName">
                            </div>
                        </div>
                        {else}}
                        <div class="control-group">
                            <label class="control-label" for="labelName"><asp:Localize runat="server" meta:resourcekey="name_label" /></label>
                            <div class="controls">
                                <label class="control-label" style="text-align:left" data-bind="text: name" id="label"></label>
                            </div>
                        </div>
                        <div class="control-group">
                            <label class="control-label" for="inputQuantity"><asp:Localize runat="server" meta:resourcekey="quantity_label" /></label>
                            <div class="controls">
                                <input type="text" data-bind="value: quantity, events: ['change', 'keyup']" id="inputQuantity" name="inputQuantity">
                            </div>
                        </div>
                        <div class="control-group">
                            <label class="control-label" for="selectIcon"><asp:Localize runat="server" meta:resourcekey="icon_label" /></label>
                            <div style="margin-left:10px; margin-top: 5px; float:right;" class="control-group form-inline">
                            <%--    <select style="width:200px;" data-bind="value: integer(iconId), options: icons, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=icon_default_option_label />', value: '' }, enabled: hasIcons,"></select>
                            --%</div>
                        </div>--%>
                    <%--    {/ifEquals}}
                    {/ifEquals}}--%>
                </form>
            </div>
        </div>
        <div style="margin-top:8px;" class="row-fluid">
            <div class="span6 offset3">
                <div class="span6">
                    <button disabled="disabled" class="btn btn-primary btn-block btn-save"><asp:Localize runat="server" meta:resourcekey="save_label" /></button>
                </div>
                <div class="span6">
                    <button disabled="disabled" class="btn btn-block btn-cancel"><asp:Localize runat="server" meta:resourcekey="cancel_label" /></button>
                </div>
            </div>
        </div>
    </div>
</script>

<script id="subnavbar_controls" type="text/x-handlebars-template">
    <div class="span12">
        <div class="subnavbar-toolbar form-inline">
            <button class="btn btn-mini btn-add-item" style="margin:0; float:left; margin-left:10px; margin-top:5px;">
                <asp:Localize runat="server" meta:resourcekey="add_item_label" />
            </button>

            <button class="btn btn-mini btn-collapse-tree btn-tree" style="margin:0; float:left; margin-left:10px; margin-top:5px;" type="button">
                <span class="collapse"> <asp:Localize runat="server" meta:resourcekey="collapse_tree" /> </span>
            </button>

            <button class="btn btn-mini btn-expand-tree btn-tree hide" style="margin:0; float:left; margin-left:10px; margin-top:5px;" type="button">
                <span class="expand"><asp:Localize runat="server" meta:resourcekey="expand_tree" /></span>
            </button>

            <%--<div id="cg_search" style="margin-top: 5px; float:right;" class="control-group form-inline">
                <label class="control-label" style="margin-right:2px;" for="searchTerm_input">
                    <asp:Localize runat="server" meta:resourcekey="search_input_label" />
                </label>
                <input type="text" id="searchTbx" data-bind="value: trim(search), events: ['change', 'keyup']," class="input-medium" placeholder="<asp:Localize runat=server meta:resourcekey=equipment_type_search_placeholder />" >
            </div>--%>
        </div>
        <%--<div class="subnavbar-toolbar form-inline">
            <div style="margin-left:10px; margin-top: 5px; float:right;" class="control-group form-inline">
                <select style="width:200px;" data-bind="value: integer(typeId), options: types, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=type_combo_all_option_label />', value: '' }, enabled: hasTypes,"></select>
            </div>
            
        </div>--%>
    </div>
</script>

<script id="add_existing_modal_template" type="text/x-handlebars-template">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><asp:Localize runat=server meta:resourcekey=add_existing_modal_title /></h3>
    </div>
    <div style="max-height:500px;padding-bottom:0;padding-top:0;" <%--class="modal-body"--%>>
        <div style="max-height:500px;padding-bottom:0;overflow-y:inherit;" class="modal-body" >
            <div class="row-fluid">
                <form class="form-horizontal">
                    <div class="control-group">
                        
                        <div style="margin-bottom: 15px">
                            <label class="control-label" style="margin-right:10px;" for="selectType">
                            <asp:Localize runat="server" meta:resourcekey="type_label" />
                            </label>
                            <div class="controls">
                                    <select  class="selectpicker " <%--data-bind="value: parent, options: models, optionsDefault: { label: '<asp:Localize runat=server meta:resourcekey=select_option_label />', value: '' }"--%> id="selectType" name="selectType" >
                                    </select>
                            </div>
                        </div>
                        <div style="margin-bottom: 15px" >
                            <label class="control-label" for="existin   gModelName"><asp:Localize runat="server" meta:resourcekey="name_label" /></label>
                            <div class="controls">
                                <input type="text" data-bind="value: name, events: ['change', 'keyup']" id="existingModelName" name="inputName">
                            </div>
                        </div>
                        <div class="span12">
                            <div class="jstreePreview" style="height:200px;overflow-y:auto; margin-top:20px;"></div>
                        </div>
                    </div>
                    <%--
                    <div id="sources" class="row-fluid active tab-pane" style="max-height:350px;min-height:350px;overflow-y:auto;">
                        <div class="types-grid-container"></div>
                    </div>
                    --%>
                </form>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <div class="modal-status-msg-container pull-left">
            <div class="modal-status-msg hide" data-bind="toggle: processing,">
                <asp:Localize runat='server' meta:resourcekey='add_existing_modal_processing_msg' />
                <i class="fa fa-cog fa-spin"></i>
            </div>
        </div>
        <button id="acceptBtn" data-bind="enabled: all(notEquals(processing, true), id)," class="btn btn-primary">
            <asp:Localize runat='server' meta:resourcekey='add_existing_modal_accept_btn_label' />
        </button>
        <button data-bind="enabled: notEquals(processing, true)" class="btn" data-dismiss="modal">
            <asp:Localize runat='server' meta:resourcekey='add_existing_modal_cancel_btn_label' />
        </button>
    </div>
</script>
